/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.format;

import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.format.Accessor;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.format.FieldFormatDirective;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.format.UnsignedFieldSpec;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.format.formatter.FormatterStructure;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.format.formatter.SpacePaddedFormatter;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.format.formatter.UnsignedIntFormatterStructure;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.format.parser.ParserOperationKt;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.format.parser.ParserStructure;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b \u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u00028\u00000\u0002B'\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0013R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/internal/format/UnsignedIntFieldFormatDirective;", "Target", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/internal/format/FieldFormatDirective;", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/internal/format/UnsignedFieldSpec;", "field", "", "minDigits", "spacePadding", "<init>", "(Lkotlinx/datetime/internal/format/UnsignedFieldSpec;ILjava/lang/Integer;)V", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/internal/format/formatter/FormatterStructure;", "formatter", "()Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/internal/format/formatter/FormatterStructure;", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/internal/format/parser/ParserStructure;", "parser", "()Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/internal/format/parser/ParserStructure;", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/internal/format/UnsignedFieldSpec;", "getField", "()Lkotlinx/datetime/internal/format/UnsignedFieldSpec;", "I", "Ljava/lang/Integer;", "maxDigits", "kotlinx-datetime"})
public abstract class UnsignedIntFieldFormatDirective<Target>
implements FieldFormatDirective<Target> {
    @NotNull
    private final UnsignedFieldSpec<Target> field;
    private final int minDigits;
    @Nullable
    private final Integer spacePadding;
    private final int maxDigits;

    public UnsignedIntFieldFormatDirective(@NotNull UnsignedFieldSpec<? super Target> field2, int minDigits, @Nullable Integer spacePadding) {
        Intrinsics.checkNotNullParameter(field2, (String)"field");
        this.field = field2;
        this.minDigits = minDigits;
        this.spacePadding = spacePadding;
        this.maxDigits = this.field.getMaxDigits();
        if (!(this.minDigits >= 0)) {
            boolean $i$a$-require-UnsignedIntFieldFormatDirective$42 = false;
            String $i$a$-require-UnsignedIntFieldFormatDirective$42 = "The minimum number of digits (" + this.minDigits + ") is negative";
            throw new IllegalArgumentException($i$a$-require-UnsignedIntFieldFormatDirective$42.toString());
        }
        if (!(this.maxDigits >= this.minDigits)) {
            boolean $i$a$-require-UnsignedIntFieldFormatDirective$52 = false;
            String $i$a$-require-UnsignedIntFieldFormatDirective$52 = "The maximum number of digits (" + this.maxDigits + ") is less than the minimum number of digits (" + this.minDigits + ')';
            throw new IllegalArgumentException($i$a$-require-UnsignedIntFieldFormatDirective$52.toString());
        }
        if (this.spacePadding != null && !(this.spacePadding > this.minDigits)) {
            boolean bl = false;
            String string = "The space padding (" + this.spacePadding + ") should be more than the minimum number of digits (" + this.minDigits + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final UnsignedFieldSpec<Target> getField() {
        return this.field;
    }

    @Override
    @NotNull
    public FormatterStructure<Target> formatter() {
        UnsignedIntFormatterStructure formatter2 = new UnsignedIntFormatterStructure((Function1)new Function1<Target, Integer>(this.field.getAccessor()){

            public final Integer invoke(Target p0) {
                return (Integer)((Accessor)this.receiver).getterNotNull(p0);
            }
        }, this.minDigits);
        return this.spacePadding != null ? (FormatterStructure)new SpacePaddedFormatter(formatter2, this.spacePadding) : (FormatterStructure)formatter2;
    }

    @Override
    @NotNull
    public ParserStructure<Target> parser() {
        return ParserOperationKt.spaceAndZeroPaddedUnsignedInt$default(this.minDigits, this.maxDigits, this.spacePadding, this.field.getAccessor(), this.field.getName(), false, 32, null);
    }
}

