/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format;

import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.Style;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.StyleBuilderApplicable;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.TextDecorationAndState;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.TextDecorationAndStateImpl;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.TextFormat;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.util.Index;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.util.TriState;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TextDecoration implements StyleBuilderApplicable,
TextFormat
{
    OBFUSCATED("obfuscated"),
    BOLD("bold"),
    STRIKETHROUGH("strikethrough"),
    UNDERLINED("underlined"),
    ITALIC("italic");

    public static final Index<String, TextDecoration> NAMES;
    private final String name;

    private TextDecoration(String name2) {
        this.name = name2;
    }

    @Deprecated
    @NotNull
    public final TextDecorationAndState as(boolean state2) {
        return this.withState(state2);
    }

    @Deprecated
    @NotNull
    public final TextDecorationAndState as(@NotNull State state2) {
        return this.withState(state2);
    }

    @NotNull
    public final TextDecorationAndState withState(boolean state2) {
        return new TextDecorationAndStateImpl(this, State.byBoolean(state2));
    }

    @NotNull
    public final TextDecorationAndState withState(@NotNull State state2) {
        return new TextDecorationAndStateImpl(this, state2);
    }

    @NotNull
    public final TextDecorationAndState withState(@NotNull TriState state2) {
        return new TextDecorationAndStateImpl(this, State.byTriState(state2));
    }

    @Override
    public void styleApply(@NotNull Style.Builder style) {
        style.decorate(this);
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    static {
        NAMES = Index.create(TextDecoration.class, constant -> constant.name);
    }

    public static enum State {
        NOT_SET("not_set"),
        FALSE("false"),
        TRUE("true");

        private final String name;

        private State(String name2) {
            this.name = name2;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public static State byBoolean(boolean flag) {
            return flag ? TRUE : FALSE;
        }

        @NotNull
        public static State byBoolean(@Nullable Boolean flag) {
            return flag == null ? NOT_SET : State.byBoolean((boolean)flag);
        }

        @NotNull
        public static State byTriState(@NotNull TriState flag) {
            Objects.requireNonNull(flag);
            switch (flag) {
                case TRUE: {
                    return TRUE;
                }
                case FALSE: {
                    return FALSE;
                }
                case NOT_SET: {
                    return NOT_SET;
                }
            }
            throw new IllegalArgumentException("Unable to turn TriState: " + (Object)((Object)flag) + " into a TextDecoration.State");
        }
    }
}

