/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapterFactory;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.Component;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson.ComponentSerializerImpl;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson.SerializerFactory;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.json.JSONOptions;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.json.LegacyHoverEventSerializer;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.util.Services;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.option.OptionState;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GsonComponentSerializerImpl
implements GsonComponentSerializer {
    private static final Optional<GsonComponentSerializer.Provider> SERVICE = Services.service(GsonComponentSerializer.Provider.class);
    static final Consumer<GsonComponentSerializer.Builder> BUILDER = SERVICE.map(GsonComponentSerializer.Provider::builder).orElseGet(() -> builder2 -> {});
    private final Gson serializer;
    private final UnaryOperator<GsonBuilder> populator;
    private final @Nullable LegacyHoverEventSerializer legacyHoverSerializer;
    private final OptionState flags;

    GsonComponentSerializerImpl(OptionState flags2, @Nullable LegacyHoverEventSerializer legacyHoverSerializer) {
        this.flags = flags2;
        this.legacyHoverSerializer = legacyHoverSerializer;
        this.populator = builder2 -> {
            builder2.registerTypeAdapterFactory((TypeAdapterFactory)new SerializerFactory(flags2, legacyHoverSerializer));
            return builder2;
        };
        this.serializer = ((GsonBuilder)this.populator.apply(new GsonBuilder().disableHtmlEscaping())).create();
    }

    @Override
    @NotNull
    public Gson serializer() {
        return this.serializer;
    }

    @Override
    @NotNull
    public UnaryOperator<GsonBuilder> populator() {
        return this.populator;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String string) {
        Component component = (Component)this.serializer().fromJson(string, Component.class);
        if (component == null) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(string);
        }
        return component;
    }

    @Override
    @Nullable
    public Component deserializeOr(@Nullable String input2, @Nullable Component fallback) {
        if (input2 == null) {
            return fallback;
        }
        Component component = (Component)this.serializer().fromJson(input2, Component.class);
        if (component == null) {
            return fallback;
        }
        return component;
    }

    @Override
    @NotNull
    public String serialize(@NotNull Component component) {
        return this.serializer().toJson((Object)component);
    }

    @Override
    @NotNull
    public Component deserializeFromTree(@NotNull JsonElement input2) {
        Component component = (Component)this.serializer().fromJson(input2, Component.class);
        if (component == null) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(input2);
        }
        return component;
    }

    @Override
    @NotNull
    public JsonElement serializeToTree(@NotNull Component component) {
        return this.serializer().toJsonTree((Object)component);
    }

    @Override
    @NotNull
    public GsonComponentSerializer.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static /* synthetic */ Optional access$000() {
        return SERVICE;
    }

    static final class BuilderImpl
    implements GsonComponentSerializer.Builder {
        private OptionState flags = JSONOptions.byDataVersion();
        private @Nullable LegacyHoverEventSerializer legacyHoverSerializer;

        BuilderImpl() {
            BUILDER.accept(this);
        }

        BuilderImpl(GsonComponentSerializerImpl serializer2) {
            this();
            this.flags = serializer2.flags;
            this.legacyHoverSerializer = serializer2.legacyHoverSerializer;
        }

        @Override
        @NotNull
        public GsonComponentSerializer.Builder options(@NotNull OptionState flags2) {
            this.flags = Objects.requireNonNull(flags2, "flags");
            return this;
        }

        @Override
        @NotNull
        public GsonComponentSerializer.Builder editOptions(@NotNull Consumer<OptionState.Builder> optionEditor) {
            OptionState.Builder builder2 = JSONOptions.schema().stateBuilder().values(this.flags);
            Objects.requireNonNull(optionEditor, "flagEditor").accept(builder2);
            this.flags = builder2.build();
            return this;
        }

        @Override
        @NotNull
        public GsonComponentSerializer.Builder legacyHoverEventSerializer(@Nullable LegacyHoverEventSerializer serializer2) {
            this.legacyHoverSerializer = serializer2;
            return this;
        }

        @Override
        @NotNull
        public GsonComponentSerializer build() {
            return new GsonComponentSerializerImpl(this.flags, this.legacyHoverSerializer);
        }
    }

    static final class Instances {
        static final GsonComponentSerializer INSTANCE = GsonComponentSerializerImpl.access$000().map(GsonComponentSerializer.Provider::gson).orElseGet(() -> new GsonComponentSerializerImpl(JSONOptions.byDataVersion(), null));
        static final GsonComponentSerializer LEGACY_INSTANCE = GsonComponentSerializerImpl.access$000().map(GsonComponentSerializer.Provider::gsonLegacy).orElseGet(() -> new GsonComponentSerializerImpl(JSONOptions.byDataVersion().at(2525), null));

        Instances() {
        }
    }
}

