/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.key.InvalidKeyException;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.key.Key;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.Component;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.event.HoverEvent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson.SerializerFactory;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.json.JSONOptions;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.option.OptionState;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

final class ShowEntitySerializer
extends TypeAdapter<HoverEvent.ShowEntity> {
    private final Gson gson;
    private final boolean emitKeyAsTypeAndUuidAsId;

    static TypeAdapter<HoverEvent.ShowEntity> create(Gson gson, OptionState opt) {
        return new ShowEntitySerializer(gson, opt.value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_KEY_AS_TYPE_AND_UUID_AS_ID)).nullSafe();
    }

    private ShowEntitySerializer(Gson gson, boolean emitKeyAsTypeAndUuidAsId) {
        this.gson = gson;
        this.emitKeyAsTypeAndUuidAsId = emitKeyAsTypeAndUuidAsId;
    }

    public HoverEvent.ShowEntity read(JsonReader in) throws IOException {
        in.beginObject();
        Key type = null;
        UUID id2 = null;
        Component name2 = null;
        while (in.hasNext()) {
            String fieldName;
            switch (fieldName = in.nextName()) {
                case "id": {
                    if (in.peek() == JsonToken.BEGIN_ARRAY) {
                        id2 = (UUID)this.gson.fromJson(in, UUID.class);
                        break;
                    }
                    String string = in.nextString();
                    if (string.contains(":")) {
                        type = Key.key(string);
                    }
                    try {
                        id2 = UUID.fromString(string);
                    }
                    catch (IllegalArgumentException ignored) {
                        try {
                            type = Key.key(string);
                        }
                        catch (InvalidKeyException invalidKeyException) {}
                    }
                    break;
                }
                case "type": {
                    type = (Key)this.gson.fromJson(in, Key.class);
                    break;
                }
                case "uuid": {
                    id2 = (UUID)this.gson.fromJson(in, UUID.class);
                    break;
                }
                case "name": {
                    name2 = (Component)this.gson.fromJson(in, SerializerFactory.COMPONENT_TYPE);
                    break;
                }
                default: {
                    in.skipValue();
                }
            }
        }
        if (type == null || id2 == null) {
            throw new JsonParseException("A show entity hover event needs type and id fields to be deserialized");
        }
        in.endObject();
        return HoverEvent.ShowEntity.showEntity(type, id2, name2);
    }

    public void write(JsonWriter out, HoverEvent.ShowEntity value2) throws IOException {
        out.beginObject();
        out.name(this.emitKeyAsTypeAndUuidAsId ? "type" : "id");
        this.gson.toJson((Object)value2.type(), SerializerFactory.KEY_TYPE, out);
        out.name(this.emitKeyAsTypeAndUuidAsId ? "id" : "uuid");
        this.gson.toJson((Object)value2.id(), SerializerFactory.UUID_TYPE, out);
        @Nullable Component name2 = value2.name();
        if (name2 != null) {
            out.name("name");
            this.gson.toJson((Object)name2, SerializerFactory.COMPONENT_TYPE, out);
        }
        out.endObject();
    }
}

