/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.key.Key;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.Component;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.event.ClickEvent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.event.HoverEvent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.ShadowColor;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.Style;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.TextColor;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.TextDecoration;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson.ComponentSerializerImpl;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson.GsonHacks;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson.SerializerFactory;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.gson.TextColorWrapper;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.json.JSONOptions;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.serializer.json.LegacyHoverEventSerializer;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.util.ARGBLike;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.util.Codec;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.option.OptionState;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

final class StyleSerializer
extends TypeAdapter<Style> {
    private static final TextDecoration[] DECORATIONS = new TextDecoration[]{TextDecoration.BOLD, TextDecoration.ITALIC, TextDecoration.UNDERLINED, TextDecoration.STRIKETHROUGH, TextDecoration.OBFUSCATED};
    private final LegacyHoverEventSerializer legacyHover;
    private final boolean emitValueFieldHover;
    private final boolean emitCamelCaseHover;
    private final boolean emitSnakeCaseHover;
    private final boolean emitCamelCaseClick;
    private final boolean emitSnakeCaseClick;
    private final boolean strictEventValues;
    private final boolean emitShadowColor;
    private final boolean emitStringPage;
    private final Gson gson;

    static TypeAdapter<Style> create(@Nullable LegacyHoverEventSerializer legacyHover, OptionState features2, Gson gson) {
        JSONOptions.HoverEventValueMode hoverMode = features2.value(JSONOptions.EMIT_HOVER_EVENT_TYPE);
        JSONOptions.ClickEventValueMode clickMode = features2.value(JSONOptions.EMIT_CLICK_EVENT_TYPE);
        return new StyleSerializer(legacyHover, hoverMode == JSONOptions.HoverEventValueMode.VALUE_FIELD || hoverMode == JSONOptions.HoverEventValueMode.ALL, hoverMode == JSONOptions.HoverEventValueMode.CAMEL_CASE || hoverMode == JSONOptions.HoverEventValueMode.ALL, hoverMode == JSONOptions.HoverEventValueMode.SNAKE_CASE || hoverMode == JSONOptions.HoverEventValueMode.ALL, clickMode == JSONOptions.ClickEventValueMode.CAMEL_CASE || clickMode == JSONOptions.ClickEventValueMode.BOTH, clickMode == JSONOptions.ClickEventValueMode.SNAKE_CASE || clickMode == JSONOptions.ClickEventValueMode.BOTH, features2.value(JSONOptions.VALIDATE_STRICT_EVENTS), features2.value(JSONOptions.SHADOW_COLOR_MODE) != JSONOptions.ShadowColorEmitMode.NONE, features2.value(JSONOptions.EMIT_CHANGE_PAGE_CLICK_EVENT_PAGE_AS_STRING), gson).nullSafe();
    }

    private StyleSerializer(@Nullable LegacyHoverEventSerializer legacyHover, boolean emitValueFieldHover, boolean emitCamelCaseHover, boolean emitSnakeCaseHover, boolean emitCamelCaseClick, boolean emitSnakeCaseClick, boolean strictEventValues, boolean emitShadowColor, boolean emitStringPage, Gson gson) {
        this.legacyHover = legacyHover;
        this.emitValueFieldHover = emitValueFieldHover;
        this.emitCamelCaseHover = emitCamelCaseHover;
        this.emitSnakeCaseHover = emitSnakeCaseHover;
        this.emitCamelCaseClick = emitCamelCaseClick;
        this.emitSnakeCaseClick = emitSnakeCaseClick;
        this.strictEventValues = strictEventValues;
        this.emitShadowColor = emitShadowColor;
        this.emitStringPage = emitStringPage;
        this.gson = gson;
    }

    public Style read(JsonReader in) throws IOException {
        in.beginObject();
        Style.Builder style = Style.style();
        while (in.hasNext()) {
            String fieldName = in.nextName();
            if (fieldName.equals("font")) {
                style.font((Key)this.gson.fromJson(in, SerializerFactory.KEY_TYPE));
                continue;
            }
            if (fieldName.equals("color")) {
                TextColorWrapper color2 = (TextColorWrapper)this.gson.fromJson(in, SerializerFactory.COLOR_WRAPPER_TYPE);
                if (color2.color != null) {
                    style.color(color2.color);
                    continue;
                }
                if (color2.decoration == null) continue;
                style.decoration(color2.decoration, TextDecoration.State.TRUE);
                continue;
            }
            if (fieldName.equals("shadow_color")) {
                style.shadowColor((ARGBLike)this.gson.fromJson(in, SerializerFactory.SHADOW_COLOR_TYPE));
                continue;
            }
            if (TextDecoration.NAMES.keys().contains(fieldName)) {
                style.decoration(TextDecoration.NAMES.value(fieldName), GsonHacks.readBoolean(in));
                continue;
            }
            if (fieldName.equals("insertion")) {
                style.insertion(in.nextString());
                continue;
            }
            if (fieldName.equals("click_event") || fieldName.equals("clickEvent")) {
                in.beginObject();
                ClickEvent.Action action = null;
                String value2 = null;
                Key key = null;
                Integer page = null;
                while (in.hasNext()) {
                    String clickEventField = in.nextName();
                    if (clickEventField.equals("action")) {
                        action = (ClickEvent.Action)((Object)this.gson.fromJson(in, SerializerFactory.CLICK_ACTION_TYPE));
                        continue;
                    }
                    if (clickEventField.equals("page")) {
                        if (in.peek() == JsonToken.NUMBER) {
                            page = in.nextInt();
                            continue;
                        }
                        if (in.peek() == JsonToken.STRING) {
                            page = Integer.parseInt(in.nextString());
                            continue;
                        }
                        if (in.peek() == JsonToken.NULL) {
                            throw ComponentSerializerImpl.notSureHowToDeserialize(clickEventField);
                        }
                        in.skipValue();
                        continue;
                    }
                    if (clickEventField.equals("value") || clickEventField.equals("url") || clickEventField.equals("path") || clickEventField.equals("command") || clickEventField.equals("payload")) {
                        if (in.peek() == JsonToken.NULL) {
                            if (this.strictEventValues) {
                                throw ComponentSerializerImpl.notSureHowToDeserialize(clickEventField);
                            }
                            in.nextNull();
                            continue;
                        }
                        value2 = in.nextString();
                        continue;
                    }
                    if (clickEventField.equals("id")) {
                        key = Key.key(in.nextString());
                        continue;
                    }
                    in.skipValue();
                }
                if (action != null && action.readable()) {
                    switch (action) {
                        case OPEN_URL: {
                            if (value2 == null) break;
                            style.clickEvent(ClickEvent.openUrl(value2));
                            break;
                        }
                        case RUN_COMMAND: {
                            if (value2 == null) break;
                            style.clickEvent(ClickEvent.runCommand(value2));
                            break;
                        }
                        case SUGGEST_COMMAND: {
                            if (value2 == null) break;
                            style.clickEvent(ClickEvent.suggestCommand(value2));
                            break;
                        }
                        case CHANGE_PAGE: {
                            if (page == null) break;
                            style.clickEvent(ClickEvent.changePage(page));
                            break;
                        }
                        case COPY_TO_CLIPBOARD: {
                            if (value2 == null) break;
                            style.clickEvent(ClickEvent.copyToClipboard(value2));
                            break;
                        }
                        case CUSTOM: {
                            if (key == null || value2 == null) break;
                            style.clickEvent(ClickEvent.custom(key, value2));
                            break;
                        }
                    }
                }
                in.endObject();
                continue;
            }
            if (fieldName.equals("hover_event") || fieldName.equals("hoverEvent")) {
                Object value3;
                HoverEvent.Action action;
                JsonPrimitive serializedAction;
                JsonObject hoverEventObject = (JsonObject)this.gson.fromJson(in, JsonObject.class);
                if (hoverEventObject == null || (serializedAction = hoverEventObject.getAsJsonPrimitive("action")) == null || !(action = (HoverEvent.Action)this.gson.fromJson((JsonElement)serializedAction, SerializerFactory.HOVER_ACTION_TYPE)).readable()) continue;
                Class actionType = action.type();
                if (hoverEventObject.has("contents")) {
                    @Nullable JsonElement rawValue = hoverEventObject.get("contents");
                    if (GsonHacks.isNullOrEmpty(rawValue)) {
                        if (this.strictEventValues) {
                            throw ComponentSerializerImpl.notSureHowToDeserialize(rawValue);
                        }
                        value3 = null;
                    } else {
                        value3 = SerializerFactory.COMPONENT_TYPE.isAssignableFrom(actionType) ? this.gson.fromJson(rawValue, SerializerFactory.COMPONENT_TYPE) : (SerializerFactory.SHOW_ITEM_TYPE.isAssignableFrom(actionType) ? this.gson.fromJson(rawValue, SerializerFactory.SHOW_ITEM_TYPE) : (SerializerFactory.SHOW_ENTITY_TYPE.isAssignableFrom(actionType) ? this.gson.fromJson(rawValue, SerializerFactory.SHOW_ENTITY_TYPE) : null));
                    }
                } else if (hoverEventObject.has("value")) {
                    JsonElement element = hoverEventObject.get("value");
                    if (GsonHacks.isNullOrEmpty(element)) {
                        if (this.strictEventValues) {
                            throw ComponentSerializerImpl.notSureHowToDeserialize(element);
                        }
                        value3 = null;
                    } else if (SerializerFactory.COMPONENT_TYPE.isAssignableFrom(actionType)) {
                        Component rawValue = (Component)this.gson.fromJson(element, SerializerFactory.COMPONENT_TYPE);
                        value3 = this.legacyHoverEventContents(action, rawValue);
                    } else {
                        value3 = SerializerFactory.STRING_TYPE.isAssignableFrom(actionType) ? this.gson.fromJson(element, SerializerFactory.STRING_TYPE) : null;
                    }
                } else if (SerializerFactory.SHOW_ITEM_TYPE.isAssignableFrom(actionType)) {
                    value3 = this.gson.fromJson((JsonElement)hoverEventObject, SerializerFactory.SHOW_ITEM_TYPE);
                } else if (SerializerFactory.SHOW_ENTITY_TYPE.isAssignableFrom(actionType)) {
                    value3 = this.gson.fromJson((JsonElement)hoverEventObject, SerializerFactory.SHOW_ENTITY_TYPE);
                } else {
                    if (this.strictEventValues) {
                        throw ComponentSerializerImpl.notSureHowToDeserialize(hoverEventObject);
                    }
                    value3 = null;
                }
                if (value3 == null) continue;
                style.hoverEvent(HoverEvent.hoverEvent(action, value3));
                continue;
            }
            in.skipValue();
        }
        in.endObject();
        return style.build();
    }

    private Object legacyHoverEventContents(HoverEvent.Action<?> action, Component rawValue) {
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return rawValue;
        }
        if (this.legacyHover != null) {
            try {
                if (action == HoverEvent.Action.SHOW_ENTITY) {
                    return this.legacyHover.deserializeShowEntity(rawValue, this.decoder());
                }
                if (action == HoverEvent.Action.SHOW_ITEM) {
                    return this.legacyHover.deserializeShowItem(rawValue);
                }
            }
            catch (IOException ex) {
                throw new JsonParseException((Throwable)ex);
            }
        }
        throw new UnsupportedOperationException();
    }

    private Codec.Decoder<Component, String, JsonParseException> decoder() {
        return string -> (Component)this.gson.fromJson(string, SerializerFactory.COMPONENT_TYPE);
    }

    private Codec.Encoder<Component, String, JsonParseException> encoder() {
        return component -> this.gson.toJson(component, SerializerFactory.COMPONENT_TYPE);
    }

    public void write(JsonWriter out, Style value2) throws IOException {
        Key font;
        HoverEvent<?> hoverEvent;
        ClickEvent clickEvent;
        String insertion;
        ShadowColor shadowColor;
        out.beginObject();
        for (TextDecoration decoration : DECORATIONS) {
            TextDecoration.State state2 = value2.decoration(decoration);
            if (state2 == TextDecoration.State.NOT_SET) continue;
            String name2 = TextDecoration.NAMES.key(decoration);
            assert (name2 != null);
            out.name(name2);
            out.value(state2 == TextDecoration.State.TRUE);
        }
        @Nullable TextColor color2 = value2.color();
        if (color2 != null) {
            out.name("color");
            this.gson.toJson((Object)color2, SerializerFactory.COLOR_TYPE, out);
        }
        if ((shadowColor = value2.shadowColor()) != null && this.emitShadowColor) {
            out.name("shadow_color");
            this.gson.toJson((Object)shadowColor, SerializerFactory.SHADOW_COLOR_TYPE, out);
        }
        if ((insertion = value2.insertion()) != null) {
            out.name("insertion");
            out.value(insertion);
        }
        if ((clickEvent = value2.clickEvent()) != null) {
            ClickEvent.Action action = clickEvent.action();
            if (this.emitSnakeCaseClick) {
                out.name("click_event");
                out.beginObject();
                out.name("action");
                this.gson.toJson((Object)action, SerializerFactory.CLICK_ACTION_TYPE, out);
                if (action.readable()) {
                    ClickEvent.Payload payload = clickEvent.payload();
                    if (payload instanceof ClickEvent.Payload.Text) {
                        switch (action) {
                            case OPEN_URL: {
                                out.name("url");
                                break;
                            }
                            case RUN_COMMAND: 
                            case SUGGEST_COMMAND: {
                                out.name("command");
                                break;
                            }
                            case COPY_TO_CLIPBOARD: {
                                out.name("value");
                            }
                        }
                        out.value(((ClickEvent.Payload.Text)payload).value());
                    } else if (payload instanceof ClickEvent.Payload.Custom) {
                        ClickEvent.Payload.Custom customPayload = (ClickEvent.Payload.Custom)payload;
                        out.name("id");
                        this.gson.toJson((Object)customPayload.key(), SerializerFactory.KEY_TYPE, out);
                        out.name("payload");
                        out.value(customPayload.data());
                    } else if (payload instanceof ClickEvent.Payload.Int) {
                        ClickEvent.Payload.Int intPayload = (ClickEvent.Payload.Int)payload;
                        out.name("page");
                        if (this.emitStringPage) {
                            out.value(String.valueOf(intPayload.integer()));
                        } else {
                            out.value((long)intPayload.integer());
                        }
                    }
                }
                out.endObject();
            }
            if (this.emitCamelCaseClick && action.payloadType() == ClickEvent.Payload.Text.class) {
                out.name("clickEvent");
                out.beginObject();
                out.name("action");
                this.gson.toJson((Object)action, SerializerFactory.CLICK_ACTION_TYPE, out);
                out.name("value");
                out.value(clickEvent.value());
                out.endObject();
            }
        }
        if ((hoverEvent = value2.hoverEvent()) != null && ((this.emitSnakeCaseHover || this.emitCamelCaseHover) && hoverEvent.action() != HoverEvent.Action.SHOW_ACHIEVEMENT || this.emitValueFieldHover)) {
            HoverEvent.Action<?> action = hoverEvent.action();
            if (this.emitSnakeCaseHover && action != HoverEvent.Action.SHOW_ACHIEVEMENT) {
                out.name("hover_event");
                out.beginObject();
                out.name("action");
                this.gson.toJson(action, SerializerFactory.HOVER_ACTION_TYPE, out);
                if (action == HoverEvent.Action.SHOW_ITEM) {
                    for (Map.Entry entry : this.gson.toJsonTree(hoverEvent.value(), SerializerFactory.SHOW_ITEM_TYPE).getAsJsonObject().entrySet()) {
                        out.name((String)entry.getKey());
                        this.gson.toJson((JsonElement)entry.getValue(), out);
                    }
                } else if (action == HoverEvent.Action.SHOW_ENTITY) {
                    for (Map.Entry entry : this.gson.toJsonTree(hoverEvent.value(), SerializerFactory.SHOW_ENTITY_TYPE).getAsJsonObject().entrySet()) {
                        out.name((String)entry.getKey());
                        this.gson.toJson((JsonElement)entry.getValue(), out);
                    }
                } else if (action == HoverEvent.Action.SHOW_TEXT) {
                    out.name("value");
                    this.gson.toJson(hoverEvent.value(), SerializerFactory.COMPONENT_TYPE, out);
                } else {
                    throw new JsonParseException("Don't know how to serialize " + hoverEvent.value());
                }
                out.endObject();
            }
            if (this.emitCamelCaseHover || this.emitValueFieldHover) {
                out.name("hoverEvent");
                out.beginObject();
                out.name("action");
                this.gson.toJson(action, SerializerFactory.HOVER_ACTION_TYPE, out);
                if (this.emitCamelCaseHover && action != HoverEvent.Action.SHOW_ACHIEVEMENT) {
                    out.name("contents");
                    if (action == HoverEvent.Action.SHOW_ITEM) {
                        this.gson.toJson(hoverEvent.value(), SerializerFactory.SHOW_ITEM_TYPE, out);
                    } else if (action == HoverEvent.Action.SHOW_ENTITY) {
                        this.gson.toJson(hoverEvent.value(), SerializerFactory.SHOW_ENTITY_TYPE, out);
                    } else if (action == HoverEvent.Action.SHOW_TEXT) {
                        this.gson.toJson(hoverEvent.value(), SerializerFactory.COMPONENT_TYPE, out);
                    } else {
                        throw new JsonParseException("Don't know how to serialize " + hoverEvent.value());
                    }
                }
                if (this.emitValueFieldHover) {
                    out.name("value");
                    this.serializeLegacyHoverEvent(hoverEvent, out);
                }
                out.endObject();
            }
        }
        if ((font = value2.font()) != null) {
            out.name("font");
            this.gson.toJson((Object)font, SerializerFactory.KEY_TYPE, out);
        }
        out.endObject();
    }

    private void serializeLegacyHoverEvent(HoverEvent<?> hoverEvent, JsonWriter out) throws IOException {
        if (hoverEvent.action() == HoverEvent.Action.SHOW_TEXT) {
            this.gson.toJson(hoverEvent.value(), SerializerFactory.COMPONENT_TYPE, out);
        } else if (hoverEvent.action() == HoverEvent.Action.SHOW_ACHIEVEMENT) {
            this.gson.toJson(hoverEvent.value(), String.class, out);
        } else if (this.legacyHover != null) {
            Component serialized = null;
            try {
                if (hoverEvent.action() == HoverEvent.Action.SHOW_ENTITY) {
                    serialized = this.legacyHover.serializeShowEntity((HoverEvent.ShowEntity)hoverEvent.value(), this.encoder());
                } else if (hoverEvent.action() == HoverEvent.Action.SHOW_ITEM) {
                    serialized = this.legacyHover.serializeShowItem((HoverEvent.ShowItem)hoverEvent.value());
                }
            }
            catch (IOException ex) {
                throw new JsonSyntaxException((Throwable)ex);
            }
            if (serialized != null) {
                this.gson.toJson((Object)serialized, SerializerFactory.COMPONENT_TYPE, out);
            } else {
                out.nullValue();
            }
        } else {
            out.nullValue();
        }
    }

    static {
        EnumSet<TextDecoration> knownDecorations = EnumSet.allOf(TextDecoration.class);
        for (TextDecoration decoration : DECORATIONS) {
            knownDecorations.remove(decoration);
        }
        if (!knownDecorations.isEmpty()) {
            throw new IllegalStateException("Gson serializer is missing some text decorations: " + knownDecorations);
        }
    }
}

