/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.net.kyori.option;

import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.option.Option;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.option.OptionImpl;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.option.OptionSchema;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.option.OptionState;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.option.OptionStateImpl;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.option.value.ValueType;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jspecify.annotations.Nullable;

final class OptionSchemaImpl
implements OptionSchema {
    final OptionState emptyState;
    final ConcurrentMap<String, Option<?>> options = new ConcurrentHashMap();

    OptionSchemaImpl(@Nullable OptionSchemaImpl parent) {
        if (parent != null) {
            this.options.putAll(parent.options);
        }
        this.emptyState = new OptionStateImpl(this, new IdentityHashMap());
    }

    @Override
    public Set<Option<?>> knownOptions() {
        return Collections.unmodifiableSet(new HashSet(this.options.values()));
    }

    @Override
    public boolean has(Option<?> option2) {
        Option own = (Option)this.options.get(option2.id());
        return own != null && own.equals(option2);
    }

    @Override
    public OptionState.Builder stateBuilder() {
        return new OptionStateImpl.BuilderImpl(this);
    }

    @Override
    public OptionState.VersionedBuilder versionedStateBuilder() {
        return new OptionStateImpl.VersionedBuilderImpl(this);
    }

    @Override
    public OptionState emptyState() {
        return this.emptyState;
    }

    public String toString() {
        return "OptionSchemaImpl{options=" + this.options + '}';
    }

    final class MutableImpl
    implements OptionSchema.Mutable {
        MutableImpl() {
        }

        <T> Option<T> register(String id2, ValueType<T> type, @Nullable T defaultValue) {
            OptionImpl<T> ret = new OptionImpl<T>(Objects.requireNonNull(id2, "id"), Objects.requireNonNull(type, "type"), defaultValue);
            if (OptionSchemaImpl.this.options.putIfAbsent(id2, ret) != null) {
                throw new IllegalStateException("Key " + id2 + " has already been used. Option keys must be unique within a schema.");
            }
            return ret;
        }

        @Override
        public Option<String> stringOption(String id2, @Nullable String defaultValue) {
            return this.register(id2, ValueType.stringType(), defaultValue);
        }

        @Override
        public Option<Boolean> booleanOption(String id2, boolean defaultValue) {
            return this.register(id2, ValueType.booleanType(), defaultValue);
        }

        @Override
        public Option<Integer> intOption(String id2, int defaultValue) {
            return this.register(id2, ValueType.integerType(), defaultValue);
        }

        @Override
        public Option<Double> doubleOption(String id2, double defaultValue) {
            return this.register(id2, ValueType.doubleType(), defaultValue);
        }

        @Override
        public <E extends Enum<E>> Option<E> enumOption(String id2, Class<E> enumClazz, @Nullable E defaultValue) {
            return this.register(id2, ValueType.enumType(enumClazz), defaultValue);
        }

        @Override
        public OptionSchema frozenView() {
            return OptionSchemaImpl.this;
        }

        @Override
        public Set<Option<?>> knownOptions() {
            return OptionSchemaImpl.this.knownOptions();
        }

        @Override
        public boolean has(Option<?> option2) {
            return OptionSchemaImpl.this.has(option2);
        }

        @Override
        public OptionState.Builder stateBuilder() {
            return OptionSchemaImpl.this.stateBuilder();
        }

        @Override
        public OptionState.VersionedBuilder versionedStateBuilder() {
            return OptionSchemaImpl.this.versionedStateBuilder();
        }

        @Override
        public OptionState emptyState() {
            return OptionSchemaImpl.this.emptyState();
        }

        public String toString() {
            return "MutableImpl{schema=" + OptionSchemaImpl.this + "}";
        }
    }

    static final class Instances {
        static MutableImpl GLOBAL = new OptionSchemaImpl(null).new MutableImpl();

        Instances() {
        }
    }
}

