/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.net.peanuuutz.tomlkt.internal.emitter;

import io.github.quiltservertools.blockbotdiscord.libs.net.peanuuutz.tomlkt.Toml;
import io.github.quiltservertools.blockbotdiscord.libs.net.peanuuutz.tomlkt.TomlArray;
import io.github.quiltservertools.blockbotdiscord.libs.net.peanuuutz.tomlkt.TomlBlockArray;
import io.github.quiltservertools.blockbotdiscord.libs.net.peanuuutz.tomlkt.TomlElement;
import io.github.quiltservertools.blockbotdiscord.libs.net.peanuuutz.tomlkt.TomlElementKt;
import io.github.quiltservertools.blockbotdiscord.libs.net.peanuuutz.tomlkt.TomlInteger;
import io.github.quiltservertools.blockbotdiscord.libs.net.peanuuutz.tomlkt.TomlLiteral;
import io.github.quiltservertools.blockbotdiscord.libs.net.peanuuutz.tomlkt.TomlNull;
import io.github.quiltservertools.blockbotdiscord.libs.net.peanuuutz.tomlkt.TomlTable;
import io.github.quiltservertools.blockbotdiscord.libs.net.peanuuutz.tomlkt.TomlWriter;
import io.github.quiltservertools.blockbotdiscord.libs.net.peanuuutz.tomlkt.internal.StringUtilsKt;
import io.github.quiltservertools.blockbotdiscord.libs.net.peanuuutz.tomlkt.internal.emitter.TomlInlineArrayEmitter;
import io.github.quiltservertools.blockbotdiscord.libs.net.peanuuutz.tomlkt.internal.emitter.TomlInlineTableEmitter;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b$\u0010\u001eJ\u0017\u0010%\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b%\u0010\u001eJ\u0017\u0010(\u001a\u00020\u00002\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010*\u001a\u00020\n2\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010.\u001a\u00020\u00002\u0006\u0010-\u001a\u00020,H\u0016\u00a2\u0006\u0004\b.\u0010/J\u0017\u00100\u001a\u00020\n2\u0006\u0010-\u001a\u00020,H\u0016\u00a2\u0006\u0004\b0\u00101R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00102\u001a\u0004\b3\u00104R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u00105\u001a\u0004\b6\u00107R\"\u00108\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b8\u0010:\"\u0004\b;\u0010\u0016R$\u0010=\u001a\u0004\u0018\u00010<8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\"\u0010C\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bC\u00109\u001a\u0004\bC\u0010:\"\u0004\bD\u0010\u0016R\"\u0010E\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bE\u00109\u001a\u0004\bE\u0010:\"\u0004\bF\u0010\u0016R$\u0010H\u001a\u0004\u0018\u00010G8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010M\u00a8\u0006N"}, d2={"Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/internal/emitter/AbstractTomlElementEmitter;", "", "Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/Toml;", "toml", "Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlWriter;", "writer", "<init>", "(Lnet/peanuuutz/tomlkt/Toml;Lnet/peanuuutz/tomlkt/TomlWriter;)V", "Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlElement;", "element", "", "emitElement", "(Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlElement;)V", "emitNull", "()V", "Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlLiteral;", "literal", "emitLiteral", "(Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlLiteral;)V", "", "boolean", "emitBoolean", "(Z)V", "", "integer", "emitInteger", "(J)V", "", "content", "emitULong", "(Ljava/lang/String;)V", "", "float", "emitFloat", "(D)V", "string", "emitString", "emitDateTime", "Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlArray;", "array", "createArrayEmitter", "(Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlArray;)Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/internal/emitter/AbstractTomlElementEmitter;", "emitArray", "(Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlArray;)V", "Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlTable;", "table", "createTableEmitter", "(Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlTable;)Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/internal/emitter/AbstractTomlElementEmitter;", "emitTable", "(Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlTable;)V", "Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/Toml;", "getToml", "()Lnet/peanuuutz/tomlkt/Toml;", "Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlWriter;", "getWriter", "()Lnet/peanuuutz/tomlkt/TomlWriter;", "isInline", "Z", "()Z", "setInline", "Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlBlockArray;", "blockArray", "Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlBlockArray;", "getBlockArray", "()Lnet/peanuuutz/tomlkt/TomlBlockArray;", "setBlockArray", "(Lnet/peanuuutz/tomlkt/TomlBlockArray;)V", "isStringMultiline", "setStringMultiline", "isStringLiteral", "setStringLiteral", "Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlInteger;", "integerRepresentation", "Lio/github/quiltservertools/blockbotdiscord/libs/net/peanuuutz/tomlkt/TomlInteger;", "getIntegerRepresentation", "()Lnet/peanuuutz/tomlkt/TomlInteger;", "setIntegerRepresentation", "(Lnet/peanuuutz/tomlkt/TomlInteger;)V", "tomlkt"})
@SourceDebugExtension(value={"SMAP\nTomlElementEmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomlElementEmitter.kt\nnet/peanuuutz/tomlkt/internal/emitter/AbstractTomlElementEmitter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,690:1\n1#2:691\n*E\n"})
public abstract class AbstractTomlElementEmitter {
    @NotNull
    private final Toml toml;
    @NotNull
    private final TomlWriter writer;
    private boolean isInline;
    @Nullable
    private TomlBlockArray blockArray;
    private boolean isStringMultiline;
    private boolean isStringLiteral;
    @Nullable
    private TomlInteger integerRepresentation;

    public AbstractTomlElementEmitter(@NotNull Toml toml, @NotNull TomlWriter writer2) {
        Intrinsics.checkNotNullParameter((Object)toml, (String)"toml");
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        this.toml = toml;
        this.writer = writer2;
    }

    @NotNull
    public final Toml getToml() {
        return this.toml;
    }

    @NotNull
    public final TomlWriter getWriter() {
        return this.writer;
    }

    public final boolean isInline() {
        return this.isInline;
    }

    public final void setInline(boolean bl) {
        this.isInline = bl;
    }

    @Nullable
    public final TomlBlockArray getBlockArray() {
        return this.blockArray;
    }

    public final void setBlockArray(@Nullable TomlBlockArray tomlBlockArray) {
        this.blockArray = tomlBlockArray;
    }

    public final boolean isStringMultiline() {
        return this.isStringMultiline;
    }

    public final void setStringMultiline(boolean bl) {
        this.isStringMultiline = bl;
    }

    public final boolean isStringLiteral() {
        return this.isStringLiteral;
    }

    public final void setStringLiteral(boolean bl) {
        this.isStringLiteral = bl;
    }

    @Nullable
    public final TomlInteger getIntegerRepresentation() {
        return this.integerRepresentation;
    }

    public final void setIntegerRepresentation(@Nullable TomlInteger tomlInteger) {
        this.integerRepresentation = tomlInteger;
    }

    public final void emitElement(@NotNull TomlElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TomlElement tomlElement = element;
        if (tomlElement instanceof TomlNull) {
            this.emitNull();
        } else if (tomlElement instanceof TomlLiteral) {
            this.emitLiteral((TomlLiteral)element);
        } else if (tomlElement instanceof TomlArray) {
            this.createArrayEmitter((TomlArray)element).emitArray((TomlArray)element);
        } else if (tomlElement instanceof TomlTable) {
            this.createTableEmitter((TomlTable)element).emitTable((TomlTable)element);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public void emitNull() {
        this.writer.writeNullValue();
    }

    public final void emitLiteral(@NotNull TomlLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        switch (WhenMappings.$EnumSwitchMapping$0[literal.getType().ordinal()]) {
            case 1: {
                this.emitBoolean(TomlElementKt.toBoolean(literal));
                break;
            }
            case 2: {
                Long l = TomlElementKt.toLongOrNull(literal);
                if (l == null) {
                    this.emitULong(literal.getContent());
                    return;
                }
                this.emitInteger(l);
                break;
            }
            case 3: {
                this.emitFloat(TomlElementKt.toDouble(literal));
                break;
            }
            case 4: {
                this.emitString(literal.toString());
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.emitDateTime(literal.getContent());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public void emitBoolean(boolean bl) {
        this.writer.writeBooleanValue(bl);
    }

    public void emitInteger(long integer) {
        TomlInteger representation = this.integerRepresentation;
        if (representation == null) {
            TomlWriter.DefaultImpls.writeIntegerValue$default(this.writer, integer, null, 0, false, 14, null);
            return;
        }
        this.writer.writeIntegerValue(integer, representation.base(), representation.group(), this.toml.getConfig().getUppercaseInteger());
    }

    public void emitULong(@NotNull String content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        TomlInteger representation = this.integerRepresentation;
        if (representation == null) {
            this.writer.writeString(content2);
            return;
        }
        if (!(representation.group() >= 0)) {
            boolean bl = false;
            String string = "Group size cannot be negative";
            throw new IllegalArgumentException(string.toString());
        }
        String string = StringUtilsKt.processIntegerString(content2, representation.base(), representation.group(), this.toml.getConfig().getUppercaseInteger());
        this.writer.writeString(string);
    }

    public void emitFloat(double d) {
        this.writer.writeFloatValue(d);
    }

    public void emitString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.writer.writeStringValue(string, this.isStringMultiline, this.isStringLiteral);
    }

    public void emitDateTime(@NotNull String content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.writer.writeString(content2);
    }

    @NotNull
    public AbstractTomlElementEmitter createArrayEmitter(@NotNull TomlArray array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return new TomlInlineArrayEmitter(this);
    }

    public void emitArray(@NotNull TomlArray array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.createArrayEmitter(array).emitArray(array);
    }

    @NotNull
    public AbstractTomlElementEmitter createTableEmitter(@NotNull TomlTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return new TomlInlineTableEmitter(this);
    }

    public void emitTable(@NotNull TomlTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.createTableEmitter(table).emitTable(table);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TomlLiteral.Type.values().length];
            try {
                nArray[TomlLiteral.Type.Boolean.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TomlLiteral.Type.Integer.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TomlLiteral.Type.Float.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TomlLiteral.Type.String.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TomlLiteral.Type.LocalDateTime.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TomlLiteral.Type.OffsetDateTime.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TomlLiteral.Type.LocalDate.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TomlLiteral.Type.LocalTime.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

