/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.asm;

import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.asm.ExtensionVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionInfo {
    private static final Logger log = LoggerFactory.getLogger(ExtensionInfo.class);
    private final String className;
    int ordinal = 0;
    List<String> plugins = new ArrayList<String>();
    List<String> points = new ArrayList<String>();

    ExtensionInfo(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public List<String> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }

    public List<String> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    public static ExtensionInfo load(String className, ClassLoader classLoader) {
        ExtensionInfo extensionInfo;
        block8: {
            InputStream input2 = classLoader.getResourceAsStream(className.replace('.', '/') + ".class");
            try {
                ExtensionInfo info2 = new ExtensionInfo(className);
                new ClassReader(input2).accept((ClassVisitor)new ExtensionVisitor(info2), 2);
                extensionInfo = info2;
                if (input2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input2 != null) {
                        try {
                            input2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            input2.close();
        }
        return extensionInfo;
    }
}

