/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.asm;

import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.Extension;
import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.asm.ExtensionInfo;
import java.util.Arrays;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExtensionVisitor
extends ClassVisitor {
    private static final Logger log = LoggerFactory.getLogger(ExtensionVisitor.class);
    private static final int ASM_VERSION = 458752;
    private final ExtensionInfo extensionInfo;

    ExtensionVisitor(ExtensionInfo extensionInfo) {
        super(458752);
        this.extensionInfo = extensionInfo;
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        if (!Type.getType((String)descriptor2).getClassName().equals(Extension.class.getName())) {
            return super.visitAnnotation(descriptor2, visible);
        }
        return new AnnotationVisitor(458752){

            public AnnotationVisitor visitArray(final String name2) {
                if ("ordinal".equals(name2) || "plugins".equals(name2) || "points".equals(name2)) {
                    return new AnnotationVisitor(458752, super.visitArray(name2)){

                        public void visit(String key, Object value2) {
                            log.debug("Load annotation attribute {} = {} ({})", new Object[]{name2, value2, value2.getClass().getName()});
                            if ("ordinal".equals(name2)) {
                                ((ExtensionVisitor)ExtensionVisitor.this).extensionInfo.ordinal = Integer.parseInt(value2.toString());
                            } else if ("plugins".equals(name2)) {
                                if (value2 instanceof String) {
                                    log.debug("Found plugin {}", value2);
                                    ((ExtensionVisitor)ExtensionVisitor.this).extensionInfo.plugins.add((String)value2);
                                } else if (value2 instanceof String[]) {
                                    log.debug("Found plugins {}", (Object)Arrays.toString((String[])value2));
                                    ((ExtensionVisitor)ExtensionVisitor.this).extensionInfo.plugins.addAll(Arrays.asList((String[])value2));
                                } else {
                                    log.debug("Found plugin {}", (Object)value2.toString());
                                    ((ExtensionVisitor)ExtensionVisitor.this).extensionInfo.plugins.add(value2.toString());
                                }
                            } else {
                                String pointClassName = ((Type)value2).getClassName();
                                log.debug("Found point " + pointClassName);
                                ((ExtensionVisitor)ExtensionVisitor.this).extensionInfo.points.add(pointClassName);
                            }
                            super.visit(key, value2);
                        }
                    };
                }
                return super.visitArray(name2);
            }
        };
    }
}

