/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.processor;

import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.processor.ExtensionAnnotationProcessor;
import io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.processor.ExtensionStorage;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class LegacyExtensionStorage
extends ExtensionStorage {
    public static final String EXTENSIONS_RESOURCE = "META-INF/extensions.idx";

    public LegacyExtensionStorage(ExtensionAnnotationProcessor processor) {
        super(processor);
    }

    @Override
    public Map<String, Set<String>> read() {
        HashMap<String, Set<String>> extensions = new HashMap<String, Set<String>>();
        try {
            FileObject file2 = this.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", EXTENSIONS_RESOURCE);
            HashSet<String> entries2 = new HashSet<String>();
            ExtensionStorage.read(file2.openReader(true), entries2);
            extensions.put(null, entries2);
        }
        catch (FileNotFoundException | NoSuchFileException file2) {
        }
        catch (FilerException file2) {
        }
        catch (IOException e) {
            this.error(e.getMessage(), new Object[0]);
        }
        return extensions;
    }

    @Override
    public void write(Map<String, Set<String>> extensions) {
        try {
            FileObject file2 = this.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", EXTENSIONS_RESOURCE, new Element[0]);
            try (BufferedWriter writer2 = new BufferedWriter(file2.openWriter());){
                writer2.write("# Generated by PF4J");
                writer2.newLine();
                for (Map.Entry<String, Set<String>> entry : extensions.entrySet()) {
                    for (String extension : entry.getValue()) {
                        writer2.write(extension);
                        writer2.newLine();
                    }
                }
            }
        }
        catch (FileNotFoundException file2) {
        }
        catch (FilerException file2) {
        }
        catch (IOException e) {
            this.error(e.toString(), new Object[0]);
        }
    }
}

