/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.org.pf4j.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class DirectedGraph<V> {
    private Map<V, List<V>> neighbors = new HashMap<V, List<V>>();

    public void addVertex(V vertex) {
        if (this.containsVertex(vertex)) {
            return;
        }
        this.neighbors.put(vertex, new ArrayList());
    }

    public boolean containsVertex(V vertex) {
        return this.neighbors.containsKey(vertex);
    }

    public void removeVertex(V vertex) {
        this.neighbors.remove(vertex);
    }

    public void addEdge(V from2, V to) {
        this.addVertex(from2);
        this.addVertex(to);
        this.neighbors.get(from2).add(to);
    }

    public void removeEdge(V from2, V to) {
        if (!this.containsVertex(from2)) {
            throw new IllegalArgumentException("Nonexistent vertex " + from2);
        }
        if (!this.containsVertex(to)) {
            throw new IllegalArgumentException("Nonexistent vertex " + to);
        }
        this.neighbors.get(from2).remove(to);
    }

    public List<V> getNeighbors(V vertex) {
        return this.containsVertex(vertex) ? this.neighbors.get(vertex) : new ArrayList();
    }

    public Map<V, Integer> outDegree() {
        HashMap<V, Integer> result2 = new HashMap<V, Integer>();
        for (V vertex : this.neighbors.keySet()) {
            result2.put(vertex, this.neighbors.get(vertex).size());
        }
        return result2;
    }

    public Map<V, Integer> inDegree() {
        HashMap<V, Integer> result2 = new HashMap<V, Integer>();
        for (V vertex : this.neighbors.keySet()) {
            result2.put(vertex, 0);
        }
        for (V from2 : this.neighbors.keySet()) {
            for (V to : this.neighbors.get(from2)) {
                result2.put(to, (Integer)result2.get(to) + 1);
            }
        }
        return result2;
    }

    public List<V> topologicalSort() {
        Map<Integer, Integer> degree = this.inDegree();
        Stack<V> zeroVertices = new Stack<V>();
        for (V v : degree.keySet()) {
            if (degree.get(v) != 0) continue;
            zeroVertices.push(v);
        }
        ArrayList result2 = new ArrayList();
        while (!zeroVertices.isEmpty()) {
            Object vertex = zeroVertices.pop();
            result2.add(vertex);
            for (V neighbor : this.neighbors.get(vertex)) {
                degree.put((Integer)neighbor, degree.get(neighbor) - 1);
                if (degree.get(neighbor) != 0) continue;
                zeroVertices.push(neighbor);
            }
        }
        if (result2.size() != this.neighbors.size()) {
            return null;
        }
        return result2;
    }

    public List<V> reverseTopologicalSort() {
        List<V> list2 = this.topologicalSort();
        if (list2 == null) {
            return null;
        }
        Collections.reverse(list2);
        return list2;
    }

    public boolean isDag() {
        return this.topologicalSort() != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (V vertex : this.neighbors.keySet()) {
            sb.append("\n   ").append(vertex).append(" -> ").append(this.neighbors.get(vertex));
        }
        return sb.toString();
    }
}

