/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.org.reflections.adapters;

import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.AccessFlag;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.AnnotationsAttribute;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.ClassFile;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.Descriptor;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.FieldInfo;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.MethodInfo;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.ParameterAnnotationsAttribute;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.Annotation;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.ReflectionsException;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.adapters.MetadataAdapter;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.util.Utils;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.vfs.Vfs;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class JavassistAdapter
implements MetadataAdapter<ClassFile, FieldInfo, MethodInfo> {
    public static boolean includeInvisibleTag = true;

    @Override
    public List<FieldInfo> getFields(ClassFile cls) {
        return cls.getFields();
    }

    @Override
    public List<MethodInfo> getMethods(ClassFile cls) {
        return cls.getMethods();
    }

    @Override
    public String getMethodName(MethodInfo method) {
        return method.getName();
    }

    @Override
    public List<String> getParameterNames(MethodInfo method) {
        String descriptor2 = method.getDescriptor();
        descriptor2 = descriptor2.substring(descriptor2.indexOf("(") + 1, descriptor2.lastIndexOf(")"));
        return this.splitDescriptorToTypeNames(descriptor2);
    }

    @Override
    public List<String> getClassAnnotationNames(ClassFile aClass) {
        return this.getAnnotationNames((AnnotationsAttribute)aClass.getAttribute("RuntimeVisibleAnnotations"), includeInvisibleTag ? (AnnotationsAttribute)aClass.getAttribute("RuntimeInvisibleAnnotations") : null);
    }

    @Override
    public List<String> getFieldAnnotationNames(FieldInfo field2) {
        return this.getAnnotationNames((AnnotationsAttribute)field2.getAttribute("RuntimeVisibleAnnotations"), includeInvisibleTag ? (AnnotationsAttribute)field2.getAttribute("RuntimeInvisibleAnnotations") : null);
    }

    @Override
    public List<String> getMethodAnnotationNames(MethodInfo method) {
        return this.getAnnotationNames((AnnotationsAttribute)method.getAttribute("RuntimeVisibleAnnotations"), includeInvisibleTag ? (AnnotationsAttribute)method.getAttribute("RuntimeInvisibleAnnotations") : null);
    }

    @Override
    public List<String> getParameterAnnotationNames(MethodInfo method, int parameterIndex) {
        ArrayList<String> result2 = new ArrayList<String>();
        List<ParameterAnnotationsAttribute> parameterAnnotationsAttributes = Arrays.asList((ParameterAnnotationsAttribute)method.getAttribute("RuntimeVisibleParameterAnnotations"), (ParameterAnnotationsAttribute)method.getAttribute("RuntimeInvisibleParameterAnnotations"));
        for (ParameterAnnotationsAttribute parameterAnnotationsAttribute : parameterAnnotationsAttributes) {
            Annotation[][] annotations;
            if (parameterAnnotationsAttribute == null || parameterIndex >= (annotations = parameterAnnotationsAttribute.getAnnotations()).length) continue;
            Annotation[] annotation = annotations[parameterIndex];
            result2.addAll(this.getAnnotationNames(annotation));
        }
        return result2;
    }

    @Override
    public String getReturnTypeName(MethodInfo method) {
        String descriptor2 = method.getDescriptor();
        descriptor2 = descriptor2.substring(descriptor2.lastIndexOf(")") + 1);
        return this.splitDescriptorToTypeNames(descriptor2).get(0);
    }

    @Override
    public String getFieldName(FieldInfo field2) {
        return field2.getName();
    }

    @Override
    public ClassFile getOrCreateClassObject(Vfs.File file2) {
        InputStream inputStream2 = null;
        try {
            inputStream2 = file2.openInputStream();
            DataInputStream dis = new DataInputStream(new BufferedInputStream(inputStream2));
            ClassFile classFile = new ClassFile(dis);
            return classFile;
        }
        catch (IOException e) {
            throw new ReflectionsException("could not create class file from " + file2.getName(), e);
        }
        finally {
            Utils.close(inputStream2);
        }
    }

    @Override
    public String getMethodModifier(MethodInfo method) {
        int accessFlags = method.getAccessFlags();
        return AccessFlag.isPrivate(accessFlags) ? "private" : (AccessFlag.isProtected(accessFlags) ? "protected" : (this.isPublic(accessFlags) ? "public" : ""));
    }

    @Override
    public String getMethodKey(ClassFile cls, MethodInfo method) {
        return this.getMethodName(method) + "(" + Utils.join(this.getParameterNames(method), ", ") + ")";
    }

    @Override
    public String getMethodFullKey(ClassFile cls, MethodInfo method) {
        return this.getClassName(cls) + "." + this.getMethodKey(cls, method);
    }

    @Override
    public boolean isPublic(Object o) {
        Integer accessFlags = o instanceof ClassFile ? ((ClassFile)o).getAccessFlags() : (o instanceof FieldInfo ? ((FieldInfo)o).getAccessFlags() : (o instanceof MethodInfo ? Integer.valueOf(((MethodInfo)o).getAccessFlags()) : null).intValue());
        return accessFlags != null && AccessFlag.isPublic(accessFlags);
    }

    @Override
    public String getClassName(ClassFile cls) {
        return cls.getName();
    }

    @Override
    public String getSuperclassName(ClassFile cls) {
        return cls.getSuperclass();
    }

    @Override
    public List<String> getInterfacesNames(ClassFile cls) {
        return Arrays.asList(cls.getInterfaces());
    }

    @Override
    public boolean acceptsInput(String file2) {
        return file2.endsWith(".class");
    }

    private List<String> getAnnotationNames(AnnotationsAttribute ... annotationsAttributes) {
        if (annotationsAttributes != null) {
            return Arrays.stream(annotationsAttributes).filter(Objects::nonNull).flatMap(annotationsAttribute -> Arrays.stream(annotationsAttribute.getAnnotations())).map(Annotation::getTypeName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<String> getAnnotationNames(Annotation[] annotations) {
        return Arrays.stream(annotations).map(Annotation::getTypeName).collect(Collectors.toList());
    }

    private List<String> splitDescriptorToTypeNames(String descriptors) {
        List<String> result2 = new ArrayList<String>();
        if (descriptors != null && descriptors.length() != 0) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            Descriptor.Iterator iterator2 = new Descriptor.Iterator(descriptors);
            while (iterator2.hasNext()) {
                indices.add(iterator2.next());
            }
            indices.add(descriptors.length());
            result2 = IntStream.range(0, indices.size() - 1).mapToObj(i -> Descriptor.toString(descriptors.substring((Integer)indices.get(i), (Integer)indices.get(i + 1)))).collect(Collectors.toList());
        }
        return result2;
    }
}

