/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.org.reflections.scanners;

import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.CodeAttribute;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.LocalVariableAttribute;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.MethodInfo;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.Store;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.adapters.MetadataAdapter;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.scanners.AbstractScanner;
import io.github.quiltservertools.blockbotdiscord.libs.org.reflections.util.Utils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class MethodParameterNamesScanner
extends AbstractScanner {
    @Override
    public void scan(Object cls, Store store) {
        MetadataAdapter md = this.getMetadataAdapter();
        for (Object method : md.getMethods(cls)) {
            String key = md.getMethodFullKey(cls, method);
            if (!this.acceptResult(key)) continue;
            CodeAttribute codeAttribute = ((MethodInfo)method).getCodeAttribute();
            LocalVariableAttribute table = codeAttribute != null ? (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable") : null;
            int length = table != null ? table.tableLength() : 0;
            int i = Modifier.isStatic(((MethodInfo)method).getAccessFlags()) ? 0 : 1;
            if (i >= length) continue;
            ArrayList<String> names = new ArrayList<String>(length - i);
            while (i < length) {
                names.add(((MethodInfo)method).getConstPool().getUtf8Info(table.nameIndex(i++)));
            }
            this.put(store, key, Utils.join(names, ", "));
        }
    }
}

