/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RouteDatabase;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 -2\u00020\u0001:\u0002-.B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\fH\u0086\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u0010H\u0086\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J!\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001fR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010 R\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010&\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010$R\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00130!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010$R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010,\u00a8\u0006/"}, d2={"Lokhttp3/internal/connection/RouteSelector;", "", "Lokhttp3/Address;", "address", "Lokhttp3/internal/connection/RouteDatabase;", "routeDatabase", "Lokhttp3/Call;", "call", "Lokhttp3/EventListener;", "eventListener", "<init>", "(Lokhttp3/Address;Lokhttp3/internal/connection/RouteDatabase;Lokhttp3/Call;Lokhttp3/EventListener;)V", "", "hasNext", "()Z", "hasNextProxy", "Lokhttp3/internal/connection/RouteSelector$Selection;", "next", "()Lokhttp3/internal/connection/RouteSelector$Selection;", "Ljava/net/Proxy;", "nextProxy", "()Ljava/net/Proxy;", "proxy", "", "resetNextInetSocketAddress", "(Ljava/net/Proxy;)V", "Lokhttp3/HttpUrl;", "url", "resetNextProxy", "(Lokhttp3/HttpUrl;Ljava/net/Proxy;)V", "Lokhttp3/Address;", "Lokhttp3/Call;", "Lokhttp3/EventListener;", "", "Ljava/net/InetSocketAddress;", "inetSocketAddresses", "Ljava/util/List;", "", "nextProxyIndex", "I", "", "Lokhttp3/Route;", "postponedRoutes", "proxies", "Lokhttp3/internal/connection/RouteDatabase;", "Companion", "Selection", "okhttp"})
public final class RouteSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Address address;
    @NotNull
    private final RouteDatabase routeDatabase;
    @NotNull
    private final Call call;
    @NotNull
    private final EventListener eventListener;
    @NotNull
    private List<? extends Proxy> proxies;
    private int nextProxyIndex;
    @NotNull
    private List<? extends InetSocketAddress> inetSocketAddresses;
    @NotNull
    private final List<Route> postponedRoutes;

    public RouteSelector(@NotNull Address address, @NotNull RouteDatabase routeDatabase, @NotNull Call call2, @NotNull EventListener eventListener) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)routeDatabase, (String)"routeDatabase");
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        this.address = address;
        this.routeDatabase = routeDatabase;
        this.call = call2;
        this.eventListener = eventListener;
        this.proxies = CollectionsKt.emptyList();
        this.inetSocketAddresses = CollectionsKt.emptyList();
        this.postponedRoutes = new ArrayList();
        this.resetNextProxy(this.address.url(), this.address.proxy());
    }

    public final boolean hasNext() {
        return this.hasNextProxy() || !((Collection)this.postponedRoutes).isEmpty();
    }

    @NotNull
    public final Selection next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        List routes = new ArrayList();
        while (this.hasNextProxy()) {
            Proxy proxy2 = this.nextProxy();
            for (InetSocketAddress inetSocketAddress : this.inetSocketAddresses) {
                Route route = new Route(this.address, proxy2, inetSocketAddress);
                if (this.routeDatabase.shouldPostpone(route)) {
                    ((Collection)this.postponedRoutes).add(route);
                    continue;
                }
                ((Collection)routes).add(route);
            }
            if (!(!((Collection)routes).isEmpty())) continue;
        }
        if (routes.isEmpty()) {
            CollectionsKt.addAll((Collection)routes, (Iterable)this.postponedRoutes);
            this.postponedRoutes.clear();
        }
        return new Selection(routes);
    }

    private final void resetNextProxy(HttpUrl url2, Proxy proxy2) {
        this.eventListener.proxySelectStart(this.call, url2);
        this.proxies = RouteSelector.resetNextProxy$selectProxies(proxy2, url2, this);
        this.nextProxyIndex = 0;
        this.eventListener.proxySelectEnd(this.call, url2, this.proxies);
    }

    private final boolean hasNextProxy() {
        return this.nextProxyIndex < this.proxies.size();
    }

    private final Proxy nextProxy() throws IOException {
        if (!this.hasNextProxy()) {
            throw new SocketException("No route to " + this.address.url().host() + "; exhausted proxy configurations: " + this.proxies);
        }
        int n = this.nextProxyIndex;
        this.nextProxyIndex = n + 1;
        Proxy result2 = this.proxies.get(n);
        this.resetNextInetSocketAddress(result2);
        return result2;
    }

    private final void resetNextInetSocketAddress(Proxy proxy2) throws IOException {
        List mutableInetSocketAddresses;
        this.inetSocketAddresses = mutableInetSocketAddresses = (List)new ArrayList();
        String socketHost = null;
        int socketPort = 0;
        if (proxy2.type() == Proxy.Type.DIRECT || proxy2.type() == Proxy.Type.SOCKS) {
            socketHost = this.address.url().host();
            socketPort = this.address.url().port();
        } else {
            SocketAddress proxyAddress = proxy2.address();
            if (!(proxyAddress instanceof InetSocketAddress)) {
                boolean $i$a$-require-RouteSelector$resetNextInetSocketAddress$22 = false;
                String $i$a$-require-RouteSelector$resetNextInetSocketAddress$22 = "Proxy.address() is not an InetSocketAddress: " + proxyAddress.getClass();
                throw new IllegalArgumentException($i$a$-require-RouteSelector$resetNextInetSocketAddress$22.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)proxyAddress, (String)"proxyAddress");
            socketHost = Companion.getSocketHost((InetSocketAddress)proxyAddress);
            socketPort = ((InetSocketAddress)proxyAddress).getPort();
        }
        if (!(1 <= socketPort ? socketPort < 65536 : false)) {
            throw new SocketException("No route to " + socketHost + ':' + socketPort + "; port is out of range");
        }
        if (proxy2.type() == Proxy.Type.SOCKS) {
            ((Collection)mutableInetSocketAddresses).add(InetSocketAddress.createUnresolved(socketHost, socketPort));
        } else {
            List<InetAddress> list2;
            if (Util.canParseAsIpAddress(socketHost)) {
                list2 = CollectionsKt.listOf((Object)InetAddress.getByName(socketHost));
            } else {
                this.eventListener.dnsStart(this.call, socketHost);
                List<InetAddress> result2 = this.address.dns().lookup(socketHost);
                if (result2.isEmpty()) {
                    throw new UnknownHostException(this.address.dns() + " returned no addresses for " + socketHost);
                }
                this.eventListener.dnsEnd(this.call, socketHost, result2);
                list2 = result2;
            }
            List<InetAddress> addresses = list2;
            for (InetAddress inetAddress : addresses) {
                ((Collection)mutableInetSocketAddresses).add(new InetSocketAddress(inetAddress, socketPort));
            }
        }
    }

    private static final List<Proxy> resetNextProxy$selectProxies(Proxy $proxy, HttpUrl $url, RouteSelector this$0) {
        Proxy proxy2 = $proxy;
        if (proxy2 != null) {
            return CollectionsKt.listOf((Object)proxy2);
        }
        URI uri = $url.uri();
        if (uri.getHost() == null) {
            Proxy[] proxyArray = new Proxy[]{Proxy.NO_PROXY};
            return Util.immutableListOf(proxyArray);
        }
        List<Proxy> proxiesOrNull = this$0.address.proxySelector().select(uri);
        Proxy[] proxyArray = (Proxy[])proxiesOrNull;
        if (proxyArray == null || proxyArray.isEmpty()) {
            proxyArray = new Proxy[]{Proxy.NO_PROXY};
            return Util.immutableListOf(proxyArray);
        }
        Intrinsics.checkNotNullExpressionValue(proxiesOrNull, (String)"proxiesOrNull");
        return Util.toImmutableList(proxiesOrNull);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0015\u0010\b\u001a\u00020\u0005*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lokhttp3/internal/connection/RouteSelector$Companion;", "", "<init>", "()V", "Ljava/net/InetSocketAddress;", "", "getSocketHost", "(Ljava/net/InetSocketAddress;)Ljava/lang/String;", "socketHost", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSocketHost(@NotNull InetSocketAddress $this$socketHost) {
            Intrinsics.checkNotNullParameter((Object)$this$socketHost, (String)"<this>");
            InetAddress inetAddress = $this$socketHost.getAddress();
            if (inetAddress == null) {
                String string = $this$socketHost.getHostName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hostName");
                return string;
            }
            InetAddress address = inetAddress;
            String string = address.getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"address.hostAddress");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\b\u001a\u00020\u0007H\u0086\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0003H\u0086\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lokhttp3/internal/connection/RouteSelector$Selection;", "", "", "Lokhttp3/Route;", "routes", "<init>", "(Ljava/util/List;)V", "", "hasNext", "()Z", "next", "()Lokhttp3/Route;", "", "nextRouteIndex", "I", "Ljava/util/List;", "getRoutes", "()Ljava/util/List;", "okhttp"})
    public static final class Selection {
        @NotNull
        private final List<Route> routes;
        private int nextRouteIndex;

        public Selection(@NotNull List<Route> routes) {
            Intrinsics.checkNotNullParameter(routes, (String)"routes");
            this.routes = routes;
        }

        @NotNull
        public final List<Route> getRoutes() {
            return this.routes;
        }

        public final boolean hasNext() {
            return this.nextRouteIndex < this.routes.size();
        }

        @NotNull
        public final Route next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = this.nextRouteIndex;
            this.nextRouteIndex = n + 1;
            return this.routes.get(n);
        }
    }
}

