/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.sse;

import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.EventListener;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.sse.ServerSentEventReader;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J+\u0010\u0015\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010#\u001a\u00020\n2\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010'J\u0013\u0010*\u001a\u00020)*\u00020(H\u0002\u00a2\u0006\u0004\b*\u0010+R\u0016\u0010\u0018\u001a\u00020,8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0018\u0010-R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010.R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010/\u00a8\u00060"}, d2={"Lokhttp3/internal/sse/RealEventSource;", "Lokhttp3/sse/EventSource;", "Lokhttp3/internal/sse/ServerSentEventReader$Callback;", "Lokhttp3/Callback;", "Lokhttp3/Request;", "request", "Lokhttp3/sse/EventSourceListener;", "listener", "<init>", "(Lokhttp3/Request;Lokhttp3/sse/EventSourceListener;)V", "", "cancel", "()V", "Lokhttp3/OkHttpClient;", "client", "connect", "(Lokhttp3/OkHttpClient;)V", "", "id", "type", "data", "onEvent", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lokhttp3/Call;", "call", "Ljava/io/IOException;", "e", "onFailure", "(Lokhttp3/Call;Ljava/io/IOException;)V", "Lokhttp3/Response;", "response", "onResponse", "(Lokhttp3/Call;Lokhttp3/Response;)V", "", "timeMs", "onRetryChange", "(J)V", "processResponse", "(Lokhttp3/Response;)V", "()Lokhttp3/Request;", "Lokhttp3/ResponseBody;", "", "isEventStream", "(Lokhttp3/ResponseBody;)Z", "Lokhttp3/internal/connection/RealCall;", "Lokhttp3/internal/connection/RealCall;", "Lokhttp3/sse/EventSourceListener;", "Lokhttp3/Request;", "okhttp-sse"})
public final class RealEventSource
implements EventSource,
ServerSentEventReader.Callback,
Callback {
    @NotNull
    private final Request request;
    @NotNull
    private final EventSourceListener listener;
    private RealCall call;

    public RealEventSource(@NotNull Request request, @NotNull EventSourceListener listener) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.request = request;
        this.listener = listener;
    }

    public final void connect(@NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        OkHttpClient client2 = client.newBuilder().eventListener(EventListener.NONE).build();
        Call call2 = client2.newCall(this.request);
        Intrinsics.checkNotNull((Object)call2, (String)"null cannot be cast to non-null type okhttp3.internal.connection.RealCall");
        this.call = (RealCall)call2;
        RealCall realCall = this.call;
        if (realCall == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
            realCall = null;
        }
        realCall.enqueue(this);
    }

    @Override
    public void onResponse(@NotNull Call call2, @NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        this.processResponse(response2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processResponse(@NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Closeable closeable = response2;
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl = false;
            if (!response2.isSuccessful()) {
                this.listener.onFailure(this, null, response2);
                return;
            }
            ResponseBody responseBody = response2.body();
            Intrinsics.checkNotNull((Object)responseBody);
            ResponseBody body2 = responseBody;
            if (!this.isEventStream(body2)) {
                this.listener.onFailure(this, new IllegalStateException("Invalid content-type: " + body2.contentType()), response2);
                return;
            }
            RealCall realCall = this.call;
            if (realCall == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                realCall = null;
            }
            realCall.timeoutEarlyExit();
            Response response3 = response2.newBuilder().body(Util.EMPTY_RESPONSE).build();
            ServerSentEventReader reader2 = new ServerSentEventReader(body2.source(), this);
            try {
                this.listener.onOpen(this, response3);
                while (reader2.processNextEvent()) {
                }
            }
            catch (Exception e) {
                this.listener.onFailure(this, e, response3);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                return;
            }
            this.listener.onClosed(this);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final boolean isEventStream(ResponseBody $this$isEventStream) {
        MediaType mediaType = $this$isEventStream.contentType();
        if (mediaType == null) {
            return false;
        }
        MediaType contentType = mediaType;
        return Intrinsics.areEqual((Object)contentType.type(), (Object)"text") && Intrinsics.areEqual((Object)contentType.subtype(), (Object)"event-stream");
    }

    @Override
    public void onFailure(@NotNull Call call2, @NotNull IOException e) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.listener.onFailure(this, e, null);
    }

    @Override
    @NotNull
    public Request request() {
        return this.request;
    }

    @Override
    public void cancel() {
        RealCall realCall = this.call;
        if (realCall == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
            realCall = null;
        }
        realCall.cancel();
    }

    @Override
    public void onEvent(@Nullable String id2, @Nullable String type, @NotNull String data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.listener.onEvent(this, id2, type, data2);
    }

    @Override
    public void onRetryChange(long timeMs) {
    }
}

