/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.ws.WebSocketExtensions;
import okhttp3.internal.ws.WebSocketProtocol;
import okhttp3.internal.ws.WebSocketReader;
import okhttp3.internal.ws.WebSocketWriter;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u0082\u00012\u00020\u00012\u00020\u0002:\n\u0083\u0001\u0082\u0001\u0084\u0001\u0085\u0001\u0086\u0001BA\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J!\u0010 \u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fJ!\u0010&\u001a\u00020%2\u0006\u0010\"\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0004\b&\u0010'J'\u0010&\u001a\u00020%2\u0006\u0010\"\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010(\u001a\u00020\u000b\u00a2\u0006\u0004\b&\u0010)J\u0015\u0010,\u001a\u00020\u00152\u0006\u0010+\u001a\u00020*\u00a2\u0006\u0004\b,\u0010-J#\u00101\u001a\u00020\u00152\n\u00100\u001a\u00060.j\u0002`/2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0004\b1\u00102J\u001d\u00106\u001a\u00020\u00152\u0006\u00103\u001a\u00020#2\u0006\u00105\u001a\u000204\u00a2\u0006\u0004\b6\u00107J\r\u00108\u001a\u00020\u0015\u00a2\u0006\u0004\b8\u0010\u0019J\u001f\u00109\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b9\u0010:J\u0017\u0010<\u001a\u00020\u00152\u0006\u0010;\u001a\u00020#H\u0016\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010<\u001a\u00020\u00152\u0006\u0010?\u001a\u00020>H\u0016\u00a2\u0006\u0004\b<\u0010@J\u0017\u0010B\u001a\u00020\u00152\u0006\u0010A\u001a\u00020>H\u0016\u00a2\u0006\u0004\bB\u0010@J\u0017\u0010C\u001a\u00020\u00152\u0006\u0010A\u001a\u00020>H\u0016\u00a2\u0006\u0004\bC\u0010@J\u0015\u0010D\u001a\u00020%2\u0006\u0010A\u001a\u00020>\u00a2\u0006\u0004\bD\u0010EJ\r\u0010F\u001a\u00020%\u00a2\u0006\u0004\bF\u0010GJ\u000f\u0010H\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bH\u0010IJ\r\u0010J\u001a\u00020!\u00a2\u0006\u0004\bJ\u0010KJ\r\u0010L\u001a\u00020!\u00a2\u0006\u0004\bL\u0010KJ\u000f\u0010M\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\bM\u0010NJ\u000f\u0010O\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\bO\u0010\u0019J\u0017\u0010P\u001a\u00020%2\u0006\u0010;\u001a\u00020#H\u0016\u00a2\u0006\u0004\bP\u0010QJ\u0017\u0010P\u001a\u00020%2\u0006\u0010?\u001a\u00020>H\u0016\u00a2\u0006\u0004\bP\u0010EJ\u001f\u0010P\u001a\u00020%2\u0006\u0010R\u001a\u00020>2\u0006\u0010S\u001a\u00020!H\u0002\u00a2\u0006\u0004\bP\u0010TJ\r\u0010U\u001a\u00020!\u00a2\u0006\u0004\bU\u0010KJ\r\u0010V\u001a\u00020\u0015\u00a2\u0006\u0004\bV\u0010\u0019J\u000f\u0010X\u001a\u00020%H\u0000\u00a2\u0006\u0004\bW\u0010GJ\u000f\u0010Z\u001a\u00020\u0015H\u0000\u00a2\u0006\u0004\bY\u0010\u0019J\u0013\u0010[\u001a\u00020%*\u00020\rH\u0002\u00a2\u0006\u0004\b[\u0010\\R\u0016\u0010]\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b]\u0010^R\u0018\u0010`\u001a\u0004\u0018\u00010_8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b`\u0010aR\u0016\u0010b\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bb\u0010^R\u0018\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010cR\u0016\u0010d\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bd\u0010^R\u0014\u0010e\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\be\u0010fR\u001a\u0010\b\u001a\u00020\u00078\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\b\u0010g\u001a\u0004\bh\u0010iR\u001a\u0010l\u001a\b\u0012\u0004\u0012\u00020k0j8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bl\u0010mR\u0016\u0010\u000f\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010nR\u0018\u00103\u001a\u0004\u0018\u00010#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u0010fR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010oR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010nR\u001a\u0010p\u001a\b\u0012\u0004\u0012\u00020>0j8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bp\u0010mR\u0016\u0010H\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010nR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010qR\u0018\u0010s\u001a\u0004\u0018\u00010r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bs\u0010tR\u0016\u0010u\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bu\u0010vR\u0018\u0010w\u001a\u0004\u0018\u00010#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bw\u0010fR\u0016\u0010J\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010vR\u0016\u0010L\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010vR\u0016\u0010U\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bU\u0010vR\u0018\u00105\u001a\u0004\u0018\u0001048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u0010xR\u0016\u0010z\u001a\u00020y8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bz\u0010{R\u0018\u0010}\u001a\u0004\u0018\u00010|8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b}\u0010~R\u001b\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u007f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0080\u0001\u0010\u0081\u0001\u00a8\u0006\u0087\u0001"}, d2={"Lokhttp3/internal/ws/RealWebSocket;", "Lokhttp3/WebSocket;", "Lokhttp3/internal/ws/WebSocketReader$FrameCallback;", "Lokhttp3/internal/concurrent/TaskRunner;", "taskRunner", "Lokhttp3/Request;", "originalRequest", "Lokhttp3/WebSocketListener;", "listener", "Ljava/util/Random;", "random", "", "pingIntervalMillis", "Lokhttp3/internal/ws/WebSocketExtensions;", "extensions", "minimumDeflateSize", "<init>", "(Lokhttp3/internal/concurrent/TaskRunner;Lokhttp3/Request;Lokhttp3/WebSocketListener;Ljava/util/Random;JLokhttp3/internal/ws/WebSocketExtensions;J)V", "timeout", "Ljava/util/concurrent/TimeUnit;", "timeUnit", "", "awaitTermination", "(JLjava/util/concurrent/TimeUnit;)V", "cancel", "()V", "Lokhttp3/Response;", "response", "Lokhttp3/internal/connection/Exchange;", "exchange", "checkUpgradeSuccess$okhttp", "(Lokhttp3/Response;Lokhttp3/internal/connection/Exchange;)V", "checkUpgradeSuccess", "", "code", "", "reason", "", "close", "(ILjava/lang/String;)Z", "cancelAfterCloseMillis", "(ILjava/lang/String;J)Z", "Lokhttp3/OkHttpClient;", "client", "connect", "(Lokhttp3/OkHttpClient;)V", "Ljava/lang/Exception;", "Lkotlin/Exception;", "e", "failWebSocket", "(Ljava/lang/Exception;Lokhttp3/Response;)V", "name", "Lokhttp3/internal/ws/RealWebSocket$Streams;", "streams", "initReaderAndWriter", "(Ljava/lang/String;Lokhttp3/internal/ws/RealWebSocket$Streams;)V", "loopReader", "onReadClose", "(ILjava/lang/String;)V", "text", "onReadMessage", "(Ljava/lang/String;)V", "Lokio/ByteString;", "bytes", "(Lokio/ByteString;)V", "payload", "onReadPing", "onReadPong", "pong", "(Lokio/ByteString;)Z", "processNextFrame", "()Z", "queueSize", "()J", "receivedPingCount", "()I", "receivedPongCount", "request", "()Lokhttp3/Request;", "runWriter", "send", "(Ljava/lang/String;)Z", "data", "formatOpcode", "(Lokio/ByteString;I)Z", "sentPingCount", "tearDown", "writeOneFrame$okhttp", "writeOneFrame", "writePingFrame$okhttp", "writePingFrame", "isValid", "(Lokhttp3/internal/ws/WebSocketExtensions;)Z", "awaitingPong", "Z", "Lokhttp3/Call;", "call", "Lokhttp3/Call;", "enqueuedClose", "Lokhttp3/internal/ws/WebSocketExtensions;", "failed", "key", "Ljava/lang/String;", "Lokhttp3/WebSocketListener;", "getListener$okhttp", "()Lokhttp3/WebSocketListener;", "Ljava/util/ArrayDeque;", "", "messageAndCloseQueue", "Ljava/util/ArrayDeque;", "J", "Lokhttp3/Request;", "pongQueue", "Ljava/util/Random;", "Lokhttp3/internal/ws/WebSocketReader;", "reader", "Lokhttp3/internal/ws/WebSocketReader;", "receivedCloseCode", "I", "receivedCloseReason", "Lokhttp3/internal/ws/RealWebSocket$Streams;", "Lokhttp3/internal/concurrent/TaskQueue;", "taskQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "Lokhttp3/internal/ws/WebSocketWriter;", "writer", "Lokhttp3/internal/ws/WebSocketWriter;", "Lokhttp3/internal/concurrent/Task;", "writerTask", "Lokhttp3/internal/concurrent/Task;", "Companion", "Close", "Message", "Streams", "WriterTask", "okhttp"})
@SourceDebugExtension(value={"SMAP\nRealWebSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealWebSocket.kt\nokhttp3/internal/ws/RealWebSocket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 4 Util.kt\nokhttp3/internal/Util\n*L\n1#1,654:1\n1#2:655\n84#3,4:656\n90#3,13:664\n608#4,4:660\n*S KotlinDebug\n*F\n+ 1 RealWebSocket.kt\nokhttp3/internal/ws/RealWebSocket\n*L\n269#1:656,4\n512#1:664,13\n457#1:660,4\n*E\n"})
public final class RealWebSocket
implements WebSocket,
WebSocketReader.FrameCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Request originalRequest;
    @NotNull
    private final WebSocketListener listener;
    @NotNull
    private final Random random;
    private final long pingIntervalMillis;
    @Nullable
    private WebSocketExtensions extensions;
    private long minimumDeflateSize;
    @NotNull
    private final String key;
    @Nullable
    private Call call;
    @Nullable
    private Task writerTask;
    @Nullable
    private WebSocketReader reader;
    @Nullable
    private WebSocketWriter writer;
    @NotNull
    private TaskQueue taskQueue;
    @Nullable
    private String name;
    @Nullable
    private Streams streams;
    @NotNull
    private final ArrayDeque<ByteString> pongQueue;
    @NotNull
    private final ArrayDeque<Object> messageAndCloseQueue;
    private long queueSize;
    private boolean enqueuedClose;
    private int receivedCloseCode;
    @Nullable
    private String receivedCloseReason;
    private boolean failed;
    private int sentPingCount;
    private int receivedPingCount;
    private int receivedPongCount;
    private boolean awaitingPong;
    @NotNull
    private static final List<Protocol> ONLY_HTTP1 = CollectionsKt.listOf((Object)((Object)Protocol.HTTP_1_1));
    private static final long MAX_QUEUE_SIZE = 0x1000000L;
    private static final long CANCEL_AFTER_CLOSE_MILLIS = 60000L;
    public static final long DEFAULT_MINIMUM_DEFLATE_SIZE = 1024L;

    /*
     * WARNING - void declaration
     */
    public RealWebSocket(@NotNull TaskRunner taskRunner, @NotNull Request originalRequest, @NotNull WebSocketListener listener, @NotNull Random random, long pingIntervalMillis, @Nullable WebSocketExtensions extensions, long minimumDeflateSize) {
        void $this$_init__u24lambda_u241;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        Intrinsics.checkNotNullParameter((Object)originalRequest, (String)"originalRequest");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.originalRequest = originalRequest;
        this.listener = listener;
        this.random = random;
        this.pingIntervalMillis = pingIntervalMillis;
        this.extensions = extensions;
        this.minimumDeflateSize = minimumDeflateSize;
        this.taskQueue = taskRunner.newQueue();
        this.pongQueue = new ArrayDeque();
        this.messageAndCloseQueue = new ArrayDeque();
        this.receivedCloseCode = -1;
        if (!Intrinsics.areEqual((Object)"GET", (Object)this.originalRequest.method())) {
            boolean $i$a$-require-RealWebSocket$22 = false;
            String $i$a$-require-RealWebSocket$22 = "Request must be GET: " + this.originalRequest.method();
            throw new IllegalArgumentException($i$a$-require-RealWebSocket$22.toString());
        }
        byte[] $i$a$-require-RealWebSocket$22 = byArray = new byte[16];
        ByteString.Companion companion = ByteString.Companion;
        RealWebSocket realWebSocket = this;
        boolean bl = false;
        this.random.nextBytes((byte[])$this$_init__u24lambda_u241);
        Unit unit = Unit.INSTANCE;
        realWebSocket.key = ByteString.Companion.of$default(companion, byArray, 0, 0, 3, null).base64();
    }

    @NotNull
    public final WebSocketListener getListener$okhttp() {
        return this.listener;
    }

    @Override
    @NotNull
    public Request request() {
        return this.originalRequest;
    }

    @Override
    public synchronized long queueSize() {
        return this.queueSize;
    }

    @Override
    public void cancel() {
        Call call2 = this.call;
        Intrinsics.checkNotNull((Object)call2);
        call2.cancel();
    }

    public final void connect(@NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (this.originalRequest.header("Sec-WebSocket-Extensions") != null) {
            this.failWebSocket(new ProtocolException("Request header not permitted: 'Sec-WebSocket-Extensions'"), null);
            return;
        }
        OkHttpClient webSocketClient = client.newBuilder().eventListener(EventListener.NONE).protocols(ONLY_HTTP1).build();
        Request request = this.originalRequest.newBuilder().header("Upgrade", "websocket").header("Connection", "Upgrade").header("Sec-WebSocket-Key", this.key).header("Sec-WebSocket-Version", "13").header("Sec-WebSocket-Extensions", "permessage-deflate").build();
        Call call2 = this.call = (Call)new RealCall(webSocketClient, request, true);
        Intrinsics.checkNotNull((Object)call2);
        call2.enqueue(new Callback(this, request){
            final /* synthetic */ RealWebSocket this$0;
            final /* synthetic */ Request $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call2, @NotNull Response response2) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                Exchange exchange = response2.exchange();
                Streams streams = null;
                try {
                    this.this$0.checkUpgradeSuccess$okhttp(response2, exchange);
                    Exchange exchange2 = exchange;
                    Intrinsics.checkNotNull((Object)exchange2);
                    streams = exchange2.newWebSocketStreams();
                }
                catch (IOException e) {
                    this.this$0.failWebSocket(e, response2);
                    Util.closeQuietly(response2);
                    Exchange exchange3 = exchange;
                    if (exchange3 != null) {
                        exchange3.webSocketUpgradeFailed();
                    }
                    return;
                }
                WebSocketExtensions extensions = WebSocketExtensions.Companion.parse(response2.headers());
                RealWebSocket.access$setExtensions$p(this.this$0, extensions);
                if (!RealWebSocket.access$isValid(this.this$0, extensions)) {
                    RealWebSocket realWebSocket = this.this$0;
                    RealWebSocket realWebSocket2 = this.this$0;
                    RealWebSocket realWebSocket3 = realWebSocket;
                    synchronized (realWebSocket3) {
                        boolean bl = false;
                        RealWebSocket.access$getMessageAndCloseQueue$p(realWebSocket2).clear();
                        boolean bl2 = realWebSocket2.close(1010, "unexpected Sec-WebSocket-Extensions in response header");
                    }
                }
                try {
                    String name2 = Util.okHttpName + " WebSocket " + this.$request.url().redact();
                    this.this$0.initReaderAndWriter(name2, streams);
                    this.this$0.getListener$okhttp().onOpen(this.this$0, response2);
                    this.this$0.loopReader();
                }
                catch (Exception e) {
                    this.this$0.failWebSocket(e, null);
                }
            }

            public void onFailure(@NotNull Call call2, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.failWebSocket(e, null);
            }
        });
    }

    private final boolean isValid(WebSocketExtensions $this$isValid) {
        if ($this$isValid.unknownValues) {
            return false;
        }
        if ($this$isValid.clientMaxWindowBits != null) {
            return false;
        }
        return $this$isValid.serverMaxWindowBits == null || new IntRange(8, 15).contains($this$isValid.serverMaxWindowBits.intValue());
    }

    public final void checkUpgradeSuccess$okhttp(@NotNull Response response2, @Nullable Exchange exchange) throws IOException {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        if (response2.code() != 101) {
            throw new ProtocolException("Expected HTTP 101 response but was '" + response2.code() + ' ' + response2.message() + '\'');
        }
        String headerConnection = Response.header$default(response2, "Connection", null, 2, null);
        if (!StringsKt.equals((String)"Upgrade", (String)headerConnection, (boolean)true)) {
            throw new ProtocolException("Expected 'Connection' header value 'Upgrade' but was '" + headerConnection + '\'');
        }
        String headerUpgrade = Response.header$default(response2, "Upgrade", null, 2, null);
        if (!StringsKt.equals((String)"websocket", (String)headerUpgrade, (boolean)true)) {
            throw new ProtocolException("Expected 'Upgrade' header value 'websocket' but was '" + headerUpgrade + '\'');
        }
        String headerAccept = Response.header$default(response2, "Sec-WebSocket-Accept", null, 2, null);
        String acceptExpected = ByteString.Companion.encodeUtf8(this.key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").sha1().base64();
        if (!Intrinsics.areEqual((Object)acceptExpected, (Object)headerAccept)) {
            throw new ProtocolException("Expected 'Sec-WebSocket-Accept' header value '" + acceptExpected + "' but was '" + headerAccept + '\'');
        }
        if (exchange == null) {
            throw new ProtocolException("Web Socket exchange missing: bad interceptor?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void initReaderAndWriter(@NotNull String name2, @NotNull Streams streams) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)streams, (String)"streams");
        WebSocketExtensions webSocketExtensions = this.extensions;
        Intrinsics.checkNotNull((Object)webSocketExtensions);
        WebSocketExtensions extensions = webSocketExtensions;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            boolean bl = false;
            this.name = name2;
            this.streams = streams;
            this.writer = new WebSocketWriter(streams.getClient(), streams.getSink(), this.random, extensions.perMessageDeflate, extensions.noContextTakeover(streams.getClient()), this.minimumDeflateSize);
            this.writerTask = new WriterTask();
            if (this.pingIntervalMillis != 0L) {
                void this_$iv;
                long pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos(this.pingIntervalMillis);
                TaskQueue taskQueue = this.taskQueue;
                String name$iv = name2 + " ping";
                boolean $i$f$schedule = false;
                this_$iv.schedule(new Task(name$iv, this, pingIntervalNanos){
                    final /* synthetic */ RealWebSocket this$0;
                    final /* synthetic */ long $pingIntervalNanos$inlined;
                    {
                        this.this$0 = realWebSocket;
                        this.$pingIntervalNanos$inlined = l;
                        super($name, false, 2, null);
                    }

                    public long runOnce() {
                        boolean bl = false;
                        this.this$0.writePingFrame$okhttp();
                        return this.$pingIntervalNanos$inlined;
                    }
                }, pingIntervalNanos);
            }
            if (!((Collection)this.messageAndCloseQueue).isEmpty()) {
                this.runWriter();
            }
            Unit unit = Unit.INSTANCE;
        }
        this.reader = new WebSocketReader(streams.getClient(), streams.getSource(), this, extensions.perMessageDeflate, extensions.noContextTakeover(!streams.getClient()));
    }

    public final void loopReader() throws IOException {
        while (this.receivedCloseCode == -1) {
            WebSocketReader webSocketReader = this.reader;
            Intrinsics.checkNotNull((Object)webSocketReader);
            webSocketReader.processNextFrame();
        }
    }

    public final boolean processNextFrame() throws IOException {
        boolean bl;
        try {
            WebSocketReader webSocketReader = this.reader;
            Intrinsics.checkNotNull((Object)webSocketReader);
            webSocketReader.processNextFrame();
            bl = this.receivedCloseCode == -1;
        }
        catch (Exception e) {
            this.failWebSocket(e, null);
            bl = false;
        }
        return bl;
    }

    public final void awaitTermination(long timeout2, @NotNull TimeUnit timeUnit) throws InterruptedException {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        this.taskQueue.idleLatch().await(timeout2, timeUnit);
    }

    public final void tearDown() throws InterruptedException {
        this.taskQueue.shutdown();
        this.taskQueue.idleLatch().await(10L, TimeUnit.SECONDS);
    }

    public final synchronized int sentPingCount() {
        return this.sentPingCount;
    }

    public final synchronized int receivedPingCount() {
        return this.receivedPingCount;
    }

    public final synchronized int receivedPongCount() {
        return this.receivedPongCount;
    }

    @Override
    public void onReadMessage(@NotNull String text) throws IOException {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.listener.onMessage((WebSocket)this, text);
    }

    @Override
    public void onReadMessage(@NotNull ByteString bytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.listener.onMessage((WebSocket)this, bytes);
    }

    @Override
    public synchronized void onReadPing(@NotNull ByteString payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return;
        }
        this.pongQueue.add(payload);
        this.runWriter();
        int n = this.receivedPingCount;
        this.receivedPingCount = n + 1;
    }

    @Override
    public synchronized void onReadPong(@NotNull ByteString payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        int n = this.receivedPongCount;
        this.receivedPongCount = n + 1;
        this.awaitingPong = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReadClose(int code, @NotNull String reason2) {
        Intrinsics.checkNotNullParameter((Object)reason2, (String)"reason");
        if (!(code != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Streams toClose = null;
        WebSocketReader readerToClose = null;
        WebSocketWriter writerToClose = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            boolean bl = false;
            if (!(this.receivedCloseCode == -1)) {
                boolean bl2 = false;
                String string = "already closed";
                throw new IllegalStateException(string.toString());
            }
            this.receivedCloseCode = code;
            this.receivedCloseReason = reason2;
            if (this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
                toClose = this.streams;
                this.streams = null;
                readerToClose = this.reader;
                this.reader = null;
                writerToClose = this.writer;
                this.writer = null;
                this.taskQueue.shutdown();
            }
            Unit unit = Unit.INSTANCE;
        }
        try {
            this.listener.onClosing(this, code, reason2);
            if (toClose != null) {
                this.listener.onClosed(this, code, reason2);
            }
        }
        finally {
            Streams streams = toClose;
            if (streams != null) {
                Util.closeQuietly(streams);
            }
            WebSocketReader webSocketReader = readerToClose;
            if (webSocketReader != null) {
                Util.closeQuietly(webSocketReader);
            }
            WebSocketWriter webSocketWriter = writerToClose;
            if (webSocketWriter != null) {
                Util.closeQuietly(webSocketWriter);
            }
        }
    }

    @Override
    public boolean send(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.send(ByteString.Companion.encodeUtf8(text), 1);
    }

    @Override
    public boolean send(@NotNull ByteString bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.send(bytes, 2);
    }

    private final synchronized boolean send(ByteString data2, int formatOpcode) {
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        if (this.queueSize + (long)data2.size() > 0x1000000L) {
            this.close(1001, null);
            return false;
        }
        this.queueSize += (long)data2.size();
        this.messageAndCloseQueue.add(new Message(formatOpcode, data2));
        this.runWriter();
        return true;
    }

    public final synchronized boolean pong(@NotNull ByteString payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return false;
        }
        this.pongQueue.add(payload);
        this.runWriter();
        return true;
    }

    @Override
    public boolean close(int code, @Nullable String reason2) {
        return this.close(code, reason2, 60000L);
    }

    public final synchronized boolean close(int code, @Nullable String reason2, long cancelAfterCloseMillis) {
        WebSocketProtocol.INSTANCE.validateCloseCode(code);
        ByteString reasonBytes = null;
        if (reason2 != null && !((long)(reasonBytes = ByteString.Companion.encodeUtf8(reason2)).size() <= 123L)) {
            boolean bl = false;
            String string = "reason.size() > 123: " + reason2;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        this.enqueuedClose = true;
        this.messageAndCloseQueue.add(new Close(code, reasonBytes, cancelAfterCloseMillis));
        this.runWriter();
        return true;
    }

    private final void runWriter() {
        RealWebSocket $this$assertThreadHoldsLock$iv = this;
        boolean $i$f$assertThreadHoldsLock = false;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        Task writerTask = this.writerTask;
        if (writerTask != null) {
            TaskQueue.schedule$default(this.taskQueue, writerTask, 0L, 2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean writeOneFrame$okhttp() throws IOException {
        Streams streams;
        boolean bl;
        Object object;
        WebSocketWriter writer2 = null;
        ByteString pong = null;
        Object messageOrClose = null;
        int receivedCloseCode = 0;
        receivedCloseCode = -1;
        String receivedCloseReason = null;
        Streams streamsToClose = null;
        WebSocketReader readerToClose = null;
        WebSocketWriter writerToClose = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            block26: {
                block25: {
                    boolean bl2 = false;
                    if (!this.failed) break block25;
                    boolean bl3 = false;
                    return bl3;
                }
                writer2 = this.writer;
                pong = this.pongQueue.poll();
                if (pong != null) break block26;
                messageOrClose = this.messageAndCloseQueue.poll();
                if (messageOrClose instanceof Close) {
                    receivedCloseCode = this.receivedCloseCode;
                    receivedCloseReason = this.receivedCloseReason;
                    if (receivedCloseCode != -1) {
                        streamsToClose = this.streams;
                        this.streams = null;
                        readerToClose = this.reader;
                        this.reader = null;
                        writerToClose = this.writer;
                        this.writer = null;
                        this.taskQueue.shutdown();
                    } else {
                        void name$iv;
                        void $this$iv;
                        long cancelAfterCloseMillis = ((Close)messageOrClose).getCancelAfterCloseMillis();
                        TaskQueue taskQueue = this.taskQueue;
                        String string = this.name + " cancel";
                        long delayNanos$iv = TimeUnit.MILLISECONDS.toNanos(cancelAfterCloseMillis);
                        boolean cancelable$iv = true;
                        boolean $i$f$execute = false;
                        $this$iv.schedule(new Task((String)name$iv, cancelable$iv, this){
                            final /* synthetic */ RealWebSocket this$0;
                            {
                                this.this$0 = realWebSocket;
                                super($name, $cancelable);
                            }

                            public long runOnce() {
                                boolean bl = false;
                                this.this$0.cancel();
                                return -1L;
                            }
                        }, delayNanos$iv);
                    }
                    break block26;
                }
                if (messageOrClose != null) break block26;
                boolean bl4 = false;
                return bl4;
            }
            object = Unit.INSTANCE;
        }
        try {
            if (pong != null) {
                WebSocketWriter webSocketWriter = writer2;
                Intrinsics.checkNotNull((Object)webSocketWriter);
                webSocketWriter.writePong(pong);
            } else if (messageOrClose instanceof Message) {
                Message message2 = (Message)messageOrClose;
                WebSocketWriter webSocketWriter = writer2;
                Intrinsics.checkNotNull((Object)webSocketWriter);
                webSocketWriter.writeMessageFrame(message2.getFormatOpcode(), message2.getData());
                object = this;
                synchronized (object) {
                    boolean bl5 = false;
                    this.queueSize -= (long)message2.getData().size();
                    Unit unit = Unit.INSTANCE;
                }
            } else if (messageOrClose instanceof Close) {
                Close close2 = (Close)messageOrClose;
                WebSocketWriter webSocketWriter = writer2;
                Intrinsics.checkNotNull((Object)webSocketWriter);
                webSocketWriter.writeClose(close2.getCode(), close2.getReason());
                if (streamsToClose != null) {
                    WebSocket webSocket2 = this;
                    String string = receivedCloseReason;
                    Intrinsics.checkNotNull((Object)string);
                    this.listener.onClosed(webSocket2, receivedCloseCode, string);
                }
            } else {
                throw new AssertionError();
            }
            bl = true;
            streams = streamsToClose;
        }
        catch (Throwable throwable) {
            block27: {
                Streams streams2 = streamsToClose;
                if (streams2 != null) {
                    Util.closeQuietly(streams2);
                }
                WebSocketReader webSocketReader = readerToClose;
                if (webSocketReader != null) {
                    Util.closeQuietly(webSocketReader);
                }
                WebSocketWriter webSocketWriter = writerToClose;
                if (webSocketWriter == null) break block27;
                Util.closeQuietly(webSocketWriter);
            }
            throw throwable;
        }
        if (streams != null) {
            Util.closeQuietly(streams);
        }
        WebSocketReader webSocketReader = readerToClose;
        if (webSocketReader != null) {
            Util.closeQuietly(webSocketReader);
        }
        WebSocketWriter webSocketWriter = writerToClose;
        if (webSocketWriter != null) {
            Util.closeQuietly(webSocketWriter);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writePingFrame$okhttp() {
        WebSocketWriter writer2 = null;
        int failedPing = 0;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            boolean bl = false;
            if (this.failed) {
                return;
            }
            WebSocketWriter webSocketWriter = this.writer;
            if (webSocketWriter == null) {
                return;
            }
            writer2 = webSocketWriter;
            failedPing = this.awaitingPong ? this.sentPingCount : -1;
            int n = this.sentPingCount;
            this.sentPingCount = n + 1;
            this.awaitingPong = true;
            Unit unit = Unit.INSTANCE;
        }
        if (failedPing != -1) {
            this.failWebSocket(new SocketTimeoutException("sent ping but didn't receive pong within " + this.pingIntervalMillis + "ms (after " + (failedPing - 1) + " successful ping/pongs)"), null);
            return;
        }
        try {
            writer2.writePing(ByteString.EMPTY);
        }
        catch (IOException e) {
            this.failWebSocket(e, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void failWebSocket(@NotNull Exception e, @Nullable Response response2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Streams streamsToClose = null;
        WebSocketReader readerToClose = null;
        WebSocketWriter writerToClose = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            boolean bl = false;
            if (this.failed) {
                return;
            }
            this.failed = true;
            streamsToClose = this.streams;
            this.streams = null;
            readerToClose = this.reader;
            this.reader = null;
            writerToClose = this.writer;
            this.writer = null;
            this.taskQueue.shutdown();
            Unit unit = Unit.INSTANCE;
        }
        try {
            this.listener.onFailure(this, e, response2);
        }
        finally {
            Streams streams = streamsToClose;
            if (streams != null) {
                Util.closeQuietly(streams);
            }
            WebSocketReader webSocketReader = readerToClose;
            if (webSocketReader != null) {
                Util.closeQuietly(webSocketReader);
            }
            WebSocketWriter webSocketWriter = writerToClose;
            if (webSocketWriter != null) {
                Util.closeQuietly(webSocketWriter);
            }
        }
    }

    public static final /* synthetic */ void access$setExtensions$p(RealWebSocket $this, WebSocketExtensions webSocketExtensions) {
        $this.extensions = webSocketExtensions;
    }

    public static final /* synthetic */ boolean access$isValid(RealWebSocket $this, WebSocketExtensions $receiver) {
        return $this.isValid($receiver);
    }

    public static final /* synthetic */ ArrayDeque access$getMessageAndCloseQueue$p(RealWebSocket $this) {
        return $this.messageAndCloseQueue;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Close;", "", "", "code", "Lokio/ByteString;", "reason", "", "cancelAfterCloseMillis", "<init>", "(ILokio/ByteString;J)V", "J", "getCancelAfterCloseMillis", "()J", "I", "getCode", "()I", "Lokio/ByteString;", "getReason", "()Lokio/ByteString;", "okhttp"})
    public static final class Close {
        private final int code;
        @Nullable
        private final ByteString reason;
        private final long cancelAfterCloseMillis;

        public Close(int code, @Nullable ByteString reason2, long cancelAfterCloseMillis) {
            this.code = code;
            this.reason = reason2;
            this.cancelAfterCloseMillis = cancelAfterCloseMillis;
        }

        public final int getCode() {
            return this.code;
        }

        @Nullable
        public final ByteString getReason() {
            return this.reason;
        }

        public final long getCancelAfterCloseMillis() {
            return this.cancelAfterCloseMillis;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Companion;", "", "<init>", "()V", "", "CANCEL_AFTER_CLOSE_MILLIS", "J", "DEFAULT_MINIMUM_DEFLATE_SIZE", "MAX_QUEUE_SIZE", "", "Lokhttp3/Protocol;", "ONLY_HTTP1", "Ljava/util/List;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Message;", "", "", "formatOpcode", "Lokio/ByteString;", "data", "<init>", "(ILokio/ByteString;)V", "Lokio/ByteString;", "getData", "()Lokio/ByteString;", "I", "getFormatOpcode", "()I", "okhttp"})
    public static final class Message {
        private final int formatOpcode;
        @NotNull
        private final ByteString data;

        public Message(int formatOpcode, @NotNull ByteString data2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            this.formatOpcode = formatOpcode;
            this.data = data2;
        }

        public final int getFormatOpcode() {
            return this.formatOpcode;
        }

        @NotNull
        public final ByteString getData() {
            return this.data;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Streams;", "Ljava/io/Closeable;", "", "client", "Lokio/BufferedSource;", "source", "Lokio/BufferedSink;", "sink", "<init>", "(ZLokio/BufferedSource;Lokio/BufferedSink;)V", "Z", "getClient", "()Z", "Lokio/BufferedSink;", "getSink", "()Lokio/BufferedSink;", "Lokio/BufferedSource;", "getSource", "()Lokio/BufferedSource;", "okhttp"})
    public static abstract class Streams
    implements Closeable {
        private final boolean client;
        @NotNull
        private final BufferedSource source;
        @NotNull
        private final BufferedSink sink;

        public Streams(boolean client, @NotNull BufferedSource source2, @NotNull BufferedSink sink2) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            this.client = client;
            this.source = source2;
            this.sink = sink2;
        }

        public final boolean getClient() {
            return this.client;
        }

        @NotNull
        public final BufferedSource getSource() {
            return this.source;
        }

        @NotNull
        public final BufferedSink getSink() {
            return this.sink;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lokhttp3/internal/ws/RealWebSocket$WriterTask;", "Lokhttp3/internal/concurrent/Task;", "<init>", "(Lokhttp3/internal/ws/RealWebSocket;)V", "", "runOnce", "()J", "okhttp"})
    private final class WriterTask
    extends Task {
        public WriterTask() {
            super(RealWebSocket.this.name + " writer", false, 2, null);
        }

        @Override
        public long runOnce() {
            try {
                if (RealWebSocket.this.writeOneFrame$okhttp()) {
                    return 0L;
                }
            }
            catch (IOException e) {
                RealWebSocket.this.failWebSocket(e, null);
            }
            return -1L;
        }
    }
}

