/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Native;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.common.AbstractFirmware;
import oshi.util.Memoizer;
import oshi.util.Util;
import oshi.util.tuples.Quintet;

@Immutable
final class MacFirmware
extends AbstractFirmware {
    private final Supplier<Quintet<String, String, String, String, String>> manufNameDescVersRelease = Memoizer.memoize(MacFirmware::queryEfi);

    MacFirmware() {
    }

    @Override
    public String getManufacturer() {
        return this.manufNameDescVersRelease.get().getA();
    }

    @Override
    public String getName() {
        return this.manufNameDescVersRelease.get().getB();
    }

    @Override
    public String getDescription() {
        return this.manufNameDescVersRelease.get().getC();
    }

    @Override
    public String getVersion() {
        return this.manufNameDescVersRelease.get().getD();
    }

    @Override
    public String getReleaseDate() {
        return this.manufNameDescVersRelease.get().getE();
    }

    private static Quintet<String, String, String, String, String> queryEfi() {
        String manufacturer = null;
        String name2 = null;
        String description2 = null;
        String version = null;
        String releaseDate = null;
        IOKit.IOService platformExpert = IOKitUtil.getMatchingService("IOPlatformExpertDevice");
        if (platformExpert != null) {
            byte[] data2;
            IOKit.IOIterator iter = platformExpert.getChildIterator("IODeviceTree");
            if (iter != null) {
                IOKit.IORegistryEntry entry = iter.next();
                while (entry != null) {
                    switch (entry.getName()) {
                        case "rom": {
                            data2 = entry.getByteArrayProperty("vendor");
                            if (data2 != null) {
                                manufacturer = Native.toString(data2, StandardCharsets.UTF_8);
                            }
                            if ((data2 = entry.getByteArrayProperty("version")) != null) {
                                version = Native.toString(data2, StandardCharsets.UTF_8);
                            }
                            if ((data2 = entry.getByteArrayProperty("release-date")) == null) break;
                            releaseDate = Native.toString(data2, StandardCharsets.UTF_8);
                            break;
                        }
                        case "chosen": {
                            data2 = entry.getByteArrayProperty("booter-name");
                            if (data2 == null) break;
                            name2 = Native.toString(data2, StandardCharsets.UTF_8);
                            break;
                        }
                        case "efi": {
                            data2 = entry.getByteArrayProperty("firmware-abi");
                            if (data2 == null) break;
                            description2 = Native.toString(data2, StandardCharsets.UTF_8);
                            break;
                        }
                        default: {
                            if (!Util.isBlank(name2)) break;
                            name2 = entry.getStringProperty("IONameMatch");
                        }
                    }
                    entry.release();
                    entry = iter.next();
                }
                iter.release();
            }
            if (Util.isBlank(manufacturer) && (data2 = platformExpert.getByteArrayProperty("manufacturer")) != null) {
                manufacturer = Native.toString(data2, StandardCharsets.UTF_8);
            }
            if (Util.isBlank(version) && (data2 = platformExpert.getByteArrayProperty("target-type")) != null) {
                version = Native.toString(data2, StandardCharsets.UTF_8);
            }
            if (Util.isBlank(name2) && (data2 = platformExpert.getByteArrayProperty("device_type")) != null) {
                name2 = Native.toString(data2, StandardCharsets.UTF_8);
            }
            platformExpert.release();
        }
        return new Quintet<String, String, String, String, String>(Util.isBlank(manufacturer) ? "unknown" : manufacturer, Util.isBlank(name2) ? "unknown" : name2, Util.isBlank(description2) ? "unknown" : description2, Util.isBlank(version) ? "unknown" : version, Util.isBlank(releaseDate) ? "unknown" : releaseDate);
    }
}

