/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser;

import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.annotation.JsonIncludeProperties;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.annotation.ObjectIdGenerators;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.annotation.ObjectIdResolver;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.AbstractTypeResolver;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.AnnotationIntrospector;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.BeanDescription;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.BeanProperty;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.DeserializationConfig;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.DeserializationContext;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JavaType;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JsonMappingException;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.KeyDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.MapperFeature;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.PropertyMetadata;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.PropertyName;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.BasicDeserializerFactory;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.BeanDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.CreatorProperty;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.impl.ErrorThrowingDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.impl.FieldProperty;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.impl.PropertyBasedObjectIdGenerator;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.impl.SetterlessProperty;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.impl.UnsupportedTypeDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.std.ThrowableDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsontype.impl.SubTypeValidator;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.util.BeanUtil;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.util.ClassUtil;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanDeserializerFactory
extends BasicDeserializerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Class<?>[] INIT_CAUSE_PARAMS = new Class[]{Throwable.class};
    public static final BeanDeserializerFactory instance = new BeanDeserializerFactory(new DeserializerFactoryConfig());

    public BeanDeserializerFactory(DeserializerFactoryConfig config2) {
        super(config2);
    }

    @Override
    public DeserializerFactory withConfig(DeserializerFactoryConfig config2) {
        if (this._factoryConfig == config2) {
            return this;
        }
        ClassUtil.verifyMustOverride(BeanDeserializerFactory.class, this, "withConfig");
        return new BeanDeserializerFactory(config2);
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        JavaType concreteType;
        DeserializationConfig config2 = ctxt.getConfig();
        JsonDeserializer<Object> deser = this._findCustomBeanDeserializer(type, config2, beanDesc);
        if (deser != null) {
            if (this._factoryConfig.hasDeserializerModifiers()) {
                for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                    deser = mod.modifyDeserializer(ctxt.getConfig(), beanDesc, deser);
                }
            }
            return deser;
        }
        if (type.isThrowable()) {
            return this.buildThrowableDeserializer(ctxt, type, beanDesc);
        }
        if (type.isAbstract() && !type.isPrimitive() && !type.isEnumType() && (concreteType = this.materializeAbstractType(ctxt, type, beanDesc)) != null) {
            beanDesc = config2.introspect(concreteType);
            return this.buildBeanDeserializer(ctxt, concreteType, beanDesc);
        }
        deser = this.findStdDeserializer(ctxt, type, beanDesc);
        if (deser != null) {
            return deser;
        }
        if (!this.isPotentialBeanType(type.getRawClass())) {
            return null;
        }
        this._validateSubType(ctxt, type, beanDesc);
        deser = this._findUnsupportedTypeDeserializer(ctxt, type, beanDesc);
        if (deser != null) {
            return deser;
        }
        return this.buildBeanDeserializer(ctxt, type, beanDesc);
    }

    @Override
    public JsonDeserializer<Object> createBuilderBasedDeserializer(DeserializationContext ctxt, JavaType valueType, BeanDescription valueBeanDesc, Class<?> builderClass) throws JsonMappingException {
        JavaType builderType = ctxt.isEnabled(MapperFeature.INFER_BUILDER_TYPE_BINDINGS) ? ctxt.getTypeFactory().constructParametricType(builderClass, valueType.getBindings()) : ctxt.constructType(builderClass);
        BeanDescription builderDesc = ctxt.getConfig().introspectForBuilder(builderType, valueBeanDesc);
        return this.buildBuilderBasedDeserializer(ctxt, valueType, builderDesc);
    }

    protected JsonDeserializer<?> findStdDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        JsonDeserializer<?> deser = this.findDefaultDeserializer(ctxt, type, beanDesc);
        if (deser != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deser = mod.modifyDeserializer(ctxt.getConfig(), beanDesc, deser);
            }
        }
        return deser;
    }

    protected JsonDeserializer<Object> _findUnsupportedTypeDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        String errorMsg = BeanUtil.checkUnsupportedType(type);
        if (errorMsg != null && ctxt.getConfig().findMixInClassFor(type.getRawClass()) == null) {
            return new UnsupportedTypeDeserializer(type, errorMsg);
        }
        return null;
    }

    protected JavaType materializeAbstractType(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        for (AbstractTypeResolver r : this._factoryConfig.abstractTypeResolvers()) {
            JavaType concrete = r.resolveAbstractType(ctxt.getConfig(), beanDesc);
            if (concrete == null) continue;
            return concrete;
        }
        return null;
    }

    public JsonDeserializer<Object> buildBeanDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        ValueInstantiator valueInstantiator;
        try {
            valueInstantiator = this.findValueInstantiator(ctxt, beanDesc);
        }
        catch (NoClassDefFoundError error) {
            return new ErrorThrowingDeserializer(error);
        }
        catch (IllegalArgumentException e0) {
            InvalidDefinitionException e = InvalidDefinitionException.from(ctxt.getParser(), ClassUtil.exceptionMessage(e0), beanDesc, null);
            e.initCause(e0);
            throw e;
        }
        BeanDeserializerBuilder builder2 = this.constructBeanDeserializerBuilder(ctxt, beanDesc);
        builder2.setValueInstantiator(valueInstantiator);
        this.addBeanProps(ctxt, beanDesc, builder2);
        this.addObjectIdReader(ctxt, beanDesc, builder2);
        this.addBackReferenceProperties(ctxt, beanDesc, builder2);
        this.addInjectables(ctxt, beanDesc, builder2);
        DeserializationConfig config2 = ctxt.getConfig();
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                builder2 = mod.updateBuilder(config2, beanDesc, builder2);
            }
        }
        JsonDeserializer deserializer = type.isAbstract() && !valueInstantiator.canInstantiate() ? builder2.buildAbstract() : builder2.build();
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deserializer = mod.modifyDeserializer(config2, beanDesc, deserializer);
            }
        }
        return deserializer;
    }

    protected JsonDeserializer<Object> buildBuilderBasedDeserializer(DeserializationContext ctxt, JavaType valueType, BeanDescription builderDesc) throws JsonMappingException {
        ValueInstantiator valueInstantiator;
        try {
            valueInstantiator = this.findValueInstantiator(ctxt, builderDesc);
        }
        catch (NoClassDefFoundError error) {
            return new ErrorThrowingDeserializer(error);
        }
        catch (IllegalArgumentException e) {
            throw InvalidDefinitionException.from(ctxt.getParser(), ClassUtil.exceptionMessage(e), builderDesc, null);
        }
        DeserializationConfig config2 = ctxt.getConfig();
        BeanDeserializerBuilder builder2 = this.constructBeanDeserializerBuilder(ctxt, builderDesc);
        builder2.setValueInstantiator(valueInstantiator);
        this.addBeanProps(ctxt, builderDesc, builder2);
        this.addObjectIdReader(ctxt, builderDesc, builder2);
        this.addBackReferenceProperties(ctxt, builderDesc, builder2);
        this.addInjectables(ctxt, builderDesc, builder2);
        JsonPOJOBuilder.Value builderConfig = builderDesc.findPOJOBuilderConfig();
        String buildMethodName = builderConfig == null ? "build" : builderConfig.buildMethodName;
        AnnotatedMethod buildMethod = builderDesc.findMethod(buildMethodName, null);
        if (buildMethod != null && config2.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(buildMethod.getMember(), config2.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        builder2.setPOJOBuilder(buildMethod, builderConfig);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                builder2 = mod.updateBuilder(config2, builderDesc, builder2);
            }
        }
        JsonDeserializer<Object> deserializer = builder2.buildBuilderBased(valueType, buildMethodName);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deserializer = mod.modifyDeserializer(config2, builderDesc, deserializer);
            }
        }
        return deserializer;
    }

    protected void addObjectIdReader(DeserializationContext ctxt, BeanDescription beanDesc, BeanDeserializerBuilder builder2) throws JsonMappingException {
        ObjectIdGenerator gen;
        JavaType idType;
        SettableBeanProperty idProp;
        ObjectIdInfo objectIdInfo = beanDesc.getObjectIdInfo();
        if (objectIdInfo == null) {
            return;
        }
        Class<? extends ObjectIdGenerator<?>> implClass = objectIdInfo.getGeneratorType();
        ObjectIdResolver resolver = ctxt.objectIdResolverInstance(beanDesc.getClassInfo(), objectIdInfo);
        if (implClass == ObjectIdGenerators.PropertyGenerator.class) {
            PropertyName propName = objectIdInfo.getPropertyName();
            idProp = builder2.findProperty(propName);
            if (idProp == null) {
                throw new IllegalArgumentException(String.format("Invalid Object Id definition for %s: cannot find property with name %s", ClassUtil.getTypeDescription(beanDesc.getType()), ClassUtil.name(propName)));
            }
            idType = idProp.getType();
            gen = new PropertyBasedObjectIdGenerator(objectIdInfo.getScope());
        } else {
            JavaType type = ctxt.constructType(implClass);
            idType = ctxt.getTypeFactory().findTypeParameters(type, ObjectIdGenerator.class)[0];
            idProp = null;
            gen = ctxt.objectIdGeneratorInstance(beanDesc.getClassInfo(), objectIdInfo);
        }
        JsonDeserializer<Object> deser = ctxt.findRootValueDeserializer(idType);
        builder2.setObjectIdReader(ObjectIdReader.construct(idType, objectIdInfo.getPropertyName(), gen, deser, idProp, resolver));
    }

    public JsonDeserializer<Object> buildThrowableDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        JsonDeserializer deserializer;
        Object propDef;
        SettableBeanProperty prop;
        DeserializationConfig config2 = ctxt.getConfig();
        BeanDeserializerBuilder builder2 = this.constructBeanDeserializerBuilder(ctxt, beanDesc);
        builder2.setValueInstantiator(this.findValueInstantiator(ctxt, beanDesc));
        this.addBeanProps(ctxt, beanDesc, builder2);
        AnnotatedMethod am = beanDesc.findMethod("initCause", INIT_CAUSE_PARAMS);
        if (am != null && (prop = this.constructSettableProperty(ctxt, beanDesc, (BeanPropertyDefinition)(propDef = SimpleBeanPropertyDefinition.construct(ctxt.getConfig(), am, new PropertyName("cause"))), am.getParameterType(0))) != null) {
            builder2.addOrReplaceProperty(prop, true);
        }
        builder2.addIgnorable("localizedMessage");
        builder2.addIgnorable("suppressed");
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                builder2 = mod.updateBuilder(config2, beanDesc, builder2);
            }
        }
        if ((deserializer = builder2.build()) instanceof BeanDeserializer) {
            deserializer = new ThrowableDeserializer((BeanDeserializer)deserializer);
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deserializer = mod.modifyDeserializer(config2, beanDesc, deserializer);
            }
        }
        return deserializer;
    }

    protected BeanDeserializerBuilder constructBeanDeserializerBuilder(DeserializationContext ctxt, BeanDescription beanDesc) {
        return new BeanDeserializerBuilder(beanDesc, ctxt);
    }

    protected void addBeanProps(DeserializationContext ctxt, BeanDescription beanDesc, BeanDeserializerBuilder builder2) throws JsonMappingException {
        AnnotatedMember anySetter;
        Set<Object> ignored;
        boolean isConcrete = !beanDesc.getType().isAbstract();
        SettableBeanProperty[] creatorProps = isConcrete ? builder2.getValueInstantiator().getFromObjectArguments(ctxt.getConfig()) : null;
        boolean hasCreatorProps = creatorProps != null;
        JsonIgnoreProperties.Value ignorals = ctxt.getConfig().getDefaultPropertyIgnorals(beanDesc.getBeanClass(), beanDesc.getClassInfo());
        if (ignorals != null) {
            boolean ignoreAny = ignorals.getIgnoreUnknown();
            builder2.setIgnoreUnknownProperties(ignoreAny);
            ignored = ignorals.findIgnoredForDeserialization();
            for (Object propName : ignored) {
                builder2.addIgnorable((String)propName);
            }
        } else {
            ignored = Collections.emptySet();
        }
        JsonIncludeProperties.Value inclusions = ctxt.getConfig().getDefaultPropertyInclusions(beanDesc.getBeanClass(), beanDesc.getClassInfo());
        Set<String> included = null;
        if (inclusions != null && (included = inclusions.getIncluded()) != null) {
            for (String propName : included) {
                builder2.addIncludable(propName);
            }
        }
        if ((anySetter = beanDesc.findAnySetterAccessor()) != null) {
            builder2.setAnySetter(this.constructAnySetter(ctxt, beanDesc, anySetter));
        } else {
            Set<String> ignored2 = beanDesc.getIgnoredPropertyNames();
            if (ignored2 != null) {
                for (String propName : ignored2) {
                    builder2.addIgnorable(propName);
                }
            }
        }
        boolean useGettersAsSetters = ctxt.isEnabled(MapperFeature.USE_GETTERS_AS_SETTERS) && ctxt.isEnabled(MapperFeature.AUTO_DETECT_GETTERS);
        List<BeanPropertyDefinition> propDefs = this.filterBeanProps(ctxt, beanDesc, builder2, beanDesc.findProperties(), ignored, included);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                propDefs = mod.updateProperties(ctxt.getConfig(), beanDesc, propDefs);
            }
        }
        for (BeanPropertyDefinition propDef : propDefs) {
            JavaType propertyType;
            SettableBeanProperty prop = null;
            if (propDef.hasSetter()) {
                AnnotatedMethod setter = propDef.getSetter();
                propertyType = setter.getParameterType(0);
                prop = this.constructSettableProperty(ctxt, beanDesc, propDef, propertyType);
            } else if (propDef.hasField()) {
                AnnotatedField field2 = propDef.getField();
                propertyType = field2.getType();
                prop = this.constructSettableProperty(ctxt, beanDesc, propDef, propertyType);
            } else {
                AnnotatedMethod getter = propDef.getGetter();
                if (getter != null) {
                    PropertyMetadata md;
                    if (useGettersAsSetters && this._isSetterlessType(getter.getRawType())) {
                        if (!builder2.hasIgnorable(propDef.getName())) {
                            prop = this.constructSetterlessProperty(ctxt, beanDesc, propDef);
                        }
                    } else if (!propDef.hasConstructorParameter() && (md = propDef.getMetadata()).getMergeInfo() != null) {
                        prop = this.constructSetterlessProperty(ctxt, beanDesc, propDef);
                    }
                }
            }
            if (hasCreatorProps && propDef.hasConstructorParameter()) {
                Class<?>[] views;
                String name2 = propDef.getName();
                CreatorProperty cprop = null;
                for (SettableBeanProperty cp : creatorProps) {
                    if (!name2.equals(cp.getName()) || !(cp instanceof CreatorProperty)) continue;
                    cprop = (CreatorProperty)cp;
                    break;
                }
                if (cprop == null) {
                    ArrayList<String> n = new ArrayList<String>();
                    for (SettableBeanProperty cp : creatorProps) {
                        n.add(cp.getName());
                    }
                    ctxt.reportBadPropertyDefinition(beanDesc, propDef, "Could not find creator property with name %s (known Creator properties: %s)", ClassUtil.name(name2), n);
                    continue;
                }
                if (prop != null) {
                    cprop.setFallbackSetter(prop);
                }
                if ((views = propDef.findViews()) == null) {
                    views = beanDesc.findDefaultViews();
                }
                cprop.setViews(views);
                builder2.addCreatorProperty(cprop);
                continue;
            }
            if (prop == null) continue;
            Class<?>[] views = propDef.findViews();
            if (views == null) {
                views = beanDesc.findDefaultViews();
            }
            prop.setViews(views);
            builder2.addProperty(prop);
        }
    }

    private boolean _isSetterlessType(Class<?> rawType) {
        return Collection.class.isAssignableFrom(rawType) || Map.class.isAssignableFrom(rawType);
    }

    @Deprecated
    protected List<BeanPropertyDefinition> filterBeanProps(DeserializationContext ctxt, BeanDescription beanDesc, BeanDeserializerBuilder builder2, List<BeanPropertyDefinition> propDefsIn, Set<String> ignored) throws JsonMappingException {
        return this.filterBeanProps(ctxt, beanDesc, builder2, propDefsIn, ignored, null);
    }

    protected List<BeanPropertyDefinition> filterBeanProps(DeserializationContext ctxt, BeanDescription beanDesc, BeanDeserializerBuilder builder2, List<BeanPropertyDefinition> propDefsIn, Set<String> ignored, Set<String> included) {
        ArrayList<BeanPropertyDefinition> result2 = new ArrayList<BeanPropertyDefinition>(Math.max(4, propDefsIn.size()));
        HashMap ignoredTypes = new HashMap();
        for (BeanPropertyDefinition property2 : propDefsIn) {
            Class<?> rawPropertyType;
            String name2 = property2.getName();
            if (IgnorePropertiesUtil.shouldIgnore(name2, ignored, included)) continue;
            if (!property2.hasConstructorParameter() && (rawPropertyType = property2.getRawPrimaryType()) != null && this.isIgnorableType(ctxt.getConfig(), property2, rawPropertyType, ignoredTypes)) {
                builder2.addIgnorable(name2);
                continue;
            }
            result2.add(property2);
        }
        return result2;
    }

    protected void addBackReferenceProperties(DeserializationContext ctxt, BeanDescription beanDesc, BeanDeserializerBuilder builder2) throws JsonMappingException {
        List<BeanPropertyDefinition> refProps = beanDesc.findBackReferences();
        if (refProps != null) {
            for (BeanPropertyDefinition refProp : refProps) {
                String refName = refProp.findReferenceName();
                builder2.addBackReferenceProperty(refName, this.constructSettableProperty(ctxt, beanDesc, refProp, refProp.getPrimaryType()));
            }
        }
    }

    @Deprecated
    protected void addReferenceProperties(DeserializationContext ctxt, BeanDescription beanDesc, BeanDeserializerBuilder builder2) throws JsonMappingException {
        this.addBackReferenceProperties(ctxt, beanDesc, builder2);
    }

    protected void addInjectables(DeserializationContext ctxt, BeanDescription beanDesc, BeanDeserializerBuilder builder2) throws JsonMappingException {
        Map<Object, AnnotatedMember> raw = beanDesc.findInjectables();
        if (raw != null) {
            for (Map.Entry<Object, AnnotatedMember> entry : raw.entrySet()) {
                AnnotatedMember m = entry.getValue();
                builder2.addInjectable(PropertyName.construct(m.getName()), m.getType(), beanDesc.getClassAnnotations(), m, entry.getKey());
            }
        }
    }

    protected SettableAnyProperty constructAnySetter(DeserializationContext ctxt, BeanDescription beanDesc, AnnotatedMember mutator) throws JsonMappingException {
        BeanProperty.Std prop;
        JavaType valueType;
        JavaType keyType;
        if (mutator instanceof AnnotatedMethod) {
            AnnotatedMethod am = (AnnotatedMethod)mutator;
            keyType = am.getParameterType(0);
            valueType = am.getParameterType(1);
            valueType = this.resolveMemberAndTypeAnnotations(ctxt, mutator, valueType);
            prop = new BeanProperty.Std(PropertyName.construct(mutator.getName()), valueType, null, mutator, PropertyMetadata.STD_OPTIONAL);
        } else if (mutator instanceof AnnotatedField) {
            AnnotatedField af = (AnnotatedField)mutator;
            JavaType mapType = af.getType();
            mapType = this.resolveMemberAndTypeAnnotations(ctxt, mutator, mapType);
            keyType = mapType.getKeyType();
            valueType = mapType.getContentType();
            prop = new BeanProperty.Std(PropertyName.construct(mutator.getName()), mapType, null, mutator, PropertyMetadata.STD_OPTIONAL);
        } else {
            return (SettableAnyProperty)ctxt.reportBadDefinition(beanDesc.getType(), String.format("Unrecognized mutator type for any setter: %s", mutator.getClass()));
        }
        KeyDeserializer keyDeser = this.findKeyDeserializerFromAnnotation(ctxt, mutator);
        if (keyDeser == null) {
            keyDeser = (KeyDeserializer)keyType.getValueHandler();
        }
        if (keyDeser == null) {
            keyDeser = ctxt.findKeyDeserializer(keyType, prop);
        } else if (keyDeser instanceof ContextualKeyDeserializer) {
            keyDeser = ((ContextualKeyDeserializer)((Object)keyDeser)).createContextual(ctxt, prop);
        }
        JsonDeserializer<Object> deser = this.findContentDeserializerFromAnnotation(ctxt, mutator);
        if (deser == null) {
            deser = (JsonDeserializer<Object>)valueType.getValueHandler();
        }
        if (deser != null) {
            deser = ctxt.handlePrimaryContextualization(deser, prop, valueType);
        }
        TypeDeserializer typeDeser = (TypeDeserializer)valueType.getTypeHandler();
        return new SettableAnyProperty(prop, mutator, valueType, keyDeser, deser, typeDeser);
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationContext ctxt, BeanDescription beanDesc, BeanPropertyDefinition propDef, JavaType propType0) throws JsonMappingException {
        ObjectIdInfo objectIdInfo;
        AnnotationIntrospector.ReferenceProperty ref;
        AnnotatedMember mutator = propDef.getNonConstructorMutator();
        if (mutator == null) {
            ctxt.reportBadPropertyDefinition(beanDesc, propDef, "No non-constructor mutator available", new Object[0]);
        }
        JavaType type = this.resolveMemberAndTypeAnnotations(ctxt, mutator, propType0);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty prop = mutator instanceof AnnotatedMethod ? new MethodProperty(propDef, type, typeDeser, beanDesc.getClassAnnotations(), (AnnotatedMethod)mutator) : new FieldProperty(propDef, type, typeDeser, beanDesc.getClassAnnotations(), (AnnotatedField)mutator);
        JsonDeserializer<?> deser = this.findDeserializerFromAnnotation(ctxt, mutator);
        if (deser == null) {
            deser = (JsonDeserializer<?>)type.getValueHandler();
        }
        if (deser != null) {
            deser = ctxt.handlePrimaryContextualization(deser, prop, type);
            prop = prop.withValueDeserializer(deser);
        }
        if ((ref = propDef.findReferenceType()) != null && ref.isManagedReference()) {
            prop.setManagedReferenceName(ref.getName());
        }
        if ((objectIdInfo = propDef.findObjectIdInfo()) != null) {
            prop.setObjectIdInfo(objectIdInfo);
        }
        return prop;
    }

    protected SettableBeanProperty constructSetterlessProperty(DeserializationContext ctxt, BeanDescription beanDesc, BeanPropertyDefinition propDef) throws JsonMappingException {
        AnnotatedMethod getter = propDef.getGetter();
        JavaType type = this.resolveMemberAndTypeAnnotations(ctxt, getter, getter.getType());
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty prop = new SetterlessProperty(propDef, type, typeDeser, beanDesc.getClassAnnotations(), getter);
        JsonDeserializer<?> deser = this.findDeserializerFromAnnotation(ctxt, getter);
        if (deser == null) {
            deser = (JsonDeserializer<?>)type.getValueHandler();
        }
        if (deser != null) {
            deser = ctxt.handlePrimaryContextualization(deser, prop, type);
            prop = ((SettableBeanProperty)prop).withValueDeserializer(deser);
        }
        return prop;
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        String typeStr = ClassUtil.canBeABeanType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Cannot deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        if (ClassUtil.isProxyType(type)) {
            throw new IllegalArgumentException("Cannot deserialize Proxy class " + type.getName() + " as a Bean");
        }
        typeStr = ClassUtil.isLocalType(type, true);
        if (typeStr != null) {
            throw new IllegalArgumentException("Cannot deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        return true;
    }

    protected boolean isIgnorableType(DeserializationConfig config2, BeanPropertyDefinition propDef, Class<?> type, Map<Class<?>, Boolean> ignoredTypes) {
        Boolean status2 = ignoredTypes.get(type);
        if (status2 != null) {
            return status2;
        }
        if (type == String.class || type.isPrimitive()) {
            status2 = Boolean.FALSE;
        } else {
            status2 = config2.getConfigOverride(type).getIsIgnoredType();
            if (status2 == null) {
                BeanDescription desc = config2.introspectClassAnnotations(type);
                status2 = config2.getAnnotationIntrospector().isIgnorableType(desc.getClassInfo());
                if (status2 == null) {
                    status2 = Boolean.FALSE;
                }
            }
        }
        ignoredTypes.put(type, status2);
        return status2;
    }

    protected void _validateSubType(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        SubTypeValidator.instance().validateSubType(ctxt, type, beanDesc);
    }
}

