/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.impl;

import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.JsonParser;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.DeserializationConfig;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.DeserializationContext;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public final class ManagedReferenceProperty
extends SettableBeanProperty.Delegating {
    private static final long serialVersionUID = 1L;
    protected final String _referenceName;
    protected final boolean _isContainer;
    protected final SettableBeanProperty _backProperty;

    public ManagedReferenceProperty(SettableBeanProperty forward, String refName, SettableBeanProperty backward, boolean isContainer) {
        super(forward);
        this._referenceName = refName;
        this._backProperty = backward;
        this._isContainer = isContainer;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty d) {
        throw new IllegalStateException("Should never try to reset delegate");
    }

    @Override
    public void fixAccess(DeserializationConfig config2) {
        this.delegate.fixAccess(config2);
        this._backProperty.fixAccess(config2);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        this.set(instance, this.delegate.deserialize(p, ctxt));
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        return this.setAndReturn(instance, this.deserialize(p, ctxt));
    }

    @Override
    public final void set(Object instance, Object value2) throws IOException {
        this.setAndReturn(instance, value2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object setAndReturn(Object instance, Object value2) throws IOException {
        if (value2 == null) return this.delegate.setAndReturn(instance, value2);
        if (this._isContainer) {
            if (value2 instanceof Object[]) {
                for (Object ob : (Object[])value2) {
                    if (ob == null) continue;
                    this._backProperty.set(ob, instance);
                }
                return this.delegate.setAndReturn(instance, value2);
            } else if (value2 instanceof Collection) {
                for (Object ob : (Collection)value2) {
                    if (ob == null) continue;
                    this._backProperty.set(ob, instance);
                }
                return this.delegate.setAndReturn(instance, value2);
            } else {
                if (!(value2 instanceof Map)) throw new IllegalStateException("Unsupported container type (" + value2.getClass().getName() + ") when resolving reference '" + this._referenceName + "'");
                for (Object ob : ((Map)value2).values()) {
                    if (ob == null) continue;
                    this._backProperty.set(ob, instance);
                }
            }
            return this.delegate.setAndReturn(instance, value2);
        } else {
            this._backProperty.set(value2, instance);
        }
        return this.delegate.setAndReturn(instance, value2);
    }
}

