/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.std;

import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.BeanDescription;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.DeserializationConfig;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JavaType;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JsonMappingException;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.KeyDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.MapperFeature;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.KeyDeserializers;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.util.ClassUtil;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    private static final long serialVersionUID = 1L;

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver) {
        return new StdKeyDeserializer.EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, AnnotatedMethod factory2) {
        return new StdKeyDeserializer.EnumKD(enumResolver, factory2);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig config2, JavaType type, JsonDeserializer<?> deser) {
        return new StdKeyDeserializer.DelegatingKD(type.getRawClass(), deser);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig config2, JavaType type) {
        BeanDescription beanDesc = config2.introspect(type);
        Constructor<?> ctor = beanDesc.findSingleArgConstructor(String.class);
        if (ctor != null) {
            if (config2.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(ctor, config2.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new StdKeyDeserializer.StringCtorKeyDeserializer(ctor);
        }
        Method m = beanDesc.findFactoryMethod(String.class);
        if (m != null) {
            if (config2.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(m, config2.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new StdKeyDeserializer.StringFactoryKeyDeserializer(m);
        }
        return null;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType type, DeserializationConfig config2, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (raw.isPrimitive()) {
            raw = ClassUtil.wrapperType(raw);
        }
        return StdKeyDeserializer.forType(raw);
    }
}

