/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.ser.std;

import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.JsonGenerator;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.JsonToken;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.type.WritableTypeId;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JavaType;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JsonMappingException;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JsonNode;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.SerializerProvider;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value2) {
        return value2.length == 0;
    }

    @Override
    public void serialize(byte[] value2, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBinary(provider.getConfig().getBase64Variant(), value2, 0, value2.length);
    }

    @Override
    public void serializeWithType(byte[] value2, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value2, JsonToken.VALUE_EMBEDDED_OBJECT));
        g.writeBinary(provider.getConfig().getBase64Variant(), value2, 0, value2.length);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

