/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.ser.std;

import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.annotation.JsonFormat;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.JsonGenerator;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.JsonParser;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.BeanProperty;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JavaType;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JsonMappingException;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JsonNode;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JsonSerializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.SerializerProvider;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.ser.std.ToStringSerializerBase;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

@JacksonStdImpl
public class NumberSerializer
extends StdScalarSerializer<Number>
implements ContextualSerializer {
    public static final NumberSerializer instance = new NumberSerializer((Class<? extends Number>)Number.class);
    protected static final int MAX_BIG_DECIMAL_SCALE = 9999;
    protected final boolean _isInt;

    public NumberSerializer(Class<? extends Number> rawType) {
        super(rawType, false);
        this._isInt = rawType == BigInteger.class;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property2) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(prov, property2, this.handledType());
        if (format != null) {
            switch (format.getShape()) {
                case STRING: {
                    if (this.handledType() == BigDecimal.class) {
                        return NumberSerializer.bigDecimalAsStringSerializer();
                    }
                    return ToStringSerializer.instance;
                }
            }
        }
        return this;
    }

    @Override
    public void serialize(Number value2, JsonGenerator g, SerializerProvider provider) throws IOException {
        if (value2 instanceof BigDecimal) {
            g.writeNumber((BigDecimal)value2);
        } else if (value2 instanceof BigInteger) {
            g.writeNumber((BigInteger)value2);
        } else if (value2 instanceof Long) {
            g.writeNumber(value2.longValue());
        } else if (value2 instanceof Double) {
            g.writeNumber(value2.doubleValue());
        } else if (value2 instanceof Float) {
            g.writeNumber(value2.floatValue());
        } else if (value2 instanceof Integer || value2 instanceof Byte || value2 instanceof Short) {
            g.writeNumber(value2.intValue());
        } else {
            g.writeNumber(value2.toString());
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._isInt ? "integer" : "number", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (this._isInt) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.BIG_INTEGER);
        } else if (this.handledType() == BigDecimal.class) {
            this.visitFloatFormat(visitor, typeHint, JsonParser.NumberType.BIG_DECIMAL);
        } else {
            visitor.expectNumberFormat(typeHint);
        }
    }

    public static JsonSerializer<?> bigDecimalAsStringSerializer() {
        return BigDecimalAsStringSerializer.BD_INSTANCE;
    }

    static final class BigDecimalAsStringSerializer
    extends ToStringSerializerBase {
        static final BigDecimalAsStringSerializer BD_INSTANCE = new BigDecimalAsStringSerializer();

        public BigDecimalAsStringSerializer() {
            super(BigDecimal.class);
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, Object value2) {
            return false;
        }

        @Override
        public void serialize(Object value2, JsonGenerator gen, SerializerProvider provider) throws IOException {
            String text;
            if (gen.isEnabled(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN)) {
                BigDecimal bd = (BigDecimal)value2;
                if (!this._verifyBigDecimalRange(gen, bd)) {
                    String errorMsg = String.format("Attempt to write plain `java.math.BigDecimal` (see JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) with illegal scale (%d): needs to be between [-%d, %d]", bd.scale(), 9999, 9999);
                    provider.reportMappingProblem(errorMsg, new Object[0]);
                }
                text = bd.toPlainString();
            } else {
                text = value2.toString();
            }
            gen.writeString(text);
        }

        @Override
        public String valueToString(Object value2) {
            throw new IllegalStateException();
        }

        protected boolean _verifyBigDecimalRange(JsonGenerator gen, BigDecimal value2) throws IOException {
            int scale = value2.scale();
            return scale >= -9999 && scale <= 9999;
        }
    }
}

