/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl;

import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.ICUCache;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.ICUResourceBundle;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.OlsonTimeZone;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.SimpleCache;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.SoftCache;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.Utility;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.Output;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.SimpleTimeZone;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.TimeZone;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.UResourceBundle;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeSet;

public final class ZoneMeta {
    private static final boolean ASSERT = false;
    private static final String ZONEINFORESNAME = "zoneinfo64";
    private static final String kREGIONS = "Regions";
    private static final String kZONES = "Zones";
    private static final String kNAMES = "Names";
    private static final String kGMT_ID = "GMT";
    private static final String kCUSTOM_TZ_PREFIX = "GMT";
    private static final String kWorld = "001";
    private static SoftReference<Set<String>> REF_SYSTEM_ZONES;
    private static SoftReference<Set<String>> REF_CANONICAL_SYSTEM_ZONES;
    private static SoftReference<Set<String>> REF_CANONICAL_SYSTEM_LOCATION_ZONES;
    private static String[] ZONEIDS;
    private static ICUCache<String, String> CANONICAL_ID_CACHE;
    private static ICUCache<String, String> REGION_CACHE;
    private static ICUCache<String, Boolean> SINGLE_COUNTRY_CACHE;
    private static final SystemTimeZoneCache SYSTEM_ZONE_CACHE;
    private static final int kMAX_CUSTOM_HOUR = 23;
    private static final int kMAX_CUSTOM_MIN = 59;
    private static final int kMAX_CUSTOM_SEC = 59;
    private static final CustomTimeZoneCache CUSTOM_ZONE_CACHE;

    private static synchronized Set<String> getSystemZIDs() {
        Set<String> systemZones = null;
        if (REF_SYSTEM_ZONES != null) {
            systemZones = REF_SYSTEM_ZONES.get();
        }
        if (systemZones == null) {
            String[] allIDs;
            TreeSet<String> systemIDs = new TreeSet<String>();
            for (String id2 : allIDs = ZoneMeta.getZoneIDs()) {
                if (id2.equals("Etc/Unknown")) continue;
                systemIDs.add(id2);
            }
            systemZones = Collections.unmodifiableSet(systemIDs);
            REF_SYSTEM_ZONES = new SoftReference<Set<String>>(systemZones);
        }
        return systemZones;
    }

    private static synchronized Set<String> getCanonicalSystemZIDs() {
        Set<String> canonicalSystemZones = null;
        if (REF_CANONICAL_SYSTEM_ZONES != null) {
            canonicalSystemZones = REF_CANONICAL_SYSTEM_ZONES.get();
        }
        if (canonicalSystemZones == null) {
            String[] allIDs;
            TreeSet<String> canonicalSystemIDs = new TreeSet<String>();
            for (String id2 : allIDs = ZoneMeta.getZoneIDs()) {
                String canonicalID;
                if (id2.equals("Etc/Unknown") || !id2.equals(canonicalID = ZoneMeta.getCanonicalCLDRID(id2))) continue;
                canonicalSystemIDs.add(id2);
            }
            canonicalSystemZones = Collections.unmodifiableSet(canonicalSystemIDs);
            REF_CANONICAL_SYSTEM_ZONES = new SoftReference<Set<String>>(canonicalSystemZones);
        }
        return canonicalSystemZones;
    }

    private static synchronized Set<String> getCanonicalSystemLocationZIDs() {
        Set<String> canonicalSystemLocationZones = null;
        if (REF_CANONICAL_SYSTEM_LOCATION_ZONES != null) {
            canonicalSystemLocationZones = REF_CANONICAL_SYSTEM_LOCATION_ZONES.get();
        }
        if (canonicalSystemLocationZones == null) {
            String[] allIDs;
            TreeSet<String> canonicalSystemLocationIDs = new TreeSet<String>();
            for (String id2 : allIDs = ZoneMeta.getZoneIDs()) {
                String region2;
                String canonicalID;
                if (id2.equals("Etc/Unknown") || !id2.equals(canonicalID = ZoneMeta.getCanonicalCLDRID(id2)) || (region2 = ZoneMeta.getRegion(id2)) == null || region2.equals(kWorld)) continue;
                canonicalSystemLocationIDs.add(id2);
            }
            canonicalSystemLocationZones = Collections.unmodifiableSet(canonicalSystemLocationIDs);
            REF_CANONICAL_SYSTEM_LOCATION_ZONES = new SoftReference<Set<String>>(canonicalSystemLocationZones);
        }
        return canonicalSystemLocationZones;
    }

    public static Set<String> getAvailableIDs(TimeZone.SystemTimeZoneType type, String region2, Integer rawOffset) {
        Set<String> baseSet = null;
        switch (type) {
            case ANY: {
                baseSet = ZoneMeta.getSystemZIDs();
                break;
            }
            case CANONICAL: {
                baseSet = ZoneMeta.getCanonicalSystemZIDs();
                break;
            }
            case CANONICAL_LOCATION: {
                baseSet = ZoneMeta.getCanonicalSystemLocationZIDs();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SystemTimeZoneType");
            }
        }
        if (region2 == null && rawOffset == null) {
            return baseSet;
        }
        if (region2 != null) {
            region2 = region2.toUpperCase(Locale.ENGLISH);
        }
        TreeSet<String> result2 = new TreeSet<String>();
        for (String id2 : baseSet) {
            OlsonTimeZone z;
            String r;
            if (region2 != null && !region2.equals(r = ZoneMeta.getRegion(id2)) || rawOffset != null && ((z = ZoneMeta.getSystemTimeZone(id2)) == null || !rawOffset.equals(((TimeZone)z).getRawOffset()))) continue;
            result2.add(id2);
        }
        if (result2.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result2);
    }

    public static synchronized int countEquivalentIDs(String id2) {
        int count2 = 0;
        UResourceBundle res = ZoneMeta.openOlsonResource(null, id2);
        if (res != null) {
            try {
                UResourceBundle links = res.get("links");
                int[] v = links.getIntVector();
                count2 = v.length;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return count2;
    }

    public static synchronized String getEquivalentID(String id2, int index) {
        UResourceBundle res;
        String result2 = "";
        if (index >= 0 && (res = ZoneMeta.openOlsonResource(null, id2)) != null) {
            String tmp;
            int zoneIdx = -1;
            try {
                UResourceBundle links = res.get("links");
                int[] zones = links.getIntVector();
                if (index < zones.length) {
                    zoneIdx = zones[index];
                }
            }
            catch (MissingResourceException links) {
                // empty catch block
            }
            if (zoneIdx >= 0 && (tmp = ZoneMeta.getZoneID(zoneIdx)) != null) {
                result2 = tmp;
            }
        }
        return result2;
    }

    private static synchronized String[] getZoneIDs() {
        if (ZONEIDS == null) {
            try {
                UResourceBundle top = UResourceBundle.getBundleInstance("io/github/quiltservertools/blockbotdiscord/libs/com/ibm/icu/impl/data/icudata", ZONEINFORESNAME, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                ZONEIDS = top.getStringArray(kNAMES);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (ZONEIDS == null) {
            ZONEIDS = new String[0];
        }
        return ZONEIDS;
    }

    private static String getZoneID(int idx) {
        String[] ids;
        if (idx >= 0 && idx < (ids = ZoneMeta.getZoneIDs()).length) {
            return ids[idx];
        }
        return null;
    }

    private static int getZoneIndex(String zid) {
        int zoneIdx = -1;
        String[] all = ZoneMeta.getZoneIDs();
        if (all.length > 0) {
            int mid;
            int start2 = 0;
            int limit2 = all.length;
            int lastMid = Integer.MAX_VALUE;
            while (lastMid != (mid = (start2 + limit2) / 2)) {
                lastMid = mid;
                int r = zid.compareTo(all[mid]);
                if (r == 0) {
                    zoneIdx = mid;
                    break;
                }
                if (r < 0) {
                    limit2 = mid;
                    continue;
                }
                start2 = mid;
            }
        }
        return zoneIdx;
    }

    public static String getCanonicalCLDRID(TimeZone tz) {
        if (tz instanceof OlsonTimeZone) {
            return ((OlsonTimeZone)tz).getCanonicalID();
        }
        return ZoneMeta.getCanonicalCLDRID(tz.getID());
    }

    public static String getCanonicalCLDRID(String tzid) {
        String canonical = CANONICAL_ID_CACHE.get(tzid);
        if (canonical == null) {
            canonical = ZoneMeta.findCLDRCanonicalID(tzid);
            if (canonical == null) {
                try {
                    int zoneIdx = ZoneMeta.getZoneIndex(tzid);
                    if (zoneIdx >= 0) {
                        UResourceBundle top = UResourceBundle.getBundleInstance("io/github/quiltservertools/blockbotdiscord/libs/com/ibm/icu/impl/data/icudata", ZONEINFORESNAME, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                        UResourceBundle zones = top.get(kZONES);
                        UResourceBundle zone = zones.get(zoneIdx);
                        if (zone.getType() == 7) {
                            tzid = ZoneMeta.getZoneID(zone.getInt());
                            canonical = ZoneMeta.findCLDRCanonicalID(tzid);
                        }
                        if (canonical == null) {
                            canonical = tzid;
                        }
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (canonical != null) {
                CANONICAL_ID_CACHE.put(tzid, canonical);
            }
        }
        return canonical;
    }

    private static String findCLDRCanonicalID(String tzid) {
        String canonical = null;
        String tzidKey = tzid.replace('/', ':');
        try {
            UResourceBundle keyTypeData = UResourceBundle.getBundleInstance("io/github/quiltservertools/blockbotdiscord/libs/com/ibm/icu/impl/data/icudata", "keyTypeData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle typeMap = keyTypeData.get("typeMap");
            UResourceBundle typeKeys = typeMap.get("timezone");
            try {
                typeKeys.get(tzidKey);
                canonical = tzid;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (canonical == null) {
                UResourceBundle typeAlias = keyTypeData.get("typeAlias");
                UResourceBundle aliasesForKey = typeAlias.get("timezone");
                canonical = aliasesForKey.getString(tzidKey);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return canonical;
    }

    public static String getIanaID(String tzid) {
        String canonicalID = ZoneMeta.getCanonicalCLDRID(tzid);
        if (canonicalID == null) {
            return null;
        }
        UResourceBundle keyTypeData = UResourceBundle.getBundleInstance("io/github/quiltservertools/blockbotdiscord/libs/com/ibm/icu/impl/data/icudata", "keyTypeData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle ianaMap = keyTypeData.get("ianaMap");
        UResourceBundle ianaTzMap = ianaMap.get("timezone");
        try {
            return ianaTzMap.getString(canonicalID.replace('/', ':'));
        }
        catch (MissingResourceException e) {
            return canonicalID;
        }
    }

    public static String getRegion(String tzid) {
        int zoneIdx;
        String region2 = REGION_CACHE.get(tzid);
        if (region2 == null && (zoneIdx = ZoneMeta.getZoneIndex(tzid)) >= 0) {
            try {
                UResourceBundle top = UResourceBundle.getBundleInstance("io/github/quiltservertools/blockbotdiscord/libs/com/ibm/icu/impl/data/icudata", ZONEINFORESNAME, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                UResourceBundle regions2 = top.get(kREGIONS);
                if (zoneIdx < regions2.getSize()) {
                    region2 = regions2.getString(zoneIdx);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (region2 != null) {
                REGION_CACHE.put(tzid, region2);
            }
        }
        return region2;
    }

    public static String getCanonicalCountry(String tzid) {
        String country = ZoneMeta.getRegion(tzid);
        if (country != null && country.equals(kWorld)) {
            country = null;
        }
        return country;
    }

    public static String getCanonicalCountry(String tzid, Output<Boolean> isPrimary) {
        isPrimary.value = Boolean.FALSE;
        String country = ZoneMeta.getRegion(tzid);
        if (country != null && country.equals(kWorld)) {
            return null;
        }
        Boolean singleZone = SINGLE_COUNTRY_CACHE.get(tzid);
        if (singleZone == null) {
            Set<String> ids = TimeZone.getAvailableIDs(TimeZone.SystemTimeZoneType.CANONICAL_LOCATION, country, null);
            assert (ids.size() >= 1);
            singleZone = ids.size() <= 1;
            SINGLE_COUNTRY_CACHE.put(tzid, singleZone);
        }
        if (singleZone.booleanValue()) {
            isPrimary.value = Boolean.TRUE;
        } else {
            try {
                UResourceBundle bundle = UResourceBundle.getBundleInstance("io/github/quiltservertools/blockbotdiscord/libs/com/ibm/icu/impl/data/icudata", "metaZones");
                UResourceBundle primaryZones = bundle.get("primaryZones");
                String primaryZone = primaryZones.getString(country);
                if (tzid.equals(primaryZone)) {
                    isPrimary.value = Boolean.TRUE;
                } else {
                    String canonicalID = ZoneMeta.getCanonicalCLDRID(tzid);
                    if (canonicalID != null && canonicalID.equals(primaryZone)) {
                        isPrimary.value = Boolean.TRUE;
                    }
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return country;
    }

    public static UResourceBundle openOlsonResource(UResourceBundle top, String id2) {
        UResourceBundle res = null;
        int zoneIdx = ZoneMeta.getZoneIndex(id2);
        if (zoneIdx >= 0) {
            try {
                UResourceBundle zones;
                UResourceBundle zone;
                if (top == null) {
                    top = UResourceBundle.getBundleInstance("io/github/quiltservertools/blockbotdiscord/libs/com/ibm/icu/impl/data/icudata", ZONEINFORESNAME, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                }
                if ((zone = (zones = top.get(kZONES)).get(zoneIdx)).getType() == 7) {
                    zone = zones.get(zone.getInt());
                }
                res = zone;
            }
            catch (MissingResourceException e) {
                res = null;
            }
        }
        return res;
    }

    public static OlsonTimeZone getSystemTimeZone(String id2) {
        return (OlsonTimeZone)SYSTEM_ZONE_CACHE.getInstance(id2, id2);
    }

    public static SimpleTimeZone getCustomTimeZone(String id2) {
        int[] fields = new int[4];
        if (ZoneMeta.parseCustomID(id2, fields)) {
            Integer key = fields[0] * (fields[1] | fields[2] << 5 | fields[3] << 11);
            return (SimpleTimeZone)CUSTOM_ZONE_CACHE.getInstance(key, fields);
        }
        return null;
    }

    public static String getCustomID(String id2) {
        int[] fields = new int[4];
        if (ZoneMeta.parseCustomID(id2, fields)) {
            return ZoneMeta.formatCustomID(fields[1], fields[2], fields[3], fields[0] < 0);
        }
        return null;
    }

    static boolean parseCustomID(String id2, int[] fields) {
        if (id2 != null && id2.length() > "GMT".length() && id2.substring(0, 3).equalsIgnoreCase("GMT")) {
            int sign2 = 1;
            int hour2 = 0;
            int min = 0;
            int sec = 0;
            int[] pos = new int[]{"GMT".length()};
            if (id2.charAt(pos[0]) == '-') {
                sign2 = -1;
            } else if (id2.charAt(pos[0]) != '+') {
                return false;
            }
            pos[0] = pos[0] + 1;
            int start2 = pos[0];
            hour2 = Utility.parseNumber(id2, pos, 10);
            if (pos[0] == id2.length()) {
                int length = pos[0] - start2;
                switch (length) {
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        min = hour2 % 100;
                        hour2 /= 100;
                        break;
                    }
                    case 5: 
                    case 6: {
                        sec = hour2 % 100;
                        min = hour2 / 100 % 100;
                        hour2 /= 10000;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } else {
                if (pos[0] - start2 < 1 || pos[0] - start2 > 2 || id2.charAt(pos[0]) != ':') {
                    return false;
                }
                pos[0] = pos[0] + 1;
                if (id2.length() == pos[0]) {
                    return false;
                }
                start2 = pos[0];
                min = Utility.parseNumber(id2, pos, 10);
                if (pos[0] - start2 != 2) {
                    return false;
                }
                if (id2.length() > pos[0]) {
                    if (id2.charAt(pos[0]) != ':') {
                        return false;
                    }
                    pos[0] = pos[0] + 1;
                    start2 = pos[0];
                    sec = Utility.parseNumber(id2, pos, 10);
                    if (pos[0] - start2 != 2 || id2.length() > pos[0]) {
                        return false;
                    }
                }
            }
            if (hour2 <= 23 && min <= 59 && sec <= 59) {
                if (fields != null) {
                    if (fields.length >= 1) {
                        fields[0] = sign2;
                    }
                    if (fields.length >= 2) {
                        fields[1] = hour2;
                    }
                    if (fields.length >= 3) {
                        fields[2] = min;
                    }
                    if (fields.length >= 4) {
                        fields[3] = sec;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static SimpleTimeZone getCustomTimeZone(int offset) {
        boolean negative = false;
        int tmp = offset;
        if (offset < 0) {
            negative = true;
            tmp = -offset;
        }
        int sec = (tmp /= 1000) % 60;
        int min = (tmp /= 60) % 60;
        int hour2 = tmp / 60;
        String zid = ZoneMeta.formatCustomID(hour2, min, sec, negative);
        return new SimpleTimeZone(offset, zid);
    }

    static String formatCustomID(int hour2, int min, int sec, boolean negative) {
        StringBuilder zid = new StringBuilder("GMT");
        if (hour2 != 0 || min != 0) {
            if (negative) {
                zid.append('-');
            } else {
                zid.append('+');
            }
            if (hour2 < 10) {
                zid.append('0');
            }
            zid.append(hour2);
            zid.append(':');
            if (min < 10) {
                zid.append('0');
            }
            zid.append(min);
            if (sec != 0) {
                zid.append(':');
                if (sec < 10) {
                    zid.append('0');
                }
                zid.append(sec);
            }
        }
        return zid.toString();
    }

    public static String getShortID(TimeZone tz) {
        String canonicalID = null;
        canonicalID = tz instanceof OlsonTimeZone ? ((OlsonTimeZone)tz).getCanonicalID() : ZoneMeta.getCanonicalCLDRID(tz.getID());
        if (canonicalID == null) {
            return null;
        }
        return ZoneMeta.getShortIDFromCanonical(canonicalID);
    }

    public static String getShortID(String id2) {
        String canonicalID = ZoneMeta.getCanonicalCLDRID(id2);
        if (canonicalID == null) {
            return null;
        }
        return ZoneMeta.getShortIDFromCanonical(canonicalID);
    }

    private static String getShortIDFromCanonical(String canonicalID) {
        String shortID = null;
        String tzidKey = canonicalID.replace('/', ':');
        try {
            UResourceBundle keyTypeData = UResourceBundle.getBundleInstance("io/github/quiltservertools/blockbotdiscord/libs/com/ibm/icu/impl/data/icudata", "keyTypeData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle typeMap = keyTypeData.get("typeMap");
            UResourceBundle typeKeys = typeMap.get("timezone");
            shortID = typeKeys.getString(tzidKey);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return shortID;
    }

    static {
        ZONEIDS = null;
        CANONICAL_ID_CACHE = new SimpleCache<String, String>();
        REGION_CACHE = new SimpleCache<String, String>();
        SINGLE_COUNTRY_CACHE = new SimpleCache<String, Boolean>();
        SYSTEM_ZONE_CACHE = new SystemTimeZoneCache();
        CUSTOM_ZONE_CACHE = new CustomTimeZoneCache();
    }

    private static class CustomTimeZoneCache
    extends SoftCache<Integer, SimpleTimeZone, int[]> {
        private CustomTimeZoneCache() {
        }

        @Override
        protected SimpleTimeZone createInstance(Integer key, int[] data2) {
            assert (data2.length == 4);
            assert (data2[0] == 1 || data2[0] == -1);
            assert (data2[1] >= 0 && data2[1] <= 23);
            assert (data2[2] >= 0 && data2[2] <= 59);
            assert (data2[3] >= 0 && data2[3] <= 59);
            String id2 = ZoneMeta.formatCustomID(data2[1], data2[2], data2[3], data2[0] < 0);
            int offset = data2[0] * ((data2[1] * 60 + data2[2]) * 60 + data2[3]) * 1000;
            SimpleTimeZone tz = new SimpleTimeZone(offset, id2);
            tz.freeze();
            return tz;
        }
    }

    private static class SystemTimeZoneCache
    extends SoftCache<String, OlsonTimeZone, String> {
        private SystemTimeZoneCache() {
        }

        @Override
        protected OlsonTimeZone createInstance(String key, String data2) {
            OlsonTimeZone tz = null;
            try {
                UResourceBundle top = UResourceBundle.getBundleInstance("io/github/quiltservertools/blockbotdiscord/libs/com/ibm/icu/impl/data/icudata", ZoneMeta.ZONEINFORESNAME, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                UResourceBundle res = ZoneMeta.openOlsonResource(top, data2);
                if (res != null) {
                    tz = new OlsonTimeZone(top, res, data2);
                    tz.freeze();
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return tz;
        }
    }
}

