/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.units;

import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.ICUResourceBundle;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.UResource;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.units.ConversionRates;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.units.MeasureUnitImpl;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.units.SingleUnitImpl;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.units.UnitsData;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.ULocale;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.UResourceBundle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UnitPreferences {
    private static final Map<String, String> measurementSystem;
    private HashMap<String, HashMap<String, UnitPreference[]>> mapToUnitPreferences = new HashMap();

    public UnitPreferences() {
        ICUResourceBundle resource2 = (ICUResourceBundle)UResourceBundle.getBundleInstance("io/github/quiltservertools/blockbotdiscord/libs/com/ibm/icu/impl/data/icudata", "units");
        UnitPreferencesSink sink2 = new UnitPreferencesSink();
        resource2.getAllItemsWithFallback("unitPreferenceData", sink2);
        this.mapToUnitPreferences = sink2.getMapToUnitPreferences();
    }

    public static String formMapKey(String category, String usage) {
        return category + "++" + usage;
    }

    private static String[] getAllUsages(String usage) {
        ArrayList<String> result2 = new ArrayList<String>();
        result2.add(usage);
        for (int i = usage.length() - 1; i >= 0; --i) {
            if (usage.charAt(i) != '-') continue;
            result2.add(usage.substring(0, i));
        }
        if (!usage.equals("default")) {
            result2.add("default");
        }
        return result2.toArray(new String[0]);
    }

    public UnitPreference[] getPreferencesFor(String category, String usage, ULocale locale, UnitsData data2) {
        if ("temperature".equals(category)) {
            String localeUnitCategory;
            String localeUnit = locale.getKeywordValue("mu");
            if ("fahrenhe".equals(localeUnit)) {
                localeUnit = "fahrenheit";
            }
            try {
                localeUnitCategory = localeUnit == null ? null : data2.getCategory(MeasureUnitImpl.forIdentifier(localeUnit));
            }
            catch (Exception e) {
                localeUnitCategory = null;
            }
            if (localeUnitCategory != null && category.equals(localeUnitCategory)) {
                UnitPreference[] preferences = new UnitPreference[]{new UnitPreference(localeUnit, null, null)};
                return preferences;
            }
        }
        String region2 = ULocale.getRegionForSupplementalData(locale, true);
        String localeSystem = locale.getKeywordValue("measure");
        boolean isLocaleSystem = measurementSystem.containsKey(localeSystem);
        String[] subUsages = UnitPreferences.getAllUsages(usage);
        UnitPreference[] result2 = null;
        for (String subUsage : subUsages) {
            result2 = this.getUnitPreferences(category, subUsage, region2);
            if (result2 != null && isLocaleSystem) {
                ConversionRates rates = new ConversionRates();
                boolean unitsMatchSystem = true;
                for (UnitPreference unitPref : result2) {
                    MeasureUnitImpl measureUnit = MeasureUnitImpl.forIdentifier(unitPref.getUnit());
                    ArrayList<SingleUnitImpl> singleUnits = new ArrayList<SingleUnitImpl>(measureUnit.getSingleUnits());
                    for (SingleUnitImpl singleUnit : singleUnits) {
                        String systems = rates.extractSystems(singleUnit);
                        if (systems.contains("metric_adjacent") || systems.contains(localeSystem)) continue;
                        unitsMatchSystem = false;
                    }
                }
                if (!unitsMatchSystem) {
                    String newRegion = measurementSystem.get(localeSystem);
                    result2 = this.getUnitPreferences(category, subUsage, newRegion);
                }
            }
            if (result2 != null) break;
        }
        assert (result2 != null) : "At least the category must be exist";
        return result2;
    }

    private UnitPreference[] getUnitPreferences(String category, String usage, String region2) {
        String key = UnitPreferences.formMapKey(category, usage);
        if (this.mapToUnitPreferences.containsKey(key)) {
            UnitPreference[] result2;
            HashMap<String, UnitPreference[]> unitPreferencesMap = this.mapToUnitPreferences.get(key);
            UnitPreference[] unitPreferenceArray = result2 = unitPreferencesMap.containsKey(region2) ? unitPreferencesMap.get(region2) : unitPreferencesMap.get("001");
            assert (result2 != null);
            return result2;
        }
        return null;
    }

    static {
        HashMap<String, String> tempMS = new HashMap<String, String>();
        tempMS.put("metric", "001");
        tempMS.put("ussystem", "US");
        tempMS.put("uksystem", "GB");
        measurementSystem = Collections.unmodifiableMap(tempMS);
    }

    public static class UnitPreferencesSink
    extends UResource.Sink {
        private HashMap<String, HashMap<String, UnitPreference[]>> mapToUnitPreferences = new HashMap();

        public HashMap<String, HashMap<String, UnitPreference[]>> getMapToUnitPreferences() {
            return this.mapToUnitPreferences;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value2, boolean noFallback) {
            assert ("unitPreferenceData".equals(key.toString()));
            UResource.Table categoryTable = value2.getTable();
            int i = 0;
            while (categoryTable.getKeyAndValue(i, key, value2)) {
                assert (value2.getType() == 2);
                String category = key.toString();
                UResource.Table usageTable = value2.getTable();
                int j = 0;
                while (usageTable.getKeyAndValue(j, key, value2)) {
                    assert (value2.getType() == 2);
                    String usage = key.toString();
                    UResource.Table regionTable = value2.getTable();
                    int k = 0;
                    while (regionTable.getKeyAndValue(k, key, value2)) {
                        assert (value2.getType() == 8);
                        String region2 = key.toString();
                        UResource.Array preferencesTable = value2.getArray();
                        ArrayList<UnitPreference> unitPreferences = new ArrayList<UnitPreference>();
                        int l = 0;
                        while (preferencesTable.getValue(l, value2)) {
                            assert (value2.getType() == 2);
                            UResource.Table singlePrefTable = value2.getTable();
                            String unit = null;
                            String geq = "1";
                            String skeleton = "";
                            int m = 0;
                            while (singlePrefTable.getKeyAndValue(m, key, value2)) {
                                assert (value2.getType() == 0);
                                String keyString = key.toString();
                                if ("unit".equals(keyString)) {
                                    unit = value2.getString();
                                } else if ("geq".equals(keyString)) {
                                    geq = value2.getString();
                                } else if ("skeleton".equals(keyString)) {
                                    skeleton = value2.getString();
                                } else assert (false) : "key must be unit, geq or skeleton";
                                ++m;
                            }
                            assert (unit != null);
                            unitPreferences.add(new UnitPreference(unit, geq, skeleton));
                            ++l;
                        }
                        assert (!unitPreferences.isEmpty());
                        this.insertUnitPreferences(category, usage, region2, unitPreferences.toArray(new UnitPreference[0]));
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }

        private void insertUnitPreferences(String category, String usage, String region2, UnitPreference[] unitPreferences) {
            HashMap<Object, Object> shouldInsert;
            String key = UnitPreferences.formMapKey(category, usage);
            if (this.mapToUnitPreferences.containsKey(key)) {
                shouldInsert = this.mapToUnitPreferences.get(key);
            } else {
                shouldInsert = new HashMap();
                this.mapToUnitPreferences.put(key, shouldInsert);
            }
            shouldInsert.put(region2, unitPreferences);
        }
    }

    public static class UnitPreference {
        private final String unit;
        private final BigDecimal geq;
        private final String skeleton;

        public UnitPreference(String unit, String geq, String skeleton) {
            this.unit = unit;
            this.geq = geq == null ? BigDecimal.valueOf(Double.MIN_VALUE) : new BigDecimal(geq);
            this.skeleton = skeleton == null ? "" : skeleton;
        }

        public String getUnit() {
            return this.unit;
        }

        public BigDecimal getGeq() {
            return this.geq;
        }

        public String getSkeleton() {
            return this.skeleton;
        }
    }
}

