/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.number;

import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number.DecimalQuantity;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.number.FormattedNumberRange;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.number.NumberRangeFormatterImpl;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.number.NumberRangeFormatterSettings;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.number.UnlocalizedNumberRangeFormatter;

public class LocalizedNumberRangeFormatter
extends NumberRangeFormatterSettings<LocalizedNumberRangeFormatter> {
    private volatile NumberRangeFormatterImpl fImpl;

    LocalizedNumberRangeFormatter(NumberRangeFormatterSettings<?> parent, int key, Object value2) {
        super(parent, key, value2);
    }

    public FormattedNumberRange formatRange(int first, int second2) {
        DecimalQuantity_DualStorageBCD dq1 = new DecimalQuantity_DualStorageBCD(first);
        DecimalQuantity_DualStorageBCD dq2 = new DecimalQuantity_DualStorageBCD(second2);
        return this.formatImpl(dq1, dq2, first == second2);
    }

    public FormattedNumberRange formatRange(double first, double second2) {
        DecimalQuantity_DualStorageBCD dq1 = new DecimalQuantity_DualStorageBCD(first);
        DecimalQuantity_DualStorageBCD dq2 = new DecimalQuantity_DualStorageBCD(second2);
        return this.formatImpl(dq1, dq2, first == second2);
    }

    public FormattedNumberRange formatRange(Number first, Number second2) {
        if (first == null || second2 == null) {
            throw new IllegalArgumentException("Cannot format null values in range");
        }
        DecimalQuantity_DualStorageBCD dq1 = new DecimalQuantity_DualStorageBCD(first);
        DecimalQuantity_DualStorageBCD dq2 = new DecimalQuantity_DualStorageBCD(second2);
        return this.formatImpl(dq1, dq2, first.equals(second2));
    }

    public UnlocalizedNumberRangeFormatter withoutLocale() {
        return new UnlocalizedNumberRangeFormatter(this, 1, null);
    }

    FormattedNumberRange formatImpl(DecimalQuantity first, DecimalQuantity second2, boolean equalBeforeRounding) {
        if (this.fImpl == null) {
            this.fImpl = new NumberRangeFormatterImpl(this.resolve());
        }
        return this.fImpl.format(first, second2, equalBeforeRounding);
    }

    @Override
    LocalizedNumberRangeFormatter create(int key, Object value2) {
        return new LocalizedNumberRangeFormatter(this, key, value2);
    }
}

