/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.text;

import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.ICUCache;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.ICUResourceBundle;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.PatternTokenizer;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.SimpleCache;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.SimpleFormatterImpl;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.UResource;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.text.DateFormat;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.text.DecimalFormatSymbols;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.text.UnicodeSet;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.Calendar;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.Freezable;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.ICUCloneNotSupportedException;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.Region;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.ULocale;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.UResourceBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class DateTimePatternGenerator
implements Freezable<DateTimePatternGenerator>,
Cloneable {
    private static final boolean DEBUG = false;
    private static final String[] LAST_RESORT_ALLOWED_HOUR_FORMAT = new String[]{"H"};
    static final Map<String, String[]> LOCALE_TO_ALLOWED_HOUR;
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int QUARTER = 2;
    public static final int MONTH = 3;
    public static final int WEEK_OF_YEAR = 4;
    public static final int WEEK_OF_MONTH = 5;
    public static final int WEEKDAY = 6;
    public static final int DAY = 7;
    public static final int DAY_OF_YEAR = 8;
    public static final int DAY_OF_WEEK_IN_MONTH = 9;
    public static final int DAYPERIOD = 10;
    public static final int HOUR = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int FRACTIONAL_SECOND = 14;
    public static final int ZONE = 15;
    @Deprecated
    public static final int TYPE_LIMIT = 16;
    private static final DisplayWidth APPENDITEM_WIDTH;
    private static final int APPENDITEM_WIDTH_INT;
    private static final DisplayWidth[] CLDR_FIELD_WIDTH;
    public static final int MATCH_NO_OPTIONS = 0;
    public static final int MATCH_HOUR_FIELD_LENGTH = 2048;
    @Deprecated
    public static final int MATCH_MINUTE_FIELD_LENGTH = 4096;
    @Deprecated
    public static final int MATCH_SECOND_FIELD_LENGTH = 8192;
    public static final int MATCH_ALL_FIELDS_LENGTH = 65535;
    private TreeMap<DateTimeMatcher, PatternWithSkeletonFlag> skeleton2pattern = new TreeMap();
    private TreeMap<String, PatternWithSkeletonFlag> basePattern_pattern = new TreeMap();
    private String decimal = "?";
    private String[] dateTimeFormats = new String[]{"{1} {0}", "{1} {0}", "{1} {0}", "{1} {0}"};
    private String[] appendItemFormats = new String[16];
    private String[][] fieldDisplayNames = new String[16][DisplayWidth.access$100()];
    private char defaultHourFormatChar = (char)72;
    private volatile boolean frozen = false;
    private transient DateTimeMatcher current = new DateTimeMatcher();
    private transient FormatParser fp = new FormatParser();
    private transient DistanceInfo _distanceInfo = new DistanceInfo();
    private String[] allowedHourFormats;
    private static final int FRACTIONAL_MASK = 16384;
    private static final int SECOND_AND_FRACTIONAL_MASK = 24576;
    private static ICUCache<String, DateTimePatternGenerator> DTPNG_CACHE;
    private static final String[] CLDR_FIELD_APPEND;
    private static final String[] CLDR_FIELD_NAME;
    private static final String[] FIELD_NAME;
    private static final String[] CANONICAL_ITEMS;
    private static final Set<String> CANONICAL_SET;
    private Set<String> cldrAvailableFormatKeys = new HashSet<String>(20);
    private static final int DATE_MASK = 1023;
    private static final int TIME_MASK = 64512;
    private static final int DELTA = 16;
    private static final int NUMERIC = 256;
    private static final int NONE = 0;
    private static final int NARROW = -257;
    private static final int SHORTER = -258;
    private static final int SHORT = -259;
    private static final int LONG = -260;
    private static final int EXTRA_FIELD = 65536;
    private static final int MISSING_FIELD = 4096;
    private static final int[][] types;

    public static DateTimePatternGenerator getEmptyInstance() {
        DateTimePatternGenerator instance = new DateTimePatternGenerator();
        instance.addCanonicalItems();
        instance.fillInMissing();
        return instance;
    }

    protected DateTimePatternGenerator() {
    }

    public static DateTimePatternGenerator getInstance() {
        return DateTimePatternGenerator.getInstance(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public static DateTimePatternGenerator getInstance(ULocale uLocale) {
        return DateTimePatternGenerator.getFrozenInstance(uLocale).cloneAsThawed();
    }

    public static DateTimePatternGenerator getInstance(Locale locale) {
        return DateTimePatternGenerator.getInstance(ULocale.forLocale(locale));
    }

    @Deprecated
    public static DateTimePatternGenerator getFrozenInstance(ULocale uLocale) {
        String localeKey = uLocale.toString();
        DateTimePatternGenerator result2 = DTPNG_CACHE.get(localeKey);
        if (result2 != null) {
            return result2;
        }
        result2 = new DateTimePatternGenerator();
        result2.initData(uLocale, false);
        result2.freeze();
        DTPNG_CACHE.put(localeKey, result2);
        return result2;
    }

    @Deprecated
    public static DateTimePatternGenerator getInstanceNoStdPat(ULocale uLocale) {
        DateTimePatternGenerator result2 = new DateTimePatternGenerator();
        result2.initData(uLocale, true);
        return result2;
    }

    private void initData(ULocale uLocale, boolean skipStdPatterns) {
        PatternInfo returnInfo = new PatternInfo();
        this.addCanonicalItems();
        if (!skipStdPatterns) {
            this.addICUPatterns(returnInfo, uLocale);
        }
        this.addCLDRData(returnInfo, uLocale);
        if (!skipStdPatterns) {
            this.setDateTimeFromCalendar(uLocale);
        } else {
            this.setDateTimeFormat("{1} {0}");
        }
        this.setDecimalSymbols(uLocale);
        this.getAllowedHourFormats(uLocale);
        this.fillInMissing();
    }

    private void addICUPatterns(PatternInfo returnInfo, ULocale uLocale) {
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("io/github/quiltservertools/blockbotdiscord/libs/com/ibm/icu/impl/data/icudata", uLocale);
        String calendarTypeToUse = this.getCalendarTypeToUse(uLocale);
        ICUResourceBundle dateTimePatterns = rb.getWithFallback("calendar/" + calendarTypeToUse + "/DateTimePatterns");
        if (dateTimePatterns.getType() != 8 || dateTimePatterns.getSize() < 8) {
            throw new MissingResourceException("Resource in wrong format", "ICUResourceBundle", "calendar/" + calendarTypeToUse + "/DateTimePatterns");
        }
        for (int i = 0; i < 8; ++i) {
            String pattern;
            UResourceBundle patternRes = dateTimePatterns.get(i);
            switch (patternRes.getType()) {
                case 0: {
                    pattern = patternRes.getString();
                    break;
                }
                case 8: {
                    pattern = patternRes.getString(0);
                    break;
                }
                default: {
                    throw new MissingResourceException("Resource in wrong format", "ICUResourceBundle", "calendar/" + calendarTypeToUse + "/DateTimePatterns");
                }
            }
            this.addPattern(pattern, false, returnInfo);
        }
    }

    private String getCalendarTypeToUse(ULocale uLocale) {
        String calendarTypeToUse = uLocale.getKeywordValue("calendar");
        if (calendarTypeToUse == null) {
            String[] preferredCalendarTypes = Calendar.getKeywordValuesForLocale("calendar", uLocale, true);
            calendarTypeToUse = preferredCalendarTypes[0];
        }
        if (calendarTypeToUse == null) {
            calendarTypeToUse = "gregorian";
        }
        return calendarTypeToUse;
    }

    private void consumeShortTimePattern(String shortTimePattern, PatternInfo returnInfo) {
        this.hackTimes(returnInfo, shortTimePattern);
    }

    private void fillInMissing() {
        for (int i = 0; i < 16; ++i) {
            if (this.getAppendItemFormat(i) == null) {
                this.setAppendItemFormat(i, "{0} \u251c{2}: {1}\u2524");
            }
            if (this.getFieldDisplayName(i, DisplayWidth.WIDE) == null) {
                this.setFieldDisplayName(i, DisplayWidth.WIDE, "F" + i);
            }
            if (this.getFieldDisplayName(i, DisplayWidth.ABBREVIATED) == null) {
                this.setFieldDisplayName(i, DisplayWidth.ABBREVIATED, this.getFieldDisplayName(i, DisplayWidth.WIDE));
            }
            if (this.getFieldDisplayName(i, DisplayWidth.NARROW) != null) continue;
            this.setFieldDisplayName(i, DisplayWidth.NARROW, this.getFieldDisplayName(i, DisplayWidth.ABBREVIATED));
        }
    }

    private void addCLDRData(PatternInfo returnInfo, ULocale uLocale) {
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("io/github/quiltservertools/blockbotdiscord/libs/com/ibm/icu/impl/data/icudata", uLocale);
        String calendarTypeToUse = this.getCalendarTypeToUse(uLocale);
        AppendItemFormatsSink appendItemFormatsSink = new AppendItemFormatsSink();
        try {
            rb.getAllChildrenWithFallback("calendar/" + calendarTypeToUse + "/appendItems", appendItemFormatsSink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        AppendItemNamesSink appendItemNamesSink = new AppendItemNamesSink();
        try {
            rb.getAllChildrenWithFallback("fields", appendItemNamesSink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        AvailableFormatsSink availableFormatsSink = new AvailableFormatsSink(returnInfo);
        try {
            rb.getAllChildrenWithFallback("calendar/" + calendarTypeToUse + "/availableFormats", availableFormatsSink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private void setDateTimeFromCalendar(ULocale uLocale) {
        Calendar cal = Calendar.getInstance(uLocale);
        for (int style = 0; style <= 3; ++style) {
            String dateTimeFormat = Calendar.getDateAtTimePattern(cal, uLocale, style);
            this.setDateTimeFormat(style, dateTimeFormat);
        }
    }

    private void setDecimalSymbols(ULocale uLocale) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(uLocale);
        this.setDecimal(String.valueOf(dfs.getDecimalSeparator()));
    }

    private String[] getAllowedHourFormatsLangCountry(String language, String country) {
        String langCountry = language + "_" + country;
        String[] list2 = LOCALE_TO_ALLOWED_HOUR.get(langCountry);
        if (list2 == null) {
            list2 = LOCALE_TO_ALLOWED_HOUR.get(country);
        }
        return list2;
    }

    private void getAllowedHourFormats(ULocale uLocale) {
        String language = uLocale.getLanguage();
        String country = ULocale.getRegionForSupplementalData(uLocale, false);
        if (language.isEmpty() || country.isEmpty()) {
            ULocale max = ULocale.addLikelySubtags(uLocale);
            language = max.getLanguage();
            country = max.getCountry();
        }
        if (language.isEmpty()) {
            language = "und";
        }
        if (country.isEmpty()) {
            country = "001";
        }
        String[] list2 = this.getAllowedHourFormatsLangCountry(language, country);
        Character defaultCharFromLocale = null;
        String hourCycle = uLocale.getKeywordValue("hours");
        if (hourCycle != null) {
            switch (hourCycle) {
                case "h24": {
                    defaultCharFromLocale = Character.valueOf('k');
                    break;
                }
                case "h23": {
                    defaultCharFromLocale = Character.valueOf('H');
                    break;
                }
                case "h12": {
                    defaultCharFromLocale = Character.valueOf('h');
                    break;
                }
                case "h11": {
                    defaultCharFromLocale = Character.valueOf('K');
                }
            }
        }
        if (list2 == null) {
            try {
                Region region2 = Region.getInstance(country);
                country = region2.toString();
                list2 = this.getAllowedHourFormatsLangCountry(language, country);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (list2 != null) {
            this.defaultHourFormatChar = defaultCharFromLocale != null ? defaultCharFromLocale.charValue() : list2[0].charAt(0);
            this.allowedHourFormats = Arrays.copyOfRange(list2, 1, list2.length - 1);
        } else {
            this.allowedHourFormats = LAST_RESORT_ALLOWED_HOUR_FORMAT;
            this.defaultHourFormatChar = defaultCharFromLocale != null ? defaultCharFromLocale.charValue() : this.allowedHourFormats[0].charAt(0);
        }
    }

    @Deprecated
    public char getDefaultHourFormatChar() {
        return this.defaultHourFormatChar;
    }

    @Deprecated
    public void setDefaultHourFormatChar(char defaultHourFormatChar) {
        this.defaultHourFormatChar = defaultHourFormatChar;
    }

    private void hackTimes(PatternInfo returnInfo, String shortTimePattern) {
        this.fp.set(shortTimePattern);
        StringBuilder mmss = new StringBuilder();
        boolean gotMm = false;
        for (int i = 0; i < this.fp.items.size(); ++i) {
            Object item2 = this.fp.items.get(i);
            if (item2 instanceof String) {
                if (!gotMm) continue;
                mmss.append(this.fp.quoteLiteral(item2.toString()));
                continue;
            }
            char ch = item2.toString().charAt(0);
            if (ch == 'm') {
                gotMm = true;
                mmss.append(item2);
                continue;
            }
            if (ch == 's') {
                if (!gotMm) break;
                mmss.append(item2);
                this.addPattern(mmss.toString(), false, returnInfo);
                break;
            }
            if (gotMm || ch == 'z' || ch == 'Z' || ch == 'v' || ch == 'V') break;
        }
        BitSet variables = new BitSet();
        BitSet nuke = new BitSet();
        for (int i = 0; i < this.fp.items.size(); ++i) {
            Object item3 = this.fp.items.get(i);
            if (!(item3 instanceof VariableField)) continue;
            variables.set(i);
            char ch = item3.toString().charAt(0);
            if (ch != 's' && ch != 'S') continue;
            nuke.set(i);
            for (int j = i - 1; j >= 0 && !variables.get(j); ++j) {
                nuke.set(i);
            }
        }
        String hhmm = DateTimePatternGenerator.getFilteredPattern(this.fp, nuke);
        this.addPattern(hhmm, false, returnInfo);
    }

    private static String getFilteredPattern(FormatParser fp, BitSet nuke) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < fp.items.size(); ++i) {
            if (nuke.get(i)) continue;
            Object item2 = fp.items.get(i);
            if (item2 instanceof String) {
                result2.append(fp.quoteLiteral(item2.toString()));
                continue;
            }
            result2.append(item2.toString());
        }
        return result2.toString();
    }

    @Deprecated
    public static int getAppendFormatNumber(UResource.Key key) {
        for (int i = 0; i < CLDR_FIELD_APPEND.length; ++i) {
            if (!key.contentEquals(CLDR_FIELD_APPEND[i])) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public static int getAppendFormatNumber(String string) {
        for (int i = 0; i < CLDR_FIELD_APPEND.length; ++i) {
            if (!CLDR_FIELD_APPEND[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    private static int getCLDRFieldAndWidthNumber(UResource.Key key) {
        for (int i = 0; i < CLDR_FIELD_NAME.length; ++i) {
            for (int j = 0; j < DisplayWidth.COUNT; ++j) {
                String fullKey = CLDR_FIELD_NAME[i].concat(DateTimePatternGenerator.CLDR_FIELD_WIDTH[j].cldrKey());
                if (!key.contentEquals(fullKey)) continue;
                return i * DisplayWidth.COUNT + j;
            }
        }
        return -1;
    }

    public String getBestPattern(String skeleton) {
        return this.getBestPattern(skeleton, null, 0);
    }

    public String getBestPattern(String skeleton, int options2) {
        return this.getBestPattern(skeleton, null, options2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBestPattern(String skeleton, DateTimeMatcher skipMatcher, int options2) {
        String timePattern;
        String datePattern;
        EnumSet<DTPGflags> flags2 = EnumSet.noneOf(DTPGflags.class);
        String skeletonMapped = this.mapSkeletonMetacharacters(skeleton, flags2);
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(skeletonMapped, this.fp, false);
            PatternWithMatcher bestWithMatcher = this.getBestRaw(this.current, -1, this._distanceInfo, skipMatcher);
            if (this._distanceInfo.missingFieldMask == 0 && this._distanceInfo.extraFieldMask == 0) {
                return this.adjustFieldTypes(bestWithMatcher, this.current, flags2, options2);
            }
            int neededFields = this.current.getFieldMask();
            datePattern = this.getBestAppending(this.current, neededFields & 0x3FF, this._distanceInfo, skipMatcher, flags2, options2);
            timePattern = this.getBestAppending(this.current, neededFields & 0xFC00, this._distanceInfo, skipMatcher, flags2, options2);
        }
        if (datePattern == null) {
            return timePattern == null ? "" : timePattern;
        }
        if (timePattern == null) {
            return datePattern;
        }
        String canonicalSkeleton = this.current.toCanonicalString();
        int style = 3;
        int monthFieldLen = 0;
        int monthFieldOffset = canonicalSkeleton.indexOf(77);
        if (monthFieldOffset >= 0) {
            monthFieldLen = 1 + canonicalSkeleton.lastIndexOf(77) - monthFieldOffset;
        }
        if (monthFieldLen == 4) {
            style = canonicalSkeleton.indexOf(69) >= 0 ? 0 : 1;
        } else if (monthFieldLen == 3) {
            style = 2;
        }
        return SimpleFormatterImpl.formatRawPattern(this.getDateTimeFormat(style), 2, 2, timePattern, datePattern);
    }

    private String mapSkeletonMetacharacters(String skeleton, EnumSet<DTPGflags> flags2) {
        StringBuilder skeletonCopy = new StringBuilder();
        boolean inQuoted = false;
        for (int patPos = 0; patPos < skeleton.length(); ++patPos) {
            char patChr = skeleton.charAt(patPos);
            if (patChr == '\'') {
                inQuoted = !inQuoted;
                continue;
            }
            if (inQuoted) continue;
            if (patChr == 'j' || patChr == 'C') {
                int extraLen = 0;
                while (patPos + 1 < skeleton.length() && skeleton.charAt(patPos + 1) == patChr) {
                    ++extraLen;
                    ++patPos;
                }
                int hourLen = 1 + (extraLen & 1);
                int dayPeriodLen = extraLen < 2 ? 1 : 3 + (extraLen >> 1);
                char hourChar = 'h';
                char dayPeriodChar = 'a';
                if (patChr == 'j') {
                    hourChar = this.defaultHourFormatChar;
                } else {
                    String bestAllowed = this.allowedHourFormats[0];
                    hourChar = bestAllowed.charAt(0);
                    char last = bestAllowed.charAt(bestAllowed.length() - 1);
                    if (last == 'b' || last == 'B') {
                        dayPeriodChar = last;
                    }
                }
                if (hourChar == 'H' || hourChar == 'k') {
                    dayPeriodLen = 0;
                }
                while (dayPeriodLen-- > 0) {
                    skeletonCopy.append(dayPeriodChar);
                }
                while (hourLen-- > 0) {
                    skeletonCopy.append(hourChar);
                }
                continue;
            }
            if (patChr == 'J') {
                skeletonCopy.append('H');
                flags2.add(DTPGflags.SKELETON_USES_CAP_J);
                continue;
            }
            skeletonCopy.append(patChr);
        }
        return skeletonCopy.toString();
    }

    public DateTimePatternGenerator addPattern(String pattern, boolean override, PatternInfo returnInfo) {
        return this.addPatternWithSkeleton(pattern, null, override, returnInfo);
    }

    @Deprecated
    public DateTimePatternGenerator addPatternWithSkeleton(String pattern, String skeletonToUse, boolean override, PatternInfo returnInfo) {
        PatternWithSkeletonFlag previousValue;
        this.checkFrozen();
        DateTimeMatcher matcher = skeletonToUse == null ? new DateTimeMatcher().set(pattern, this.fp, false) : new DateTimeMatcher().set(skeletonToUse, this.fp, false);
        String basePattern = matcher.getBasePattern();
        PatternWithSkeletonFlag previousPatternWithSameBase = this.basePattern_pattern.get(basePattern);
        if (previousPatternWithSameBase != null && (!previousPatternWithSameBase.skeletonWasSpecified || skeletonToUse != null && !override)) {
            returnInfo.status = 1;
            returnInfo.conflictingPattern = previousPatternWithSameBase.pattern;
            if (!override) {
                return this;
            }
        }
        if ((previousValue = this.skeleton2pattern.get(matcher)) != null) {
            returnInfo.status = 2;
            returnInfo.conflictingPattern = previousValue.pattern;
            if (!override || skeletonToUse != null && previousValue.skeletonWasSpecified) {
                return this;
            }
        }
        returnInfo.status = 0;
        returnInfo.conflictingPattern = "";
        PatternWithSkeletonFlag patWithSkelFlag = new PatternWithSkeletonFlag(pattern, skeletonToUse != null);
        this.skeleton2pattern.put(matcher, patWithSkelFlag);
        this.basePattern_pattern.put(basePattern, patWithSkelFlag);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSkeleton(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp, false);
            return this.current.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getSkeletonAllowingDuplicates(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp, true);
            return this.current.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getCanonicalSkeletonAllowingDuplicates(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp, true);
            return this.current.toCanonicalString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseSkeleton(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp, false);
            return this.current.getBasePattern();
        }
    }

    public Map<String, String> getSkeletons(Map<String, String> result2) {
        if (result2 == null) {
            result2 = new LinkedHashMap<String, String>();
        }
        for (DateTimeMatcher item2 : this.skeleton2pattern.keySet()) {
            PatternWithSkeletonFlag patternWithSkelFlag = this.skeleton2pattern.get(item2);
            String pattern = patternWithSkelFlag.pattern;
            if (CANONICAL_SET.contains(pattern)) continue;
            result2.put(item2.toString(), pattern);
        }
        return result2;
    }

    public Set<String> getBaseSkeletons(Set<String> result2) {
        if (result2 == null) {
            result2 = new HashSet<String>();
        }
        result2.addAll(this.basePattern_pattern.keySet());
        return result2;
    }

    public String replaceFieldTypes(String pattern, String skeleton) {
        return this.replaceFieldTypes(pattern, skeleton, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String replaceFieldTypes(String pattern, String skeleton, int options2) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            PatternWithMatcher patternNoMatcher = new PatternWithMatcher(pattern, null);
            return this.adjustFieldTypes(patternNoMatcher, this.current.set(skeleton, this.fp, false), EnumSet.noneOf(DTPGflags.class), options2);
        }
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.checkFrozen();
        for (int style = 0; style <= 3; ++style) {
            this.setDateTimeFormat(style, dateTimeFormat);
        }
    }

    public String getDateTimeFormat() {
        return this.getDateTimeFormat(2);
    }

    public void setDateTimeFormat(int style, String dateTimeFormat) {
        if (style < 0 || style > 3) {
            throw new IllegalArgumentException("Illegal style here: " + style);
        }
        this.checkFrozen();
        this.dateTimeFormats[style] = dateTimeFormat;
    }

    public String getDateTimeFormat(int style) {
        if (style < 0 || style > 3) {
            throw new IllegalArgumentException("Illegal style here: " + style);
        }
        return this.dateTimeFormats[style];
    }

    public void setDecimal(String decimal) {
        this.checkFrozen();
        this.decimal = decimal;
    }

    public String getDecimal() {
        return this.decimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Collection<String> getRedundants(Collection<String> output) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            if (output == null) {
                output = new LinkedHashSet<String>();
            }
            for (DateTimeMatcher cur : this.skeleton2pattern.keySet()) {
                String trial;
                PatternWithSkeletonFlag patternWithSkelFlag = this.skeleton2pattern.get(cur);
                String pattern = patternWithSkelFlag.pattern;
                if (CANONICAL_SET.contains(pattern) || !(trial = this.getBestPattern(cur.toString(), cur, 0)).equals(pattern)) continue;
                output.add(pattern);
            }
            return output;
        }
    }

    public void setAppendItemFormat(int field2, String value2) {
        this.checkFrozen();
        this.appendItemFormats[field2] = value2;
    }

    public String getAppendItemFormat(int field2) {
        return this.appendItemFormats[field2];
    }

    public void setAppendItemName(int field2, String value2) {
        this.setFieldDisplayName(field2, APPENDITEM_WIDTH, value2);
    }

    public String getAppendItemName(int field2) {
        return this.getFieldDisplayName(field2, APPENDITEM_WIDTH);
    }

    public DateFormat.HourCycle getDefaultHourCycle() {
        switch (this.getDefaultHourFormatChar()) {
            case 'h': {
                return DateFormat.HourCycle.HOUR_CYCLE_12;
            }
            case 'H': {
                return DateFormat.HourCycle.HOUR_CYCLE_23;
            }
            case 'k': {
                return DateFormat.HourCycle.HOUR_CYCLE_24;
            }
            case 'K': {
                return DateFormat.HourCycle.HOUR_CYCLE_11;
            }
        }
        throw new AssertionError((Object)"should be unreachable");
    }

    @Deprecated
    private void setFieldDisplayName(int field2, DisplayWidth width, String value2) {
        this.checkFrozen();
        if (field2 < 16 && field2 >= 0) {
            this.fieldDisplayNames[field2][width.ordinal()] = value2;
        }
    }

    public String getFieldDisplayName(int field2, DisplayWidth width) {
        if (field2 >= 16 || field2 < 0) {
            return "";
        }
        return this.fieldDisplayNames[field2][width.ordinal()];
    }

    @Deprecated
    public static boolean isSingleField(String skeleton) {
        char first = skeleton.charAt(0);
        for (int i = 1; i < skeleton.length(); ++i) {
            if (skeleton.charAt(i) == first) continue;
            return false;
        }
        return true;
    }

    private void setAvailableFormat(String key) {
        this.checkFrozen();
        this.cldrAvailableFormatKeys.add(key);
    }

    private boolean isAvailableFormatSet(String key) {
        return this.cldrAvailableFormatKeys.contains(key);
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public DateTimePatternGenerator freeze() {
        this.frozen = true;
        return this;
    }

    @Override
    public DateTimePatternGenerator cloneAsThawed() {
        DateTimePatternGenerator result2 = (DateTimePatternGenerator)this.clone();
        this.frozen = false;
        return result2;
    }

    public Object clone() {
        try {
            DateTimePatternGenerator result2 = (DateTimePatternGenerator)super.clone();
            result2.skeleton2pattern = (TreeMap)this.skeleton2pattern.clone();
            result2.basePattern_pattern = (TreeMap)this.basePattern_pattern.clone();
            result2.dateTimeFormats = (String[])this.dateTimeFormats.clone();
            result2.appendItemFormats = (String[])this.appendItemFormats.clone();
            result2.fieldDisplayNames = (String[][])this.fieldDisplayNames.clone();
            result2.current = new DateTimeMatcher();
            result2.fp = new FormatParser();
            result2._distanceInfo = new DistanceInfo();
            result2.frozen = false;
            return result2;
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException("Internal Error", e);
        }
    }

    @Deprecated
    public boolean skeletonsAreSimilar(String id2, String skeleton) {
        if (id2.equals(skeleton)) {
            return true;
        }
        TreeSet<String> parser1 = this.getSet(id2);
        TreeSet<String> parser2 = this.getSet(skeleton);
        if (parser1.size() != parser2.size()) {
            return false;
        }
        Iterator<String> it2 = parser2.iterator();
        for (String item2 : parser1) {
            String item22;
            int index2;
            int index1 = DateTimePatternGenerator.getCanonicalIndex(item2, false);
            if (types[index1][1] == types[index2 = DateTimePatternGenerator.getCanonicalIndex(item22 = it2.next(), false)][1]) continue;
            return false;
        }
        return true;
    }

    private TreeSet<String> getSet(String id2) {
        List<Object> items = this.fp.set(id2).getItems();
        TreeSet<String> result2 = new TreeSet<String>();
        for (Object obj : items) {
            String item2 = obj.toString();
            if (item2.startsWith("G") || item2.startsWith("a")) continue;
            result2.add(item2);
        }
        return result2;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
    }

    private String getBestAppending(DateTimeMatcher source2, int missingFields, DistanceInfo distInfo, DateTimeMatcher skipMatcher, EnumSet<DTPGflags> flags2, int options2) {
        String resultPattern = null;
        if (missingFields != 0) {
            PatternWithMatcher resultPatternWithMatcher = this.getBestRaw(source2, missingFields, distInfo, skipMatcher);
            resultPattern = this.adjustFieldTypes(resultPatternWithMatcher, source2, flags2, options2);
            while (distInfo.missingFieldMask != 0) {
                if ((distInfo.missingFieldMask & 0x6000) == 16384 && (missingFields & 0x6000) == 24576) {
                    resultPatternWithMatcher.pattern = resultPattern;
                    flags2 = EnumSet.copyOf(flags2);
                    flags2.add(DTPGflags.FIX_FRACTIONAL_SECONDS);
                    resultPattern = this.adjustFieldTypes(resultPatternWithMatcher, source2, flags2, options2);
                    distInfo.missingFieldMask &= 0xFFFFBFFF;
                    continue;
                }
                int startingMask = distInfo.missingFieldMask;
                PatternWithMatcher tempWithMatcher = this.getBestRaw(source2, distInfo.missingFieldMask, distInfo, skipMatcher);
                String temp = this.adjustFieldTypes(tempWithMatcher, source2, flags2, options2);
                int foundMask = startingMask & ~distInfo.missingFieldMask;
                int topField = this.getTopBitNumber(foundMask);
                resultPattern = SimpleFormatterImpl.formatRawPattern(this.getAppendFormat(topField), 2, 3, resultPattern, temp, this.getAppendName(topField));
            }
        }
        return resultPattern;
    }

    private String getAppendName(int foundMask) {
        return "'" + this.fieldDisplayNames[foundMask][APPENDITEM_WIDTH_INT] + "'";
    }

    private String getAppendFormat(int foundMask) {
        return this.appendItemFormats[foundMask];
    }

    private int getTopBitNumber(int foundMask) {
        int i = 0;
        while (foundMask != 0) {
            foundMask >>>= 1;
            ++i;
        }
        return i - 1;
    }

    private void addCanonicalItems() {
        PatternInfo patternInfo = new PatternInfo();
        for (int i = 0; i < CANONICAL_ITEMS.length; ++i) {
            this.addPattern(String.valueOf(CANONICAL_ITEMS[i]), false, patternInfo);
        }
    }

    private PatternWithMatcher getBestRaw(DateTimeMatcher source2, int includeMask, DistanceInfo missingFields, DateTimeMatcher skipMatcher) {
        int bestDistance = Integer.MAX_VALUE;
        int bestMissingFieldMask = Integer.MIN_VALUE;
        PatternWithMatcher bestPatternWithMatcher = new PatternWithMatcher("", null);
        DistanceInfo tempInfo = new DistanceInfo();
        for (DateTimeMatcher trial : this.skeleton2pattern.keySet()) {
            int distance;
            if (trial.equals(skipMatcher) || (distance = source2.getDistance(trial, includeMask, tempInfo)) >= bestDistance && (distance != bestDistance || bestMissingFieldMask >= tempInfo.missingFieldMask)) continue;
            bestDistance = distance;
            bestMissingFieldMask = tempInfo.missingFieldMask;
            PatternWithSkeletonFlag patternWithSkelFlag = this.skeleton2pattern.get(trial);
            bestPatternWithMatcher.pattern = patternWithSkelFlag.pattern;
            bestPatternWithMatcher.matcherWithSkeleton = patternWithSkelFlag.skeletonWasSpecified ? trial : null;
            missingFields.setTo(tempInfo);
            if (distance != 0) continue;
            break;
        }
        return bestPatternWithMatcher;
    }

    private String adjustFieldTypes(PatternWithMatcher patternWithMatcher, DateTimeMatcher inputRequest, EnumSet<DTPGflags> flags2, int options2) {
        this.fp.set(patternWithMatcher.pattern);
        StringBuilder newPattern = new StringBuilder();
        for (Object item2 : this.fp.getItems()) {
            if (item2 instanceof String) {
                newPattern.append(this.fp.quoteLiteral((String)item2));
                continue;
            }
            VariableField variableField = (VariableField)item2;
            StringBuilder fieldBuilder = new StringBuilder(variableField.toString());
            int type = variableField.getType();
            if (flags2.contains((Object)DTPGflags.FIX_FRACTIONAL_SECONDS) && type == 13) {
                fieldBuilder.append(this.decimal);
                inputRequest.original.appendFieldTo(14, fieldBuilder);
            } else if (inputRequest.type[type] != 0) {
                int c;
                int reqFieldChar = inputRequest.original.getFieldChar(type);
                int reqFieldLen = inputRequest.original.getFieldLength(type);
                if (reqFieldChar == 69 && reqFieldLen < 3) {
                    reqFieldLen = 3;
                }
                int adjFieldLen = reqFieldLen;
                DateTimeMatcher matcherWithSkeleton = patternWithMatcher.matcherWithSkeleton;
                if (type == 11 && (options2 & 0x800) == 0 || type == 12 && (options2 & 0x1000) == 0 || type == 13 && (options2 & 0x2000) == 0) {
                    adjFieldLen = fieldBuilder.length();
                } else if (matcherWithSkeleton != null && reqFieldChar != 99 && reqFieldChar != 101) {
                    int skelFieldLen = matcherWithSkeleton.original.getFieldLength(type);
                    boolean patFieldIsNumeric = variableField.isNumeric();
                    boolean skelFieldIsNumeric = matcherWithSkeleton.fieldIsNumeric(type);
                    if (skelFieldLen == reqFieldLen || patFieldIsNumeric && !skelFieldIsNumeric || skelFieldIsNumeric && !patFieldIsNumeric) {
                        adjFieldLen = fieldBuilder.length();
                    }
                }
                int n = c = type != 11 && type != 3 && type != 6 && (type != 1 || reqFieldChar == 89) ? reqFieldChar : fieldBuilder.charAt(0);
                if (c == 69 && adjFieldLen < 3) {
                    c = 101;
                }
                if (type == 11) {
                    if (flags2.contains((Object)DTPGflags.SKELETON_USES_CAP_J) || reqFieldChar == this.defaultHourFormatChar) {
                        c = this.defaultHourFormatChar;
                    } else if (reqFieldChar == 104 && this.defaultHourFormatChar == 'K') {
                        c = 75;
                    } else if (reqFieldChar == 72 && this.defaultHourFormatChar == 'k') {
                        c = 107;
                    } else if (reqFieldChar == 107 && this.defaultHourFormatChar == 'H') {
                        c = 72;
                    } else if (reqFieldChar == 75 && this.defaultHourFormatChar == 'h') {
                        c = 104;
                    }
                }
                fieldBuilder = new StringBuilder();
                for (int i = adjFieldLen; i > 0; --i) {
                    fieldBuilder.append((char)c);
                }
            }
            newPattern.append((CharSequence)fieldBuilder);
        }
        return newPattern.toString();
    }

    @Deprecated
    public String getFields(String pattern) {
        this.fp.set(pattern);
        StringBuilder newPattern = new StringBuilder();
        for (Object item2 : this.fp.getItems()) {
            if (item2 instanceof String) {
                newPattern.append(this.fp.quoteLiteral((String)item2));
                continue;
            }
            newPattern.append("{" + DateTimePatternGenerator.getName(item2.toString()) + "}");
        }
        return newPattern.toString();
    }

    private static String showMask(int mask) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            if ((mask & 1 << i) == 0) continue;
            if (result2.length() != 0) {
                result2.append(" | ");
            }
            result2.append(FIELD_NAME[i]);
            result2.append(" ");
        }
        return result2.toString();
    }

    private static String getName(String s) {
        int i = DateTimePatternGenerator.getCanonicalIndex(s, true);
        String name2 = FIELD_NAME[types[i][1]];
        name2 = types[i][2] < 0 ? name2 + ":S" : name2 + ":N";
        return name2;
    }

    private static int getCanonicalIndex(String s, boolean strict) {
        int len = s.length();
        if (len == 0) {
            return -1;
        }
        char ch = s.charAt(0);
        for (int i = 1; i < len; ++i) {
            if (s.charAt(i) == ch) continue;
            return -1;
        }
        int bestRow = -1;
        for (int i = 0; i < types.length; ++i) {
            int[] row = types[i];
            if (row[0] != ch) continue;
            bestRow = i;
            if (row[3] > len || row[row.length - 1] < len) continue;
            return i;
        }
        return strict ? -1 : bestRow;
    }

    private static char getCanonicalChar(int field2, char reference) {
        if (reference == 'h' || reference == 'K') {
            return 'h';
        }
        for (int i = 0; i < types.length; ++i) {
            int[] row = types[i];
            if (row[1] != field2) continue;
            return (char)row[0];
        }
        throw new IllegalArgumentException("Could not find field " + field2);
    }

    static {
        HashMap temp = new HashMap();
        ICUResourceBundle suppData = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("io/github/quiltservertools/blockbotdiscord/libs/com/ibm/icu/impl/data/icudata", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        DayPeriodAllowedHoursSink allowedHoursSink = new DayPeriodAllowedHoursSink(temp);
        suppData.getAllItemsWithFallback("timeData", allowedHoursSink);
        LOCALE_TO_ALLOWED_HOUR = Collections.unmodifiableMap(temp);
        APPENDITEM_WIDTH = DisplayWidth.WIDE;
        APPENDITEM_WIDTH_INT = APPENDITEM_WIDTH.ordinal();
        CLDR_FIELD_WIDTH = DisplayWidth.values();
        DTPNG_CACHE = new SimpleCache<String, DateTimePatternGenerator>();
        CLDR_FIELD_APPEND = new String[]{"Era", "Year", "Quarter", "Month", "Week", "*", "Day-Of-Week", "Day", "*", "*", "*", "Hour", "Minute", "Second", "*", "Timezone"};
        CLDR_FIELD_NAME = new String[]{"era", "year", "quarter", "month", "week", "weekOfMonth", "weekday", "day", "dayOfYear", "weekdayOfMonth", "dayperiod", "hour", "minute", "second", "*", "zone"};
        FIELD_NAME = new String[]{"Era", "Year", "Quarter", "Month", "Week_in_Year", "Week_in_Month", "Weekday", "Day", "Day_Of_Year", "Day_of_Week_in_Month", "Dayperiod", "Hour", "Minute", "Second", "Fractional_Second", "Zone"};
        CANONICAL_ITEMS = new String[]{"G", "y", "Q", "M", "w", "W", "E", "d", "D", "F", "a", "H", "m", "s", "S", "v"};
        CANONICAL_SET = new HashSet<String>(Arrays.asList(CANONICAL_ITEMS));
        types = new int[][]{{71, 0, -259, 1, 3}, {71, 0, -260, 4}, {71, 0, -257, 5}, {121, 1, 256, 1, 20}, {89, 1, 272, 1, 20}, {117, 1, 288, 1, 20}, {114, 1, 304, 1, 20}, {85, 1, -259, 1, 3}, {85, 1, -260, 4}, {85, 1, -257, 5}, {81, 2, 256, 1, 2}, {81, 2, -259, 3}, {81, 2, -260, 4}, {81, 2, -257, 5}, {113, 2, 272, 1, 2}, {113, 2, -275, 3}, {113, 2, -276, 4}, {113, 2, -273, 5}, {77, 3, 256, 1, 2}, {77, 3, -259, 3}, {77, 3, -260, 4}, {77, 3, -257, 5}, {76, 3, 272, 1, 2}, {76, 3, -275, 3}, {76, 3, -276, 4}, {76, 3, -273, 5}, {108, 3, 272, 1, 1}, {119, 4, 256, 1, 2}, {87, 5, 256, 1}, {69, 6, -259, 1, 3}, {69, 6, -260, 4}, {69, 6, -257, 5}, {69, 6, -258, 6}, {99, 6, 288, 1, 2}, {99, 6, -291, 3}, {99, 6, -292, 4}, {99, 6, -289, 5}, {99, 6, -290, 6}, {101, 6, 272, 1, 2}, {101, 6, -275, 3}, {101, 6, -276, 4}, {101, 6, -273, 5}, {101, 6, -274, 6}, {100, 7, 256, 1, 2}, {103, 7, 272, 1, 20}, {68, 8, 256, 1, 3}, {70, 9, 256, 1}, {97, 10, -259, 1, 3}, {97, 10, -260, 4}, {97, 10, -257, 5}, {98, 10, -275, 1, 3}, {98, 10, -276, 4}, {98, 10, -273, 5}, {66, 10, -307, 1, 3}, {66, 10, -308, 4}, {66, 10, -305, 5}, {72, 11, 416, 1, 2}, {107, 11, 432, 1, 2}, {104, 11, 256, 1, 2}, {75, 11, 272, 1, 2}, {109, 12, 256, 1, 2}, {115, 13, 256, 1, 2}, {65, 13, 272, 1, 1000}, {83, 14, 256, 1, 1000}, {118, 15, -291, 1}, {118, 15, -292, 4}, {122, 15, -259, 1, 3}, {122, 15, -260, 4}, {90, 15, -273, 1, 3}, {90, 15, -276, 4}, {90, 15, -275, 5}, {79, 15, -275, 1}, {79, 15, -276, 4}, {86, 15, -275, 1}, {86, 15, -276, 2}, {86, 15, -277, 3}, {86, 15, -278, 4}, {88, 15, -273, 1}, {88, 15, -275, 2}, {88, 15, -276, 4}, {120, 15, -273, 1}, {120, 15, -275, 2}, {120, 15, -276, 4}};
    }

    private static class DistanceInfo {
        int missingFieldMask;
        int extraFieldMask;

        private DistanceInfo() {
        }

        void clear() {
            this.extraFieldMask = 0;
            this.missingFieldMask = 0;
        }

        void setTo(DistanceInfo other) {
            this.missingFieldMask = other.missingFieldMask;
            this.extraFieldMask = other.extraFieldMask;
        }

        void addMissing(int field2) {
            this.missingFieldMask |= 1 << field2;
        }

        void addExtra(int field2) {
            this.extraFieldMask |= 1 << field2;
        }

        public String toString() {
            return "missingFieldMask: " + DateTimePatternGenerator.showMask(this.missingFieldMask) + ", extraFieldMask: " + DateTimePatternGenerator.showMask(this.extraFieldMask);
        }
    }

    private static class DateTimeMatcher
    implements Comparable<DateTimeMatcher> {
        private int[] type = new int[16];
        private SkeletonFields original = new SkeletonFields();
        private SkeletonFields baseOriginal = new SkeletonFields();
        private boolean addedDefaultDayPeriod = false;

        private DateTimeMatcher() {
        }

        public boolean fieldIsNumeric(int field2) {
            return this.type[field2] > 0;
        }

        public String toString() {
            return this.original.toString(this.addedDefaultDayPeriod);
        }

        public String toCanonicalString() {
            return this.original.toCanonicalString(this.addedDefaultDayPeriod);
        }

        String getBasePattern() {
            return this.baseOriginal.toString(this.addedDefaultDayPeriod);
        }

        DateTimeMatcher set(String pattern, FormatParser fp, boolean allowDuplicateFields) {
            int[] row;
            Arrays.fill(this.type, 0);
            this.original.clear();
            this.baseOriginal.clear();
            this.addedDefaultDayPeriod = false;
            fp.set(pattern);
            for (Object obj : fp.getItems()) {
                if (!(obj instanceof VariableField)) continue;
                VariableField item2 = (VariableField)obj;
                String value2 = item2.toString();
                int canonicalIndex = item2.getCanonicalIndex();
                int[] row2 = types[canonicalIndex];
                int field2 = row2[1];
                if (!this.original.isFieldEmpty(field2)) {
                    char ch1 = this.original.getFieldChar(field2);
                    char ch2 = value2.charAt(0);
                    if (allowDuplicateFields || ch1 == 'r' && (ch2 == 'U' || ch2 == 'y') || (ch1 == 'U' || ch1 == 'y') && ch2 == 'r') continue;
                    throw new IllegalArgumentException("Conflicting fields:\t" + ch1 + ", " + value2 + "\t in " + pattern);
                }
                this.original.populate(field2, value2);
                char repeatChar = (char)row2[0];
                int repeatCount = row2[3];
                if ("GEzvQ".indexOf(repeatChar) >= 0) {
                    repeatCount = 1;
                }
                this.baseOriginal.populate(field2, repeatChar, repeatCount);
                int subField = row2[2];
                if (subField > 0) {
                    subField += value2.length();
                }
                this.type[field2] = subField;
            }
            if (!this.original.isFieldEmpty(12) && !this.original.isFieldEmpty(14) && this.original.isFieldEmpty(13)) {
                for (int i = 0; i < types.length; ++i) {
                    row = types[i];
                    if (row[1] != 13) continue;
                    this.original.populate(13, (char)row[0], row[3]);
                    this.baseOriginal.populate(13, (char)row[0], row[3]);
                    int subField = row[2];
                    this.type[13] = subField > 0 ? subField + 1 : subField;
                    break;
                }
            }
            if (!this.original.isFieldEmpty(11)) {
                if (this.original.getFieldChar(11) == 'h' || this.original.getFieldChar(11) == 'K') {
                    if (this.original.isFieldEmpty(10)) {
                        for (int i = 0; i < types.length; ++i) {
                            row = types[i];
                            if (row[1] != 10) continue;
                            this.original.populate(10, (char)row[0], row[3]);
                            this.baseOriginal.populate(10, (char)row[0], row[3]);
                            this.type[10] = row[2];
                            this.addedDefaultDayPeriod = true;
                            break;
                        }
                    }
                } else if (!this.original.isFieldEmpty(10)) {
                    this.original.clearField(10);
                    this.baseOriginal.clearField(10);
                    this.type[10] = 0;
                }
            }
            return this;
        }

        int getFieldMask() {
            int result2 = 0;
            for (int i = 0; i < this.type.length; ++i) {
                if (this.type[i] == 0) continue;
                result2 |= 1 << i;
            }
            return result2;
        }

        void extractFrom(DateTimeMatcher source2, int fieldMask) {
            for (int i = 0; i < this.type.length; ++i) {
                if ((fieldMask & 1 << i) != 0) {
                    this.type[i] = source2.type[i];
                    this.original.copyFieldFrom(source2.original, i);
                    continue;
                }
                this.type[i] = 0;
                this.original.clearField(i);
            }
        }

        int getDistance(DateTimeMatcher other, int includeMask, DistanceInfo distanceInfo) {
            int result2 = 0;
            distanceInfo.clear();
            for (int i = 0; i < 16; ++i) {
                int otherType;
                int myType = (includeMask & 1 << i) == 0 ? 0 : this.type[i];
                if (myType == (otherType = other.type[i])) continue;
                if (myType == 0) {
                    result2 += 65536;
                    distanceInfo.addExtra(i);
                    continue;
                }
                if (otherType == 0) {
                    result2 += 4096;
                    distanceInfo.addMissing(i);
                    continue;
                }
                result2 += Math.abs(myType - otherType);
            }
            return result2;
        }

        @Override
        public int compareTo(DateTimeMatcher that) {
            int result2 = this.original.compareTo(that.original);
            return result2 > 0 ? -1 : (result2 < 0 ? 1 : 0);
        }

        public boolean equals(Object other) {
            return this == other || other != null && other instanceof DateTimeMatcher && this.original.equals(((DateTimeMatcher)other).original);
        }

        public int hashCode() {
            return this.original.hashCode();
        }
    }

    private static class SkeletonFields {
        private byte[] chars = new byte[16];
        private byte[] lengths = new byte[16];
        private static final byte DEFAULT_CHAR = 0;
        private static final byte DEFAULT_LENGTH = 0;

        private SkeletonFields() {
        }

        public void clear() {
            Arrays.fill(this.chars, (byte)0);
            Arrays.fill(this.lengths, (byte)0);
        }

        void copyFieldFrom(SkeletonFields other, int field2) {
            this.chars[field2] = other.chars[field2];
            this.lengths[field2] = other.lengths[field2];
        }

        void clearField(int field2) {
            this.chars[field2] = 0;
            this.lengths[field2] = 0;
        }

        char getFieldChar(int field2) {
            return (char)this.chars[field2];
        }

        int getFieldLength(int field2) {
            return this.lengths[field2];
        }

        void populate(int field2, String value2) {
            for (char ch : value2.toCharArray()) {
                assert (ch == value2.charAt(0));
            }
            this.populate(field2, value2.charAt(0), value2.length());
        }

        void populate(int field2, char ch, int length) {
            assert (ch <= '\u007f');
            assert (length <= 127);
            this.chars[field2] = (byte)ch;
            this.lengths[field2] = (byte)length;
        }

        public boolean isFieldEmpty(int field2) {
            return this.lengths[field2] == 0;
        }

        public String toString() {
            return this.appendTo(new StringBuilder(), false, false).toString();
        }

        public String toString(boolean skipDayPeriod) {
            return this.appendTo(new StringBuilder(), false, skipDayPeriod).toString();
        }

        public String toCanonicalString() {
            return this.appendTo(new StringBuilder(), true, false).toString();
        }

        public String toCanonicalString(boolean skipDayPeriod) {
            return this.appendTo(new StringBuilder(), true, skipDayPeriod).toString();
        }

        public StringBuilder appendTo(StringBuilder sb) {
            return this.appendTo(sb, false, false);
        }

        private StringBuilder appendTo(StringBuilder sb, boolean canonical, boolean skipDayPeriod) {
            for (int i = 0; i < 16; ++i) {
                if (skipDayPeriod && i == 10) continue;
                this.appendFieldTo(i, sb, canonical);
            }
            return sb;
        }

        public StringBuilder appendFieldTo(int field2, StringBuilder sb) {
            return this.appendFieldTo(field2, sb, false);
        }

        private StringBuilder appendFieldTo(int field2, StringBuilder sb, boolean canonical) {
            char ch = (char)this.chars[field2];
            int length = this.lengths[field2];
            if (canonical) {
                ch = DateTimePatternGenerator.getCanonicalChar(field2, ch);
            }
            for (int i = 0; i < length; ++i) {
                sb.append(ch);
            }
            return sb;
        }

        public int compareTo(SkeletonFields other) {
            for (int i = 0; i < 16; ++i) {
                int charDiff = this.chars[i] - other.chars[i];
                if (charDiff != 0) {
                    return charDiff;
                }
                int lengthDiff = this.lengths[i] - other.lengths[i];
                if (lengthDiff == 0) continue;
                return lengthDiff;
            }
            return 0;
        }

        public boolean equals(Object other) {
            return this == other || other != null && other instanceof SkeletonFields && this.compareTo((SkeletonFields)other) == 0;
        }

        public int hashCode() {
            return Arrays.hashCode(this.chars) ^ Arrays.hashCode(this.lengths);
        }
    }

    private static enum DTPGflags {
        FIX_FRACTIONAL_SECONDS,
        SKELETON_USES_CAP_J;

    }

    private static class PatternWithSkeletonFlag {
        public String pattern;
        public boolean skeletonWasSpecified;

        public PatternWithSkeletonFlag(String pat, boolean skelSpecified) {
            this.pattern = pat;
            this.skeletonWasSpecified = skelSpecified;
        }

        public String toString() {
            return this.pattern + "," + this.skeletonWasSpecified;
        }
    }

    private static class PatternWithMatcher {
        public String pattern;
        public DateTimeMatcher matcherWithSkeleton;

        public PatternWithMatcher(String pat, DateTimeMatcher matcher) {
            this.pattern = pat;
            this.matcherWithSkeleton = matcher;
        }
    }

    @Deprecated
    public static class FormatParser {
        private static final UnicodeSet SYNTAX_CHARS = new UnicodeSet("[a-zA-Z]").freeze();
        private static final UnicodeSet QUOTING_CHARS = new UnicodeSet("[[[:script=Latn:][:script=Cyrl:]]&[[:L:][:M:]]]").freeze();
        private transient PatternTokenizer tokenizer = new PatternTokenizer().setSyntaxCharacters(SYNTAX_CHARS).setExtraQuotingCharacters(QUOTING_CHARS).setUsingQuote(true);
        private List<Object> items = new ArrayList<Object>();

        @Deprecated
        public FormatParser() {
        }

        @Deprecated
        public final FormatParser set(String string) {
            return this.set(string, false);
        }

        @Deprecated
        public FormatParser set(String string, boolean strict) {
            this.items.clear();
            if (string.length() == 0) {
                return this;
            }
            this.tokenizer.setPattern(string);
            StringBuffer buffer = new StringBuffer();
            StringBuffer variable = new StringBuffer();
            while (true) {
                buffer.setLength(0);
                int status2 = this.tokenizer.next(buffer);
                if (status2 == 0) break;
                if (status2 == 1) {
                    if (variable.length() != 0 && buffer.charAt(0) != variable.charAt(0)) {
                        this.addVariable(variable, false);
                    }
                    variable.append(buffer);
                    continue;
                }
                this.addVariable(variable, false);
                this.items.add(buffer.toString());
            }
            this.addVariable(variable, false);
            return this;
        }

        private void addVariable(StringBuffer variable, boolean strict) {
            if (variable.length() != 0) {
                this.items.add(new VariableField(variable.toString(), strict));
                variable.setLength(0);
            }
        }

        @Deprecated
        public List<Object> getItems() {
            return this.items;
        }

        @Deprecated
        public String toString() {
            return this.toString(0, this.items.size());
        }

        @Deprecated
        public String toString(int start2, int limit2) {
            StringBuilder result2 = new StringBuilder();
            for (int i = start2; i < limit2; ++i) {
                Object item2 = this.items.get(i);
                if (item2 instanceof String) {
                    String itemString = (String)item2;
                    result2.append(this.tokenizer.quoteLiteral(itemString));
                    continue;
                }
                result2.append(this.items.get(i).toString());
            }
            return result2.toString();
        }

        @Deprecated
        public boolean hasDateAndTimeFields() {
            int foundMask = 0;
            for (Object item2 : this.items) {
                if (!(item2 instanceof VariableField)) continue;
                int type = ((VariableField)item2).getType();
                foundMask |= 1 << type;
            }
            boolean isDate = (foundMask & 0x3FF) != 0;
            boolean isTime = (foundMask & 0xFC00) != 0;
            return isDate && isTime;
        }

        @Deprecated
        public Object quoteLiteral(String string) {
            return this.tokenizer.quoteLiteral(string);
        }
    }

    @Deprecated
    public static class VariableField {
        private final String string;
        private final int canonicalIndex;

        @Deprecated
        public VariableField(String string) {
            this(string, false);
        }

        @Deprecated
        public VariableField(String string, boolean strict) {
            this.canonicalIndex = DateTimePatternGenerator.getCanonicalIndex(string, strict);
            if (this.canonicalIndex < 0) {
                throw new IllegalArgumentException("Illegal datetime field:\t" + string);
            }
            this.string = string;
        }

        @Deprecated
        public int getType() {
            return types[this.canonicalIndex][1];
        }

        @Deprecated
        public static String getCanonicalCode(int type) {
            try {
                return CANONICAL_ITEMS[type];
            }
            catch (Exception e) {
                return String.valueOf(type);
            }
        }

        @Deprecated
        public boolean isNumeric() {
            return types[this.canonicalIndex][2] > 0;
        }

        private int getCanonicalIndex() {
            return this.canonicalIndex;
        }

        @Deprecated
        public String toString() {
            return this.string;
        }
    }

    public static enum DisplayWidth {
        WIDE(""),
        ABBREVIATED("-short"),
        NARROW("-narrow");

        @Deprecated
        private static int COUNT;
        private final String cldrKey;

        private DisplayWidth(String cldrKey) {
            this.cldrKey = cldrKey;
        }

        private String cldrKey() {
            return this.cldrKey;
        }

        static {
            COUNT = DisplayWidth.values().length;
        }
    }

    public static final class PatternInfo {
        public static final int OK = 0;
        public static final int BASE_CONFLICT = 1;
        public static final int CONFLICT = 2;
        public int status;
        public String conflictingPattern;
    }

    private static class DayPeriodAllowedHoursSink
    extends UResource.Sink {
        HashMap<String, String[]> tempMap;

        private DayPeriodAllowedHoursSink(HashMap<String, String[]> tempMap) {
            this.tempMap = tempMap;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value2, boolean noFallback) {
            UResource.Table timeData = value2.getTable();
            int i = 0;
            while (timeData.getKeyAndValue(i, key, value2)) {
                String regionOrLocale = key.toString();
                UResource.Table formatList = value2.getTable();
                String[] allowed = null;
                String preferred = null;
                int j = 0;
                while (formatList.getKeyAndValue(j, key, value2)) {
                    if (key.contentEquals("allowed")) {
                        allowed = value2.getStringArrayOrStringAsArray();
                    } else if (key.contentEquals("preferred")) {
                        preferred = value2.getString();
                    }
                    ++j;
                }
                String[] list2 = null;
                if (allowed != null && allowed.length > 0) {
                    list2 = new String[allowed.length + 1];
                    list2[0] = preferred != null ? preferred : allowed[0];
                    System.arraycopy(allowed, 0, list2, 1, allowed.length);
                } else {
                    list2 = new String[]{preferred != null ? preferred : LAST_RESORT_ALLOWED_HOUR_FORMAT[0], list2[0]};
                }
                this.tempMap.put(regionOrLocale, list2);
                ++i;
            }
        }
    }

    private class AvailableFormatsSink
    extends UResource.Sink {
        PatternInfo returnInfo;

        public AvailableFormatsSink(PatternInfo returnInfo) {
            this.returnInfo = returnInfo;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value2, boolean isRoot) {
            String formatKey = key.toString();
            if (!DateTimePatternGenerator.this.isAvailableFormatSet(formatKey)) {
                DateTimePatternGenerator.this.setAvailableFormat(formatKey);
                String formatValue = value2.toString();
                DateTimePatternGenerator.this.addPatternWithSkeleton(formatValue, formatKey, true, this.returnInfo);
            }
        }
    }

    private class AppendItemNamesSink
    extends UResource.Sink {
        private AppendItemNamesSink() {
        }

        @Override
        public void put(UResource.Key key, UResource.Value value2, boolean noFallback) {
            int fieldAndWidth = DateTimePatternGenerator.getCLDRFieldAndWidthNumber(key);
            if (fieldAndWidth == -1) {
                return;
            }
            int field2 = fieldAndWidth / DisplayWidth.COUNT;
            DisplayWidth width = CLDR_FIELD_WIDTH[fieldAndWidth % DisplayWidth.COUNT];
            UResource.Table detailsTable = value2.getTable();
            if (detailsTable.findValue("dn", value2) && DateTimePatternGenerator.this.getFieldDisplayName(field2, width) == null) {
                DateTimePatternGenerator.this.setFieldDisplayName(field2, width, value2.toString());
            }
        }
    }

    private class AppendItemFormatsSink
    extends UResource.Sink {
        private AppendItemFormatsSink() {
        }

        @Override
        public void put(UResource.Key key, UResource.Value value2, boolean noFallback) {
            int field2 = DateTimePatternGenerator.getAppendFormatNumber(key);
            if (field2 < 0) {
                return;
            }
            if (DateTimePatternGenerator.this.getAppendItemFormat(field2) == null) {
                DateTimePatternGenerator.this.setAppendItemFormat(field2, value2.toString());
            }
        }
    }
}

