/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.moandjiezana.toml;

import io.github.quiltservertools.blockbotdiscord.libs.com.moandjiezana.toml.Context;
import io.github.quiltservertools.blockbotdiscord.libs.com.moandjiezana.toml.Identifier;
import io.github.quiltservertools.blockbotdiscord.libs.com.moandjiezana.toml.Keys;
import java.util.concurrent.atomic.AtomicInteger;

class IdentifierConverter {
    static final IdentifierConverter IDENTIFIER_CONVERTER = new IdentifierConverter();

    Identifier convert(String s, AtomicInteger index, Context context) {
        boolean quoted = false;
        StringBuilder name2 = new StringBuilder();
        boolean terminated = false;
        boolean isKey = s.charAt(index.get()) != '[';
        boolean isTableArray = !isKey && s.length() > index.get() + 1 && s.charAt(index.get() + 1) == '[';
        boolean inComment = false;
        int i = index.get();
        while (i < s.length()) {
            char c = s.charAt(i);
            if (Keys.isQuote(c) && (i == 0 || s.charAt(i - 1) != '\\')) {
                quoted = !quoted;
                name2.append(c);
            } else {
                if (c == '\n') {
                    index.decrementAndGet();
                    break;
                }
                if (quoted) {
                    name2.append(c);
                } else {
                    if (c == '=' && isKey) {
                        terminated = true;
                        break;
                    }
                    if (c == ']' && !isKey) {
                        if (!isTableArray || s.length() > index.get() + 1 && s.charAt(index.get() + 1) == ']') {
                            terminated = true;
                            name2.append(']');
                            if (isTableArray) {
                                name2.append(']');
                            }
                        }
                    } else if (terminated && c == '#') {
                        inComment = true;
                    } else {
                        if (terminated && !Character.isWhitespace(c) && !inComment) {
                            terminated = false;
                            break;
                        }
                        if (!terminated) {
                            name2.append(c);
                        }
                    }
                }
            }
            i = index.incrementAndGet();
        }
        if (!terminated) {
            if (isKey) {
                context.errors.unterminatedKey(name2.toString(), context.line.get());
            } else {
                context.errors.invalidKey(name2.toString(), context.line.get());
            }
            return Identifier.INVALID;
        }
        return Identifier.from(name2.toString(), context);
    }

    private IdentifierConverter() {
    }
}

