/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.vdurmont.emoji;

import io.github.quiltservertools.blockbotdiscord.libs.com.vdurmont.emoji.Emoji;
import io.github.quiltservertools.blockbotdiscord.libs.org.json.JSONArray;
import io.github.quiltservertools.blockbotdiscord.libs.org.json.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmojiLoader {
    private EmojiLoader() {
    }

    public static List<Emoji> loadEmojis(InputStream stream) throws IOException {
        JSONArray emojisJSON = new JSONArray(EmojiLoader.inputStreamToString(stream));
        ArrayList<Emoji> emojis2 = new ArrayList<Emoji>(emojisJSON.length());
        for (int i = 0; i < emojisJSON.length(); ++i) {
            Emoji emoji2 = EmojiLoader.buildEmojiFromJSON(emojisJSON.getJSONObject(i));
            if (emoji2 == null) continue;
            emojis2.add(emoji2);
        }
        return emojis2;
    }

    private static String inputStreamToString(InputStream stream) throws IOException {
        String read2;
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(stream, "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        while ((read2 = br.readLine()) != null) {
            sb.append(read2);
        }
        br.close();
        return sb.toString();
    }

    protected static Emoji buildEmojiFromJSON(JSONObject json) throws UnsupportedEncodingException {
        if (!json.has("emoji")) {
            return null;
        }
        byte[] bytes = json.getString("emoji").getBytes("UTF-8");
        String description2 = null;
        if (json.has("description")) {
            description2 = json.getString("description");
        }
        boolean supportsFitzpatrick = false;
        if (json.has("supports_fitzpatrick")) {
            supportsFitzpatrick = json.getBoolean("supports_fitzpatrick");
        }
        List<String> aliases = EmojiLoader.jsonArrayToStringList(json.getJSONArray("aliases"));
        List<String> tags2 = EmojiLoader.jsonArrayToStringList(json.getJSONArray("tags"));
        return new Emoji(description2, supportsFitzpatrick, aliases, tags2, bytes);
    }

    private static List<String> jsonArrayToStringList(JSONArray array) {
        ArrayList<String> strings = new ArrayList<String>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            strings.add(array.getString(i));
        }
        return strings;
    }
}

