/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.dev.kord.rest.request;

import io.github.quiltservertools.blockbotdiscord.libs.dev.kord.rest.ratelimit.BucketKey;
import io.github.quiltservertools.blockbotdiscord.libs.dev.kord.rest.request.HttpUtilsKt;
import io.github.quiltservertools.blockbotdiscord.libs.dev.kord.rest.request.Request;
import io.github.quiltservertools.blockbotdiscord.libs.dev.kord.rest.request.RequestBuilder;
import io.github.quiltservertools.blockbotdiscord.libs.dev.kord.rest.route.Route;
import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.client.statement.HttpResponse;
import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.client.statement.HttpResponseKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Clock;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a'\u0010\u0005\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0000*\b\u0012\u0004\u0012\u00028\u00000\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0019\u0010\u000b\u001a\u00020\n*\u00020\u00072\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0019\u0010\u000e\u001a\u00020\r*\u00020\u00072\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0019\u0010\u0011\u001a\u00020\u0002*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u0014\u0010\u0013\u001a\u00020\u0002*\u00020\u0007H\u0086@\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a!\u0010\u0011\u001a\u00020\u0002*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0006\u0010\u0010\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0016\"\u0014\u0010\u0017\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\"\u0014\u0010\u0019\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0018\"\u0014\u0010\u001a\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0018\"\u0014\u0010\u001b\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0018\"\u0014\u0010\u001c\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0018\"\u0014\u0010\u001d\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0018\"\u0014\u0010\u001e\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u0018\"\u0014\u0010\u0005\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018\"\u0015\u0010\u000b\u001a\u00020\n*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u0015\u0010\"\u001a\u00020!*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\"\u0015\u0010$\u001a\u00020!*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b$\u0010#\"\u0015\u0010%\u001a\u00020!*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b%\u0010#\"\u0015\u0010&\u001a\u00020!*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b&\u0010#\"\u0017\u0010)\u001a\u0004\u0018\u00010\r*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\"\u0017\u0010+\u001a\u0004\u0018\u00010\r*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b*\u0010(\"\u0015\u0010,\u001a\u00020!*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b,\u0010#\"\u0017\u00100\u001a\u0004\u0018\u00010-*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00061"}, d2={"T", "Lio/github/quiltservertools/blockbotdiscord/libs/dev/kord/rest/request/RequestBuilder;", "", "reason", "", "auditLogReason", "(Lio/github/quiltservertools/blockbotdiscord/libs/dev/kord/rest/request/RequestBuilder;Ljava/lang/String;)V", "Lio/github/quiltservertools/blockbotdiscord/libs/io/ktor/client/statement/HttpResponse;", "Lkotlin/time/Clock;", "clock", "Lkotlin/time/Instant;", "channelResetPoint", "(Lio/github/quiltservertools/blockbotdiscord/libs/io/ktor/client/statement/HttpResponse;Lkotlin/time/Clock;)Lkotlin/time/Instant;", "", "globalSuspensionPoint", "(Lio/github/quiltservertools/blockbotdiscord/libs/io/ktor/client/statement/HttpResponse;Lkotlin/time/Clock;)J", "body", "logString", "(Lio/github/quiltservertools/blockbotdiscord/libs/io/ktor/client/statement/HttpResponse;Ljava/lang/String;)Ljava/lang/String;", "errorString", "(Lio/ktor/client/statement/HttpResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/github/quiltservertools/blockbotdiscord/libs/dev/kord/rest/request/Request;", "(Lio/github/quiltservertools/blockbotdiscord/libs/dev/kord/rest/request/Request;Ljava/lang/String;)Ljava/lang/String;", "rateLimitGlobalHeader", "Ljava/lang/String;", "retryAfterHeader", "rateLimitRemainingHeader", "resetTimeHeader", "bucketRateLimitKey", "rateLimit", "rateLimitResetAfter", "getChannelResetPoint", "(Lio/ktor/client/statement/HttpResponse;)Lkotlin/time/Instant;", "", "isRateLimit", "(Lio/ktor/client/statement/HttpResponse;)Z", "isError", "isErrorWithRateLimit", "isGlobalRateLimit", "getRateLimitTotal", "(Lio/ktor/client/statement/HttpResponse;)Ljava/lang/Long;", "rateLimitTotal", "getRateLimitRemaining", "rateLimitRemaining", "isChannelRateLimit", "Lio/github/quiltservertools/blockbotdiscord/libs/dev/kord/rest/ratelimit/BucketKey;", "getBucket", "(Lio/ktor/client/statement/HttpResponse;)Ljava/lang/String;", "bucket", "rest"})
@SourceDebugExtension(value={"SMAP\nHttpUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpUtils.kt\ndev/kord/rest/request/HttpUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class HttpUtilsKt {
    @NotNull
    private static final String rateLimitGlobalHeader = "X-RateLimit-Global";
    @NotNull
    private static final String retryAfterHeader = "Retry-After";
    @NotNull
    private static final String rateLimitRemainingHeader = "X-RateLimit-Remaining";
    @NotNull
    private static final String resetTimeHeader = "X-RateLimit-Reset";
    @NotNull
    private static final String bucketRateLimitKey = "X-RateLimit-Bucket";
    @NotNull
    private static final String rateLimit = "X-RateLimit-Limit";
    @NotNull
    private static final String rateLimitResetAfter = "X-RateLimit-Reset-After";
    @NotNull
    private static final String auditLogReason = "X-Audit-Log-Reason";

    public static final <T> void auditLogReason(@NotNull RequestBuilder<T> $this$auditLogReason, @Nullable String reason2) {
        block0: {
            Intrinsics.checkNotNullParameter($this$auditLogReason, (String)"<this>");
            String string = reason2;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            $this$auditLogReason.urlEncodedHeader(auditLogReason, reason2);
        }
    }

    @NotNull
    public static final Instant getChannelResetPoint(@NotNull HttpResponse $this$channelResetPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$channelResetPoint, (String)"<this>");
        String string = $this$channelResetPoint.getHeaders().get(resetTimeHeader);
        if (string == null) {
            return Clock.System.INSTANCE.now();
        }
        double unixSeconds = Double.parseDouble(string);
        return Instant.Companion.fromEpochMilliseconds((long)(unixSeconds * (double)1000));
    }

    @NotNull
    public static final Instant channelResetPoint(@NotNull HttpResponse $this$channelResetPoint, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)$this$channelResetPoint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        String string = $this$channelResetPoint.getHeaders().get(rateLimitResetAfter);
        if (string == null) {
            return clock.now();
        }
        double seconds = Double.parseDouble(string);
        return clock.now().plus-LRDsOJo(DurationKt.toDuration((double)seconds, (DurationUnit)DurationUnit.SECONDS));
    }

    public static final boolean isRateLimit(@NotNull HttpResponse $this$isRateLimit) {
        Intrinsics.checkNotNullParameter((Object)$this$isRateLimit, (String)"<this>");
        return $this$isRateLimit.getStatus().getValue() == 429;
    }

    public static final boolean isError(@NotNull HttpResponse $this$isError) {
        Intrinsics.checkNotNullParameter((Object)$this$isError, (String)"<this>");
        int n = $this$isError.getStatus().getValue();
        return 400 <= n ? n < 600 : false;
    }

    public static final boolean isErrorWithRateLimit(@NotNull HttpResponse $this$isErrorWithRateLimit) {
        Intrinsics.checkNotNullParameter((Object)$this$isErrorWithRateLimit, (String)"<this>");
        return $this$isErrorWithRateLimit.getStatus().getValue() == 403 || $this$isErrorWithRateLimit.getStatus().getValue() == 401;
    }

    public static final boolean isGlobalRateLimit(@NotNull HttpResponse $this$isGlobalRateLimit) {
        Intrinsics.checkNotNullParameter((Object)$this$isGlobalRateLimit, (String)"<this>");
        return $this$isGlobalRateLimit.getHeaders().get(rateLimitGlobalHeader) != null;
    }

    @Nullable
    public static final Long getRateLimitTotal(@NotNull HttpResponse $this$rateLimitTotal) {
        Intrinsics.checkNotNullParameter((Object)$this$rateLimitTotal, (String)"<this>");
        String string = $this$rateLimitTotal.getHeaders().get(rateLimit);
        return string != null ? StringsKt.toLongOrNull((String)string) : null;
    }

    @Nullable
    public static final Long getRateLimitRemaining(@NotNull HttpResponse $this$rateLimitRemaining) {
        Intrinsics.checkNotNullParameter((Object)$this$rateLimitRemaining, (String)"<this>");
        String string = $this$rateLimitRemaining.getHeaders().get(rateLimitRemainingHeader);
        return string != null ? StringsKt.toLongOrNull((String)string) : null;
    }

    public static final boolean isChannelRateLimit(@NotNull HttpResponse $this$isChannelRateLimit) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isChannelRateLimit, (String)"<this>");
        String string = $this$isChannelRateLimit.getHeaders().get(rateLimitRemainingHeader);
        if (string != null) {
            Integer n = StringsKt.toIntOrNull((String)string);
            bl = n != null && n == 0;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final String getBucket(@NotNull HttpResponse $this$bucket) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$bucket, (String)"<this>");
        String string2 = $this$bucket.getHeaders().get(bucketRateLimitKey);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = BucketKey.constructor-impl(it);
        } else {
            string = null;
        }
        return string;
    }

    public static final long globalSuspensionPoint(@NotNull HttpResponse $this$globalSuspensionPoint, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)$this$globalSuspensionPoint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        String string = $this$globalSuspensionPoint.getHeaders().get(retryAfterHeader);
        if (string == null) {
            return clock.now().toEpochMilliseconds();
        }
        long secondsWait = Long.parseLong(string);
        return secondsWait * (long)1000 + clock.now().toEpochMilliseconds();
    }

    @NotNull
    public static final String logString(@NotNull HttpResponse $this$logString, @NotNull String body2) {
        Intrinsics.checkNotNullParameter((Object)$this$logString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        return "[RESPONSE]:" + $this$logString.getStatus().getValue() + ':' + $this$logString.getCall().getRequest().getMethod().getValue() + ':' + $this$logString.getCall().getRequest().getUrl() + " body:" + body2;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object errorString(@NotNull HttpResponse $this$errorString, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof errorString.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpUtilsKt.errorString(null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this$errorString;
                $continuation.label = 1;
                v0 = HttpResponseKt.bodyAsText$default($this$errorString, null, (Continuation)$continuation, 1, null);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                $this$errorString = (HttpResponse)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                message = (String)v0;
                return HttpUtilsKt.logString($this$errorString, message);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final String logString(@NotNull Request<?, ?> $this$logString, @NotNull String body2) {
        Intrinsics.checkNotNullParameter($this$logString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        String method = $this$logString.getRoute().getMethod().getValue();
        String path = $this$logString.getRoute().getPath();
        String params = CollectionsKt.joinToString$default((Iterable)$this$logString.getRouteParams().entrySet(), (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, HttpUtilsKt::logString$lambda$2, (int)24, null);
        return "[REQUEST]:" + method + ':' + path + " params:" + params + " body:" + body2;
    }

    private static final CharSequence logString$lambda$2(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        Route.Key key = (Route.Key)entry.getKey();
        String value2 = (String)entry.getValue();
        return key + '=' + value2;
    }
}

