/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.dev.kordex.parser;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.github.quiltservertools.blockbotdiscord.libs.dev.kordex.parser.Cursor;
import io.github.quiltservertools.blockbotdiscord.libs.dev.kordex.parser.tokens.NamedArgumentToken;
import io.github.quiltservertools.blockbotdiscord.libs.dev.kordex.parser.tokens.PositionalArgumentToken;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\r\u0010\fJ\r\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ#\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u000fJ#\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\"\u0010\u001e\u001a\u00020\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010&\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lio/github/quiltservertools/blockbotdiscord/libs/dev/kordex/parser/StringParser;", "", "", "input", "<init>", "(Ljava/lang/String;)V", "", "Lio/github/quiltservertools/blockbotdiscord/libs/dev/kordex/parser/tokens/NamedArgumentToken;", "parseNamed", "()Ljava/util/List;", "Lio/github/quiltservertools/blockbotdiscord/libs/dev/kordex/parser/tokens/PositionalArgumentToken;", "peekNext", "()Lio/github/quiltservertools/blockbotdiscord/libs/dev/kordex/parser/tokens/PositionalArgumentToken;", "parseNext", "consumeRemaining", "()Ljava/lang/String;", "Lkotlin/Function1;", "", "", "predicate", "consumeWhile", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/String;", "peekRemaining", "peekWhile", "Ljava/lang/String;", "getInput", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Lio/github/quiltservertools/blockbotdiscord/libs/dev/kordex/parser/Cursor;", "cursor", "Lio/github/quiltservertools/blockbotdiscord/libs/dev/kordex/parser/Cursor;", "getCursor", "()Ldev/kordex/parser/Cursor;", "setCursor", "(Ldev/kordex/parser/Cursor;)V", "getHasNext", "()Z", "hasNext", "token-parser"})
public class StringParser {
    @NotNull
    private final String input;
    @NotNull
    private final KLogger logger;
    @NotNull
    private Cursor cursor;

    public StringParser(@NotNull String input2) {
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        this.input = input2;
        this.logger = KotlinLogging.INSTANCE.logger((Function0<Unit>)((Function0)StringParser::logger$lambda$0));
        this.cursor = new Cursor(this.getInput());
    }

    @NotNull
    public String getInput() {
        return this.input;
    }

    @NotNull
    public final Cursor getCursor() {
        return this.cursor;
    }

    public final void setCursor(@NotNull Cursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"<set-?>");
        this.cursor = cursor;
    }

    public final boolean getHasNext() {
        return this.cursor.getHasNext();
    }

    @NotNull
    public final List<NamedArgumentToken> parseNamed() {
        List tokens = new ArrayList();
        StringBuilder buffer = new StringBuilder();
        StringBuilder outputBuffer = new StringBuilder();
        boolean isQuoted = false;
        boolean isFlag = false;
        boolean isFlagValue = false;
        String flagName = "";
        boolean isKeyword = false;
        String keywordName = "";
        while (this.cursor.getHasNext()) {
            char c;
            boolean canBeQuoted;
            char c2 = this.cursor.next();
            this.logger.trace((Function0<? extends Object>)((Function0)() -> StringParser.parseNamed$lambda$0(c2)));
            boolean bl = canBeQuoted = !isQuoted && (!isFlag || isFlagValue || isKeyword);
            if (c2 == '\"' && ((CharSequence)buffer).length() == 0 && canBeQuoted) {
                this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$1));
                isQuoted = true;
                continue;
            }
            if (c2 == '-') {
                Character c3 = this.cursor.peekNext();
                c = '-';
                if (c3 != null && c3.charValue() == c && ((CharSequence)buffer).length() == 0 && !isFlag && !isKeyword) {
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$2));
                    this.cursor.next();
                    isFlag = true;
                    continue;
                }
            }
            if (c2 == '=' && ((CharSequence)buffer).length() > 0 && !isKeyword && !isFlag) {
                this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$3));
                Intrinsics.checkNotNullExpressionValue((Object)buffer.toString(), (String)"toString(...)");
                StringsKt.clear((StringBuilder)buffer);
                isKeyword = true;
                continue;
            }
            if (c2 == '\\') {
                Character c4 = this.cursor.peekNext();
                c = '\"';
                if (c4 != null && c4.charValue() == c && isQuoted) {
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$4));
                    buffer.append('\"');
                    this.cursor.next();
                    continue;
                }
            }
            if (c2 == '\"' && isQuoted) {
                this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$5));
                if (isFlagValue) {
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$6));
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$7));
                    String string = buffer.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    tokens.add(new NamedArgumentToken(flagName, string));
                    flagName = "";
                    isFlag = false;
                    isFlagValue = false;
                } else if (isKeyword) {
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$8));
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$9));
                    String string = buffer.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    tokens.add(new NamedArgumentToken(keywordName, string));
                    keywordName = "";
                    isKeyword = false;
                } else {
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$10));
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$11));
                    outputBuffer.append("\"" + buffer + "\"");
                    this.cursor.skipWhitespace();
                }
                StringsKt.clear((StringBuilder)buffer);
                isQuoted = false;
                continue;
            }
            if (c2 == ' ' && !isQuoted) {
                this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$12));
                if (isFlag) {
                    if (!isFlagValue) {
                        this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$13));
                        this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$14));
                        Intrinsics.checkNotNullExpressionValue((Object)buffer.toString(), (String)"toString(...)");
                        isFlagValue = true;
                    } else {
                        this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$15));
                        this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$16));
                        String string = buffer.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        tokens.add(new NamedArgumentToken(flagName, string));
                        this.cursor.skipWhitespace();
                        flagName = "";
                        isFlag = false;
                        isFlagValue = false;
                    }
                } else if (isKeyword) {
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$17));
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$18));
                    String string = buffer.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    tokens.add(new NamedArgumentToken(keywordName, string));
                    this.cursor.skipWhitespace();
                    keywordName = "";
                    isKeyword = false;
                } else {
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$19));
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$20));
                    outputBuffer.append(buffer + " ");
                }
                StringsKt.clear((StringBuilder)buffer);
                continue;
            }
            buffer.append(c2);
            this.logger.trace((Function0<? extends Object>)((Function0)() -> StringParser.parseNamed$lambda$21(buffer, c2)));
        }
        if (((CharSequence)buffer).length() > 0) {
            this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$22));
            this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$23));
            if (isFlag) {
                if (!isFlagValue) {
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$24));
                } else {
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$25));
                    String string = buffer.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    tokens.add(new NamedArgumentToken(flagName, string));
                }
            } else if (isKeyword) {
                this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$26));
                String string = buffer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                tokens.add(new NamedArgumentToken(keywordName, string));
            } else {
                this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNamed$lambda$27));
                outputBuffer.append(buffer.toString());
            }
        }
        String string = outputBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.cursor = new Cursor(((Object)StringsKt.trim((CharSequence)string)).toString());
        return tokens;
    }

    @Nullable
    public final PositionalArgumentToken peekNext() {
        int curIndex = this.cursor.getIndex();
        PositionalArgumentToken token = this.parseNext();
        this.cursor.setIndex(curIndex);
        return token;
    }

    @Nullable
    public final PositionalArgumentToken parseNext() {
        StringBuilder buffer = new StringBuilder();
        PositionalArgumentToken token = null;
        boolean isQuoted = false;
        while (this.cursor.getHasNext()) {
            char c = this.cursor.next();
            if (c == '\"' && ((CharSequence)buffer).length() == 0 && !isQuoted) {
                this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNext$lambda$0));
                isQuoted = true;
                continue;
            }
            if (c == '\\') {
                Character c2 = this.cursor.peekNext();
                char c3 = '\"';
                if (c2 != null && c2.charValue() == c3 && isQuoted) {
                    this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNext$lambda$1));
                    buffer.append('\"');
                    this.cursor.next();
                    continue;
                }
            }
            if (c == '\"' && isQuoted) {
                this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNext$lambda$2));
                this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNext$lambda$3));
                this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNext$lambda$4));
                String string = buffer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                token = new PositionalArgumentToken(string);
                this.cursor.skipWhitespace();
                StringsKt.clear((StringBuilder)buffer);
                break;
            }
            if (c == ' ' && !isQuoted) {
                this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNext$lambda$5));
                this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNext$lambda$6));
                this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNext$lambda$7));
                String string = buffer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                token = new PositionalArgumentToken(string);
                this.cursor.skipWhitespace();
                StringsKt.clear((StringBuilder)buffer);
                break;
            }
            buffer.append(c);
            this.logger.trace((Function0<? extends Object>)((Function0)() -> StringParser.parseNext$lambda$8(buffer, c)));
        }
        if (((CharSequence)buffer).length() > 0) {
            this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNext$lambda$9));
            this.logger.trace((Function0<? extends Object>)((Function0)StringParser::parseNext$lambda$10));
            String string = buffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            token = new PositionalArgumentToken(string);
        }
        return token;
    }

    @NotNull
    public final String consumeRemaining() {
        return this.cursor.consumeRemaining();
    }

    @Nullable
    public final String consumeWhile(@NotNull Function1<? super Character, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        String result2 = this.cursor.consumeWhile(predicate);
        if (result2 != null) {
            this.cursor.skipWhitespace();
        }
        return result2;
    }

    @NotNull
    public final String peekRemaining() {
        int curIndex = this.cursor.getIndex();
        String result2 = this.cursor.consumeRemaining();
        this.cursor.setIndex(curIndex);
        return result2;
    }

    @Nullable
    public final String peekWhile(@NotNull Function1<? super Character, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int curIndex = this.cursor.getIndex();
        String result2 = this.cursor.consumeWhile(predicate);
        this.cursor.setIndex(curIndex);
        return result2;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object parseNamed$lambda$0(char $char) {
        return "Character: " + $char;
    }

    private static final Object parseNamed$lambda$1() {
        return "  Marking as quoted.";
    }

    private static final Object parseNamed$lambda$2() {
        return "  Marking as flag.";
    }

    private static final Object parseNamed$lambda$3() {
        return "  Marking as keyword pair.";
    }

    private static final Object parseNamed$lambda$4() {
        return "  Escaped quote.";
    }

    private static final Object parseNamed$lambda$5() {
        return "  Reached quoted end.";
    }

    private static final Object parseNamed$lambda$6() {
        return "    Flag value detected.";
    }

    private static final Object parseNamed$lambda$7() {
        return "";
    }

    private static final Object parseNamed$lambda$8() {
        return "    Keyword value detected.";
    }

    private static final Object parseNamed$lambda$9() {
        return "";
    }

    private static final Object parseNamed$lambda$10() {
        return "    Token end detected.";
    }

    private static final Object parseNamed$lambda$11() {
        return "";
    }

    private static final Object parseNamed$lambda$12() {
        return "  Whitespace detected.";
    }

    private static final Object parseNamed$lambda$13() {
        return "    Flag name detected.";
    }

    private static final Object parseNamed$lambda$14() {
        return "";
    }

    private static final Object parseNamed$lambda$15() {
        return "    Flag value detected.";
    }

    private static final Object parseNamed$lambda$16() {
        return "";
    }

    private static final Object parseNamed$lambda$17() {
        return "    Keyword value detected.";
    }

    private static final Object parseNamed$lambda$18() {
        return "";
    }

    private static final Object parseNamed$lambda$19() {
        return "    Token end detected.";
    }

    private static final Object parseNamed$lambda$20() {
        return "";
    }

    private static final Object parseNamed$lambda$21(StringBuilder $buffer, char $char) {
        return "  Adding: \"" + $buffer + "\" + '" + $char + "'";
    }

    private static final Object parseNamed$lambda$22() {
        return "";
    }

    private static final Object parseNamed$lambda$23() {
        return "Buffer's not empty yet.";
    }

    private static final Object parseNamed$lambda$24() {
        return "  !! Flag name detected - this shouldn't happen!";
    }

    private static final Object parseNamed$lambda$25() {
        return "  Flag value detected.";
    }

    private static final Object parseNamed$lambda$26() {
        return "  Keyword value detected.";
    }

    private static final Object parseNamed$lambda$27() {
        return "  End of token detected.";
    }

    private static final Object parseNext$lambda$0() {
        return "  Marking as quoted.";
    }

    private static final Object parseNext$lambda$1() {
        return "  Escaped quote.";
    }

    private static final Object parseNext$lambda$2() {
        return "  Reached quoted end.";
    }

    private static final Object parseNext$lambda$3() {
        return "    Token end detected.";
    }

    private static final Object parseNext$lambda$4() {
        return "";
    }

    private static final Object parseNext$lambda$5() {
        return "  Whitespace detected.";
    }

    private static final Object parseNext$lambda$6() {
        return "    Token end detected.";
    }

    private static final Object parseNext$lambda$7() {
        return "";
    }

    private static final Object parseNext$lambda$8(StringBuilder $buffer, char $char) {
        return "  Adding: \"" + $buffer + "\" + '" + $char + "'";
    }

    private static final Object parseNext$lambda$9() {
        return "";
    }

    private static final Object parseNext$lambda$10() {
        return "Remaining buffer treated as positional token.";
    }
}

