/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.mcdiscordreserializer.renderer.implementation;

import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.mcdiscordreserializer.renderer.MinecraftRenderer;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.Component;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.TextComponent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.TextReplacementConfig;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.event.ClickEvent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.event.HoverEvent;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.NamedTextColor;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.TextColor;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.format.TextDecoration;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class DefaultMinecraftRenderer
implements MinecraftRenderer {
    public static final DefaultMinecraftRenderer INSTANCE = new DefaultMinecraftRenderer();
    private static final Pattern PATTERN_NEWLINE = Pattern.compile("\n");
    private static final Component QUOTE_PREFIX = Component.text("| ", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD);
    private static final TextReplacementConfig QUOTE_REPLACEMENT = (TextReplacementConfig)TextReplacementConfig.builder().match(PATTERN_NEWLINE).replacement(builder2 -> builder2.append(QUOTE_PREFIX)).build();

    @Override
    public Component link(@NotNull Component part, String link) {
        return part.clickEvent(ClickEvent.openUrl(link));
    }

    @Override
    @NotNull
    public Component strikethrough(@NotNull Component component) {
        return component.decoration(TextDecoration.STRIKETHROUGH, true);
    }

    @Override
    @NotNull
    public Component underline(@NotNull Component component) {
        return component.decoration(TextDecoration.UNDERLINED, true);
    }

    @Override
    @NotNull
    public Component italics(@NotNull Component component) {
        return component.decoration(TextDecoration.ITALIC, true);
    }

    @Override
    @NotNull
    public Component bold(@NotNull Component component) {
        return component.decoration(TextDecoration.BOLD, true);
    }

    @Override
    @NotNull
    public Component codeString(@NotNull Component component) {
        return component.color(NamedTextColor.DARK_GRAY);
    }

    @Override
    @NotNull
    public Component codeBlock(@NotNull Component component) {
        return component.color(NamedTextColor.DARK_GRAY);
    }

    @Override
    @NotNull
    public Component appendSpoiler(@NotNull Component component, @NotNull Component content2) {
        return component.append((Component)content2.decoration(TextDecoration.OBFUSCATED, true).color(NamedTextColor.DARK_GRAY).hoverEvent(HoverEvent.showText(content2)));
    }

    @Override
    @NotNull
    public Component appendQuote(@NotNull Component component, @NotNull Component content2) {
        return ((TextComponent)Component.empty().append(QUOTE_PREFIX)).append(component.replaceText(QUOTE_REPLACEMENT));
    }

    @Override
    @NotNull
    public Component appendEmoteMention(@NotNull Component component, @NotNull String name2, @NotNull String id2) {
        return component.append(Component.text(":" + name2 + ":"));
    }

    @Override
    @NotNull
    public Component appendChannelMention(@NotNull Component component, @NotNull String id2) {
        return component.append(Component.text("<#" + id2 + ">"));
    }

    @Override
    @NotNull
    public Component appendUserMention(@NotNull Component component, @NotNull String id2) {
        return component.append(Component.text("<@" + id2 + ">"));
    }

    @Override
    @NotNull
    public Component appendRoleMention(@NotNull Component component, @NotNull String id2) {
        return component.append(Component.text("<@&" + id2 + ">"));
    }
}

