/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.ktor.http;

import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.http.CookieDateBuilder;
import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.http.CookieUtilsKt;
import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.http.InvalidCookieDateException;
import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.http.StringLexer;
import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.util.date.GMTDate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\n\u001a\u00020\t\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/github/quiltservertools/blockbotdiscord/libs/io/ktor/http/CookieDateParser;", "", "<init>", "()V", "T", "", "source", "name", "field", "", "checkFieldNotNull", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "", "requirement", "Lkotlin/Function0;", "msg", "checkRequirement", "(Ljava/lang/String;ZLkotlin/jvm/functions/Function0;)V", "Lio/github/quiltservertools/blockbotdiscord/libs/io/ktor/util/date/GMTDate;", "parse", "(Ljava/lang/String;)Lio/ktor/util/date/GMTDate;", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nCookieUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CookieUtils.kt\nio/ktor/http/CookieDateParser\n+ 2 CookieUtils.kt\nio/ktor/http/StringLexer\n*L\n1#1,349:1\n56#2,3:350\n*S KotlinDebug\n*F\n+ 1 CookieUtils.kt\nio/ktor/http/CookieDateParser\n*L\n294#1:350,3\n*E\n"})
public final class CookieDateParser {
    private final <T> void checkFieldNotNull(String source2, String name2, T field2) {
        if (field2 == null) {
            throw new InvalidCookieDateException(source2, "Could not find " + name2);
        }
    }

    private final void checkRequirement(String source2, boolean requirement, Function0<String> msg) {
        if (!requirement) {
            throw new InvalidCookieDateException(source2, (String)msg.invoke());
        }
    }

    @NotNull
    public final GMTDate parse(@NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        StringLexer lexer = new StringLexer(source2);
        CookieDateBuilder builder2 = new CookieDateBuilder();
        lexer.acceptWhile((Function1<? super Character, Boolean>)((Function1)CookieDateParser::parse$lambda$0));
        while (lexer.getHasRemaining()) {
            String token;
            if (!lexer.test((Function1<? super Character, Boolean>)((Function1)CookieDateParser::parse$lambda$1))) continue;
            StringLexer this_$iv = lexer;
            boolean $i$f$capture = false;
            int start$iv = this_$iv.getIndex();
            StringLexer $this$parse_u24lambda_u243 = this_$iv;
            boolean bl = false;
            $this$parse_u24lambda_u243.acceptWhile((Function1<? super Character, Boolean>)((Function1)CookieDateParser::parse$lambda$3$lambda$2));
            Intrinsics.checkNotNullExpressionValue((Object)this_$iv.getSource().substring(start$iv, this_$iv.getIndex()), (String)"substring(...)");
            CookieUtilsKt.handleToken(builder2, token);
            lexer.acceptWhile((Function1<? super Character, Boolean>)((Function1)CookieDateParser::parse$lambda$4));
        }
        Integer n = builder2.getYear();
        Object object = new IntRange(70, 99);
        if (n != null && object.contains(n.intValue())) {
            Integer n2 = builder2.getYear();
            Intrinsics.checkNotNull((Object)n2);
            builder2.setYear(n2 + 1900);
        } else {
            object = new IntRange(0, 69);
            if (n != null && object.contains(n.intValue())) {
                Integer n3 = builder2.getYear();
                Intrinsics.checkNotNull((Object)n3);
                builder2.setYear(n3 + 2000);
            }
        }
        this.checkFieldNotNull(source2, "day-of-month", builder2.getDayOfMonth());
        this.checkFieldNotNull(source2, "month", builder2.getMonth());
        this.checkFieldNotNull(source2, "year", builder2.getYear());
        this.checkFieldNotNull(source2, "time", builder2.getHours());
        this.checkFieldNotNull(source2, "time", builder2.getMinutes());
        this.checkFieldNotNull(source2, "time", builder2.getSeconds());
        n = new IntRange(1, 31);
        object = builder2.getDayOfMonth();
        this.checkRequirement(source2, object != null && n.contains((Integer)object), (Function0<String>)((Function0)CookieDateParser::parse$lambda$5));
        Integer n4 = builder2.getYear();
        Intrinsics.checkNotNull((Object)n4);
        this.checkRequirement(source2, n4 >= 1601, (Function0<String>)((Function0)CookieDateParser::parse$lambda$6));
        Integer n5 = builder2.getHours();
        Intrinsics.checkNotNull((Object)n5);
        this.checkRequirement(source2, n5 <= 23, (Function0<String>)((Function0)CookieDateParser::parse$lambda$7));
        Integer n6 = builder2.getMinutes();
        Intrinsics.checkNotNull((Object)n6);
        this.checkRequirement(source2, n6 <= 59, (Function0<String>)((Function0)CookieDateParser::parse$lambda$8));
        Integer n7 = builder2.getSeconds();
        Intrinsics.checkNotNull((Object)n7);
        this.checkRequirement(source2, n7 <= 59, (Function0<String>)((Function0)CookieDateParser::parse$lambda$9));
        return builder2.build();
    }

    private static final boolean parse$lambda$0(char it) {
        return CookieUtilsKt.isDelimiter(it);
    }

    private static final boolean parse$lambda$1(char it) {
        return CookieUtilsKt.isNonDelimiter(it);
    }

    private static final boolean parse$lambda$3$lambda$2(char it) {
        return CookieUtilsKt.isNonDelimiter(it);
    }

    private static final boolean parse$lambda$4(char it) {
        return CookieUtilsKt.isDelimiter(it);
    }

    private static final String parse$lambda$5() {
        return "day-of-month not in [1,31]";
    }

    private static final String parse$lambda$6() {
        return "year >= 1601";
    }

    private static final String parse$lambda$7() {
        return "hours > 23";
    }

    private static final String parse$lambda$8() {
        return "minutes > 59";
    }

    private static final String parse$lambda$9() {
        return "seconds > 59";
    }
}

