/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.ktor.http;

import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.http.ContentType;
import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.http.HeaderValue;
import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.http.HeaderValueParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u001a\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0005\u001a\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\b\u0010\u0005\u001a%\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\b\u0010\u000b\u001a)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0002*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a+\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u0011*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a#\u0010\u0018\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001aE\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u001c\u0010\u001c\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00030\u001aj\b\u0012\u0004\u0012\u00020\u0003`\u001b0\u00122\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a=\u0010 \u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u001c\u0010\u001f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000e0\u001aj\b\u0012\u0004\u0012\u00020\u000e`\u001b0\u0012H\u0002\u00a2\u0006\u0004\b \u0010!\u001a+\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b#\u0010$\u001a+\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b%\u0010$\u001a\u001b\u0010&\u001a\u00020\t*\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b&\u0010'\u00a8\u0006("}, d2={"", "header", "", "Lio/github/quiltservertools/blockbotdiscord/libs/io/ktor/http/HeaderValue;", "parseAndSortHeader", "(Ljava/lang/String;)Ljava/util/List;", "parseAndSortContentTypeHeader", "text", "parseHeaderValue", "", "parametersOnly", "(Ljava/lang/String;Z)Ljava/util/List;", "", "Lkotlin/Pair;", "Lio/github/quiltservertools/blockbotdiscord/libs/io/ktor/http/HeaderValueParam;", "toHeaderParamsList", "(Ljava/lang/Iterable;)Ljava/util/List;", "T", "Lkotlin/Lazy;", "valueOrEmpty", "(Lkotlin/Lazy;)Ljava/util/List;", "", "start", "end", "subtrim", "(Ljava/lang/String;II)Ljava/lang/String;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "items", "parseHeaderValueItem", "(Ljava/lang/String;ILkotlin/Lazy;Z)I", "parameters", "parseHeaderValueParameter", "(Ljava/lang/String;ILkotlin/Lazy;)I", "value", "parseHeaderValueParameterValue", "(Ljava/lang/String;I)Lkotlin/Pair;", "parseHeaderValueParameterValueQuoted", "nextIsDelimiterOrEnd", "(Ljava/lang/String;I)Z", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nHttpHeaderValueParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpHeaderValueParser.kt\nio/ktor/http/HttpHeaderValueParserKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1068#2:244\n1563#2:245\n1634#2,3:246\n*S KotlinDebug\n*F\n+ 1 HttpHeaderValueParser.kt\nio/ktor/http/HttpHeaderValueParserKt\n*L\n59#1:244\n115#1:245\n115#1:246,3\n*E\n"})
public final class HttpHeaderValueParserKt {
    @NotNull
    public static final List<HeaderValue> parseAndSortHeader(@Nullable String header) {
        Iterable $this$sortedByDescending$iv = HttpHeaderValueParserKt.parseHeaderValue(header);
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HeaderValue it = (HeaderValue)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getQuality());
                it = (HeaderValue)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getQuality()));
            }
        });
    }

    @NotNull
    public static final List<HeaderValue> parseAndSortContentTypeHeader(@Nullable String header) {
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                HeaderValue it = (HeaderValue)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getQuality());
                it = (HeaderValue)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getQuality()));
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    HeaderValue it = (HeaderValue)a;
                    boolean bl = false;
                    ContentType contentType = ContentType.Companion.parse(it.getValue());
                    int asterisks = 0;
                    if (Intrinsics.areEqual((Object)contentType.getContentType(), (Object)"*")) {
                        asterisks += 2;
                    }
                    if (Intrinsics.areEqual((Object)contentType.getContentSubtype(), (Object)"*")) {
                        ++asterisks;
                    }
                    it = (HeaderValue)b;
                    Comparable comparable = Integer.valueOf(asterisks);
                    bl = false;
                    contentType = ContentType.Companion.parse(it.getValue());
                    asterisks = 0;
                    if (Intrinsics.areEqual((Object)contentType.getContentType(), (Object)"*")) {
                        asterisks += 2;
                    }
                    if (Intrinsics.areEqual((Object)contentType.getContentSubtype(), (Object)"*")) {
                        ++asterisks;
                    }
                    n = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(asterisks));
                }
                return n;
            }
        };
        return CollectionsKt.sortedWith((Iterable)HttpHeaderValueParserKt.parseHeaderValue(header), (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    HeaderValue it = (HeaderValue)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getParams().size());
                    it = (HeaderValue)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getParams().size()));
                }
                return n;
            }
        });
    }

    @NotNull
    public static final List<HeaderValue> parseHeaderValue(@Nullable String text) {
        return HttpHeaderValueParserKt.parseHeaderValue(text, false);
    }

    @NotNull
    public static final List<HeaderValue> parseHeaderValue(@Nullable String text, boolean parametersOnly) {
        if (text == null) {
            return CollectionsKt.emptyList();
        }
        int position2 = 0;
        Lazy items = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, HttpHeaderValueParserKt::parseHeaderValue$lambda$4);
        while (position2 <= StringsKt.getLastIndex((CharSequence)text)) {
            position2 = HttpHeaderValueParserKt.parseHeaderValueItem(text, position2, (Lazy<? extends ArrayList<HeaderValue>>)items, parametersOnly);
        }
        return HttpHeaderValueParserKt.valueOrEmpty(items);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<HeaderValueParam> toHeaderParamsList(@NotNull Iterable<Pair<String, String>> $this$toHeaderParamsList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toHeaderParamsList, (String)"<this>");
        Iterable<Pair<String, String>> $this$map$iv = $this$toHeaderParamsList;
        boolean $i$f$map = false;
        Iterable<Pair<String, String>> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HeaderValueParam((String)it.getFirst(), (String)it.getSecond()));
        }
        return (List)destination$iv$iv;
    }

    private static final <T> List<T> valueOrEmpty(Lazy<? extends List<? extends T>> $this$valueOrEmpty) {
        return $this$valueOrEmpty.isInitialized() ? (List)$this$valueOrEmpty.getValue() : CollectionsKt.emptyList();
    }

    private static final String subtrim(String $this$subtrim, int start2, int end) {
        String string = $this$subtrim.substring(start2, end);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private static final int parseHeaderValueItem(String text, int start2, Lazy<? extends ArrayList<HeaderValue>> items, boolean parametersOnly) {
        Integer valueEnd;
        int position2 = start2;
        Lazy parameters = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, HttpHeaderValueParserKt::parseHeaderValueItem$lambda$6);
        Integer n = valueEnd = parametersOnly ? Integer.valueOf(position2) : null;
        block4: while (position2 <= StringsKt.getLastIndex((CharSequence)text)) {
            switch (text.charAt(position2)) {
                case ',': {
                    Integer n2 = valueEnd;
                    ((ArrayList)items.getValue()).add(new HeaderValue(HttpHeaderValueParserKt.subtrim(text, start2, n2 != null ? n2 : position2), HttpHeaderValueParserKt.valueOrEmpty(parameters)));
                    return position2 + 1;
                }
                case ';': {
                    if (valueEnd == null) {
                        valueEnd = position2;
                    }
                    position2 = HttpHeaderValueParserKt.parseHeaderValueParameter(text, position2 + 1, (Lazy<? extends ArrayList<HeaderValueParam>>)parameters);
                    continue block4;
                }
            }
            position2 = parametersOnly ? HttpHeaderValueParserKt.parseHeaderValueParameter(text, position2, (Lazy<? extends ArrayList<HeaderValueParam>>)parameters) : position2 + 1;
        }
        Integer n3 = valueEnd;
        ((ArrayList)items.getValue()).add(new HeaderValue(HttpHeaderValueParserKt.subtrim(text, start2, n3 != null ? n3 : position2), HttpHeaderValueParserKt.valueOrEmpty(parameters)));
        return position2;
    }

    private static final int parseHeaderValueParameter(String text, int start2, Lazy<? extends ArrayList<HeaderValueParam>> parameters) {
        int position2;
        for (position2 = start2; position2 <= StringsKt.getLastIndex((CharSequence)text); ++position2) {
            switch (text.charAt(position2)) {
                case '=': {
                    Pair<Integer, String> pair = HttpHeaderValueParserKt.parseHeaderValueParameterValue(text, position2 + 1);
                    int paramEnd = ((Number)pair.component1()).intValue();
                    String paramValue = (String)pair.component2();
                    HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(parameters, text, start2, position2, paramValue);
                    return paramEnd;
                }
                case ',': 
                case ';': {
                    HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(parameters, text, start2, position2, "");
                    return position2;
                }
            }
        }
        HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(parameters, text, start2, position2, "");
        return position2;
    }

    private static final Pair<Integer, String> parseHeaderValueParameterValue(String value2, int start2) {
        int position2;
        if (value2.length() == start2) {
            return TuplesKt.to((Object)start2, (Object)"");
        }
        if (value2.charAt(start2) == '\"') {
            return HttpHeaderValueParserKt.parseHeaderValueParameterValueQuoted(value2, position2 + 1);
        }
        for (position2 = start2; position2 <= StringsKt.getLastIndex((CharSequence)value2); ++position2) {
            switch (value2.charAt(position2)) {
                case ',': 
                case ';': {
                    return TuplesKt.to((Object)position2, (Object)HttpHeaderValueParserKt.subtrim(value2, start2, position2));
                }
            }
        }
        return TuplesKt.to((Object)position2, (Object)HttpHeaderValueParserKt.subtrim(value2, start2, position2));
    }

    private static final Pair<Integer, String> parseHeaderValueParameterValueQuoted(String value2, int start2) {
        int position2 = start2;
        StringBuilder builder2 = new StringBuilder();
        while (position2 <= StringsKt.getLastIndex((CharSequence)value2)) {
            char currentChar = value2.charAt(position2);
            if (currentChar == '\"' && HttpHeaderValueParserKt.nextIsDelimiterOrEnd(value2, position2)) {
                return TuplesKt.to((Object)(position2 + 1), (Object)builder2.toString());
            }
            if (currentChar == '\\' && position2 < StringsKt.getLastIndex((CharSequence)value2) - 2) {
                builder2.append(value2.charAt(position2 + 1));
                position2 += 2;
                continue;
            }
            builder2.append(currentChar);
            ++position2;
        }
        Integer n = position2;
        char c = '\"';
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        return TuplesKt.to((Object)n, (Object)(c + string2));
    }

    private static final boolean nextIsDelimiterOrEnd(String $this$nextIsDelimiterOrEnd, int start2) {
        int position2;
        for (position2 = start2 + 1; position2 < $this$nextIsDelimiterOrEnd.length() && $this$nextIsDelimiterOrEnd.charAt(position2) == ' '; ++position2) {
        }
        return position2 == $this$nextIsDelimiterOrEnd.length() || $this$nextIsDelimiterOrEnd.charAt(position2) == ';' || $this$nextIsDelimiterOrEnd.charAt(position2) == ',';
    }

    private static final ArrayList parseHeaderValue$lambda$4() {
        return new ArrayList();
    }

    private static final ArrayList parseHeaderValueItem$lambda$6() {
        return new ArrayList();
    }

    private static final void parseHeaderValueParameter$addParam(Lazy<? extends ArrayList<HeaderValueParam>> $parameters, String text, int start2, int end, String value2) {
        String name2 = HttpHeaderValueParserKt.subtrim(text, start2, end);
        if (((CharSequence)name2).length() == 0) {
            return;
        }
        ((ArrayList)$parameters.getValue()).add(new HeaderValueParam(name2, value2));
    }
}

