/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DateUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.CollectionUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.HttpUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.UrlUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Breadcrumb
implements JsonUnknown,
JsonSerializable,
Comparable<Breadcrumb> {
    @Nullable
    private final Long timestampMs;
    @Nullable
    private Date timestamp;
    @NotNull
    private final Long nanos;
    @Nullable
    private String message;
    @Nullable
    private String type;
    @NotNull
    private @NotNull Map<String, @NotNull Object> data = new ConcurrentHashMap<String, Object>();
    @Nullable
    private String category;
    @Nullable
    private String origin;
    @Nullable
    private SentryLevel level;
    @Nullable
    private Map<String, Object> unknown;

    public Breadcrumb(@NotNull Date timestamp2) {
        this.nanos = System.nanoTime();
        this.timestamp = timestamp2;
        this.timestampMs = null;
    }

    public Breadcrumb(long timestamp2) {
        this.nanos = System.nanoTime();
        this.timestampMs = timestamp2;
        this.timestamp = null;
    }

    Breadcrumb(@NotNull Breadcrumb breadcrumb2) {
        this.nanos = System.nanoTime();
        this.timestamp = breadcrumb2.timestamp;
        this.timestampMs = breadcrumb2.timestampMs;
        this.message = breadcrumb2.message;
        this.type = breadcrumb2.type;
        this.category = breadcrumb2.category;
        this.origin = breadcrumb2.origin;
        Map<String, Object> dataClone = CollectionUtils.newConcurrentHashMap(breadcrumb2.data);
        if (dataClone != null) {
            this.data = dataClone;
        }
        this.unknown = CollectionUtils.newConcurrentHashMap(breadcrumb2.unknown);
        this.level = breadcrumb2.level;
    }

    public static Breadcrumb fromMap(@NotNull Map<String, Object> map2, @NotNull SentryOptions options2) {
        @NotNull Date timestamp2 = DateUtils.getCurrentDateTime();
        String message2 = null;
        String type = null;
        @NotNull ConcurrentHashMap<String, Object> data2 = new ConcurrentHashMap<String, Object>();
        String category = null;
        String origin = null;
        SentryLevel level = null;
        ConcurrentHashMap<String, Object> unknown = null;
        block20: for (Map.Entry<String, Object> entry : map2.entrySet()) {
            Object value2 = entry.getValue();
            switch (entry.getKey()) {
                case "timestamp": {
                    Date deserializedDate;
                    if (!(value2 instanceof String) || (deserializedDate = ObjectReader.dateOrNull((String)value2, options2.getLogger())) == null) continue block20;
                    timestamp2 = deserializedDate;
                    break;
                }
                case "message": {
                    message2 = value2 instanceof String ? (String)value2 : null;
                    break;
                }
                case "type": {
                    type = value2 instanceof String ? (String)value2 : null;
                    break;
                }
                case "data": {
                    Map untypedData = value2 instanceof Map ? (Map)value2 : null;
                    if (untypedData == null) continue block20;
                    for (Map.Entry dataEntry : untypedData.entrySet()) {
                        if (dataEntry.getKey() instanceof String && dataEntry.getValue() != null) {
                            data2.put((String)dataEntry.getKey(), dataEntry.getValue());
                            continue;
                        }
                        options2.getLogger().log(SentryLevel.WARNING, "Invalid key or null value in data map.", new Object[0]);
                    }
                    continue block20;
                }
                case "category": {
                    category = value2 instanceof String ? (String)value2 : null;
                    break;
                }
                case "origin": {
                    origin = value2 instanceof String ? (String)value2 : null;
                    break;
                }
                case "level": {
                    String levelString = value2 instanceof String ? (String)value2 : null;
                    if (levelString == null) continue block20;
                    try {
                        level = SentryLevel.valueOf(levelString.toUpperCase(Locale.ROOT));
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    if (unknown == null) {
                        unknown = new ConcurrentHashMap<String, Object>();
                    }
                    unknown.put(entry.getKey(), entry.getValue());
                }
            }
        }
        Breadcrumb breadcrumb2 = new Breadcrumb(timestamp2);
        breadcrumb2.message = message2;
        breadcrumb2.type = type;
        breadcrumb2.data = data2;
        breadcrumb2.category = category;
        breadcrumb2.origin = origin;
        breadcrumb2.level = level;
        breadcrumb2.setUnknown(unknown);
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb http(@NotNull String url2, @NotNull String method) {
        Breadcrumb breadcrumb2 = new Breadcrumb();
        @NotNull UrlUtils.UrlDetails urlDetails = UrlUtils.parse(url2);
        breadcrumb2.setType("http");
        breadcrumb2.setCategory("http");
        if (urlDetails.getUrl() != null) {
            breadcrumb2.setData("url", urlDetails.getUrl());
        }
        breadcrumb2.setData("method", method.toUpperCase(Locale.ROOT));
        if (urlDetails.getQuery() != null) {
            breadcrumb2.setData("http.query", urlDetails.getQuery());
        }
        if (urlDetails.getFragment() != null) {
            breadcrumb2.setData("http.fragment", urlDetails.getFragment());
        }
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb http(@NotNull String url2, @NotNull String method, @Nullable Integer code) {
        Breadcrumb breadcrumb2 = Breadcrumb.http(url2, method);
        if (code != null) {
            breadcrumb2.setData("status_code", code);
            breadcrumb2.setLevel(Breadcrumb.levelFromHttpStatusCode(code));
        }
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb graphqlOperation(@Nullable String operationName, @Nullable String operationType, @Nullable String operationId) {
        Breadcrumb breadcrumb2 = new Breadcrumb();
        breadcrumb2.setType("graphql");
        if (operationName != null) {
            breadcrumb2.setData("operation_name", operationName);
        }
        if (operationType != null) {
            breadcrumb2.setData("operation_type", operationType);
            breadcrumb2.setCategory(operationType);
        } else {
            breadcrumb2.setCategory("graphql.operation");
        }
        if (operationId != null) {
            breadcrumb2.setData("operation_id", operationId);
        }
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb graphqlDataFetcher(@Nullable String path, @Nullable String field2, @Nullable String type, @Nullable String objectType) {
        Breadcrumb breadcrumb2 = new Breadcrumb();
        breadcrumb2.setType("graphql");
        breadcrumb2.setCategory("graphql.fetcher");
        if (path != null) {
            breadcrumb2.setData("path", path);
        }
        if (field2 != null) {
            breadcrumb2.setData("field", field2);
        }
        if (type != null) {
            breadcrumb2.setData("type", type);
        }
        if (objectType != null) {
            breadcrumb2.setData("object_type", objectType);
        }
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb graphqlDataLoader(@NotNull Iterable<?> keys, @Nullable Class<?> keyType, @Nullable Class<?> valueType, @Nullable String name2) {
        Breadcrumb breadcrumb2 = new Breadcrumb();
        breadcrumb2.setType("graphql");
        breadcrumb2.setCategory("graphql.data_loader");
        ArrayList<String> serializedKeys = new ArrayList<String>();
        for (Object key : keys) {
            serializedKeys.add(key.toString());
        }
        breadcrumb2.setData("keys", serializedKeys);
        if (keyType != null) {
            breadcrumb2.setData("key_type", keyType.getName());
        }
        if (valueType != null) {
            breadcrumb2.setData("value_type", valueType.getName());
        }
        if (name2 != null) {
            breadcrumb2.setData("name", name2);
        }
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb navigation(@NotNull String from2, @NotNull String to) {
        Breadcrumb breadcrumb2 = new Breadcrumb();
        breadcrumb2.setCategory("navigation");
        breadcrumb2.setType("navigation");
        breadcrumb2.setData("from", from2);
        breadcrumb2.setData("to", to);
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb transaction(@NotNull String message2) {
        Breadcrumb breadcrumb2 = new Breadcrumb();
        breadcrumb2.setType("default");
        breadcrumb2.setCategory("sentry.transaction");
        breadcrumb2.setMessage(message2);
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb debug(@NotNull String message2) {
        Breadcrumb breadcrumb2 = new Breadcrumb();
        breadcrumb2.setType("debug");
        breadcrumb2.setMessage(message2);
        breadcrumb2.setLevel(SentryLevel.DEBUG);
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb error(@NotNull String message2) {
        Breadcrumb breadcrumb2 = new Breadcrumb();
        breadcrumb2.setType("error");
        breadcrumb2.setMessage(message2);
        breadcrumb2.setLevel(SentryLevel.ERROR);
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb info(@NotNull String message2) {
        Breadcrumb breadcrumb2 = new Breadcrumb();
        breadcrumb2.setType("info");
        breadcrumb2.setMessage(message2);
        breadcrumb2.setLevel(SentryLevel.INFO);
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb query(@NotNull String message2) {
        Breadcrumb breadcrumb2 = new Breadcrumb();
        breadcrumb2.setType("query");
        breadcrumb2.setMessage(message2);
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb ui(@NotNull String category, @NotNull String message2) {
        Breadcrumb breadcrumb2 = new Breadcrumb();
        breadcrumb2.setType("default");
        breadcrumb2.setCategory("ui." + category);
        breadcrumb2.setMessage(message2);
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb user(@NotNull String category, @NotNull String message2) {
        Breadcrumb breadcrumb2 = new Breadcrumb();
        breadcrumb2.setType("user");
        breadcrumb2.setCategory(category);
        breadcrumb2.setMessage(message2);
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb userInteraction(@NotNull String subCategory, @Nullable String viewId, @Nullable String viewClass) {
        return Breadcrumb.userInteraction(subCategory, viewId, viewClass, Collections.emptyMap());
    }

    @NotNull
    public static Breadcrumb userInteraction(@NotNull String subCategory, @Nullable String viewId, @Nullable String viewClass, @Nullable String viewTag, @NotNull Map<String, Object> additionalData) {
        Breadcrumb breadcrumb2 = new Breadcrumb();
        breadcrumb2.setType("user");
        breadcrumb2.setCategory("ui." + subCategory);
        if (viewId != null) {
            breadcrumb2.setData("view.id", viewId);
        }
        if (viewClass != null) {
            breadcrumb2.setData("view.class", viewClass);
        }
        if (viewTag != null) {
            breadcrumb2.setData("view.tag", viewTag);
        }
        for (Map.Entry<String, Object> entry : additionalData.entrySet()) {
            breadcrumb2.getData().put(entry.getKey(), entry.getValue());
        }
        breadcrumb2.setLevel(SentryLevel.INFO);
        return breadcrumb2;
    }

    @NotNull
    public static Breadcrumb userInteraction(@NotNull String subCategory, @Nullable String viewId, @Nullable String viewClass, @NotNull Map<String, Object> additionalData) {
        return Breadcrumb.userInteraction(subCategory, viewId, viewClass, null, additionalData);
    }

    @Nullable
    private static SentryLevel levelFromHttpStatusCode(@NotNull Integer code) {
        if (HttpUtils.isHttpClientError(code)) {
            return SentryLevel.WARNING;
        }
        if (HttpUtils.isHttpServerError(code)) {
            return SentryLevel.ERROR;
        }
        return null;
    }

    public Breadcrumb() {
        this(System.currentTimeMillis());
    }

    public Breadcrumb(@Nullable String message2) {
        this();
        this.message = message2;
    }

    @NotNull
    public Date getTimestamp() {
        if (this.timestamp != null) {
            return (Date)this.timestamp.clone();
        }
        if (this.timestampMs != null) {
            this.timestamp = DateUtils.getDateTime(this.timestampMs);
            return this.timestamp;
        }
        throw new IllegalStateException("No timestamp set for breadcrumb");
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String message2) {
        this.message = message2;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }

    @ApiStatus.Internal
    @NotNull
    public Map<String, Object> getData() {
        return this.data;
    }

    @Nullable
    public Object getData(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return this.data.get(key);
    }

    public void setData(@Nullable String key, @Nullable Object value2) {
        if (key == null) {
            return;
        }
        if (value2 == null) {
            this.removeData(key);
        } else {
            this.data.put(key, value2);
        }
    }

    public void removeData(@Nullable String key) {
        if (key == null) {
            return;
        }
        this.data.remove(key);
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    public void setCategory(@Nullable String category) {
        this.category = category;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(@Nullable String origin) {
        this.origin = origin;
    }

    @Nullable
    public SentryLevel getLevel() {
        return this.level;
    }

    public void setLevel(@Nullable SentryLevel level) {
        this.level = level;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Breadcrumb that = (Breadcrumb)o;
        return this.getTimestamp().getTime() == that.getTimestamp().getTime() && Objects.equals(this.message, that.message) && Objects.equals(this.type, that.type) && Objects.equals(this.category, that.category) && Objects.equals(this.origin, that.origin) && this.level == that.level;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.message, this.type, this.category, this.origin, this.level);
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public int compareTo(@NotNull Breadcrumb o) {
        return this.nanos.compareTo(o.nanos);
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("timestamp").value(logger, this.getTimestamp());
        if (this.message != null) {
            writer2.name("message").value(this.message);
        }
        if (this.type != null) {
            writer2.name("type").value(this.type);
        }
        writer2.name("data").value(logger, this.data);
        if (this.category != null) {
            writer2.name("category").value(this.category);
        }
        if (this.origin != null) {
            writer2.name("origin").value(this.origin);
        }
        if (this.level != null) {
            writer2.name("level").value(logger, this.level);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String TIMESTAMP = "timestamp";
        public static final String MESSAGE = "message";
        public static final String TYPE = "type";
        public static final String DATA = "data";
        public static final String CATEGORY = "category";
        public static final String ORIGIN = "origin";
        public static final String LEVEL = "level";
    }

    public static final class Deserializer
    implements JsonDeserializer<Breadcrumb> {
        @Override
        @NotNull
        public Breadcrumb deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            @NotNull Date timestamp2 = DateUtils.getCurrentDateTime();
            String message2 = null;
            String type = null;
            @NotNull Map<K, V> data2 = new ConcurrentHashMap();
            String category = null;
            String origin = null;
            SentryLevel level = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block20: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "timestamp": {
                        Date deserializedDate = reader2.nextDateOrNull(logger);
                        if (deserializedDate == null) continue block20;
                        timestamp2 = deserializedDate;
                        continue block20;
                    }
                    case "message": {
                        message2 = reader2.nextStringOrNull();
                        continue block20;
                    }
                    case "type": {
                        type = reader2.nextStringOrNull();
                        continue block20;
                    }
                    case "data": {
                        Map deserializedData = CollectionUtils.newConcurrentHashMap((Map)reader2.nextObjectOrNull());
                        if (deserializedData == null) continue block20;
                        data2 = deserializedData;
                        continue block20;
                    }
                    case "category": {
                        category = reader2.nextStringOrNull();
                        continue block20;
                    }
                    case "origin": {
                        origin = reader2.nextStringOrNull();
                        continue block20;
                    }
                    case "level": {
                        try {
                            level = new SentryLevel.Deserializer().deserialize(reader2, logger);
                        }
                        catch (Exception exception) {
                            logger.log(SentryLevel.ERROR, exception, "Error when deserializing SentryLevel", new Object[0]);
                        }
                        continue block20;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            Breadcrumb breadcrumb2 = new Breadcrumb(timestamp2);
            breadcrumb2.message = message2;
            breadcrumb2.type = type;
            breadcrumb2.data = data2;
            breadcrumb2.category = category;
            breadcrumb2.origin = origin;
            breadcrumb2.level = level;
            breadcrumb2.setUnknown(unknown);
            reader2.endObject();
            return breadcrumb2;
        }
    }
}

