/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.IScopes;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.IScopesStorage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISentryLifecycleToken;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DefaultScopesStorage
implements IScopesStorage {
    @NotNull
    private static final ThreadLocal<IScopes> currentScopes = new ThreadLocal();

    @Override
    public void init() {
    }

    @Override
    public ISentryLifecycleToken set(@Nullable IScopes scopes) {
        @Nullable IScopes oldScopes = this.get();
        currentScopes.set(scopes);
        return new DefaultScopesLifecycleToken(oldScopes);
    }

    @Override
    @Nullable
    public IScopes get() {
        return currentScopes.get();
    }

    @Override
    public void close() {
        currentScopes.remove();
    }

    static final class DefaultScopesLifecycleToken
    implements ISentryLifecycleToken {
        @Nullable
        private final IScopes oldValue;

        DefaultScopesLifecycleToken(@Nullable IScopes scopes) {
            this.oldValue = scopes;
        }

        @Override
        public void close() {
            currentScopes.set(this.oldValue);
        }
    }
}

