/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.EventProcessor;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Hint;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DuplicateEventDetectionEventProcessor
implements EventProcessor {
    @NotNull
    private final Map<Throwable, Object> capturedObjects = Collections.synchronizedMap(new WeakHashMap());
    @NotNull
    private final SentryOptions options;

    public DuplicateEventDetectionEventProcessor(@NotNull SentryOptions options2) {
        this.options = Objects.requireNonNull(options2, "options are required");
    }

    @Override
    @Nullable
    public SentryEvent process(@NotNull SentryEvent event2, @NotNull Hint hint) {
        if (this.options.isEnableDeduplication()) {
            Throwable throwable = event2.getThrowable();
            if (throwable != null) {
                if (this.capturedObjects.containsKey(throwable) || DuplicateEventDetectionEventProcessor.containsAnyKey(this.capturedObjects, DuplicateEventDetectionEventProcessor.allCauses(throwable))) {
                    this.options.getLogger().log(SentryLevel.DEBUG, "Duplicate Exception detected. Event %s will be discarded.", event2.getEventId());
                    return null;
                }
                this.capturedObjects.put(throwable, null);
            }
        } else {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event deduplication is disabled.", new Object[0]);
        }
        return event2;
    }

    private static <T> boolean containsAnyKey(@NotNull Map<T, Object> map2, @NotNull List<T> list2) {
        for (T entry : list2) {
            if (!map2.containsKey(entry)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<Throwable> allCauses(@NotNull Throwable throwable) {
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        Throwable ex = throwable;
        while (ex.getCause() != null) {
            causes.add(ex.getCause());
            ex = ex.getCause();
        }
        return causes;
    }

    @Override
    @Nullable
    public Long getOrder() {
        return 1000L;
    }
}

