/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DateUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonReflectionObjectSerializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.JsonSerializationUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JsonObjectSerializer {
    public static final String OBJECT_PLACEHOLDER = "[OBJECT]";
    public final JsonReflectionObjectSerializer jsonReflectionObjectSerializer;

    public JsonObjectSerializer(int maxDepth) {
        this.jsonReflectionObjectSerializer = new JsonReflectionObjectSerializer(maxDepth);
    }

    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger, @Nullable Object object) throws IOException {
        if (object == null) {
            writer2.nullValue();
        } else if (object instanceof Character) {
            writer2.value(Character.toString(((Character)object).charValue()));
        } else if (object instanceof String) {
            writer2.value((String)object);
        } else if (object instanceof Boolean) {
            writer2.value((boolean)((Boolean)object));
        } else if (object instanceof Number) {
            writer2.value((Number)object);
        } else if (object instanceof Date) {
            this.serializeDate(writer2, logger, (Date)object);
        } else if (object instanceof TimeZone) {
            this.serializeTimeZone(writer2, logger, (TimeZone)object);
        } else if (object instanceof JsonSerializable) {
            ((JsonSerializable)object).serialize(writer2, logger);
        } else if (object instanceof Collection) {
            this.serializeCollection(writer2, logger, (Collection)object);
        } else if (object.getClass().isArray()) {
            this.serializeCollection(writer2, logger, Arrays.asList((Object[])object));
        } else if (object instanceof Map) {
            this.serializeMap(writer2, logger, (Map)object);
        } else if (object instanceof Locale) {
            writer2.value(object.toString());
        } else if (object instanceof AtomicIntegerArray) {
            this.serializeCollection(writer2, logger, JsonSerializationUtils.atomicIntegerArrayToList((AtomicIntegerArray)object));
        } else if (object instanceof AtomicBoolean) {
            writer2.value(((AtomicBoolean)object).get());
        } else if (object instanceof URI) {
            writer2.value(object.toString());
        } else if (object instanceof InetAddress) {
            writer2.value(object.toString());
        } else if (object instanceof UUID) {
            writer2.value(object.toString());
        } else if (object instanceof Currency) {
            writer2.value(object.toString());
        } else if (object instanceof Calendar) {
            this.serializeMap(writer2, logger, JsonSerializationUtils.calendarToMap((Calendar)object));
        } else if (object.getClass().isEnum()) {
            writer2.value(object.toString());
        } else {
            try {
                Object serializableObject = this.jsonReflectionObjectSerializer.serialize(object, logger);
                this.serialize(writer2, logger, serializableObject);
            }
            catch (Exception exception) {
                logger.log(SentryLevel.ERROR, "Failed serializing unknown object.", exception);
                writer2.value(OBJECT_PLACEHOLDER);
            }
        }
    }

    private void serializeDate(@NotNull ObjectWriter writer2, @NotNull ILogger logger, @NotNull Date date) throws IOException {
        try {
            writer2.value(DateUtils.getTimestamp(date));
        }
        catch (Exception e) {
            logger.log(SentryLevel.ERROR, "Error when serializing Date", e);
            writer2.nullValue();
        }
    }

    private void serializeTimeZone(@NotNull ObjectWriter writer2, @NotNull ILogger logger, @NotNull TimeZone timeZone) throws IOException {
        try {
            writer2.value(timeZone.getID());
        }
        catch (Exception e) {
            logger.log(SentryLevel.ERROR, "Error when serializing TimeZone", e);
            writer2.nullValue();
        }
    }

    private void serializeCollection(@NotNull ObjectWriter writer2, @NotNull ILogger logger, @NotNull Collection<?> collection) throws IOException {
        writer2.beginArray();
        for (Object object : collection) {
            this.serialize(writer2, logger, object);
        }
        writer2.endArray();
    }

    private void serializeMap(@NotNull ObjectWriter writer2, @NotNull ILogger logger, @NotNull Map<?, ?> map2) throws IOException {
        writer2.beginObject();
        for (Object key : map2.keySet()) {
            if (!(key instanceof String)) continue;
            writer2.name((String)key);
            this.serialize(writer2, logger, map2.get(key));
        }
        writer2.endObject();
    }
}

