/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Breadcrumb;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISerializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ProfileChunk;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ProfileContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ProfilingTraceData;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ProfilingTransactionData;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ReplayRecording;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryAppStartProfilingOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEnvelope;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEnvelopeHeader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEnvelopeItem;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEnvelopeItemHeader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryItemType;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLockReason;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLogEvents;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryReplayEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Session;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanStatus;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.UserFeedback;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.clientreport.ClientReport;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.profilemeasurements.ProfileMeasurement;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.profilemeasurements.ProfileMeasurementValue;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.App;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Browser;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Contexts;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.DebugImage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.DebugMeta;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Device;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Feedback;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Geo;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Gpu;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.MeasurementValue;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Mechanism;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Message;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.OperatingSystem;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Request;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SdkInfo;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SdkVersion;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryException;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryPackage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryRuntime;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentrySpan;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryStackFrame;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryStackTrace;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryThread;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryTransaction;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.User;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.ViewHierarchy;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.ViewHierarchyNode;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebBreadcrumbEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebEventType;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebInteractionEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebInteractionMoveEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebMetaEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebSpanEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebVideoEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSerializer
implements ISerializer {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final Map<Class<?>, JsonDeserializer<?>> deserializersByClass;

    public JsonSerializer(@NotNull SentryOptions options2) {
        this.options = options2;
        this.deserializersByClass = new HashMap();
        this.deserializersByClass.put(App.class, new App.Deserializer());
        this.deserializersByClass.put(Breadcrumb.class, new Breadcrumb.Deserializer());
        this.deserializersByClass.put(Browser.class, new Browser.Deserializer());
        this.deserializersByClass.put(Contexts.class, new Contexts.Deserializer());
        this.deserializersByClass.put(DebugImage.class, new DebugImage.Deserializer());
        this.deserializersByClass.put(DebugMeta.class, new DebugMeta.Deserializer());
        this.deserializersByClass.put(Device.class, new Device.Deserializer());
        this.deserializersByClass.put(Device.DeviceOrientation.class, new Device.DeviceOrientation.Deserializer());
        this.deserializersByClass.put(Feedback.class, new Feedback.Deserializer());
        this.deserializersByClass.put(Gpu.class, new Gpu.Deserializer());
        this.deserializersByClass.put(MeasurementValue.class, new MeasurementValue.Deserializer());
        this.deserializersByClass.put(Mechanism.class, new Mechanism.Deserializer());
        this.deserializersByClass.put(Message.class, new Message.Deserializer());
        this.deserializersByClass.put(OperatingSystem.class, new OperatingSystem.Deserializer());
        this.deserializersByClass.put(ProfileChunk.class, new ProfileChunk.Deserializer());
        this.deserializersByClass.put(ProfileContext.class, new ProfileContext.Deserializer());
        this.deserializersByClass.put(ProfilingTraceData.class, new ProfilingTraceData.Deserializer());
        this.deserializersByClass.put(ProfilingTransactionData.class, new ProfilingTransactionData.Deserializer());
        this.deserializersByClass.put(ProfileMeasurement.class, new ProfileMeasurement.Deserializer());
        this.deserializersByClass.put(ProfileMeasurementValue.class, new ProfileMeasurementValue.Deserializer());
        this.deserializersByClass.put(Request.class, new Request.Deserializer());
        this.deserializersByClass.put(ReplayRecording.class, new ReplayRecording.Deserializer());
        this.deserializersByClass.put(RRWebBreadcrumbEvent.class, new RRWebBreadcrumbEvent.Deserializer());
        this.deserializersByClass.put(RRWebEventType.class, new RRWebEventType.Deserializer());
        this.deserializersByClass.put(RRWebInteractionEvent.class, new RRWebInteractionEvent.Deserializer());
        this.deserializersByClass.put(RRWebInteractionMoveEvent.class, new RRWebInteractionMoveEvent.Deserializer());
        this.deserializersByClass.put(RRWebMetaEvent.class, new RRWebMetaEvent.Deserializer());
        this.deserializersByClass.put(RRWebSpanEvent.class, new RRWebSpanEvent.Deserializer());
        this.deserializersByClass.put(RRWebVideoEvent.class, new RRWebVideoEvent.Deserializer());
        this.deserializersByClass.put(SdkInfo.class, new SdkInfo.Deserializer());
        this.deserializersByClass.put(SdkVersion.class, new SdkVersion.Deserializer());
        this.deserializersByClass.put(SentryEnvelopeHeader.class, new SentryEnvelopeHeader.Deserializer());
        this.deserializersByClass.put(SentryEnvelopeItemHeader.class, new SentryEnvelopeItemHeader.Deserializer());
        this.deserializersByClass.put(SentryEvent.class, new SentryEvent.Deserializer());
        this.deserializersByClass.put(SentryException.class, new SentryException.Deserializer());
        this.deserializersByClass.put(SentryItemType.class, new SentryItemType.Deserializer());
        this.deserializersByClass.put(SentryLevel.class, new SentryLevel.Deserializer());
        this.deserializersByClass.put(SentryLockReason.class, new SentryLockReason.Deserializer());
        this.deserializersByClass.put(SentryLogEvents.class, new SentryLogEvents.Deserializer());
        this.deserializersByClass.put(SentryPackage.class, new SentryPackage.Deserializer());
        this.deserializersByClass.put(SentryRuntime.class, new SentryRuntime.Deserializer());
        this.deserializersByClass.put(SentryReplayEvent.class, new SentryReplayEvent.Deserializer());
        this.deserializersByClass.put(SentrySpan.class, new SentrySpan.Deserializer());
        this.deserializersByClass.put(SentryStackFrame.class, new SentryStackFrame.Deserializer());
        this.deserializersByClass.put(SentryStackTrace.class, new SentryStackTrace.Deserializer());
        this.deserializersByClass.put(SentryAppStartProfilingOptions.class, new SentryAppStartProfilingOptions.Deserializer());
        this.deserializersByClass.put(SentryThread.class, new SentryThread.Deserializer());
        this.deserializersByClass.put(SentryTransaction.class, new SentryTransaction.Deserializer());
        this.deserializersByClass.put(Session.class, new Session.Deserializer());
        this.deserializersByClass.put(SpanContext.class, new SpanContext.Deserializer());
        this.deserializersByClass.put(SpanId.class, new SpanId.Deserializer());
        this.deserializersByClass.put(SpanStatus.class, new SpanStatus.Deserializer());
        this.deserializersByClass.put(User.class, new User.Deserializer());
        this.deserializersByClass.put(Geo.class, new Geo.Deserializer());
        this.deserializersByClass.put(UserFeedback.class, new UserFeedback.Deserializer());
        this.deserializersByClass.put(ClientReport.class, new ClientReport.Deserializer());
        this.deserializersByClass.put(ViewHierarchyNode.class, new ViewHierarchyNode.Deserializer());
        this.deserializersByClass.put(ViewHierarchy.class, new ViewHierarchy.Deserializer());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T, R> T deserializeCollection(@NotNull Reader reader2, @NotNull Class<T> clazz, @Nullable JsonDeserializer<R> elementDeserializer) {
        try (JsonObjectReader jsonObjectReader = new JsonObjectReader(reader2);){
            if (Collection.class.isAssignableFrom(clazz)) {
                if (elementDeserializer == null) {
                    Object object = jsonObjectReader.nextObjectOrNull();
                    return (T)object;
                }
                List<R> list2 = jsonObjectReader.nextListOrNull(this.options.getLogger(), elementDeserializer);
                return (T)list2;
            }
            Object object = jsonObjectReader.nextObjectOrNull();
            return (T)object;
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error when deserializing", e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T deserialize(@NotNull Reader reader2, @NotNull Class<T> clazz) {
        try (JsonObjectReader jsonObjectReader = new JsonObjectReader(reader2);){
            JsonDeserializer<?> deserializer = this.deserializersByClass.get(clazz);
            if (deserializer != null) {
                Object object = deserializer.deserialize(jsonObjectReader, this.options.getLogger());
                T t = clazz.cast(object);
                return t;
            }
            if (this.isKnownPrimitive(clazz)) {
                Object object = jsonObjectReader.nextObjectOrNull();
                return (T)object;
            }
            T t = null;
            return t;
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error when deserializing", e);
            return null;
        }
    }

    @Override
    @Nullable
    public SentryEnvelope deserializeEnvelope(@NotNull InputStream inputStream2) {
        Objects.requireNonNull(inputStream2, "The InputStream object is required.");
        try {
            return this.options.getEnvelopeReader().read(inputStream2);
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error deserializing envelope.", e);
            return null;
        }
    }

    @Override
    public <T> void serialize(@NotNull T entity, @NotNull Writer writer2) throws IOException {
        Objects.requireNonNull(entity, "The entity is required.");
        Objects.requireNonNull(writer2, "The Writer object is required.");
        if (this.options.getLogger().isEnabled(SentryLevel.DEBUG)) {
            String serialized = this.serializeToString(entity, this.options.isEnablePrettySerializationOutput());
            this.options.getLogger().log(SentryLevel.DEBUG, "Serializing object: %s", serialized);
        }
        JsonObjectWriter jsonObjectWriter = new JsonObjectWriter(writer2, this.options.getMaxDepth());
        jsonObjectWriter.value(this.options.getLogger(), entity);
        writer2.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(@NotNull SentryEnvelope envelope, @NotNull OutputStream outputStream2) throws Exception {
        Objects.requireNonNull(envelope, "The SentryEnvelope object is required.");
        Objects.requireNonNull(outputStream2, "The Stream object is required.");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream2);
        BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, UTF_8));
        try {
            envelope.getHeader().serialize(new JsonObjectWriter(writer2, this.options.getMaxDepth()), this.options.getLogger());
            writer2.write("\n");
            for (SentryEnvelopeItem item2 : envelope.getItems()) {
                try {
                    byte[] data2 = item2.getData();
                    item2.getHeader().serialize(new JsonObjectWriter(writer2, this.options.getMaxDepth()), this.options.getLogger());
                    writer2.write("\n");
                    ((Writer)writer2).flush();
                    outputStream2.write(data2);
                    writer2.write("\n");
                }
                catch (Exception exception) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Failed to create envelope item. Dropping it.", exception);
                }
            }
        }
        finally {
            ((Writer)writer2).flush();
        }
    }

    @Override
    @NotNull
    public String serialize(@NotNull Map<String, Object> data2) throws Exception {
        return this.serializeToString(data2, false);
    }

    @NotNull
    private String serializeToString(Object object, boolean pretty) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonObjectWriter jsonObjectWriter = new JsonObjectWriter(stringWriter, this.options.getMaxDepth());
        if (pretty) {
            jsonObjectWriter.setIndent("\t");
        }
        jsonObjectWriter.value(this.options.getLogger(), object);
        return stringWriter.toString();
    }

    private <T> boolean isKnownPrimitive(@NotNull Class<T> clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }
}

