/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.EventProcessor;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Hint;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.HostnameCache;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryBaseEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryExceptionFactory;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryReplayEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryStackTraceFactory;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryThreadFactory;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.hints.AbnormalExit;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.hints.Cached;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.DebugMeta;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SdkVersion;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryException;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryTransaction;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.User;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.HintUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class MainEventProcessor
implements EventProcessor,
Closeable {
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final SentryThreadFactory sentryThreadFactory;
    @NotNull
    private final SentryExceptionFactory sentryExceptionFactory;
    @Nullable
    private volatile HostnameCache hostnameCache = null;

    public MainEventProcessor(@NotNull SentryOptions options2) {
        this.options = Objects.requireNonNull(options2, "The SentryOptions is required.");
        SentryStackTraceFactory sentryStackTraceFactory = new SentryStackTraceFactory(this.options);
        this.sentryExceptionFactory = new SentryExceptionFactory(sentryStackTraceFactory);
        this.sentryThreadFactory = new SentryThreadFactory(sentryStackTraceFactory, this.options);
    }

    MainEventProcessor(@NotNull SentryOptions options2, @NotNull SentryThreadFactory sentryThreadFactory, @NotNull SentryExceptionFactory sentryExceptionFactory) {
        this.options = Objects.requireNonNull(options2, "The SentryOptions is required.");
        this.sentryThreadFactory = Objects.requireNonNull(sentryThreadFactory, "The SentryThreadFactory is required.");
        this.sentryExceptionFactory = Objects.requireNonNull(sentryExceptionFactory, "The SentryExceptionFactory is required.");
    }

    @Override
    @NotNull
    public SentryEvent process(@NotNull SentryEvent event2, @NotNull Hint hint) {
        this.setCommons(event2);
        this.setExceptions(event2);
        this.setDebugMeta(event2);
        this.setModules(event2);
        if (this.shouldApplyScopeData(event2, hint)) {
            this.processNonCachedEvent(event2);
            this.setThreads(event2, hint);
        }
        return event2;
    }

    private void setDebugMeta(@NotNull SentryBaseEvent event2) {
        DebugMeta debugMeta = DebugMeta.buildDebugMeta(event2.getDebugMeta(), this.options);
        if (debugMeta != null) {
            event2.setDebugMeta(debugMeta);
        }
    }

    private void setModules(@NotNull SentryEvent event2) {
        Map<String, String> modules = this.options.getModulesLoader().getOrLoadModules();
        if (modules == null) {
            return;
        }
        Map<String, String> eventModules = event2.getModules();
        if (eventModules == null) {
            event2.setModules(modules);
        } else {
            eventModules.putAll(modules);
        }
    }

    private boolean shouldApplyScopeData(@NotNull SentryBaseEvent event2, @NotNull Hint hint) {
        if (HintUtils.shouldApplyScopeData(hint)) {
            return true;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying data relevant to the current app execution/version: %s", event2.getEventId());
        return false;
    }

    private void processNonCachedEvent(@NotNull SentryBaseEvent event2) {
        this.setRelease(event2);
        this.setEnvironment(event2);
        this.setServerName(event2);
        this.setDist(event2);
        this.setSdk(event2);
        this.setTags(event2);
        this.mergeUser(event2);
    }

    @Override
    @NotNull
    public SentryTransaction process(@NotNull SentryTransaction transaction, @NotNull Hint hint) {
        this.setCommons(transaction);
        this.setDebugMeta(transaction);
        if (this.shouldApplyScopeData(transaction, hint)) {
            this.processNonCachedEvent(transaction);
        }
        return transaction;
    }

    @Override
    @NotNull
    public SentryReplayEvent process(@NotNull SentryReplayEvent event2, @NotNull Hint hint) {
        this.setCommons(event2);
        if (this.shouldApplyScopeData(event2, hint)) {
            this.processNonCachedEvent(event2);
            @Nullable SdkVersion replaySdkVersion = this.options.getSessionReplay().getSdkVersion();
            if (replaySdkVersion != null) {
                event2.setSdk(replaySdkVersion);
            }
        }
        return event2;
    }

    private void setCommons(@NotNull SentryBaseEvent event2) {
        this.setPlatform(event2);
    }

    private void setPlatform(@NotNull SentryBaseEvent event2) {
        if (event2.getPlatform() == null) {
            event2.setPlatform("java");
        }
    }

    private void setRelease(@NotNull SentryBaseEvent event2) {
        if (event2.getRelease() == null) {
            event2.setRelease(this.options.getRelease());
        }
    }

    private void setEnvironment(@NotNull SentryBaseEvent event2) {
        if (event2.getEnvironment() == null) {
            event2.setEnvironment(this.options.getEnvironment());
        }
    }

    private void setServerName(@NotNull SentryBaseEvent event2) {
        if (event2.getServerName() == null) {
            event2.setServerName(this.options.getServerName());
        }
        if (this.options.isAttachServerName() && event2.getServerName() == null) {
            this.ensureHostnameCache();
            if (this.hostnameCache != null) {
                event2.setServerName(this.hostnameCache.getHostname());
            }
        }
    }

    private void ensureHostnameCache() {
        if (this.hostnameCache == null) {
            this.hostnameCache = HostnameCache.getInstance();
        }
    }

    private void setDist(@NotNull SentryBaseEvent event2) {
        if (event2.getDist() == null) {
            event2.setDist(this.options.getDist());
        }
    }

    private void setSdk(@NotNull SentryBaseEvent event2) {
        if (event2.getSdk() == null) {
            event2.setSdk(this.options.getSdkVersion());
        }
    }

    private void setTags(@NotNull SentryBaseEvent event2) {
        if (event2.getTags() == null) {
            event2.setTags(new HashMap<String, String>(this.options.getTags()));
        } else {
            for (Map.Entry<String, String> item2 : this.options.getTags().entrySet()) {
                if (event2.getTags().containsKey(item2.getKey())) continue;
                event2.setTag(item2.getKey(), item2.getValue());
            }
        }
    }

    private void mergeUser(@NotNull SentryBaseEvent event2) {
        @Nullable User user2 = event2.getUser();
        if (user2 == null) {
            user2 = new User();
            event2.setUser(user2);
        }
        if (user2.getIpAddress() == null && this.options.isSendDefaultPii()) {
            user2.setIpAddress("{{auto}}");
        }
    }

    private void setExceptions(@NotNull SentryEvent event2) {
        Throwable throwable = event2.getThrowableMechanism();
        if (throwable != null) {
            event2.setExceptions(this.sentryExceptionFactory.getSentryExceptions(throwable));
        }
    }

    private void setThreads(@NotNull SentryEvent event2, @NotNull Hint hint) {
        if (event2.getThreads() == null) {
            ArrayList<Long> mechanismThreadIds = null;
            List<SentryException> eventExceptions = event2.getExceptions();
            if (eventExceptions != null && !eventExceptions.isEmpty()) {
                for (SentryException item2 : eventExceptions) {
                    if (item2.getMechanism() == null || item2.getThreadId() == null) continue;
                    if (mechanismThreadIds == null) {
                        mechanismThreadIds = new ArrayList<Long>();
                    }
                    mechanismThreadIds.add(item2.getThreadId());
                }
            }
            if (this.options.isAttachThreads() || HintUtils.hasType(hint, AbnormalExit.class)) {
                Object sentrySdkHint = HintUtils.getSentrySdkHint(hint);
                boolean ignoreCurrentThread = false;
                if (sentrySdkHint instanceof AbnormalExit) {
                    ignoreCurrentThread = ((AbnormalExit)sentrySdkHint).ignoreCurrentThread();
                }
                event2.setThreads(this.sentryThreadFactory.getCurrentThreads(mechanismThreadIds, ignoreCurrentThread));
            } else if (this.options.isAttachStacktrace() && (eventExceptions == null || eventExceptions.isEmpty()) && !this.isCachedHint(hint)) {
                event2.setThreads(this.sentryThreadFactory.getCurrentThread());
            }
        }
    }

    private boolean isCachedHint(@NotNull Hint hint) {
        return HintUtils.hasType(hint, Cached.class);
    }

    @Override
    public void close() throws IOException {
        if (this.hostnameCache != null) {
            this.hostnameCache.close();
        }
    }

    boolean isClosed() {
        if (this.hostnameCache != null) {
            return this.hostnameCache.isClosed();
        }
        return true;
    }

    @VisibleForTesting
    @Nullable
    HostnameCache getHostnameCache() {
        return this.hostnameCache;
    }

    @Override
    @Nullable
    public Long getOrder() {
        return 0L;
    }
}

