/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.CollectionUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProfileContext
implements JsonUnknown,
JsonSerializable {
    public static final String TYPE = "profile";
    @NotNull
    private SentryId profilerId;
    @Nullable
    private Map<String, Object> unknown;

    public ProfileContext() {
        this(SentryId.EMPTY_ID);
    }

    public ProfileContext(@NotNull SentryId profilerId) {
        this.profilerId = profilerId;
    }

    public ProfileContext(@NotNull ProfileContext profileContext) {
        this.profilerId = profileContext.profilerId;
        Map<String, Object> copiedUnknown = CollectionUtils.newConcurrentHashMap(profileContext.unknown);
        if (copiedUnknown != null) {
            this.unknown = copiedUnknown;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileContext)) {
            return false;
        }
        ProfileContext that = (ProfileContext)o;
        return this.profilerId.equals(that.profilerId);
    }

    public int hashCode() {
        return Objects.hash(this.profilerId);
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("profiler_id").value(logger, this.profilerId);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key).value(logger, value2);
            }
        }
        writer2.endObject();
    }

    @NotNull
    public SentryId getProfilerId() {
        return this.profilerId;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String PROFILER_ID = "profiler_id";
    }

    public static final class Deserializer
    implements JsonDeserializer<ProfileContext> {
        @Override
        @NotNull
        public ProfileContext deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            ProfileContext data2 = new ProfileContext();
            ConcurrentHashMap<String, Object> unknown = null;
            block6: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "profiler_id": {
                        SentryId profilerId = reader2.nextOrNull(logger, new SentryId.Deserializer());
                        if (profilerId == null) continue block6;
                        data2.profilerId = profilerId;
                        continue block6;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            data2.setUnknown(unknown);
            reader2.endObject();
            return data2;
        }
    }
}

