/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.BaggageHeader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Breadcrumb;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.CheckIn;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DefaultScopesStorage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DefaultSpanFactory;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ExternalOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Hint;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.HubScopesWrapper;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.IHub;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.IOptionsObserver;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.IReplayApi;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.IScope;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.IScopes;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.IScopesStorage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISentryClient;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISentryExecutorService;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISentryLifecycleToken;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISpan;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ITransaction;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Integration;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JavaMemoryCollector;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.NoOpLogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.NoOpScopes;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.NoOpScopesLifecycleToken;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.NoOpScopesStorage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.OptionsContainer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.PreviousSessionFinalizer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SamplingContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Scope;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ScopeCallback;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ScopeType;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Scopes;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ScopesAdapter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ScopesStorageFactory;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryAppStartProfilingOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryClient;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryExecutorService;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOpenTelemetryMode;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryTraceHeader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SystemOutLogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TracesSamplingDecision;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TransactionContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TransactionOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.UserFeedback;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.backpressure.BackpressureMonitor;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.backpressure.NoOpBackpressureMonitor;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.cache.EnvelopeCache;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.cache.IEnvelopeCache;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.cache.PersistingScopeObserver;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.config.PropertiesProviderFactory;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.internal.debugmeta.NoOpDebugMetaLoader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.internal.debugmeta.ResourcesDebugMetaLoader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.internal.modules.CompositeModulesLoader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.internal.modules.IModulesLoader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.internal.modules.ManifestModulesLoader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.internal.modules.NoOpModulesLoader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.internal.modules.ResourcesModulesLoader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.logger.ILoggerApi;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.opentelemetry.OpenTelemetryUtil;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Feedback;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.User;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.transport.NoOpEnvelopeCache;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.AutoClosableReentrantLock;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.DebugMetaPropertiesApplier;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.FileUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.InitUtil;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.LoadClass;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Platform;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.SentryRandom;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.thread.IThreadChecker;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.thread.NoOpThreadChecker;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.thread.ThreadChecker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Sentry {
    @NotNull
    private static volatile IScopesStorage scopesStorage = NoOpScopesStorage.getInstance();
    @NotNull
    private static volatile IScopes rootScopes = NoOpScopes.getInstance();
    @NotNull
    private static final IScope globalScope = new Scope(SentryOptions.empty());
    private static final boolean GLOBAL_HUB_DEFAULT_MODE = false;
    private static volatile boolean globalHubMode = false;
    @ApiStatus.Internal
    @NotNull
    public static final String APP_START_PROFILING_CONFIG_FILE_NAME = "app_start_profiling_config";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final long classCreationTimestamp = System.currentTimeMillis();
    private static final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    private Sentry() {
    }

    @Deprecated
    @ApiStatus.Internal
    @NotNull
    public static IHub getCurrentHub() {
        return new HubScopesWrapper(Sentry.getCurrentScopes());
    }

    @ApiStatus.Internal
    @NotNull
    public static IScopes getCurrentScopes() {
        if (globalHubMode) {
            return rootScopes;
        }
        @Nullable IScopes scopes = Sentry.getScopesStorage().get();
        if (scopes == null || scopes.isNoOp()) {
            scopes = rootScopes.forkedScopes("getCurrentScopes");
            Sentry.getScopesStorage().set(scopes);
        }
        return scopes;
    }

    @NotNull
    private static IScopesStorage getScopesStorage() {
        return scopesStorage;
    }

    @ApiStatus.Internal
    @NotNull
    public static IScopes forkedRootScopes(@NotNull String creator) {
        if (globalHubMode) {
            return rootScopes;
        }
        return rootScopes.forkedScopes(creator);
    }

    @NotNull
    public static IScopes forkedScopes(@NotNull String creator) {
        return Sentry.getCurrentScopes().forkedScopes(creator);
    }

    @NotNull
    public static IScopes forkedCurrentScope(@NotNull String creator) {
        return Sentry.getCurrentScopes().forkedCurrentScope(creator);
    }

    @Deprecated
    @ApiStatus.Internal
    @NotNull
    public static ISentryLifecycleToken setCurrentHub(@NotNull IHub hub) {
        return Sentry.setCurrentScopes(hub);
    }

    @ApiStatus.Internal
    @NotNull
    public static ISentryLifecycleToken setCurrentScopes(@NotNull IScopes scopes) {
        return Sentry.getScopesStorage().set(scopes);
    }

    @NotNull
    public static IScope getGlobalScope() {
        return globalScope;
    }

    public static boolean isEnabled() {
        return Sentry.getCurrentScopes().isEnabled();
    }

    public static void init() {
        Sentry.init((SentryOptions options2) -> options2.setEnableExternalConfiguration(true), false);
    }

    public static void init(@NotNull String dsn) {
        Sentry.init((SentryOptions options2) -> options2.setDsn(dsn));
    }

    public static <T extends SentryOptions> void init(@NotNull OptionsContainer<T> clazz, @NotNull OptionsConfiguration<T> optionsConfiguration) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Sentry.init(clazz, optionsConfiguration, false);
    }

    public static <T extends SentryOptions> void init(@NotNull OptionsContainer<T> clazz, @NotNull OptionsConfiguration<T> optionsConfiguration, boolean globalHubMode) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        SentryOptions options2 = (SentryOptions)clazz.createInstance();
        Sentry.applyOptionsConfiguration(optionsConfiguration, options2);
        Sentry.init(options2, globalHubMode);
    }

    public static void init(@NotNull OptionsConfiguration<SentryOptions> optionsConfiguration) {
        Sentry.init(optionsConfiguration, false);
    }

    public static void init(@NotNull OptionsConfiguration<SentryOptions> optionsConfiguration, boolean globalHubMode) {
        SentryOptions options2 = new SentryOptions();
        Sentry.applyOptionsConfiguration(optionsConfiguration, options2);
        Sentry.init(options2, globalHubMode);
    }

    private static <T extends SentryOptions> void applyOptionsConfiguration(OptionsConfiguration<T> optionsConfiguration, T options2) {
        try {
            optionsConfiguration.configure(options2);
        }
        catch (Throwable t) {
            options2.getLogger().log(SentryLevel.ERROR, "Error in the 'OptionsConfiguration.configure' callback.", t);
        }
    }

    @ApiStatus.Internal
    public static void init(@NotNull SentryOptions options2) {
        Sentry.init(options2, false);
    }

    private static void init(@NotNull SentryOptions options2, boolean globalHubMode) {
        block15: {
            try (@NotNull ISentryLifecycleToken ignored = lock.acquire();){
                if (!options2.getClass().getName().equals("io.github.quiltservertools.blockbotdiscord.libs.io.sentry.android.core.SentryAndroidOptions") && Platform.isAndroid()) {
                    throw new IllegalArgumentException("You are running Android. Please, use SentryAndroid.init. " + options2.getClass().getName());
                }
                if (!Sentry.preInitConfigurations(options2)) {
                    return;
                }
                @Nullable Boolean globalHubModeFromOptions = options2.isGlobalHubMode();
                boolean globalHubModeToUse = globalHubModeFromOptions != null ? globalHubModeFromOptions : globalHubMode;
                options2.getLogger().log(SentryLevel.INFO, "GlobalHubMode: '%s'", String.valueOf(globalHubModeToUse));
                Sentry.globalHubMode = globalHubModeToUse;
                Sentry.initFatalLogger(options2);
                boolean shouldInit = InitUtil.shouldInit(globalScope.getOptions(), options2, Sentry.isEnabled());
                if (shouldInit) {
                    if (Sentry.isEnabled()) {
                        options2.getLogger().log(SentryLevel.WARNING, "Sentry has been already initialized. Previous configuration will be overwritten.", new Object[0]);
                    }
                    try {
                        options2.getExecutorService().submit(() -> options2.loadLazyFields());
                    }
                    catch (RejectedExecutionException e) {
                        options2.getLogger().log(SentryLevel.DEBUG, "Failed to call the executor. Lazy fields will not be loaded. Did you call Sentry.close()?", e);
                    }
                    IScopes scopes = Sentry.getCurrentScopes();
                    scopes.close(true);
                    globalScope.replaceOptions(options2);
                    Scope rootScope = new Scope(options2);
                    Scope rootIsolationScope = new Scope(options2);
                    rootScopes = new Scopes(rootScope, rootIsolationScope, globalScope, "Sentry.init");
                    Sentry.initLogger(options2);
                    Sentry.initForOpenTelemetryMaybe(options2);
                    Sentry.getScopesStorage().set(rootScopes);
                    Sentry.initConfigurations(options2);
                    globalScope.bindClient(new SentryClient(options2));
                    if (options2.getExecutorService().isClosed()) {
                        options2.setExecutorService(new SentryExecutorService());
                    }
                    for (Integration integration : options2.getIntegrations()) {
                        integration.register(ScopesAdapter.getInstance(), options2);
                    }
                    Sentry.notifyOptionsObservers(options2);
                    Sentry.finalizePreviousSession(options2, ScopesAdapter.getInstance());
                    Sentry.handleAppStartProfilingConfig(options2, options2.getExecutorService());
                    options2.getLogger().log(SentryLevel.DEBUG, "Using openTelemetryMode %s", new Object[]{options2.getOpenTelemetryMode()});
                    options2.getLogger().log(SentryLevel.DEBUG, "Using span factory %s", options2.getSpanFactory().getClass().getName());
                    options2.getLogger().log(SentryLevel.DEBUG, "Using scopes storage %s", scopesStorage.getClass().getName());
                    break block15;
                }
                options2.getLogger().log(SentryLevel.WARNING, "This init call has been ignored due to priority being too low.", new Object[0]);
            }
        }
    }

    private static void initForOpenTelemetryMaybe(SentryOptions options2) {
        OpenTelemetryUtil.updateOpenTelemetryModeIfAuto(options2, new LoadClass());
        if (SentryOpenTelemetryMode.OFF == options2.getOpenTelemetryMode()) {
            options2.setSpanFactory(new DefaultSpanFactory());
        }
        Sentry.initScopesStorage(options2);
        OpenTelemetryUtil.applyIgnoredSpanOrigins(options2);
    }

    private static void initLogger(@NotNull SentryOptions options2) {
        if (options2.isDebug() && options2.getLogger() instanceof NoOpLogger) {
            options2.setLogger(new SystemOutLogger());
        }
    }

    private static void initFatalLogger(@NotNull SentryOptions options2) {
        if (options2.getFatalLogger() instanceof NoOpLogger) {
            options2.setFatalLogger(new SystemOutLogger());
        }
    }

    private static void initScopesStorage(SentryOptions options2) {
        Sentry.getScopesStorage().close();
        scopesStorage = SentryOpenTelemetryMode.OFF == options2.getOpenTelemetryMode() ? new DefaultScopesStorage() : ScopesStorageFactory.create(new LoadClass(), NoOpLogger.getInstance());
    }

    private static void handleAppStartProfilingConfig(@NotNull SentryOptions options2, @NotNull ISentryExecutorService sentryExecutorService) {
        try {
            sentryExecutorService.submit(() -> {
                block15: {
                    String cacheDirPath = options2.getCacheDirPathWithoutDsn();
                    if (cacheDirPath != null) {
                        @NotNull File appStartProfilingConfigFile = new File(cacheDirPath, APP_START_PROFILING_CONFIG_FILE_NAME);
                        try {
                            FileUtils.deleteRecursively(appStartProfilingConfigFile);
                            if (!options2.isEnableAppStartProfiling() && !options2.isStartProfilerOnAppStart()) {
                                return;
                            }
                            if (!options2.isStartProfilerOnAppStart() && !options2.isTracingEnabled()) {
                                options2.getLogger().log(SentryLevel.INFO, "Tracing is disabled and app start profiling will not start.", new Object[0]);
                                return;
                            }
                            if (!appStartProfilingConfigFile.createNewFile()) break block15;
                            @NotNull TracesSamplingDecision appStartSamplingDecision = options2.isEnableAppStartProfiling() ? Sentry.sampleAppStartProfiling(options2) : new TracesSamplingDecision(false);
                            @NotNull SentryAppStartProfilingOptions appStartProfilingOptions = new SentryAppStartProfilingOptions(options2, appStartSamplingDecision);
                            try (FileOutputStream outputStream2 = new FileOutputStream(appStartProfilingConfigFile);
                                 BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream2, UTF_8));){
                                options2.getSerializer().serialize(appStartProfilingOptions, writer2);
                            }
                        }
                        catch (Throwable e) {
                            options2.getLogger().log(SentryLevel.ERROR, "Unable to create app start profiling config file. ", e);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            options2.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. App start profiling config will not be changed. Did you call Sentry.close()?", e);
        }
    }

    @NotNull
    private static TracesSamplingDecision sampleAppStartProfiling(@NotNull SentryOptions options2) {
        TransactionContext appStartTransactionContext = new TransactionContext("app.launch", "profile");
        appStartTransactionContext.setForNextAppStart(true);
        SamplingContext appStartSamplingContext = new SamplingContext(appStartTransactionContext, null, SentryRandom.current().nextDouble(), null);
        return options2.getInternalTracesSampler().sample(appStartSamplingContext);
    }

    private static void finalizePreviousSession(@NotNull SentryOptions options2, @NotNull IScopes scopes) {
        try {
            options2.getExecutorService().submit(new PreviousSessionFinalizer(options2, scopes));
        }
        catch (Throwable e) {
            options2.getLogger().log(SentryLevel.DEBUG, "Failed to finalize previous session.", e);
        }
    }

    private static void notifyOptionsObservers(@NotNull SentryOptions options2) {
        try {
            options2.getExecutorService().submit(() -> {
                for (IOptionsObserver observer : options2.getOptionsObservers()) {
                    observer.setRelease(options2.getRelease());
                    observer.setProguardUuid(options2.getProguardUuid());
                    observer.setSdkVersion(options2.getSdkVersion());
                    observer.setDist(options2.getDist());
                    observer.setEnvironment(options2.getEnvironment());
                    observer.setTags(options2.getTags());
                    observer.setReplayErrorSampleRate(options2.getSessionReplay().getOnErrorSampleRate());
                }
                @Nullable PersistingScopeObserver scopeCache = options2.findPersistingScopeObserver();
                if (scopeCache != null) {
                    scopeCache.resetCache();
                }
            });
        }
        catch (Throwable e) {
            options2.getLogger().log(SentryLevel.DEBUG, "Failed to notify options observers.", e);
        }
    }

    private static boolean preInitConfigurations(@NotNull SentryOptions options2) {
        if (options2.isEnableExternalConfiguration()) {
            options2.merge(ExternalOptions.from(PropertiesProviderFactory.create(), options2.getLogger()));
        }
        String dsn = options2.getDsn();
        if (!options2.isEnabled() || dsn != null && dsn.isEmpty()) {
            Sentry.close();
            return false;
        }
        if (dsn == null) {
            throw new IllegalArgumentException("DSN is required. Use empty string or set enabled to false in SentryOptions to disable SDK.");
        }
        options2.retrieveParsedDsn();
        return true;
    }

    private static void initConfigurations(@NotNull SentryOptions options2) {
        @NotNull ILogger logger = options2.getLogger();
        logger.log(SentryLevel.INFO, "Initializing SDK with DSN: '%s'", options2.getDsn());
        String outboxPath = options2.getOutboxPath();
        if (outboxPath != null) {
            File outboxDir = new File(outboxPath);
            outboxDir.mkdirs();
        } else {
            logger.log(SentryLevel.INFO, "No outbox dir path is defined in options.", new Object[0]);
        }
        String cacheDirPath = options2.getCacheDirPath();
        if (cacheDirPath != null) {
            File cacheDir = new File(cacheDirPath);
            cacheDir.mkdirs();
            IEnvelopeCache envelopeCache = options2.getEnvelopeDiskCache();
            if (envelopeCache instanceof NoOpEnvelopeCache) {
                options2.setEnvelopeDiskCache(EnvelopeCache.create(options2));
            }
        }
        String profilingTracesDirPath = options2.getProfilingTracesDirPath();
        if ((options2.isProfilingEnabled() || options2.isContinuousProfilingEnabled()) && profilingTracesDirPath != null) {
            File profilingTracesDir = new File(profilingTracesDirPath);
            profilingTracesDir.mkdirs();
            try {
                options2.getExecutorService().submit(() -> {
                    File @NotNull [] oldTracesDirContent = profilingTracesDir.listFiles();
                    if (oldTracesDirContent == null) {
                        return;
                    }
                    for (File f : oldTracesDirContent) {
                        if (f.lastModified() >= classCreationTimestamp - TimeUnit.MINUTES.toMillis(5L)) continue;
                        FileUtils.deleteRecursively(f);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                options2.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. Old profiles will not be deleted. Did you call Sentry.close()?", e);
            }
        }
        @NotNull IModulesLoader modulesLoader = options2.getModulesLoader();
        if (!options2.isSendModules()) {
            options2.setModulesLoader(NoOpModulesLoader.getInstance());
        } else if (modulesLoader instanceof NoOpModulesLoader) {
            options2.setModulesLoader(new CompositeModulesLoader(Arrays.asList(new ManifestModulesLoader(options2.getLogger()), new ResourcesModulesLoader(options2.getLogger())), options2.getLogger()));
        }
        if (options2.getDebugMetaLoader() instanceof NoOpDebugMetaLoader) {
            options2.setDebugMetaLoader(new ResourcesDebugMetaLoader(options2.getLogger()));
        }
        @Nullable List<Properties> propertiesList = options2.getDebugMetaLoader().loadDebugMeta();
        DebugMetaPropertiesApplier.applyToOptions(options2, propertiesList);
        IThreadChecker threadChecker = options2.getThreadChecker();
        if (threadChecker instanceof NoOpThreadChecker) {
            options2.setThreadChecker(ThreadChecker.getInstance());
        }
        if (options2.getPerformanceCollectors().isEmpty()) {
            options2.addPerformanceCollector(new JavaMemoryCollector());
        }
        if (options2.isEnableBackpressureHandling() && Platform.isJvm()) {
            if (options2.getBackpressureMonitor() instanceof NoOpBackpressureMonitor) {
                options2.setBackpressureMonitor(new BackpressureMonitor(options2, ScopesAdapter.getInstance()));
            }
            options2.getBackpressureMonitor().start();
        }
    }

    public static void close() {
        try (@NotNull ISentryLifecycleToken ignored = lock.acquire();){
            IScopes scopes = Sentry.getCurrentScopes();
            rootScopes = NoOpScopes.getInstance();
            Sentry.getScopesStorage().close();
            scopes.close(false);
        }
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event2) {
        return Sentry.getCurrentScopes().captureEvent(event2);
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event2, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentScopes().captureEvent(event2, callback);
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event2, @Nullable Hint hint) {
        return Sentry.getCurrentScopes().captureEvent(event2, hint);
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event2, @Nullable Hint hint, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentScopes().captureEvent(event2, hint, callback);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message2) {
        return Sentry.getCurrentScopes().captureMessage(message2);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message2, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentScopes().captureMessage(message2, callback);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message2, @NotNull SentryLevel level) {
        return Sentry.getCurrentScopes().captureMessage(message2, level);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message2, @NotNull SentryLevel level, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentScopes().captureMessage(message2, level, callback);
    }

    @NotNull
    public static SentryId captureFeedback(@NotNull Feedback feedback) {
        return Sentry.getCurrentScopes().captureFeedback(feedback);
    }

    @NotNull
    public static SentryId captureFeedback(@NotNull Feedback feedback, @Nullable Hint hint) {
        return Sentry.getCurrentScopes().captureFeedback(feedback, hint);
    }

    @NotNull
    public static SentryId captureFeedback(@NotNull Feedback feedback, @Nullable Hint hint, @Nullable ScopeCallback callback) {
        return Sentry.getCurrentScopes().captureFeedback(feedback, hint, callback);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable) {
        return Sentry.getCurrentScopes().captureException(throwable);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentScopes().captureException(throwable, callback);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable, @Nullable Hint hint) {
        return Sentry.getCurrentScopes().captureException(throwable, hint);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable, @Nullable Hint hint, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentScopes().captureException(throwable, hint, callback);
    }

    public static void captureUserFeedback(@NotNull UserFeedback userFeedback) {
        Sentry.getCurrentScopes().captureUserFeedback(userFeedback);
    }

    public static void addBreadcrumb(@NotNull Breadcrumb breadcrumb2, @Nullable Hint hint) {
        Sentry.getCurrentScopes().addBreadcrumb(breadcrumb2, hint);
    }

    public static void addBreadcrumb(@NotNull Breadcrumb breadcrumb2) {
        Sentry.getCurrentScopes().addBreadcrumb(breadcrumb2);
    }

    public static void addBreadcrumb(@NotNull String message2) {
        Sentry.getCurrentScopes().addBreadcrumb(message2);
    }

    public static void addBreadcrumb(@NotNull String message2, @NotNull String category) {
        Sentry.getCurrentScopes().addBreadcrumb(message2, category);
    }

    public static void setLevel(@Nullable SentryLevel level) {
        Sentry.getCurrentScopes().setLevel(level);
    }

    public static void setTransaction(@Nullable String transaction) {
        Sentry.getCurrentScopes().setTransaction(transaction);
    }

    public static void setUser(@Nullable User user2) {
        Sentry.getCurrentScopes().setUser(user2);
    }

    public static void setFingerprint(@NotNull List<String> fingerprint) {
        Sentry.getCurrentScopes().setFingerprint(fingerprint);
    }

    public static void clearBreadcrumbs() {
        Sentry.getCurrentScopes().clearBreadcrumbs();
    }

    public static void setTag(@Nullable String key, @Nullable String value2) {
        Sentry.getCurrentScopes().setTag(key, value2);
    }

    public static void removeTag(@Nullable String key) {
        Sentry.getCurrentScopes().removeTag(key);
    }

    public static void setExtra(@Nullable String key, @Nullable String value2) {
        Sentry.getCurrentScopes().setExtra(key, value2);
    }

    public static void removeExtra(@Nullable String key) {
        Sentry.getCurrentScopes().removeExtra(key);
    }

    @NotNull
    public static SentryId getLastEventId() {
        return Sentry.getCurrentScopes().getLastEventId();
    }

    @NotNull
    public static ISentryLifecycleToken pushScope() {
        if (!globalHubMode) {
            return Sentry.getCurrentScopes().pushScope();
        }
        return NoOpScopesLifecycleToken.getInstance();
    }

    @NotNull
    public static ISentryLifecycleToken pushIsolationScope() {
        if (!globalHubMode) {
            return Sentry.getCurrentScopes().pushIsolationScope();
        }
        return NoOpScopesLifecycleToken.getInstance();
    }

    @Deprecated
    public static void popScope() {
        if (!globalHubMode) {
            Sentry.getCurrentScopes().popScope();
        }
    }

    public static void withScope(@NotNull ScopeCallback callback) {
        Sentry.getCurrentScopes().withScope(callback);
    }

    public static void withIsolationScope(@NotNull ScopeCallback callback) {
        Sentry.getCurrentScopes().withIsolationScope(callback);
    }

    public static void configureScope(@NotNull ScopeCallback callback) {
        Sentry.configureScope(null, callback);
    }

    public static void configureScope(@Nullable ScopeType scopeType, @NotNull ScopeCallback callback) {
        Sentry.getCurrentScopes().configureScope(scopeType, callback);
    }

    public static void bindClient(@NotNull ISentryClient client) {
        Sentry.getCurrentScopes().bindClient(client);
    }

    public static boolean isHealthy() {
        return Sentry.getCurrentScopes().isHealthy();
    }

    public static void flush(long timeoutMillis) {
        Sentry.getCurrentScopes().flush(timeoutMillis);
    }

    public static void startSession() {
        Sentry.getCurrentScopes().startSession();
    }

    public static void endSession() {
        Sentry.getCurrentScopes().endSession();
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name2, @NotNull String operation) {
        return Sentry.getCurrentScopes().startTransaction(name2, operation);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name2, @NotNull String operation, @NotNull TransactionOptions transactionOptions) {
        return Sentry.getCurrentScopes().startTransaction(name2, operation, transactionOptions);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name2, @NotNull String operation, @Nullable String description2, @NotNull TransactionOptions transactionOptions) {
        ITransaction transaction = Sentry.getCurrentScopes().startTransaction(name2, operation, transactionOptions);
        transaction.setDescription(description2);
        return transaction;
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull TransactionContext transactionContexts) {
        return Sentry.getCurrentScopes().startTransaction(transactionContexts);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull TransactionContext transactionContext, @NotNull TransactionOptions transactionOptions) {
        return Sentry.getCurrentScopes().startTransaction(transactionContext, transactionOptions);
    }

    @ApiStatus.Experimental
    public static void startProfiler() {
        Sentry.getCurrentScopes().startProfiler();
    }

    @ApiStatus.Experimental
    public static void stopProfiler() {
        Sentry.getCurrentScopes().stopProfiler();
    }

    @Nullable
    public static ISpan getSpan() {
        if (globalHubMode && Platform.isAndroid()) {
            return Sentry.getCurrentScopes().getTransaction();
        }
        return Sentry.getCurrentScopes().getSpan();
    }

    @Nullable
    public static Boolean isCrashedLastRun() {
        return Sentry.getCurrentScopes().isCrashedLastRun();
    }

    public static void reportFullyDisplayed() {
        Sentry.getCurrentScopes().reportFullyDisplayed();
    }

    @Nullable
    public static TransactionContext continueTrace(@Nullable String sentryTrace, @Nullable List<String> baggageHeaders) {
        return Sentry.getCurrentScopes().continueTrace(sentryTrace, baggageHeaders);
    }

    @Nullable
    public static SentryTraceHeader getTraceparent() {
        return Sentry.getCurrentScopes().getTraceparent();
    }

    @Nullable
    public static BaggageHeader getBaggage() {
        return Sentry.getCurrentScopes().getBaggage();
    }

    @ApiStatus.Experimental
    @NotNull
    public static SentryId captureCheckIn(@NotNull CheckIn checkIn) {
        return Sentry.getCurrentScopes().captureCheckIn(checkIn);
    }

    @ApiStatus.Experimental
    @NotNull
    public static ILoggerApi logger() {
        return Sentry.getCurrentScopes().logger();
    }

    @NotNull
    public static IReplayApi replay() {
        return Sentry.getCurrentScopes().getScope().getOptions().getReplayController();
    }

    public static interface OptionsConfiguration<T extends SentryOptions> {
        public void configure(@NotNull T var1);
    }
}

