/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ProfileLifecycle;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TracesSamplingDecision;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.SentryRandom;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class SentryAppStartProfilingOptions
implements JsonUnknown,
JsonSerializable {
    boolean profileSampled;
    @Nullable
    Double profileSampleRate;
    boolean traceSampled;
    @Nullable
    Double traceSampleRate;
    @Nullable
    String profilingTracesDirPath;
    boolean isProfilingEnabled;
    boolean isContinuousProfilingEnabled;
    int profilingTracesHz;
    boolean continuousProfileSampled;
    boolean isEnableAppStartProfiling;
    boolean isStartProfilerOnAppStart;
    @NotNull
    ProfileLifecycle profileLifecycle;
    @Nullable
    private Map<String, Object> unknown;

    @VisibleForTesting
    public SentryAppStartProfilingOptions() {
        this.traceSampled = false;
        this.traceSampleRate = null;
        this.profileSampled = false;
        this.profileSampleRate = null;
        this.continuousProfileSampled = false;
        this.profilingTracesDirPath = null;
        this.isProfilingEnabled = false;
        this.isContinuousProfilingEnabled = false;
        this.profileLifecycle = ProfileLifecycle.MANUAL;
        this.profilingTracesHz = 0;
        this.isEnableAppStartProfiling = true;
        this.isStartProfilerOnAppStart = false;
    }

    SentryAppStartProfilingOptions(@NotNull SentryOptions options2, @NotNull TracesSamplingDecision samplingDecision) {
        this.traceSampled = samplingDecision.getSampled();
        this.traceSampleRate = samplingDecision.getSampleRate();
        this.profileSampled = samplingDecision.getProfileSampled();
        this.profileSampleRate = samplingDecision.getProfileSampleRate();
        this.continuousProfileSampled = options2.getInternalTracesSampler().sampleSessionProfile(SentryRandom.current().nextDouble());
        this.profilingTracesDirPath = options2.getProfilingTracesDirPath();
        this.isProfilingEnabled = options2.isProfilingEnabled();
        this.isContinuousProfilingEnabled = options2.isContinuousProfilingEnabled();
        this.profileLifecycle = options2.getProfileLifecycle();
        this.profilingTracesHz = options2.getProfilingTracesHz();
        this.isEnableAppStartProfiling = options2.isEnableAppStartProfiling();
        this.isStartProfilerOnAppStart = options2.isStartProfilerOnAppStart();
    }

    public void setProfileSampled(boolean profileSampled) {
        this.profileSampled = profileSampled;
    }

    public boolean isProfileSampled() {
        return this.profileSampled;
    }

    public void setContinuousProfileSampled(boolean continuousProfileSampled) {
        this.continuousProfileSampled = continuousProfileSampled;
    }

    public boolean isContinuousProfileSampled() {
        return this.continuousProfileSampled;
    }

    public void setProfileLifecycle(@NotNull ProfileLifecycle profileLifecycle) {
        this.profileLifecycle = profileLifecycle;
    }

    @NotNull
    public ProfileLifecycle getProfileLifecycle() {
        return this.profileLifecycle;
    }

    public void setProfileSampleRate(@Nullable Double profileSampleRate) {
        this.profileSampleRate = profileSampleRate;
    }

    @Nullable
    public Double getProfileSampleRate() {
        return this.profileSampleRate;
    }

    public void setTraceSampled(boolean traceSampled) {
        this.traceSampled = traceSampled;
    }

    public boolean isTraceSampled() {
        return this.traceSampled;
    }

    public void setTraceSampleRate(@Nullable Double traceSampleRate) {
        this.traceSampleRate = traceSampleRate;
    }

    @Nullable
    public Double getTraceSampleRate() {
        return this.traceSampleRate;
    }

    public void setProfilingTracesDirPath(@Nullable String profilingTracesDirPath) {
        this.profilingTracesDirPath = profilingTracesDirPath;
    }

    @Nullable
    public String getProfilingTracesDirPath() {
        return this.profilingTracesDirPath;
    }

    public void setProfilingEnabled(boolean profilingEnabled) {
        this.isProfilingEnabled = profilingEnabled;
    }

    public boolean isProfilingEnabled() {
        return this.isProfilingEnabled;
    }

    public void setContinuousProfilingEnabled(boolean continuousProfilingEnabled) {
        this.isContinuousProfilingEnabled = continuousProfilingEnabled;
    }

    public boolean isContinuousProfilingEnabled() {
        return this.isContinuousProfilingEnabled;
    }

    public void setProfilingTracesHz(int profilingTracesHz) {
        this.profilingTracesHz = profilingTracesHz;
    }

    public int getProfilingTracesHz() {
        return this.profilingTracesHz;
    }

    public void setEnableAppStartProfiling(boolean enableAppStartProfiling) {
        this.isEnableAppStartProfiling = enableAppStartProfiling;
    }

    public boolean isEnableAppStartProfiling() {
        return this.isEnableAppStartProfiling;
    }

    public void setStartProfilerOnAppStart(boolean startProfilerOnAppStart) {
        this.isStartProfilerOnAppStart = startProfilerOnAppStart;
    }

    public boolean isStartProfilerOnAppStart() {
        return this.isStartProfilerOnAppStart;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("profile_sampled").value(logger, this.profileSampled);
        writer2.name("profile_sample_rate").value(logger, this.profileSampleRate);
        writer2.name("continuous_profile_sampled").value(logger, this.continuousProfileSampled);
        writer2.name("trace_sampled").value(logger, this.traceSampled);
        writer2.name("trace_sample_rate").value(logger, this.traceSampleRate);
        writer2.name("profiling_traces_dir_path").value(logger, this.profilingTracesDirPath);
        writer2.name("is_profiling_enabled").value(logger, this.isProfilingEnabled);
        writer2.name("is_continuous_profiling_enabled").value(logger, this.isContinuousProfilingEnabled);
        writer2.name("profile_lifecycle").value(logger, this.profileLifecycle.name());
        writer2.name("profiling_traces_hz").value(logger, this.profilingTracesHz);
        writer2.name("is_enable_app_start_profiling").value(logger, this.isEnableAppStartProfiling);
        writer2.name("is_start_profiler_on_app_start").value(logger, this.isStartProfilerOnAppStart);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String PROFILE_SAMPLED = "profile_sampled";
        public static final String PROFILE_SAMPLE_RATE = "profile_sample_rate";
        public static final String CONTINUOUS_PROFILE_SAMPLED = "continuous_profile_sampled";
        public static final String TRACE_SAMPLED = "trace_sampled";
        public static final String TRACE_SAMPLE_RATE = "trace_sample_rate";
        public static final String PROFILING_TRACES_DIR_PATH = "profiling_traces_dir_path";
        public static final String IS_PROFILING_ENABLED = "is_profiling_enabled";
        public static final String IS_CONTINUOUS_PROFILING_ENABLED = "is_continuous_profiling_enabled";
        public static final String PROFILE_LIFECYCLE = "profile_lifecycle";
        public static final String PROFILING_TRACES_HZ = "profiling_traces_hz";
        public static final String IS_ENABLE_APP_START_PROFILING = "is_enable_app_start_profiling";
        public static final String IS_START_PROFILER_ON_APP_START = "is_start_profiler_on_app_start";
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryAppStartProfilingOptions> {
        @Override
        @NotNull
        public SentryAppStartProfilingOptions deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            SentryAppStartProfilingOptions options2 = new SentryAppStartProfilingOptions();
            ConcurrentHashMap<String, Object> unknown = null;
            block30: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "profile_sampled": {
                        @Nullable Boolean profileSampled = reader2.nextBooleanOrNull();
                        if (profileSampled == null) continue block30;
                        options2.profileSampled = profileSampled;
                        continue block30;
                    }
                    case "profile_sample_rate": {
                        @Nullable Double profileSampleRate = reader2.nextDoubleOrNull();
                        if (profileSampleRate == null) continue block30;
                        options2.profileSampleRate = profileSampleRate;
                        continue block30;
                    }
                    case "continuous_profile_sampled": {
                        @Nullable Boolean continuousProfileSampled = reader2.nextBooleanOrNull();
                        if (continuousProfileSampled == null) continue block30;
                        options2.continuousProfileSampled = continuousProfileSampled;
                        continue block30;
                    }
                    case "trace_sampled": {
                        @Nullable Boolean traceSampled = reader2.nextBooleanOrNull();
                        if (traceSampled == null) continue block30;
                        options2.traceSampled = traceSampled;
                        continue block30;
                    }
                    case "trace_sample_rate": {
                        @Nullable Double traceSampleRate = reader2.nextDoubleOrNull();
                        if (traceSampleRate == null) continue block30;
                        options2.traceSampleRate = traceSampleRate;
                        continue block30;
                    }
                    case "profiling_traces_dir_path": {
                        @Nullable String profilingTracesDirPath = reader2.nextStringOrNull();
                        if (profilingTracesDirPath == null) continue block30;
                        options2.profilingTracesDirPath = profilingTracesDirPath;
                        continue block30;
                    }
                    case "is_profiling_enabled": {
                        @Nullable Boolean isProfilingEnabled = reader2.nextBooleanOrNull();
                        if (isProfilingEnabled == null) continue block30;
                        options2.isProfilingEnabled = isProfilingEnabled;
                        continue block30;
                    }
                    case "is_continuous_profiling_enabled": {
                        @Nullable Boolean isContinuousProfilingEnabled = reader2.nextBooleanOrNull();
                        if (isContinuousProfilingEnabled == null) continue block30;
                        options2.isContinuousProfilingEnabled = isContinuousProfilingEnabled;
                        continue block30;
                    }
                    case "profile_lifecycle": {
                        @Nullable String profileLifecycle = reader2.nextStringOrNull();
                        if (profileLifecycle == null) continue block30;
                        try {
                            options2.profileLifecycle = ProfileLifecycle.valueOf(profileLifecycle);
                        }
                        catch (IllegalArgumentException e) {
                            logger.log(SentryLevel.ERROR, "Error when deserializing ProfileLifecycle: " + profileLifecycle, new Object[0]);
                        }
                        continue block30;
                    }
                    case "profiling_traces_hz": {
                        @Nullable Integer profilingTracesHz = reader2.nextIntegerOrNull();
                        if (profilingTracesHz == null) continue block30;
                        options2.profilingTracesHz = profilingTracesHz;
                        continue block30;
                    }
                    case "is_enable_app_start_profiling": {
                        @Nullable Boolean isEnableAppStartProfiling = reader2.nextBooleanOrNull();
                        if (isEnableAppStartProfiling == null) continue block30;
                        options2.isEnableAppStartProfiling = isEnableAppStartProfiling;
                        continue block30;
                    }
                    case "is_start_profiler_on_app_start": {
                        @Nullable Boolean isStartProfilerOnAppStart = reader2.nextBooleanOrNull();
                        if (isStartProfilerOnAppStart == null) continue block30;
                        options2.isStartProfilerOnAppStart = isStartProfilerOnAppStart;
                        continue block30;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            options2.setUnknown(unknown);
            reader2.endObject();
            return options2;
        }
    }
}

