/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISerializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ProfilingTraceData;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryBaseEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEnvelopeHeader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEnvelopeItem;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Session;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.exception.SentryEnvelopeException;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SdkVersion;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryEnvelope {
    @NotNull
    private final SentryEnvelopeHeader header;
    @NotNull
    private final Iterable<SentryEnvelopeItem> items;

    @NotNull
    public Iterable<SentryEnvelopeItem> getItems() {
        return this.items;
    }

    @NotNull
    public SentryEnvelopeHeader getHeader() {
        return this.header;
    }

    public SentryEnvelope(@NotNull SentryEnvelopeHeader header, @NotNull Iterable<SentryEnvelopeItem> items) {
        this.header = Objects.requireNonNull(header, "SentryEnvelopeHeader is required.");
        this.items = Objects.requireNonNull(items, "SentryEnvelope items are required.");
    }

    public SentryEnvelope(@Nullable SentryId eventId, @Nullable SdkVersion sdkVersion, @NotNull Iterable<SentryEnvelopeItem> items) {
        this.header = new SentryEnvelopeHeader(eventId, sdkVersion);
        this.items = Objects.requireNonNull(items, "SentryEnvelope items are required.");
    }

    public SentryEnvelope(@Nullable SentryId eventId, @Nullable SdkVersion sdkVersion, @NotNull SentryEnvelopeItem item2) {
        Objects.requireNonNull(item2, "SentryEnvelopeItem is required.");
        this.header = new SentryEnvelopeHeader(eventId, sdkVersion);
        ArrayList<SentryEnvelopeItem> items = new ArrayList<SentryEnvelopeItem>(1);
        items.add(item2);
        this.items = items;
    }

    @NotNull
    public static SentryEnvelope from(@NotNull ISerializer serializer2, @NotNull Session session, @Nullable SdkVersion sdkVersion) throws IOException {
        Objects.requireNonNull(serializer2, "Serializer is required.");
        Objects.requireNonNull(session, "session is required.");
        return new SentryEnvelope(null, sdkVersion, SentryEnvelopeItem.fromSession(serializer2, session));
    }

    @NotNull
    public static SentryEnvelope from(@NotNull ISerializer serializer2, @NotNull SentryBaseEvent event2, @Nullable SdkVersion sdkVersion) throws IOException {
        Objects.requireNonNull(serializer2, "Serializer is required.");
        Objects.requireNonNull(event2, "item is required.");
        return new SentryEnvelope(event2.getEventId(), sdkVersion, SentryEnvelopeItem.fromEvent(serializer2, event2));
    }

    @NotNull
    public static SentryEnvelope from(@NotNull ISerializer serializer2, @NotNull ProfilingTraceData profilingTraceData, long maxTraceFileSize, @Nullable SdkVersion sdkVersion) throws SentryEnvelopeException {
        Objects.requireNonNull(serializer2, "Serializer is required.");
        Objects.requireNonNull(profilingTraceData, "Profiling trace data is required.");
        return new SentryEnvelope(new SentryId(profilingTraceData.getProfileId()), sdkVersion, SentryEnvelopeItem.fromProfilingTrace(profilingTraceData, maxTraceFileSize, serializer2));
    }
}

