/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DateUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TraceContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SdkVersion;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryEnvelopeHeader
implements JsonSerializable,
JsonUnknown {
    @Nullable
    private final SentryId eventId;
    @Nullable
    private final SdkVersion sdkVersion;
    @Nullable
    private final TraceContext traceContext;
    @Nullable
    private Date sentAt;
    @Nullable
    private Map<String, Object> unknown;

    public SentryEnvelopeHeader(@Nullable SentryId eventId, @Nullable SdkVersion sdkVersion) {
        this(eventId, sdkVersion, null);
    }

    public SentryEnvelopeHeader(@Nullable SentryId eventId, @Nullable SdkVersion sdkVersion, @Nullable TraceContext traceContext) {
        this.eventId = eventId;
        this.sdkVersion = sdkVersion;
        this.traceContext = traceContext;
    }

    public SentryEnvelopeHeader(@Nullable SentryId eventId) {
        this(eventId, null);
    }

    public SentryEnvelopeHeader() {
        this(new SentryId());
    }

    @Nullable
    public SentryId getEventId() {
        return this.eventId;
    }

    @Nullable
    public SdkVersion getSdkVersion() {
        return this.sdkVersion;
    }

    @Nullable
    public TraceContext getTraceContext() {
        return this.traceContext;
    }

    @Nullable
    public Date getSentAt() {
        return this.sentAt;
    }

    public void setSentAt(@Nullable Date sentAt) {
        this.sentAt = sentAt;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        if (this.eventId != null) {
            writer2.name("event_id").value(logger, this.eventId);
        }
        if (this.sdkVersion != null) {
            writer2.name("sdk").value(logger, this.sdkVersion);
        }
        if (this.traceContext != null) {
            writer2.name("trace").value(logger, this.traceContext);
        }
        if (this.sentAt != null) {
            writer2.name("sent_at").value(logger, DateUtils.getTimestamp(this.sentAt));
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String EVENT_ID = "event_id";
        public static final String SDK = "sdk";
        public static final String TRACE = "trace";
        public static final String SENT_AT = "sent_at";
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryEnvelopeHeader> {
        @Override
        @NotNull
        public SentryEnvelopeHeader deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            SentryId eventId = null;
            SdkVersion sdkVersion = null;
            TraceContext traceContext = null;
            Date sentAt = null;
            HashMap<String, Object> unknown = null;
            block12: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "event_id": {
                        eventId = reader2.nextOrNull(logger, new SentryId.Deserializer());
                        continue block12;
                    }
                    case "sdk": {
                        sdkVersion = reader2.nextOrNull(logger, new SdkVersion.Deserializer());
                        continue block12;
                    }
                    case "trace": {
                        traceContext = reader2.nextOrNull(logger, new TraceContext.Deserializer());
                        continue block12;
                    }
                    case "sent_at": {
                        sentAt = reader2.nextDateOrNull(logger);
                        continue block12;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            SentryEnvelopeHeader sentryEnvelopeHeader = new SentryEnvelopeHeader(eventId, sdkVersion, traceContext);
            sentryEnvelopeHeader.setSentAt(sentAt);
            sentryEnvelopeHeader.setUnknown(unknown);
            reader2.endObject();
            return sentryEnvelopeHeader;
        }
    }
}

