/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Baggage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.BaggageHeader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.CompositePerformanceCollector;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Hint;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.IScopes;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISentryLifecycleToken;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISpan;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ITransaction;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Instrumenter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.MeasurementUnit;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.NoOpScopesLifecycleToken;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.NoOpSpan;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ProfileContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ProfileLifecycle;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ProfilingTraceData;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryDate;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryTraceHeader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Span;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanFinishedCallback;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanStatus;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TraceContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TracesSamplingDecision;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TransactionContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TransactionFinishedCallback;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TransactionOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Contexts;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryTransaction;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.TransactionNameSource;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.AutoClosableReentrantLock;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.CollectionUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.SpanUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.thread.IThreadChecker;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryTracer
implements ITransaction {
    @NotNull
    private final SentryId eventId = new SentryId();
    @NotNull
    private final Span root;
    @NotNull
    private final List<Span> children = new CopyOnWriteArrayList<Span>();
    @NotNull
    private final IScopes scopes;
    @NotNull
    private String name;
    @NotNull
    private FinishStatus finishStatus = FinishStatus.NOT_FINISHED;
    @Nullable
    private volatile TimerTask idleTimeoutTask;
    @Nullable
    private volatile TimerTask deadlineTimeoutTask;
    @Nullable
    private volatile Timer timer = null;
    @NotNull
    private final AutoClosableReentrantLock timerLock = new AutoClosableReentrantLock();
    @NotNull
    private final AutoClosableReentrantLock tracerLock = new AutoClosableReentrantLock();
    @NotNull
    private final AtomicBoolean isIdleFinishTimerRunning = new AtomicBoolean(false);
    @NotNull
    private final AtomicBoolean isDeadlineTimerRunning = new AtomicBoolean(false);
    @NotNull
    private TransactionNameSource transactionNameSource;
    @NotNull
    private final Instrumenter instrumenter;
    @NotNull
    private final Contexts contexts = new Contexts();
    @Nullable
    private final CompositePerformanceCollector compositePerformanceCollector;
    @NotNull
    private final TransactionOptions transactionOptions;

    public SentryTracer(@NotNull TransactionContext context, @NotNull IScopes scopes) {
        this(context, scopes, new TransactionOptions(), null);
    }

    public SentryTracer(@NotNull TransactionContext context, @NotNull IScopes scopes, @NotNull TransactionOptions transactionOptions) {
        this(context, scopes, transactionOptions, null);
    }

    SentryTracer(@NotNull TransactionContext context, @NotNull IScopes scopes, @NotNull TransactionOptions transactionOptions, @Nullable CompositePerformanceCollector compositePerformanceCollector) {
        Objects.requireNonNull(context, "context is required");
        Objects.requireNonNull(scopes, "scopes are required");
        this.root = new Span(context, this, scopes, transactionOptions);
        this.name = context.getName();
        this.instrumenter = context.getInstrumenter();
        this.scopes = scopes;
        this.compositePerformanceCollector = compositePerformanceCollector;
        this.transactionNameSource = context.getTransactionNameSource();
        this.transactionOptions = transactionOptions;
        this.setDefaultSpanData(this.root);
        @NotNull SentryId continuousProfilerId = scopes.getOptions().getContinuousProfiler().getProfilerId();
        if (!continuousProfilerId.equals(SentryId.EMPTY_ID) && Boolean.TRUE.equals(this.isSampled())) {
            this.contexts.setProfile(new ProfileContext(continuousProfilerId));
        }
        if (compositePerformanceCollector != null) {
            compositePerformanceCollector.start(this);
        }
        if (transactionOptions.getIdleTimeout() != null || transactionOptions.getDeadlineTimeout() != null) {
            this.timer = new Timer(true);
            this.scheduleDeadlineTimeout();
            this.scheduleFinish();
        }
    }

    @Override
    public void scheduleFinish() {
        try (@NotNull ISentryLifecycleToken ignored = this.timerLock.acquire();){
            Long idleTimeout;
            if (this.timer != null && (idleTimeout = this.transactionOptions.getIdleTimeout()) != null) {
                this.cancelIdleTimer();
                this.isIdleFinishTimerRunning.set(true);
                this.idleTimeoutTask = new TimerTask(){

                    @Override
                    public void run() {
                        SentryTracer.this.onIdleTimeoutReached();
                    }
                };
                try {
                    this.timer.schedule(this.idleTimeoutTask, idleTimeout);
                }
                catch (Throwable e) {
                    this.scopes.getOptions().getLogger().log(SentryLevel.WARNING, "Failed to schedule finish timer", e);
                    this.onIdleTimeoutReached();
                }
            }
        }
    }

    private void onIdleTimeoutReached() {
        @Nullable SpanStatus status2 = this.getStatus();
        this.finish(status2 != null ? status2 : SpanStatus.OK);
        this.isIdleFinishTimerRunning.set(false);
    }

    private void onDeadlineTimeoutReached() {
        @Nullable SpanStatus status2 = this.getStatus();
        this.forceFinish(status2 != null ? status2 : SpanStatus.DEADLINE_EXCEEDED, this.transactionOptions.getIdleTimeout() != null, null);
        this.isDeadlineTimerRunning.set(false);
    }

    @Override
    @NotNull
    public void forceFinish(@NotNull SpanStatus status2, boolean dropIfNoChildren, @Nullable Hint hint) {
        if (this.isFinished()) {
            return;
        }
        @NotNull SentryDate finishTimestamp = this.scopes.getOptions().getDateProvider().now();
        @NotNull ListIterator<T> iterator2 = CollectionUtils.reverseListIterator((CopyOnWriteArrayList)this.children);
        while (iterator2.hasPrevious()) {
            @NotNull Span span = (Span)iterator2.previous();
            span.setSpanFinishedCallback(null);
            span.finish(status2, finishTimestamp);
        }
        this.finish(status2, finishTimestamp, dropIfNoChildren, hint);
    }

    @Override
    public void finish(@Nullable SpanStatus status2, @Nullable SentryDate finishDate, boolean dropIfNoChildren, @Nullable Hint hint) {
        SentryDate finishTimestamp = this.root.getFinishDate();
        if (finishDate != null) {
            finishTimestamp = finishDate;
        }
        if (finishTimestamp == null) {
            finishTimestamp = this.scopes.getOptions().getDateProvider().now();
        }
        for (Span span2 : this.children) {
            if (!span2.getOptions().isIdle()) continue;
            span2.finish(status2 != null ? status2 : this.getSpanContext().status, finishTimestamp);
        }
        this.finishStatus = FinishStatus.finishing(status2);
        if (!(this.root.isFinished() || this.transactionOptions.isWaitForChildren() && !this.hasAllChildrenFinished())) {
            @NotNull AtomicReference<V> performanceCollectionData = new AtomicReference();
            @Nullable SpanFinishedCallback oldCallback = this.root.getSpanFinishedCallback();
            this.root.setSpanFinishedCallback(span -> {
                TransactionFinishedCallback finishedCallback;
                if (oldCallback != null) {
                    oldCallback.execute(span);
                }
                if ((finishedCallback = this.transactionOptions.getTransactionFinishedCallback()) != null) {
                    finishedCallback.execute(this);
                }
                if (this.compositePerformanceCollector != null) {
                    performanceCollectionData.set(this.compositePerformanceCollector.stop(this));
                }
            });
            this.root.finish(this.finishStatus.spanStatus, finishTimestamp);
            ProfilingTraceData profilingTraceData = null;
            if (Boolean.TRUE.equals(this.isSampled()) && Boolean.TRUE.equals(this.isProfileSampled())) {
                profilingTraceData = this.scopes.getOptions().getTransactionProfiler().onTransactionFinish(this, (List)performanceCollectionData.get(), this.scopes.getOptions());
            }
            if (this.scopes.getOptions().isContinuousProfilingEnabled() && this.scopes.getOptions().getProfileLifecycle() == ProfileLifecycle.TRACE) {
                this.scopes.getOptions().getContinuousProfiler().stopProfiler(ProfileLifecycle.TRACE);
            }
            if (performanceCollectionData.get() != null) {
                ((List)performanceCollectionData.get()).clear();
            }
            this.scopes.configureScope(scope -> scope.withTransaction(transaction -> {
                if (transaction == this) {
                    scope.clearTransaction();
                }
            }));
            SentryTransaction transaction = new SentryTransaction(this);
            if (this.timer != null) {
                try (@NotNull ISentryLifecycleToken ignored = this.timerLock.acquire();){
                    if (this.timer != null) {
                        this.cancelIdleTimer();
                        this.cancelDeadlineTimer();
                        this.timer.cancel();
                        this.timer = null;
                    }
                }
            }
            if (dropIfNoChildren && this.children.isEmpty() && this.transactionOptions.getIdleTimeout() != null) {
                this.scopes.getOptions().getLogger().log(SentryLevel.DEBUG, "Dropping idle transaction %s because it has no child spans", this.name);
                return;
            }
            transaction.getMeasurements().putAll(this.root.getMeasurements());
            this.scopes.captureTransaction(transaction, this.traceContext(), hint, profilingTraceData);
        }
    }

    private void cancelIdleTimer() {
        try (@NotNull ISentryLifecycleToken ignored = this.timerLock.acquire();){
            if (this.idleTimeoutTask != null) {
                this.idleTimeoutTask.cancel();
                this.isIdleFinishTimerRunning.set(false);
                this.idleTimeoutTask = null;
            }
        }
    }

    private void scheduleDeadlineTimeout() {
        @Nullable Long deadlineTimeOut = this.transactionOptions.getDeadlineTimeout();
        if (deadlineTimeOut != null) {
            try (@NotNull ISentryLifecycleToken ignored = this.timerLock.acquire();){
                if (this.timer != null) {
                    this.cancelDeadlineTimer();
                    this.isDeadlineTimerRunning.set(true);
                    this.deadlineTimeoutTask = new TimerTask(){

                        @Override
                        public void run() {
                            SentryTracer.this.onDeadlineTimeoutReached();
                        }
                    };
                    try {
                        this.timer.schedule(this.deadlineTimeoutTask, deadlineTimeOut);
                    }
                    catch (Throwable e) {
                        this.scopes.getOptions().getLogger().log(SentryLevel.WARNING, "Failed to schedule finish timer", e);
                        this.onDeadlineTimeoutReached();
                    }
                }
            }
        }
    }

    private void cancelDeadlineTimer() {
        try (@NotNull ISentryLifecycleToken ignored = this.timerLock.acquire();){
            if (this.deadlineTimeoutTask != null) {
                this.deadlineTimeoutTask.cancel();
                this.isDeadlineTimerRunning.set(false);
                this.deadlineTimeoutTask = null;
            }
        }
    }

    @NotNull
    public List<Span> getChildren() {
        return this.children;
    }

    @Override
    @NotNull
    public SentryDate getStartDate() {
        return this.root.getStartDate();
    }

    @Override
    @Nullable
    public SentryDate getFinishDate() {
        return this.root.getFinishDate();
    }

    @NotNull
    ISpan startChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description2) {
        return this.startChild(parentSpanId, operation, description2, new SpanOptions());
    }

    @NotNull
    ISpan startChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description2, @NotNull SpanOptions spanOptions) {
        return this.createChild(parentSpanId, operation, description2, spanOptions);
    }

    @NotNull
    ISpan startChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description2, @Nullable SentryDate timestamp2, @NotNull Instrumenter instrumenter) {
        @NotNull SpanContext spanContext = this.getSpanContext().copyForChild(operation, parentSpanId, null);
        spanContext.setDescription(description2);
        spanContext.setInstrumenter(instrumenter);
        @NotNull SpanOptions spanOptions = new SpanOptions();
        spanOptions.setStartTimestamp(timestamp2);
        return this.createChild(spanContext, spanOptions);
    }

    @NotNull
    ISpan startChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description2, @Nullable SentryDate timestamp2, @NotNull Instrumenter instrumenter, @NotNull SpanOptions spanOptions) {
        @NotNull SpanContext spanContext = this.getSpanContext().copyForChild(operation, parentSpanId, null);
        spanContext.setDescription(description2);
        spanContext.setInstrumenter(instrumenter);
        spanOptions.setStartTimestamp(timestamp2);
        return this.createChild(spanContext, spanOptions);
    }

    @NotNull
    private ISpan createChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description2, @NotNull SpanOptions options2) {
        @NotNull SpanContext spanContext = this.getSpanContext().copyForChild(operation, parentSpanId, null);
        spanContext.setDescription(description2);
        spanContext.setInstrumenter(Instrumenter.SENTRY);
        return this.createChild(spanContext, options2);
    }

    @NotNull
    private ISpan createChild(@NotNull SpanContext spanContext, @NotNull SpanOptions spanOptions) {
        if (this.root.isFinished()) {
            return NoOpSpan.getInstance();
        }
        if (!this.instrumenter.equals((Object)spanContext.getInstrumenter())) {
            return NoOpSpan.getInstance();
        }
        if (SpanUtils.isIgnored(this.scopes.getOptions().getIgnoredSpanOrigins(), spanOptions.getOrigin())) {
            return NoOpSpan.getInstance();
        }
        @Nullable SpanId parentSpanId = spanContext.getParentSpanId();
        @NotNull String operation = spanContext.getOperation();
        @Nullable String description2 = spanContext.getDescription();
        if (this.children.size() < this.scopes.getOptions().getMaxSpans()) {
            Objects.requireNonNull(parentSpanId, "parentSpanId is required");
            Objects.requireNonNull(operation, "operation is required");
            this.cancelIdleTimer();
            Span span = new Span(this, this.scopes, spanContext, spanOptions, finishingSpan -> {
                if (this.compositePerformanceCollector != null) {
                    this.compositePerformanceCollector.onSpanFinished(finishingSpan);
                }
                FinishStatus finishStatus = this.finishStatus;
                if (this.transactionOptions.getIdleTimeout() != null) {
                    if (!this.transactionOptions.isWaitForChildren() || this.hasAllChildrenFinished()) {
                        this.scheduleFinish();
                    }
                } else if (finishStatus.isFinishing) {
                    this.finish(finishStatus.spanStatus);
                }
            });
            this.setDefaultSpanData(span);
            this.children.add(span);
            if (this.compositePerformanceCollector != null) {
                this.compositePerformanceCollector.onSpanStarted(span);
            }
            return span;
        }
        this.scopes.getOptions().getLogger().log(SentryLevel.WARNING, "Span operation: %s, description: %s dropped due to limit reached. Returning NoOpSpan.", operation, description2);
        return NoOpSpan.getInstance();
    }

    private void setDefaultSpanData(@NotNull ISpan span) {
        @NotNull IThreadChecker threadChecker = this.scopes.getOptions().getThreadChecker();
        @NotNull SentryId profilerId = this.scopes.getOptions().getContinuousProfiler().getProfilerId();
        if (!profilerId.equals(SentryId.EMPTY_ID) && Boolean.TRUE.equals(span.isSampled())) {
            span.setData("profiler_id", profilerId.toString());
        }
        span.setData("thread.id", String.valueOf(threadChecker.currentThreadSystemId()));
        span.setData("thread.name", threadChecker.getCurrentThreadName());
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation) {
        return this.startChild(operation, (String)null);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description2, @Nullable SentryDate timestamp2, @NotNull Instrumenter instrumenter) {
        return this.startChild(operation, description2, timestamp2, instrumenter, new SpanOptions());
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description2, @Nullable SentryDate timestamp2, @NotNull Instrumenter instrumenter, @NotNull SpanOptions spanOptions) {
        return this.createChild(operation, description2, timestamp2, instrumenter, spanOptions);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description2, @Nullable SentryDate timestamp2) {
        return this.createChild(operation, description2, timestamp2, Instrumenter.SENTRY, new SpanOptions());
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description2) {
        return this.startChild(operation, description2, null, Instrumenter.SENTRY, new SpanOptions());
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description2, @NotNull SpanOptions spanOptions) {
        return this.createChild(operation, description2, null, Instrumenter.SENTRY, spanOptions);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull SpanContext spanContext, @NotNull SpanOptions spanOptions) {
        return this.createChild(spanContext, spanOptions);
    }

    @NotNull
    private ISpan createChild(@NotNull String operation, @Nullable String description2, @Nullable SentryDate timestamp2, @NotNull Instrumenter instrumenter, @NotNull SpanOptions spanOptions) {
        if (this.root.isFinished()) {
            return NoOpSpan.getInstance();
        }
        if (!this.instrumenter.equals((Object)instrumenter)) {
            return NoOpSpan.getInstance();
        }
        if (this.children.size() < this.scopes.getOptions().getMaxSpans()) {
            return this.root.startChild(operation, description2, timestamp2, instrumenter, spanOptions);
        }
        this.scopes.getOptions().getLogger().log(SentryLevel.WARNING, "Span operation: %s, description: %s dropped due to limit reached. Returning NoOpSpan.", operation, description2);
        return NoOpSpan.getInstance();
    }

    @Override
    @NotNull
    public SentryTraceHeader toSentryTrace() {
        return this.root.toSentryTrace();
    }

    @Override
    public void finish() {
        this.finish(this.getStatus());
    }

    @Override
    public void finish(@Nullable SpanStatus status2) {
        this.finish(status2, null);
    }

    @Override
    @ApiStatus.Internal
    public void finish(@Nullable SpanStatus status2, @Nullable SentryDate finishDate) {
        this.finish(status2, finishDate, true, null);
    }

    @Override
    @Nullable
    public TraceContext traceContext() {
        Baggage baggage;
        if (this.scopes.getOptions().isTraceSampling() && (baggage = this.getSpanContext().getBaggage()) != null) {
            this.updateBaggageValues(baggage);
            return baggage.toTraceContext();
        }
        return null;
    }

    private void updateBaggageValues(@NotNull Baggage baggage) {
        try (@NotNull ISentryLifecycleToken ignored = this.tracerLock.acquire();){
            if (baggage.isMutable()) {
                AtomicReference replayId = new AtomicReference();
                this.scopes.configureScope(scope -> replayId.set(scope.getReplayId()));
                baggage.setValuesFromTransaction(this.getSpanContext().getTraceId(), (SentryId)replayId.get(), this.scopes.getOptions(), this.getSamplingDecision(), this.getName(), this.getTransactionNameSource());
                baggage.freeze();
            }
        }
    }

    @Override
    @Nullable
    public BaggageHeader toBaggageHeader(@Nullable List<String> thirdPartyBaggageHeaders) {
        Baggage baggage;
        if (this.scopes.getOptions().isTraceSampling() && (baggage = this.getSpanContext().getBaggage()) != null) {
            this.updateBaggageValues(baggage);
            return BaggageHeader.fromBaggageAndOutgoingHeader(baggage, thirdPartyBaggageHeaders);
        }
        return null;
    }

    private boolean hasAllChildrenFinished() {
        @NotNull ListIterator<Span> iterator2 = this.children.listIterator();
        while (iterator2.hasNext()) {
            @NotNull Span span = iterator2.next();
            if (span.isFinished() || span.getFinishDate() != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setOperation(@NotNull String operation) {
        if (this.root.isFinished()) {
            this.scopes.getOptions().getLogger().log(SentryLevel.DEBUG, "The transaction is already finished. Operation %s cannot be set", operation);
            return;
        }
        this.root.setOperation(operation);
    }

    @Override
    @NotNull
    public String getOperation() {
        return this.root.getOperation();
    }

    @Override
    public void setDescription(@Nullable String description2) {
        if (this.root.isFinished()) {
            this.scopes.getOptions().getLogger().log(SentryLevel.DEBUG, "The transaction is already finished. Description %s cannot be set", description2);
            return;
        }
        this.root.setDescription(description2);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.root.getDescription();
    }

    @Override
    public void setStatus(@Nullable SpanStatus status2) {
        if (this.root.isFinished()) {
            this.scopes.getOptions().getLogger().log(SentryLevel.DEBUG, "The transaction is already finished. Status %s cannot be set", status2 == null ? "null" : status2.name());
            return;
        }
        this.root.setStatus(status2);
    }

    @Override
    @Nullable
    public SpanStatus getStatus() {
        return this.root.getStatus();
    }

    @Override
    public void setThrowable(@Nullable Throwable throwable) {
        if (this.root.isFinished()) {
            this.scopes.getOptions().getLogger().log(SentryLevel.DEBUG, "The transaction is already finished. Throwable cannot be set", new Object[0]);
            return;
        }
        this.root.setThrowable(throwable);
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.root.getThrowable();
    }

    @Override
    @NotNull
    public SpanContext getSpanContext() {
        return this.root.getSpanContext();
    }

    @Override
    public void setTag(@Nullable String key, @Nullable String value2) {
        if (this.root.isFinished()) {
            this.scopes.getOptions().getLogger().log(SentryLevel.DEBUG, "The transaction is already finished. Tag %s cannot be set", key);
            return;
        }
        this.root.setTag(key, value2);
    }

    @Override
    @Nullable
    public String getTag(@Nullable String key) {
        return this.root.getTag(key);
    }

    @Override
    public boolean isFinished() {
        return this.root.isFinished();
    }

    @Override
    public void setData(@Nullable String key, @Nullable Object value2) {
        if (this.root.isFinished()) {
            this.scopes.getOptions().getLogger().log(SentryLevel.DEBUG, "The transaction is already finished. Data %s cannot be set", key);
            return;
        }
        this.root.setData(key, value2);
    }

    @Override
    @Nullable
    public Object getData(@Nullable String key) {
        return this.root.getData(key);
    }

    @ApiStatus.Internal
    public void setMeasurementFromChild(@NotNull String name2, @NotNull Number value2) {
        if (!this.root.getMeasurements().containsKey(name2)) {
            this.setMeasurement(name2, value2);
        }
    }

    @ApiStatus.Internal
    public void setMeasurementFromChild(@NotNull String name2, @NotNull Number value2, @NotNull MeasurementUnit unit) {
        if (!this.root.getMeasurements().containsKey(name2)) {
            this.setMeasurement(name2, value2, unit);
        }
    }

    @Override
    public void setMeasurement(@NotNull String name2, @NotNull Number value2) {
        this.root.setMeasurement(name2, value2);
    }

    @Override
    public void setMeasurement(@NotNull String name2, @NotNull Number value2, @NotNull MeasurementUnit unit) {
        this.root.setMeasurement(name2, value2, unit);
    }

    @Nullable
    public Map<String, Object> getData() {
        return this.root.getData();
    }

    @Override
    @Nullable
    public Boolean isSampled() {
        return this.root.isSampled();
    }

    @Override
    @Nullable
    public Boolean isProfileSampled() {
        return this.root.isProfileSampled();
    }

    @Override
    @Nullable
    public TracesSamplingDecision getSamplingDecision() {
        return this.root.getSamplingDecision();
    }

    @Override
    public void setName(@NotNull String name2) {
        this.setName(name2, TransactionNameSource.CUSTOM);
    }

    @Override
    @ApiStatus.Internal
    public void setName(@NotNull String name2, @NotNull TransactionNameSource transactionNameSource) {
        if (this.root.isFinished()) {
            this.scopes.getOptions().getLogger().log(SentryLevel.DEBUG, "The transaction is already finished. Name %s cannot be set", name2);
            return;
        }
        this.name = name2;
        this.transactionNameSource = transactionNameSource;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public TransactionNameSource getTransactionNameSource() {
        return this.transactionNameSource;
    }

    @Override
    @NotNull
    public List<Span> getSpans() {
        return this.children;
    }

    @Override
    @Nullable
    public ISpan getLatestActiveSpan() {
        @NotNull ListIterator<T> iterator2 = CollectionUtils.reverseListIterator((CopyOnWriteArrayList)this.children);
        while (iterator2.hasPrevious()) {
            @NotNull Span span = (Span)iterator2.previous();
            if (span.isFinished()) continue;
            return span;
        }
        return null;
    }

    @Override
    @NotNull
    public SentryId getEventId() {
        return this.eventId;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public ISentryLifecycleToken makeCurrent() {
        this.scopes.configureScope(scope -> scope.setTransaction(this));
        return NoOpScopesLifecycleToken.getInstance();
    }

    @NotNull
    Span getRoot() {
        return this.root;
    }

    @TestOnly
    @Nullable
    TimerTask getIdleTimeoutTask() {
        return this.idleTimeoutTask;
    }

    @TestOnly
    @Nullable
    TimerTask getDeadlineTimeoutTask() {
        return this.deadlineTimeoutTask;
    }

    @TestOnly
    @Nullable
    Timer getTimer() {
        return this.timer;
    }

    @TestOnly
    @NotNull
    AtomicBoolean isFinishTimerRunning() {
        return this.isIdleFinishTimerRunning;
    }

    @TestOnly
    @NotNull
    AtomicBoolean isDeadlineTimerRunning() {
        return this.isDeadlineTimerRunning;
    }

    @Override
    @ApiStatus.Internal
    public void setContext(@Nullable String key, @Nullable Object context) {
        this.contexts.put(key, context);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public Contexts getContexts() {
        return this.contexts;
    }

    @Override
    public boolean updateEndDate(@NotNull SentryDate date) {
        return this.root.updateEndDate(date);
    }

    @Override
    public boolean isNoOp() {
        return false;
    }

    private static final class FinishStatus {
        static final FinishStatus NOT_FINISHED = FinishStatus.notFinished();
        private final boolean isFinishing;
        @Nullable
        private final SpanStatus spanStatus;

        @NotNull
        static FinishStatus finishing(@Nullable SpanStatus finishStatus) {
            return new FinishStatus(true, finishStatus);
        }

        @NotNull
        private static FinishStatus notFinished() {
            return new FinishStatus(false, null);
        }

        private FinishStatus(boolean isFinishing, @Nullable SpanStatus spanStatus) {
            this.isFinishing = isFinishing;
            this.spanStatus = spanStatus;
        }
    }
}

