/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.IScopes;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Integration;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.IntegrationUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class ShutdownHookIntegration
implements Integration,
Closeable {
    @NotNull
    private final Runtime runtime;
    @Nullable
    private Thread thread;

    @TestOnly
    public ShutdownHookIntegration(@NotNull Runtime runtime) {
        this.runtime = Objects.requireNonNull(runtime, "Runtime is required");
    }

    public ShutdownHookIntegration() {
        this(Runtime.getRuntime());
    }

    @Override
    public void register(@NotNull IScopes scopes, @NotNull SentryOptions options2) {
        Objects.requireNonNull(scopes, "Scopes are required");
        Objects.requireNonNull(options2, "SentryOptions is required");
        if (options2.isEnableShutdownHook()) {
            this.thread = new Thread(() -> scopes.flush(options2.getFlushTimeoutMillis()));
            this.handleShutdownInProgress(() -> {
                this.runtime.addShutdownHook(this.thread);
                options2.getLogger().log(SentryLevel.DEBUG, "ShutdownHookIntegration installed.", new Object[0]);
                IntegrationUtils.addIntegrationToSdkVersion("ShutdownHook");
            });
        } else {
            options2.getLogger().log(SentryLevel.INFO, "enableShutdownHook is disabled.", new Object[0]);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.thread != null) {
            this.handleShutdownInProgress(() -> this.runtime.removeShutdownHook(this.thread));
        }
    }

    private void handleShutdownInProgress(@NotNull Runnable runnable2) {
        block2: {
            try {
                runnable2.run();
            }
            catch (IllegalStateException e) {
                @Nullable String message2 = e.getMessage();
                if (message2 != null && (message2.equals("Shutdown in progress") || message2.equals("VM already shutting down"))) break block2;
                throw e;
            }
        }
    }

    @VisibleForTesting
    @Nullable
    Thread getHook() {
        return this.thread;
    }
}

