/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Baggage;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Instrumenter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ScopesAdapter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanStatus;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TracesSamplingDecision;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.CollectionUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.thread.IThreadChecker;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SpanContext
implements JsonUnknown,
JsonSerializable {
    public static final String TYPE = "trace";
    public static final String DEFAULT_ORIGIN = "manual";
    @NotNull
    private final SentryId traceId;
    @NotNull
    private final SpanId spanId;
    @Nullable
    private SpanId parentSpanId;
    @Nullable
    private transient TracesSamplingDecision samplingDecision;
    @NotNull
    protected String op;
    @Nullable
    protected String description;
    @Nullable
    protected SpanStatus status;
    @NotNull
    protected @NotNull Map<String, @NotNull String> tags = new ConcurrentHashMap<String, String>();
    @Nullable
    protected String origin = "manual";
    @NotNull
    protected Map<String, Object> data = new ConcurrentHashMap<String, Object>();
    @Nullable
    private Map<String, Object> unknown;
    @NotNull
    private Instrumenter instrumenter = Instrumenter.SENTRY;
    @Nullable
    protected Baggage baggage;

    public SpanContext(@NotNull String operation, @Nullable TracesSamplingDecision samplingDecision) {
        this(new SentryId(), new SpanId(), operation, null, samplingDecision);
    }

    public SpanContext(@NotNull String operation) {
        this(new SentryId(), new SpanId(), operation, null, null);
    }

    public SpanContext(@NotNull SentryId traceId, @NotNull SpanId spanId, @NotNull String operation, @Nullable SpanId parentSpanId, @Nullable TracesSamplingDecision samplingDecision) {
        this(traceId, spanId, parentSpanId, operation, null, samplingDecision, null, DEFAULT_ORIGIN);
    }

    @ApiStatus.Internal
    public SpanContext(@NotNull SentryId traceId, @NotNull SpanId spanId, @Nullable SpanId parentSpanId, @NotNull String operation, @Nullable String description2, @Nullable TracesSamplingDecision samplingDecision, @Nullable SpanStatus status2, @Nullable String origin) {
        this.traceId = Objects.requireNonNull(traceId, "traceId is required");
        this.spanId = Objects.requireNonNull(spanId, "spanId is required");
        this.op = Objects.requireNonNull(operation, "operation is required");
        this.parentSpanId = parentSpanId;
        this.description = description2;
        this.status = status2;
        this.origin = origin;
        this.setSamplingDecision(samplingDecision);
        IThreadChecker threadChecker = ScopesAdapter.getInstance().getOptions().getThreadChecker();
        this.data.put("thread.id", String.valueOf(threadChecker.currentThreadSystemId()));
        this.data.put("thread.name", threadChecker.getCurrentThreadName());
    }

    public SpanContext(@NotNull SpanContext spanContext) {
        Map<String, Object> copiedUnknown;
        this.traceId = spanContext.traceId;
        this.spanId = spanContext.spanId;
        this.parentSpanId = spanContext.parentSpanId;
        this.setSamplingDecision(spanContext.samplingDecision);
        this.op = spanContext.op;
        this.description = spanContext.description;
        this.status = spanContext.status;
        Map<String, String> copiedTags = CollectionUtils.newConcurrentHashMap(spanContext.tags);
        if (copiedTags != null) {
            this.tags = copiedTags;
        }
        if ((copiedUnknown = CollectionUtils.newConcurrentHashMap(spanContext.unknown)) != null) {
            this.unknown = copiedUnknown;
        }
        this.baggage = spanContext.baggage;
        Map<String, Object> copiedData = CollectionUtils.newConcurrentHashMap(spanContext.data);
        if (copiedData != null) {
            this.data = copiedData;
        }
    }

    public void setOperation(@NotNull String operation) {
        this.op = Objects.requireNonNull(operation, "operation is required");
    }

    public void setTag(@Nullable String name2, @Nullable String value2) {
        if (name2 == null) {
            return;
        }
        if (value2 == null) {
            this.tags.remove(name2);
        } else {
            this.tags.put(name2, value2);
        }
    }

    public void setDescription(@Nullable String description2) {
        this.description = description2;
    }

    public void setStatus(@Nullable SpanStatus status2) {
        this.status = status2;
    }

    @NotNull
    public SentryId getTraceId() {
        return this.traceId;
    }

    @NotNull
    public SpanId getSpanId() {
        return this.spanId;
    }

    @Nullable
    @TestOnly
    public SpanId getParentSpanId() {
        return this.parentSpanId;
    }

    @NotNull
    public String getOperation() {
        return this.op;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public SpanStatus getStatus() {
        return this.status;
    }

    @NotNull
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Nullable
    public TracesSamplingDecision getSamplingDecision() {
        return this.samplingDecision;
    }

    @Nullable
    public Boolean getSampled() {
        if (this.samplingDecision == null) {
            return null;
        }
        return this.samplingDecision.getSampled();
    }

    @Nullable
    public Boolean getProfileSampled() {
        if (this.samplingDecision == null) {
            return null;
        }
        return this.samplingDecision.getProfileSampled();
    }

    @ApiStatus.Internal
    public void setSampled(@Nullable Boolean sampled) {
        if (sampled == null) {
            this.setSamplingDecision(null);
        } else {
            this.setSamplingDecision(new TracesSamplingDecision(sampled));
        }
    }

    @ApiStatus.Internal
    public void setSampled(@Nullable Boolean sampled, @Nullable Boolean profileSampled) {
        if (sampled == null) {
            this.setSamplingDecision(null);
        } else if (profileSampled == null) {
            this.setSamplingDecision(new TracesSamplingDecision(sampled));
        } else {
            this.setSamplingDecision(new TracesSamplingDecision(sampled, null, profileSampled, null));
        }
    }

    @ApiStatus.Internal
    public void setSamplingDecision(@Nullable TracesSamplingDecision samplingDecision) {
        this.samplingDecision = samplingDecision;
        if (this.baggage != null) {
            this.baggage.setValuesFromSamplingDecision(this.samplingDecision);
        }
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(@Nullable String origin) {
        this.origin = origin;
    }

    @NotNull
    public Instrumenter getInstrumenter() {
        return this.instrumenter;
    }

    public void setInstrumenter(@NotNull Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
    }

    @Nullable
    public Baggage getBaggage() {
        return this.baggage;
    }

    @NotNull
    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(@Nullable String key, @Nullable Object value2) {
        if (key == null) {
            return;
        }
        if (value2 == null) {
            this.data.remove(key);
        } else {
            this.data.put(key, value2);
        }
    }

    @ApiStatus.Internal
    public SpanContext copyForChild(@NotNull String operation, @Nullable SpanId parentSpanId, @Nullable SpanId spanId) {
        return new SpanContext(this.traceId, spanId == null ? new SpanId() : spanId, parentSpanId, operation, null, this.samplingDecision, null, DEFAULT_ORIGIN);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanContext)) {
            return false;
        }
        SpanContext that = (SpanContext)o;
        return this.traceId.equals(that.traceId) && this.spanId.equals(that.spanId) && Objects.equals(this.parentSpanId, that.parentSpanId) && this.op.equals(that.op) && Objects.equals(this.description, that.description) && this.getStatus() == that.getStatus();
    }

    public int hashCode() {
        return Objects.hash(this.traceId, this.spanId, this.parentSpanId, this.op, this.description, this.getStatus());
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("trace_id");
        this.traceId.serialize(writer2, logger);
        writer2.name("span_id");
        this.spanId.serialize(writer2, logger);
        if (this.parentSpanId != null) {
            writer2.name("parent_span_id");
            this.parentSpanId.serialize(writer2, logger);
        }
        writer2.name("op").value(this.op);
        if (this.description != null) {
            writer2.name("description").value(this.description);
        }
        if (this.getStatus() != null) {
            writer2.name("status").value(logger, this.getStatus());
        }
        if (this.origin != null) {
            writer2.name("origin").value(logger, this.origin);
        }
        if (!this.tags.isEmpty()) {
            writer2.name("tags").value(logger, this.tags);
        }
        if (!this.data.isEmpty()) {
            writer2.name("data").value(logger, this.data);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key).value(logger, value2);
            }
        }
        writer2.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String TRACE_ID = "trace_id";
        public static final String SPAN_ID = "span_id";
        public static final String PARENT_SPAN_ID = "parent_span_id";
        public static final String OP = "op";
        public static final String DESCRIPTION = "description";
        public static final String STATUS = "status";
        public static final String TAGS = "tags";
        public static final String ORIGIN = "origin";
        public static final String DATA = "data";
    }

    public static final class Deserializer
    implements JsonDeserializer<SpanContext> {
        @Override
        @NotNull
        public SpanContext deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            IllegalStateException exception;
            String message2;
            reader2.beginObject();
            SentryId traceId = null;
            SpanId spanId = null;
            SpanId parentSpanId = null;
            String op = null;
            String description2 = null;
            SpanStatus status2 = null;
            String origin = null;
            Map tags2 = null;
            Map data2 = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block22: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "trace_id": {
                        traceId = new SentryId.Deserializer().deserialize(reader2, logger);
                        continue block22;
                    }
                    case "span_id": {
                        spanId = new SpanId.Deserializer().deserialize(reader2, logger);
                        continue block22;
                    }
                    case "parent_span_id": {
                        parentSpanId = reader2.nextOrNull(logger, new SpanId.Deserializer());
                        continue block22;
                    }
                    case "op": {
                        op = reader2.nextString();
                        continue block22;
                    }
                    case "description": {
                        description2 = reader2.nextString();
                        continue block22;
                    }
                    case "status": {
                        status2 = reader2.nextOrNull(logger, new SpanStatus.Deserializer());
                        continue block22;
                    }
                    case "origin": {
                        origin = reader2.nextString();
                        continue block22;
                    }
                    case "tags": {
                        tags2 = CollectionUtils.newConcurrentHashMap((Map)reader2.nextObjectOrNull());
                        continue block22;
                    }
                    case "data": {
                        data2 = (Map)reader2.nextObjectOrNull();
                        continue block22;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            if (traceId == null) {
                message2 = "Missing required field \"trace_id\"";
                exception = new IllegalStateException(message2);
                logger.log(SentryLevel.ERROR, message2, exception);
                throw exception;
            }
            if (spanId == null) {
                message2 = "Missing required field \"span_id\"";
                exception = new IllegalStateException(message2);
                logger.log(SentryLevel.ERROR, message2, exception);
                throw exception;
            }
            if (op == null) {
                op = "";
            }
            SpanContext spanContext = new SpanContext(traceId, spanId, op, parentSpanId, null);
            spanContext.setDescription(description2);
            spanContext.setStatus(status2);
            spanContext.setOrigin(origin);
            if (tags2 != null) {
                spanContext.tags = tags2;
            }
            if (data2 != null) {
                spanContext.data = data2;
            }
            spanContext.setUnknown(unknown);
            reader2.endObject();
            return spanContext;
        }
    }
}

