/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryUUID;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.LazyEvaluator;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class SpanId
implements JsonSerializable {
    public static final SpanId EMPTY_ID = new SpanId("00000000-0000-0000-0000-000000000000".replace("-", "").substring(0, 16));
    @NotNull
    private final LazyEvaluator<String> lazyValue;

    public SpanId(@NotNull String value2) {
        Objects.requireNonNull(value2, "value is required");
        this.lazyValue = new LazyEvaluator<String>(() -> value2);
    }

    public SpanId() {
        this.lazyValue = new LazyEvaluator<String>(SentryUUID::generateSpanId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanId spanId = (SpanId)o;
        return this.lazyValue.getValue().equals(spanId.lazyValue.getValue());
    }

    public int hashCode() {
        return this.lazyValue.getValue().hashCode();
    }

    public String toString() {
        return this.lazyValue.getValue();
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.value(this.lazyValue.getValue());
    }

    public static final class Deserializer
    implements JsonDeserializer<SpanId> {
        @Override
        @NotNull
        public SpanId deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            return new SpanId(reader2.nextString());
        }
    }
}

