/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.cache;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISerializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEnvelope;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEnvelopeItem;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryItemType;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Session;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.clientreport.DiscardReason;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.LazyEvaluator;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CacheStrategy {
    protected static final Charset UTF_8 = Charset.forName("UTF-8");
    @NotNull
    protected SentryOptions options;
    @NotNull
    protected final LazyEvaluator<ISerializer> serializer = new LazyEvaluator<ISerializer>(() -> this.options.getSerializer());
    @NotNull
    protected final File directory;
    private final int maxSize;

    CacheStrategy(@NotNull SentryOptions options2, @NotNull String directoryPath, int maxSize) {
        Objects.requireNonNull(directoryPath, "Directory is required.");
        this.options = Objects.requireNonNull(options2, "SentryOptions is required.");
        this.directory = new File(directoryPath);
        this.maxSize = maxSize;
    }

    protected boolean isDirectoryValid() {
        if (!(this.directory.isDirectory() && this.directory.canWrite() && this.directory.canRead())) {
            this.options.getLogger().log(SentryLevel.ERROR, "The directory for caching files is inaccessible.: %s", this.directory.getAbsolutePath());
            return false;
        }
        return true;
    }

    private void sortFilesOldestToNewest(@NotNull File[] files) {
        if (files.length > 1) {
            Arrays.sort(files, (f1, f2) -> Long.compare(f1.lastModified(), f2.lastModified()));
        }
    }

    protected void rotateCacheIfNeeded(@NotNull File[] files) {
        int length = files.length;
        if (length >= this.maxSize) {
            this.options.getLogger().log(SentryLevel.WARNING, "Cache folder if full (respecting maxSize). Rotating files", new Object[0]);
            int totalToBeDeleted = length - this.maxSize + 1;
            this.sortFilesOldestToNewest(files);
            File[] notDeletedFiles = Arrays.copyOfRange(files, totalToBeDeleted, length);
            for (int i = 0; i < totalToBeDeleted; ++i) {
                File file2 = files[i];
                this.moveInitFlagIfNecessary(file2, notDeletedFiles);
                if (file2.delete()) continue;
                this.options.getLogger().log(SentryLevel.WARNING, "File can't be deleted: %s", file2.getAbsolutePath());
            }
        }
    }

    private void moveInitFlagIfNecessary(@NotNull File currentFile, @NotNull File[] notDeletedFiles) {
        SentryEnvelope currentEnvelope = this.readEnvelope(currentFile);
        if (currentEnvelope == null || !this.isValidEnvelope(currentEnvelope)) {
            return;
        }
        this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.CACHE_OVERFLOW, currentEnvelope);
        Session currentSession = this.getFirstSession(currentEnvelope);
        if (currentSession == null || !this.isValidSession(currentSession)) {
            return;
        }
        Boolean currentSessionInit = currentSession.getInit();
        if (currentSessionInit == null || !currentSessionInit.booleanValue()) {
            return;
        }
        for (File notDeletedFile : notDeletedFiles) {
            SentryEnvelope envelope = this.readEnvelope(notDeletedFile);
            if (envelope == null || !this.isValidEnvelope(envelope)) continue;
            SentryEnvelopeItem newSessionItem = null;
            Iterator<SentryEnvelopeItem> itemsIterator = envelope.getItems().iterator();
            while (itemsIterator.hasNext()) {
                Session session;
                SentryEnvelopeItem envelopeItem = itemsIterator.next();
                if (!this.isSessionType(envelopeItem) || (session = this.readSession(envelopeItem)) == null || !this.isValidSession(session)) continue;
                Boolean init = session.getInit();
                if (init != null && init.booleanValue()) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Session %s has 2 times the init flag.", currentSession.getSessionId());
                    return;
                }
                if (currentSession.getSessionId() == null || !currentSession.getSessionId().equals(session.getSessionId())) continue;
                session.setInitAsTrue();
                try {
                    newSessionItem = SentryEnvelopeItem.fromSession(this.serializer.getValue(), session);
                    itemsIterator.remove();
                }
                catch (IOException e) {
                    this.options.getLogger().log(SentryLevel.ERROR, e, "Failed to create new envelope item for the session %s", currentSession.getSessionId());
                }
                break;
            }
            if (newSessionItem == null) continue;
            SentryEnvelope newEnvelope = this.buildNewEnvelope(envelope, newSessionItem);
            long notDeletedFileTimestamp = notDeletedFile.lastModified();
            if (!notDeletedFile.delete()) {
                this.options.getLogger().log(SentryLevel.WARNING, "File can't be deleted: %s", notDeletedFile.getAbsolutePath());
            }
            this.saveNewEnvelope(newEnvelope, notDeletedFile, notDeletedFileTimestamp);
            break;
        }
    }

    @Nullable
    private SentryEnvelope readEnvelope(@NotNull File file2) {
        SentryEnvelope sentryEnvelope;
        BufferedInputStream inputStream2 = new BufferedInputStream(new FileInputStream(file2));
        try {
            sentryEnvelope = this.serializer.getValue().deserializeEnvelope(inputStream2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream2).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to deserialize the envelope.", e);
                return null;
            }
        }
        ((InputStream)inputStream2).close();
        return sentryEnvelope;
    }

    @Nullable
    private Session getFirstSession(@NotNull SentryEnvelope envelope) {
        for (SentryEnvelopeItem item2 : envelope.getItems()) {
            if (!this.isSessionType(item2)) continue;
            return this.readSession(item2);
        }
        return null;
    }

    private boolean isValidSession(@NotNull Session session) {
        if (!session.getStatus().equals((Object)Session.State.Ok)) {
            return false;
        }
        String sessionId = session.getSessionId();
        return sessionId != null;
    }

    private boolean isSessionType(@Nullable SentryEnvelopeItem item2) {
        if (item2 == null) {
            return false;
        }
        return item2.getHeader().getType().equals(SentryItemType.Session);
    }

    @Nullable
    private Session readSession(@NotNull SentryEnvelopeItem item2) {
        Session session;
        BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(item2.getData()), UTF_8));
        try {
            session = this.serializer.getValue().deserialize(reader2, Session.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader2).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to deserialize the session.", e);
                return null;
            }
        }
        ((Reader)reader2).close();
        return session;
    }

    private void saveNewEnvelope(@NotNull SentryEnvelope envelope, @NotNull File file2, long timestamp2) {
        try (FileOutputStream outputStream2 = new FileOutputStream(file2);){
            this.serializer.getValue().serialize(envelope, outputStream2);
            file2.setLastModified(timestamp2);
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to serialize the new envelope to the disk.", e);
        }
    }

    @NotNull
    private SentryEnvelope buildNewEnvelope(@NotNull SentryEnvelope envelope, @NotNull SentryEnvelopeItem sessionItem) {
        ArrayList<SentryEnvelopeItem> newEnvelopeItems = new ArrayList<SentryEnvelopeItem>();
        for (SentryEnvelopeItem newEnvelopeItem : envelope.getItems()) {
            newEnvelopeItems.add(newEnvelopeItem);
        }
        newEnvelopeItems.add(sessionItem);
        return new SentryEnvelope(envelope.getHeader(), newEnvelopeItems);
    }

    private boolean isValidEnvelope(@NotNull SentryEnvelope envelope) {
        return envelope.getItems().iterator().hasNext();
    }
}

