/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.cache;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DateUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Hint;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISentryLifecycleToken;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISerializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryCrashLastRunState;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEnvelope;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEnvelopeItem;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryItemType;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryUUID;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Session;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.UncaughtExceptionHandlerIntegration;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.cache.CacheStrategy;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.cache.IEnvelopeCache;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.hints.AbnormalExit;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.hints.SessionEnd;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.hints.SessionStart;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.transport.NoOpEnvelopeCache;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.AutoClosableReentrantLock;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.HintUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EnvelopeCache
extends CacheStrategy
implements IEnvelopeCache {
    public static final String SUFFIX_ENVELOPE_FILE = ".envelope";
    public static final String PREFIX_CURRENT_SESSION_FILE = "session";
    public static final String PREFIX_PREVIOUS_SESSION_FILE = "previous_session";
    static final String SUFFIX_SESSION_FILE = ".json";
    public static final String CRASH_MARKER_FILE = "last_crash";
    public static final String NATIVE_CRASH_MARKER_FILE = ".sentry-native/last_crash";
    public static final String STARTUP_CRASH_MARKER_FILE = "startup_crash";
    private final CountDownLatch previousSessionLatch;
    @NotNull
    private final Map<SentryEnvelope, String> fileNameMap = new WeakHashMap<SentryEnvelope, String>();
    @NotNull
    protected final AutoClosableReentrantLock cacheLock = new AutoClosableReentrantLock();

    @NotNull
    public static IEnvelopeCache create(@NotNull SentryOptions options2) {
        String cacheDirPath = options2.getCacheDirPath();
        int maxCacheItems = options2.getMaxCacheItems();
        if (cacheDirPath == null) {
            options2.getLogger().log(SentryLevel.WARNING, "cacheDirPath is null, returning NoOpEnvelopeCache", new Object[0]);
            return NoOpEnvelopeCache.getInstance();
        }
        return new EnvelopeCache(options2, cacheDirPath, maxCacheItems);
    }

    public EnvelopeCache(@NotNull SentryOptions options2, @NotNull String cacheDirPath, int maxCacheItems) {
        super(options2, cacheDirPath, maxCacheItems);
        this.previousSessionLatch = new CountDownLatch(1);
    }

    @Override
    public void store(@NotNull SentryEnvelope envelope, @NotNull Hint hint) {
        File envelopeFile;
        Objects.requireNonNull(envelope, "Envelope is required.");
        this.rotateCacheIfNeeded(this.allEnvelopeFiles());
        File currentSessionFile = EnvelopeCache.getCurrentSessionFile(this.directory.getAbsolutePath());
        File previousSessionFile = EnvelopeCache.getPreviousSessionFile(this.directory.getAbsolutePath());
        if (HintUtils.hasType(hint, SessionEnd.class) && !currentSessionFile.delete()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Current envelope doesn't exist.", new Object[0]);
        }
        if (HintUtils.hasType(hint, AbnormalExit.class)) {
            this.tryEndPreviousSession(hint);
        }
        if (HintUtils.hasType(hint, SessionStart.class)) {
            File javaCrashMarkerFile;
            if (currentSessionFile.exists()) {
                this.options.getLogger().log(SentryLevel.WARNING, "Current session is not ended, we'd need to end it.", new Object[0]);
                try (BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(currentSessionFile), UTF_8));){
                    Session session = ((ISerializer)this.serializer.getValue()).deserialize(reader2, Session.class);
                    if (session != null) {
                        this.writeSessionToDisk(previousSessionFile, session);
                    }
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Error processing session.", e);
                }
            }
            this.updateCurrentSession(currentSessionFile, envelope);
            boolean crashedLastRun = false;
            File crashMarkerFile = new File(this.options.getCacheDirPath(), NATIVE_CRASH_MARKER_FILE);
            if (crashMarkerFile.exists()) {
                crashedLastRun = true;
            }
            if (!crashedLastRun && (javaCrashMarkerFile = new File(this.options.getCacheDirPath(), CRASH_MARKER_FILE)).exists()) {
                this.options.getLogger().log(SentryLevel.INFO, "Crash marker file exists, crashedLastRun will return true.", new Object[0]);
                crashedLastRun = true;
                if (!javaCrashMarkerFile.delete()) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete the crash marker file. %s.", javaCrashMarkerFile.getAbsolutePath());
                }
            }
            SentryCrashLastRunState.getInstance().setCrashedLastRun(crashedLastRun);
            this.flushPreviousSession();
        }
        if ((envelopeFile = this.getEnvelopeFile(envelope)).exists()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Not adding Envelope to offline storage because it already exists: %s", envelopeFile.getAbsolutePath());
            return;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Adding Envelope to offline storage: %s", envelopeFile.getAbsolutePath());
        this.writeEnvelopeToDisk(envelopeFile, envelope);
        if (HintUtils.hasType(hint, UncaughtExceptionHandlerIntegration.UncaughtExceptionHint.class)) {
            this.writeCrashMarkerFile();
        }
    }

    private void tryEndPreviousSession(@NotNull Hint hint) {
        Object sdkHint = HintUtils.getSentrySdkHint(hint);
        if (sdkHint instanceof AbnormalExit) {
            File previousSessionFile = EnvelopeCache.getPreviousSessionFile(this.directory.getAbsolutePath());
            if (previousSessionFile.exists()) {
                this.options.getLogger().log(SentryLevel.WARNING, "Previous session is not ended, we'd need to end it.", new Object[0]);
                try (BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(previousSessionFile), UTF_8));){
                    Session session = ((ISerializer)this.serializer.getValue()).deserialize(reader2, Session.class);
                    if (session != null) {
                        AbnormalExit abnormalHint = (AbnormalExit)sdkHint;
                        @Nullable Long abnormalExitTimestamp = abnormalHint.timestamp();
                        Date timestamp2 = null;
                        if (abnormalExitTimestamp != null) {
                            timestamp2 = DateUtils.getDateTime(abnormalExitTimestamp);
                            Date sessionStart = session.getStarted();
                            if (sessionStart == null || timestamp2.before(sessionStart)) {
                                this.options.getLogger().log(SentryLevel.WARNING, "Abnormal exit happened before previous session start, not ending the session.", new Object[0]);
                                return;
                            }
                        }
                        String abnormalMechanism = abnormalHint.mechanism();
                        session.update(Session.State.Abnormal, null, true, abnormalMechanism);
                        session.end(timestamp2);
                        this.writeSessionToDisk(previousSessionFile, session);
                    }
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Error processing previous session.", e);
                }
            } else {
                this.options.getLogger().log(SentryLevel.DEBUG, "No previous session file to end.", new Object[0]);
            }
        }
    }

    private void writeCrashMarkerFile() {
        File crashMarkerFile = new File(this.options.getCacheDirPath(), CRASH_MARKER_FILE);
        try (FileOutputStream outputStream2 = new FileOutputStream(crashMarkerFile);){
            String timestamp2 = DateUtils.getTimestamp(DateUtils.getCurrentDateTime());
            ((OutputStream)outputStream2).write(timestamp2.getBytes(UTF_8));
            outputStream2.flush();
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error writing the crash marker file to the disk", e);
        }
    }

    private void updateCurrentSession(@NotNull File currentSessionFile, @NotNull SentryEnvelope envelope) {
        Iterable<SentryEnvelopeItem> items = envelope.getItems();
        if (items.iterator().hasNext()) {
            SentryEnvelopeItem item2 = items.iterator().next();
            if (SentryItemType.Session.equals(item2.getHeader().getType())) {
                try (BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(item2.getData()), UTF_8));){
                    Session session = ((ISerializer)this.serializer.getValue()).deserialize(reader2, Session.class);
                    if (session == null) {
                        this.options.getLogger().log(SentryLevel.ERROR, "Item of type %s returned null by the parser.", item2.getHeader().getType());
                    } else {
                        this.writeSessionToDisk(currentSessionFile, session);
                    }
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Item failed to process.", e);
                }
            } else {
                this.options.getLogger().log(SentryLevel.INFO, "Current envelope has a different envelope type %s", item2.getHeader().getType());
            }
        } else {
            this.options.getLogger().log(SentryLevel.INFO, "Current envelope %s is empty", currentSessionFile.getAbsolutePath());
        }
    }

    private void writeEnvelopeToDisk(@NotNull File file2, @NotNull SentryEnvelope envelope) {
        if (file2.exists()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Overwriting envelope to offline storage: %s", file2.getAbsolutePath());
            if (!file2.delete()) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete: %s", file2.getAbsolutePath());
            }
        }
        try (FileOutputStream outputStream2 = new FileOutputStream(file2);){
            ((ISerializer)this.serializer.getValue()).serialize(envelope, outputStream2);
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, e, "Error writing Envelope %s to offline storage", file2.getAbsolutePath());
        }
    }

    private void writeSessionToDisk(@NotNull File file2, @NotNull Session session) {
        if (file2.exists()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Overwriting session to offline storage: %s", session.getSessionId());
            if (!file2.delete()) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete: %s", file2.getAbsolutePath());
            }
        }
        try (FileOutputStream outputStream2 = new FileOutputStream(file2);
             BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream2, UTF_8));){
            ((ISerializer)this.serializer.getValue()).serialize(session, writer2);
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, e, "Error writing Session to offline storage: %s", session.getSessionId());
        }
    }

    @Override
    public void discard(@NotNull SentryEnvelope envelope) {
        Objects.requireNonNull(envelope, "Envelope is required.");
        File envelopeFile = this.getEnvelopeFile(envelope);
        if (envelopeFile.exists()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Discarding envelope from cache: %s", envelopeFile.getAbsolutePath());
            if (!envelopeFile.delete()) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete envelope: %s", envelopeFile.getAbsolutePath());
            }
        } else {
            this.options.getLogger().log(SentryLevel.DEBUG, "Envelope was not cached: %s", envelopeFile.getAbsolutePath());
        }
    }

    @NotNull
    private File getEnvelopeFile(@NotNull SentryEnvelope envelope) {
        try (@NotNull ISentryLifecycleToken ignored = this.cacheLock.acquire();){
            String fileName;
            if (this.fileNameMap.containsKey(envelope)) {
                fileName = this.fileNameMap.get(envelope);
            } else {
                fileName = SentryUUID.generateSentryId() + SUFFIX_ENVELOPE_FILE;
                this.fileNameMap.put(envelope, fileName);
            }
            File file2 = new File(this.directory.getAbsolutePath(), fileName);
            return file2;
        }
    }

    @NotNull
    public static File getCurrentSessionFile(@NotNull String cacheDirPath) {
        return new File(cacheDirPath, "session.json");
    }

    @NotNull
    public static File getPreviousSessionFile(@NotNull String cacheDirPath) {
        return new File(cacheDirPath, "previous_session.json");
    }

    @Override
    @NotNull
    public Iterator<SentryEnvelope> iterator() {
        File[] allCachedEnvelopes = this.allEnvelopeFiles();
        ArrayList<SentryEnvelope> ret = new ArrayList<SentryEnvelope>(allCachedEnvelopes.length);
        for (File file2 : allCachedEnvelopes) {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file2));){
                ret.add(((ISerializer)this.serializer.getValue()).deserializeEnvelope(is));
            }
            catch (FileNotFoundException e) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Envelope file '%s' disappeared while converting all cached files to envelopes.", file2.getAbsolutePath());
            }
            catch (IOException e) {
                this.options.getLogger().log(SentryLevel.ERROR, String.format("Error while reading cached envelope from file %s", file2.getAbsolutePath()), e);
            }
        }
        return ret.iterator();
    }

    @NotNull
    private File[] allEnvelopeFiles() {
        File[] files;
        if (this.isDirectoryValid() && (files = this.directory.listFiles((__, fileName) -> fileName.endsWith(SUFFIX_ENVELOPE_FILE))) != null) {
            return files;
        }
        return new File[0];
    }

    public boolean waitPreviousSessionFlush() {
        try {
            return this.previousSessionLatch.await(this.options.getSessionFlushTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.options.getLogger().log(SentryLevel.DEBUG, "Timed out waiting for previous session to flush.", new Object[0]);
            return false;
        }
    }

    public void flushPreviousSession() {
        this.previousSessionLatch.countDown();
    }
}

